# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WasmPluginArgs', 'WasmPlugin']

@pulumi.input_type
class WasmPluginArgs:
    def __init__(__self__, *,
                 main_version_id: pulumi.Input[_builtins.str],
                 versions: pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['WasmPluginLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WasmPlugin resource.
        :param pulumi.Input[_builtins.str] main_version_id: The ID of the WasmPluginVersion resource that is the currently serving one. The version referred to must be a child of this WasmPlugin resource and should be listed in the "versions" field.
        :param pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]] versions: All versions of this WasmPlugin resource in the key-value format. The key is the resource ID, and the value is the VersionDetails object.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Optional. A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Set of labels associated with the WasmPlugin resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input['WasmPluginLogConfigArgs'] log_config: Optional. Specifies the logging options for the activity performed by this plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
               Note that the settings relate to the logs generated by using logging statements in your Wasm code.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the WasmPlugin resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "main_version_id", main_version_id)
        pulumi.set(__self__, "versions", versions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="mainVersionId")
    def main_version_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the WasmPluginVersion resource that is the currently serving one. The version referred to must be a child of this WasmPlugin resource and should be listed in the "versions" field.
        """
        return pulumi.get(self, "main_version_id")

    @main_version_id.setter
    def main_version_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "main_version_id", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]]:
        """
        All versions of this WasmPlugin resource in the key-value format. The key is the resource ID, and the value is the VersionDetails object.
        Structure is documented below.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]]):
        pulumi.set(self, "versions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Set of labels associated with the WasmPlugin resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the traffic extension
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['WasmPluginLogConfigArgs']]:
        """
        Optional. Specifies the logging options for the activity performed by this plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
        Note that the settings relate to the logs generated by using logging statements in your Wasm code.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['WasmPluginLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Name of the WasmPlugin resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _WasmPluginState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['WasmPluginLogConfigArgs']] = None,
                 main_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 used_bies: Optional[pulumi.Input[Sequence[pulumi.Input['WasmPluginUsedByArgs']]]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]]] = None):
        """
        Input properties used for looking up and filtering WasmPlugin resources.
        :param pulumi.Input[_builtins.str] create_time: Output only. The timestamp when the resource was created.
        :param pulumi.Input[_builtins.str] description: Optional. A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Set of labels associated with the WasmPlugin resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input['WasmPluginLogConfigArgs'] log_config: Optional. Specifies the logging options for the activity performed by this plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
               Note that the settings relate to the logs generated by using logging statements in your Wasm code.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] main_version_id: The ID of the WasmPluginVersion resource that is the currently serving one. The version referred to must be a child of this WasmPlugin resource and should be listed in the "versions" field.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the WasmPlugin resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: Output only. The timestamp when the resource was updated.
        :param pulumi.Input[Sequence[pulumi.Input['WasmPluginUsedByArgs']]] used_bies: Output only. List of all extensions that use this WasmPlugin resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]] versions: All versions of this WasmPlugin resource in the key-value format. The key is the resource ID, and the value is the VersionDetails object.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if main_version_id is not None:
            pulumi.set(__self__, "main_version_id", main_version_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if used_bies is not None:
            pulumi.set(__self__, "used_bies", used_bies)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Set of labels associated with the WasmPlugin resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the traffic extension
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['WasmPluginLogConfigArgs']]:
        """
        Optional. Specifies the logging options for the activity performed by this plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
        Note that the settings relate to the logs generated by using logging statements in your Wasm code.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['WasmPluginLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="mainVersionId")
    def main_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the WasmPluginVersion resource that is the currently serving one. The version referred to must be a child of this WasmPlugin resource and should be listed in the "versions" field.
        """
        return pulumi.get(self, "main_version_id")

    @main_version_id.setter
    def main_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "main_version_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Name of the WasmPlugin resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="usedBies")
    def used_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WasmPluginUsedByArgs']]]]:
        """
        Output only. List of all extensions that use this WasmPlugin resource.
        Structure is documented below.
        """
        return pulumi.get(self, "used_bies")

    @used_bies.setter
    def used_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WasmPluginUsedByArgs']]]]):
        pulumi.set(self, "used_bies", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]]]:
        """
        All versions of this WasmPlugin resource in the key-value format. The key is the resource ID, and the value is the VersionDetails object.
        Structure is documented below.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WasmPluginVersionArgs']]]]):
        pulumi.set(self, "versions", value)


@pulumi.type_token("gcp:networkservices/wasmPlugin:WasmPlugin")
class WasmPlugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['WasmPluginLogConfigArgs', 'WasmPluginLogConfigArgsDict']]] = None,
                 main_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WasmPluginVersionArgs', 'WasmPluginVersionArgsDict']]]]] = None,
                 __props__=None):
        """
        WasmPlugin is a resource representing a service executing a customer-provided Wasm module.

        To get more information about WasmPlugin, see:

        * [API documentation](https://cloud.google.com/service-extensions/docs/reference/rest/v1/projects.locations.wasmPlugins)
        * How-to Guides
            * [Configure a route extension](https://cloud.google.com/service-extensions/docs/create-plugin)

        ## Example Usage

        ### Wasm Plugin Basic Docker Repository

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        wasm_plugin = gcp.networkservices.WasmPlugin("wasm_plugin",
            name="my-wasm-plugin",
            description="my wasm plugin from a docker repository",
            main_version_id="v1",
            labels={
                "test_label": "test_value",
            },
            log_config={
                "enable": True,
                "sample_rate": 1,
                "min_log_level": "WARN",
            },
            versions=[{
                "version_name": "v1",
                "description": "v1 version of my wasm plugin",
                "image_uri": f"us-central1-docker.pkg.dev/{project.name}/my-artifact-registry-docker-repository/my-wasm-plugin-data:prod",
                "labels": {
                    "test_label": "test_value",
                },
            }])
        ```
        ### Wasm Plugin Basic Generic Repository

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        wasm_plugin = gcp.networkservices.WasmPlugin("wasm_plugin",
            name="my-wasm-plugin",
            description="my wasm plugin from a generic repository",
            main_version_id="v1",
            labels={
                "test_label": "test_value",
            },
            log_config={
                "enable": True,
                "sample_rate": 1,
                "min_log_level": "WARN",
            },
            versions=[{
                "version_name": "v1",
                "description": "v1 version of my wasm plugin",
                "image_uri": f"projects/{project.name}/locations/us-central1/repositories/my-artifact-registry-generic-repository/genericArtifacts/my-wasm-plugin-data:v1",
                "labels": {
                    "test_label": "test_value",
                },
            }])
        ```

        ## Import

        WasmPlugin can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/wasmPlugins/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, WasmPlugin can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/wasmPlugin:WasmPlugin default projects/{{project}}/locations/{{location}}/wasmPlugins/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/wasmPlugin:WasmPlugin default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/wasmPlugin:WasmPlugin default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Optional. A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Set of labels associated with the WasmPlugin resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input[Union['WasmPluginLogConfigArgs', 'WasmPluginLogConfigArgsDict']] log_config: Optional. Specifies the logging options for the activity performed by this plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
               Note that the settings relate to the logs generated by using logging statements in your Wasm code.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] main_version_id: The ID of the WasmPluginVersion resource that is the currently serving one. The version referred to must be a child of this WasmPlugin resource and should be listed in the "versions" field.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the WasmPlugin resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WasmPluginVersionArgs', 'WasmPluginVersionArgsDict']]]] versions: All versions of this WasmPlugin resource in the key-value format. The key is the resource ID, and the value is the VersionDetails object.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WasmPluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        WasmPlugin is a resource representing a service executing a customer-provided Wasm module.

        To get more information about WasmPlugin, see:

        * [API documentation](https://cloud.google.com/service-extensions/docs/reference/rest/v1/projects.locations.wasmPlugins)
        * How-to Guides
            * [Configure a route extension](https://cloud.google.com/service-extensions/docs/create-plugin)

        ## Example Usage

        ### Wasm Plugin Basic Docker Repository

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        wasm_plugin = gcp.networkservices.WasmPlugin("wasm_plugin",
            name="my-wasm-plugin",
            description="my wasm plugin from a docker repository",
            main_version_id="v1",
            labels={
                "test_label": "test_value",
            },
            log_config={
                "enable": True,
                "sample_rate": 1,
                "min_log_level": "WARN",
            },
            versions=[{
                "version_name": "v1",
                "description": "v1 version of my wasm plugin",
                "image_uri": f"us-central1-docker.pkg.dev/{project.name}/my-artifact-registry-docker-repository/my-wasm-plugin-data:prod",
                "labels": {
                    "test_label": "test_value",
                },
            }])
        ```
        ### Wasm Plugin Basic Generic Repository

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        wasm_plugin = gcp.networkservices.WasmPlugin("wasm_plugin",
            name="my-wasm-plugin",
            description="my wasm plugin from a generic repository",
            main_version_id="v1",
            labels={
                "test_label": "test_value",
            },
            log_config={
                "enable": True,
                "sample_rate": 1,
                "min_log_level": "WARN",
            },
            versions=[{
                "version_name": "v1",
                "description": "v1 version of my wasm plugin",
                "image_uri": f"projects/{project.name}/locations/us-central1/repositories/my-artifact-registry-generic-repository/genericArtifacts/my-wasm-plugin-data:v1",
                "labels": {
                    "test_label": "test_value",
                },
            }])
        ```

        ## Import

        WasmPlugin can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/wasmPlugins/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, WasmPlugin can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/wasmPlugin:WasmPlugin default projects/{{project}}/locations/{{location}}/wasmPlugins/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/wasmPlugin:WasmPlugin default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/wasmPlugin:WasmPlugin default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param WasmPluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WasmPluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['WasmPluginLogConfigArgs', 'WasmPluginLogConfigArgsDict']]] = None,
                 main_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WasmPluginVersionArgs', 'WasmPluginVersionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WasmPluginArgs.__new__(WasmPluginArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["log_config"] = log_config
            if main_version_id is None and not opts.urn:
                raise TypeError("Missing required property 'main_version_id'")
            __props__.__dict__["main_version_id"] = main_version_id
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if versions is None and not opts.urn:
                raise TypeError("Missing required property 'versions'")
            __props__.__dict__["versions"] = versions
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["used_bies"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WasmPlugin, __self__).__init__(
            'gcp:networkservices/wasmPlugin:WasmPlugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            log_config: Optional[pulumi.Input[Union['WasmPluginLogConfigArgs', 'WasmPluginLogConfigArgsDict']]] = None,
            main_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            used_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WasmPluginUsedByArgs', 'WasmPluginUsedByArgsDict']]]]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WasmPluginVersionArgs', 'WasmPluginVersionArgsDict']]]]] = None) -> 'WasmPlugin':
        """
        Get an existing WasmPlugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Output only. The timestamp when the resource was created.
        :param pulumi.Input[_builtins.str] description: Optional. A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Set of labels associated with the WasmPlugin resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the traffic extension
        :param pulumi.Input[Union['WasmPluginLogConfigArgs', 'WasmPluginLogConfigArgsDict']] log_config: Optional. Specifies the logging options for the activity performed by this plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
               Note that the settings relate to the logs generated by using logging statements in your Wasm code.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] main_version_id: The ID of the WasmPluginVersion resource that is the currently serving one. The version referred to must be a child of this WasmPlugin resource and should be listed in the "versions" field.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the WasmPlugin resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] update_time: Output only. The timestamp when the resource was updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WasmPluginUsedByArgs', 'WasmPluginUsedByArgsDict']]]] used_bies: Output only. List of all extensions that use this WasmPlugin resource.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WasmPluginVersionArgs', 'WasmPluginVersionArgsDict']]]] versions: All versions of this WasmPlugin resource in the key-value format. The key is the resource ID, and the value is the VersionDetails object.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WasmPluginState.__new__(_WasmPluginState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["main_version_id"] = main_version_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["used_bies"] = used_bies
        __props__.__dict__["versions"] = versions
        return WasmPlugin(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Set of labels associated with the WasmPlugin resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The location of the traffic extension
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.WasmPluginLogConfig']]:
        """
        Optional. Specifies the logging options for the activity performed by this plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
        Note that the settings relate to the logs generated by using logging statements in your Wasm code.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter(name="mainVersionId")
    def main_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the WasmPluginVersion resource that is the currently serving one. The version referred to must be a child of this WasmPlugin resource and should be listed in the "versions" field.
        """
        return pulumi.get(self, "main_version_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Name of the WasmPlugin resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="usedBies")
    def used_bies(self) -> pulumi.Output[Sequence['outputs.WasmPluginUsedBy']]:
        """
        Output only. List of all extensions that use this WasmPlugin resource.
        Structure is documented below.
        """
        return pulumi.get(self, "used_bies")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence['outputs.WasmPluginVersion']]:
        """
        All versions of this WasmPlugin resource in the key-value format. The key is the resource ID, and the value is the VersionDetails object.
        Structure is documented below.
        """
        return pulumi.get(self, "versions")

