# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TraceScopeArgs', 'TraceScope']

@pulumi.input_type
class TraceScopeArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 resource_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 trace_scope_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TraceScope resource.
        :param pulumi.Input[_builtins.str] location: GCP region the TraceScope is stored in. Only `global` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of the projects that are included in this trace scope.
               *  `projects/[PROJECT_ID]`
               A trace scope can include a maximum of 20 projects.
        :param pulumi.Input[_builtins.str] trace_scope_id: A client-assigned identifier for the trace scope.
        :param pulumi.Input[_builtins.str] description: Describes this trace scope.
               The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "resource_names", resource_names)
        pulumi.set(__self__, "trace_scope_id", trace_scope_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        GCP region the TraceScope is stored in. Only `global` is supported.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Names of the projects that are included in this trace scope.
        *  `projects/[PROJECT_ID]`
        A trace scope can include a maximum of 20 projects.
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resource_names", value)

    @_builtins.property
    @pulumi.getter(name="traceScopeId")
    def trace_scope_id(self) -> pulumi.Input[_builtins.str]:
        """
        A client-assigned identifier for the trace scope.
        """
        return pulumi.get(self, "trace_scope_id")

    @trace_scope_id.setter
    def trace_scope_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trace_scope_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes this trace scope.
        The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _TraceScopeState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trace_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TraceScope resources.
        :param pulumi.Input[_builtins.str] create_time: The creation timestamp of the trace scope.
        :param pulumi.Input[_builtins.str] description: Describes this trace scope.
               The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.str] location: GCP region the TraceScope is stored in. Only `global` is supported.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the trace scope.
               For example:
               projects/my-project/locations/global/traceScopes/my-trace-scope
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of the projects that are included in this trace scope.
               *  `projects/[PROJECT_ID]`
               A trace scope can include a maximum of 20 projects.
        :param pulumi.Input[_builtins.str] trace_scope_id: A client-assigned identifier for the trace scope.
        :param pulumi.Input[_builtins.str] update_time: The last update timestamp of the trace scope.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if trace_scope_id is not None:
            pulumi.set(__self__, "trace_scope_id", trace_scope_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the trace scope.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes this trace scope.
        The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        GCP region the TraceScope is stored in. Only `global` is supported.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of the trace scope.
        For example:
        projects/my-project/locations/global/traceScopes/my-trace-scope
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Names of the projects that are included in this trace scope.
        *  `projects/[PROJECT_ID]`
        A trace scope can include a maximum of 20 projects.
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_names", value)

    @_builtins.property
    @pulumi.getter(name="traceScopeId")
    def trace_scope_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A client-assigned identifier for the trace scope.
        """
        return pulumi.get(self, "trace_scope_id")

    @trace_scope_id.setter
    def trace_scope_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_scope_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last update timestamp of the trace scope.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:observability/traceScope:TraceScope")
class TraceScope(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trace_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A trace scope is a collection of resources whose traces are queried together

        ## Example Usage

        ### Observability Trace Scope Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        project_2 = gcp.organizations.Project("project-2",
            project_id="tf-test_26317",
            name="tf-test_4866",
            org_id="123456789",
            deletion_policy="DELETE")
        observability_trace_scope = gcp.observability.TraceScope("observability_trace_scope",
            trace_scope_id="test-scope",
            location="global",
            resource_names=[
                f"projects/{project.project_id}",
                project_2.project_id.apply(lambda project_id: f"projects/{project_id}"),
            ],
            description="A trace scope configured with Terraform",
            opts = pulumi.ResourceOptions(depends_on=[project_2]))
        ```

        ## Import

        TraceScope can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/traceScopes/{{trace_scope_id}}`

        * `{{project}}/{{location}}/{{trace_scope_id}}`

        * `{{location}}/{{trace_scope_id}}`

        When using the `pulumi import` command, TraceScope can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:observability/traceScope:TraceScope default projects/{{project}}/locations/{{location}}/traceScopes/{{trace_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:observability/traceScope:TraceScope default {{project}}/{{location}}/{{trace_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:observability/traceScope:TraceScope default {{location}}/{{trace_scope_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Describes this trace scope.
               The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.str] location: GCP region the TraceScope is stored in. Only `global` is supported.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of the projects that are included in this trace scope.
               *  `projects/[PROJECT_ID]`
               A trace scope can include a maximum of 20 projects.
        :param pulumi.Input[_builtins.str] trace_scope_id: A client-assigned identifier for the trace scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TraceScopeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A trace scope is a collection of resources whose traces are queried together

        ## Example Usage

        ### Observability Trace Scope Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        project_2 = gcp.organizations.Project("project-2",
            project_id="tf-test_26317",
            name="tf-test_4866",
            org_id="123456789",
            deletion_policy="DELETE")
        observability_trace_scope = gcp.observability.TraceScope("observability_trace_scope",
            trace_scope_id="test-scope",
            location="global",
            resource_names=[
                f"projects/{project.project_id}",
                project_2.project_id.apply(lambda project_id: f"projects/{project_id}"),
            ],
            description="A trace scope configured with Terraform",
            opts = pulumi.ResourceOptions(depends_on=[project_2]))
        ```

        ## Import

        TraceScope can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/traceScopes/{{trace_scope_id}}`

        * `{{project}}/{{location}}/{{trace_scope_id}}`

        * `{{location}}/{{trace_scope_id}}`

        When using the `pulumi import` command, TraceScope can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:observability/traceScope:TraceScope default projects/{{project}}/locations/{{location}}/traceScopes/{{trace_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:observability/traceScope:TraceScope default {{project}}/{{location}}/{{trace_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:observability/traceScope:TraceScope default {{location}}/{{trace_scope_id}}
        ```

        :param str resource_name: The name of the resource.
        :param TraceScopeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TraceScopeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trace_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TraceScopeArgs.__new__(TraceScopeArgs)

            __props__.__dict__["description"] = description
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if resource_names is None and not opts.urn:
                raise TypeError("Missing required property 'resource_names'")
            __props__.__dict__["resource_names"] = resource_names
            if trace_scope_id is None and not opts.urn:
                raise TypeError("Missing required property 'trace_scope_id'")
            __props__.__dict__["trace_scope_id"] = trace_scope_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(TraceScope, __self__).__init__(
            'gcp:observability/traceScope:TraceScope',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            trace_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'TraceScope':
        """
        Get an existing TraceScope resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation timestamp of the trace scope.
        :param pulumi.Input[_builtins.str] description: Describes this trace scope.
               The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.str] location: GCP region the TraceScope is stored in. Only `global` is supported.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the trace scope.
               For example:
               projects/my-project/locations/global/traceScopes/my-trace-scope
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of the projects that are included in this trace scope.
               *  `projects/[PROJECT_ID]`
               A trace scope can include a maximum of 20 projects.
        :param pulumi.Input[_builtins.str] trace_scope_id: A client-assigned identifier for the trace scope.
        :param pulumi.Input[_builtins.str] update_time: The last update timestamp of the trace scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TraceScopeState.__new__(_TraceScopeState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_names"] = resource_names
        __props__.__dict__["trace_scope_id"] = trace_scope_id
        __props__.__dict__["update_time"] = update_time
        return TraceScope(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the trace scope.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Describes this trace scope.
        The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        GCP region the TraceScope is stored in. Only `global` is supported.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of the trace scope.
        For example:
        projects/my-project/locations/global/traceScopes/my-trace-scope
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Names of the projects that are included in this trace scope.
        *  `projects/[PROJECT_ID]`
        A trace scope can include a maximum of 20 projects.
        """
        return pulumi.get(self, "resource_names")

    @_builtins.property
    @pulumi.getter(name="traceScopeId")
    def trace_scope_id(self) -> pulumi.Output[_builtins.str]:
        """
        A client-assigned identifier for the trace scope.
        """
        return pulumi.get(self, "trace_scope_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last update timestamp of the trace scope.
        """
        return pulumi.get(self, "update_time")

