# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousDatabaseArgs', 'AutonomousDatabase']

@pulumi.input_type
class AutonomousDatabaseArgs:
    def __init__(__self__, *,
                 autonomous_database_id: pulumi.Input[_builtins.str],
                 database: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 properties: pulumi.Input['AutonomousDatabasePropertiesArgs'],
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AutonomousDatabase resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The ID of the Autonomous Database to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] database: The name of the Autonomous Database. The database name must be unique in
               the project. The name must begin with a letter and can
               contain a maximum of 30 alphanumeric characters.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/AutonomousDatabaseBackup`.
        :param pulumi.Input['AutonomousDatabasePropertiesArgs'] properties: The properties of an Autonomous Database.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] admin_password: The password for the default ADMIN user.
        :param pulumi.Input[_builtins.str] cidr: The subnet CIDR range for the Autonmous Database.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Autonomous Database. The name does not have to
               be unique within your project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the Autonomous Database.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] network: The name of the VPC network used by the Autonomous Database.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the Autonomous Database.
               Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the odb_subnet and backup_odb_subnet.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the Autonomous Database for
               IP allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "properties", properties)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if odb_network is not None:
            pulumi.set(__self__, "odb_network", odb_network)
        if odb_subnet is not None:
            pulumi.set(__self__, "odb_subnet", odb_subnet)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Autonomous Database to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Autonomous Database. The database name must be unique in
        the project. The name must begin with a letter and can
        contain a maximum of 30 alphanumeric characters.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/AutonomousDatabaseBackup`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Input['AutonomousDatabasePropertiesArgs']:
        """
        The properties of an Autonomous Database.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input['AutonomousDatabasePropertiesArgs']):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the default ADMIN user.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet CIDR range for the Autonmous Database.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the Autonomous Database. The name does not have to
        be unique within your project.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels or tags associated with the Autonomous Database.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC network used by the Autonomous Database.
        Format: projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="odbNetwork")
    def odb_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OdbNetwork associated with the Autonomous Database.
        Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}
        It is optional but if specified, this should match the parent ODBNetwork of
        the odb_subnet and backup_odb_subnet.
        """
        return pulumi.get(self, "odb_network")

    @odb_network.setter
    def odb_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network", value)

    @_builtins.property
    @pulumi.getter(name="odbSubnet")
    def odb_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OdbSubnet associated with the Autonomous Database for
        IP allocation. Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "odb_subnet")

    @odb_subnet.setter
    def odb_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_subnet", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AutonomousDatabaseState:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 entitlement_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input['AutonomousDatabasePropertiesArgs']] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabase resources.
        :param pulumi.Input[_builtins.str] admin_password: The password for the default ADMIN user.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The ID of the Autonomous Database to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] cidr: The subnet CIDR range for the Autonmous Database.
        :param pulumi.Input[_builtins.str] create_time: The date and time that the Autonomous Database was created.
        :param pulumi.Input[_builtins.str] database: The name of the Autonomous Database. The database name must be unique in
               the project. The name must begin with a letter and can
               contain a maximum of 30 alphanumeric characters.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Autonomous Database. The name does not have to
               be unique within your project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] entitlement_id: The ID of the subscription entitlement associated with the Autonomous
               Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the Autonomous Database.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/AutonomousDatabaseBackup`.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the Autonomous Database resource in the following format:
               projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
        :param pulumi.Input[_builtins.str] network: The name of the VPC network used by the Autonomous Database.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the Autonomous Database.
               Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the odb_subnet and backup_odb_subnet.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the Autonomous Database for
               IP allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AutonomousDatabasePropertiesArgs'] properties: The properties of an Autonomous Database.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if entitlement_id is not None:
            pulumi.set(__self__, "entitlement_id", entitlement_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if odb_network is not None:
            pulumi.set(__self__, "odb_network", odb_network)
        if odb_subnet is not None:
            pulumi.set(__self__, "odb_subnet", odb_subnet)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the default ADMIN user.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Autonomous Database to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet CIDR range for the Autonmous Database.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the Autonomous Database was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Autonomous Database. The database name must be unique in
        the project. The name must begin with a letter and can
        contain a maximum of 30 alphanumeric characters.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the Autonomous Database. The name does not have to
        be unique within your project.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subscription entitlement associated with the Autonomous
        Database.
        """
        return pulumi.get(self, "entitlement_id")

    @entitlement_id.setter
    def entitlement_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entitlement_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels or tags associated with the Autonomous Database.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/AutonomousDatabaseBackup`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The name of the Autonomous Database resource in the following format:
        projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC network used by the Autonomous Database.
        Format: projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="odbNetwork")
    def odb_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OdbNetwork associated with the Autonomous Database.
        Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}
        It is optional but if specified, this should match the parent ODBNetwork of
        the odb_subnet and backup_odb_subnet.
        """
        return pulumi.get(self, "odb_network")

    @odb_network.setter
    def odb_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network", value)

    @_builtins.property
    @pulumi.getter(name="odbSubnet")
    def odb_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OdbSubnet associated with the Autonomous Database for
        IP allocation. Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "odb_subnet")

    @odb_subnet.setter
    def odb_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_subnet", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AutonomousDatabasePropertiesArgs']]:
        """
        The properties of an Autonomous Database.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AutonomousDatabasePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)


@pulumi.type_token("gcp:oracledatabase/autonomousDatabase:AutonomousDatabase")
class AutonomousDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['AutonomousDatabasePropertiesArgs', 'AutonomousDatabasePropertiesArgsDict']]] = None,
                 __props__=None):
        """
        An AutonomousDatabase resource.

        To get more information about AutonomousDatabase, see:

        * [API documentation](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.autonomousDatabases)
        * How-to Guides
            * [Create Autonomous databases](https://cloud.google.com/oracle/database/docs/create-databases)

        ## Example Usage

        ### Oracledatabase Autonomous Database Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="new",
            project="my-project")
        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="us-east4",
            project="my-project",
            database="mydatabase",
            admin_password="123Abpassword",
            network=default.id,
            cidr="10.5.0.0/24",
            properties={
                "compute_count": 2,
                "data_storage_size_tb": 1,
                "db_version": "19c",
                "db_workload": "OLTP",
                "license_type": "LICENSE_INCLUDED",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Autonomous Database Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="new",
            project="my-project")
        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="us-east4",
            project="my-project",
            display_name="autonomousDatabase displayname",
            database="mydatabase",
            admin_password="123Abpassword",
            network=default.id,
            cidr="10.5.0.0/24",
            labels={
                "label-one": "value-one",
            },
            properties={
                "compute_count": 2,
                "data_storage_size_gb": 48,
                "db_version": "19c",
                "db_edition": "STANDARD_EDITION",
                "db_workload": "OLTP",
                "is_auto_scaling_enabled": True,
                "license_type": "BRING_YOUR_OWN_LICENSE",
                "backup_retention_period_days": 60,
                "character_set": "AL32UTF8",
                "is_storage_auto_scaling_enabled": False,
                "maintenance_schedule_type": "REGULAR",
                "mtls_connection_required": False,
                "n_character_set": "AL16UTF16",
                "operations_insights_state": "NOT_ENABLED",
                "customer_contacts": [{
                    "email": "xyz@example.com",
                }],
                "private_endpoint_ip": "10.5.0.11",
                "private_endpoint_label": "myendpoint",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Autonomous Database Odbnetwork

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="europe-west2",
            project="my-project",
            database="mydatabase",
            admin_password="123Abpassword",
            odb_network="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork",
            odb_subnet="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork/odbSubnets/my-odbsubnet",
            properties={
                "compute_count": 2,
                "data_storage_size_tb": 1,
                "db_version": "19c",
                "db_workload": "OLTP",
                "license_type": "LICENSE_INCLUDED",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Autonomous Database Publicip

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="europe-west2",
            project="my-project",
            database="mydatabase",
            admin_password="123Abpassword",
            properties={
                "compute_count": 2,
                "data_storage_size_tb": 1,
                "db_version": "19c",
                "db_workload": "OLTP",
                "license_type": "LICENSE_INCLUDED",
                "mtls_connection_required": True,
            },
            deletion_protection=True)
        ```

        ## Import

        AutonomousDatabase can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/autonomousDatabases/{{autonomous_database_id}}`

        * `{{project}}/{{location}}/{{autonomous_database_id}}`

        * `{{location}}/{{autonomous_database_id}}`

        When using the `pulumi import` command, AutonomousDatabase can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/autonomousDatabase:AutonomousDatabase default projects/{{project}}/locations/{{location}}/autonomousDatabases/{{autonomous_database_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/autonomousDatabase:AutonomousDatabase default {{project}}/{{location}}/{{autonomous_database_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/autonomousDatabase:AutonomousDatabase default {{location}}/{{autonomous_database_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: The password for the default ADMIN user.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The ID of the Autonomous Database to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] cidr: The subnet CIDR range for the Autonmous Database.
        :param pulumi.Input[_builtins.str] database: The name of the Autonomous Database. The database name must be unique in
               the project. The name must begin with a letter and can
               contain a maximum of 30 alphanumeric characters.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Autonomous Database. The name does not have to
               be unique within your project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the Autonomous Database.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/AutonomousDatabaseBackup`.
        :param pulumi.Input[_builtins.str] network: The name of the VPC network used by the Autonomous Database.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the Autonomous Database.
               Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the odb_subnet and backup_odb_subnet.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the Autonomous Database for
               IP allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AutonomousDatabasePropertiesArgs', 'AutonomousDatabasePropertiesArgsDict']] properties: The properties of an Autonomous Database.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An AutonomousDatabase resource.

        To get more information about AutonomousDatabase, see:

        * [API documentation](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.autonomousDatabases)
        * How-to Guides
            * [Create Autonomous databases](https://cloud.google.com/oracle/database/docs/create-databases)

        ## Example Usage

        ### Oracledatabase Autonomous Database Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="new",
            project="my-project")
        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="us-east4",
            project="my-project",
            database="mydatabase",
            admin_password="123Abpassword",
            network=default.id,
            cidr="10.5.0.0/24",
            properties={
                "compute_count": 2,
                "data_storage_size_tb": 1,
                "db_version": "19c",
                "db_workload": "OLTP",
                "license_type": "LICENSE_INCLUDED",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Autonomous Database Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="new",
            project="my-project")
        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="us-east4",
            project="my-project",
            display_name="autonomousDatabase displayname",
            database="mydatabase",
            admin_password="123Abpassword",
            network=default.id,
            cidr="10.5.0.0/24",
            labels={
                "label-one": "value-one",
            },
            properties={
                "compute_count": 2,
                "data_storage_size_gb": 48,
                "db_version": "19c",
                "db_edition": "STANDARD_EDITION",
                "db_workload": "OLTP",
                "is_auto_scaling_enabled": True,
                "license_type": "BRING_YOUR_OWN_LICENSE",
                "backup_retention_period_days": 60,
                "character_set": "AL32UTF8",
                "is_storage_auto_scaling_enabled": False,
                "maintenance_schedule_type": "REGULAR",
                "mtls_connection_required": False,
                "n_character_set": "AL16UTF16",
                "operations_insights_state": "NOT_ENABLED",
                "customer_contacts": [{
                    "email": "xyz@example.com",
                }],
                "private_endpoint_ip": "10.5.0.11",
                "private_endpoint_label": "myendpoint",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Autonomous Database Odbnetwork

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="europe-west2",
            project="my-project",
            database="mydatabase",
            admin_password="123Abpassword",
            odb_network="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork",
            odb_subnet="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork/odbSubnets/my-odbsubnet",
            properties={
                "compute_count": 2,
                "data_storage_size_tb": 1,
                "db_version": "19c",
                "db_workload": "OLTP",
                "license_type": "LICENSE_INCLUDED",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Autonomous Database Publicip

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_adb = gcp.oracledatabase.AutonomousDatabase("myADB",
            autonomous_database_id="my-instance",
            location="europe-west2",
            project="my-project",
            database="mydatabase",
            admin_password="123Abpassword",
            properties={
                "compute_count": 2,
                "data_storage_size_tb": 1,
                "db_version": "19c",
                "db_workload": "OLTP",
                "license_type": "LICENSE_INCLUDED",
                "mtls_connection_required": True,
            },
            deletion_protection=True)
        ```

        ## Import

        AutonomousDatabase can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/autonomousDatabases/{{autonomous_database_id}}`

        * `{{project}}/{{location}}/{{autonomous_database_id}}`

        * `{{location}}/{{autonomous_database_id}}`

        When using the `pulumi import` command, AutonomousDatabase can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/autonomousDatabase:AutonomousDatabase default projects/{{project}}/locations/{{location}}/autonomousDatabases/{{autonomous_database_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/autonomousDatabase:AutonomousDatabase default {{project}}/{{location}}/{{autonomous_database_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/autonomousDatabase:AutonomousDatabase default {{location}}/{{autonomous_database_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['AutonomousDatabasePropertiesArgs', 'AutonomousDatabasePropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseArgs.__new__(AutonomousDatabaseArgs)

            __props__.__dict__["admin_password"] = admin_password
            if autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_database_id'")
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            __props__.__dict__["cidr"] = cidr
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["network"] = network
            __props__.__dict__["odb_network"] = odb_network
            __props__.__dict__["odb_subnet"] = odb_subnet
            __props__.__dict__["project"] = project
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["entitlement_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutonomousDatabase, __self__).__init__(
            'gcp:oracledatabase/autonomousDatabase:AutonomousDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            entitlement_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            odb_network: Optional[pulumi.Input[_builtins.str]] = None,
            odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Union['AutonomousDatabasePropertiesArgs', 'AutonomousDatabasePropertiesArgsDict']]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'AutonomousDatabase':
        """
        Get an existing AutonomousDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: The password for the default ADMIN user.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The ID of the Autonomous Database to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] cidr: The subnet CIDR range for the Autonmous Database.
        :param pulumi.Input[_builtins.str] create_time: The date and time that the Autonomous Database was created.
        :param pulumi.Input[_builtins.str] database: The name of the Autonomous Database. The database name must be unique in
               the project. The name must begin with a letter and can
               contain a maximum of 30 alphanumeric characters.
        :param pulumi.Input[_builtins.str] display_name: The display name for the Autonomous Database. The name does not have to
               be unique within your project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] entitlement_id: The ID of the subscription entitlement associated with the Autonomous
               Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the Autonomous Database.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/AutonomousDatabaseBackup`.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the Autonomous Database resource in the following format:
               projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
        :param pulumi.Input[_builtins.str] network: The name of the VPC network used by the Autonomous Database.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the Autonomous Database.
               Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the odb_subnet and backup_odb_subnet.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the Autonomous Database for
               IP allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AutonomousDatabasePropertiesArgs', 'AutonomousDatabasePropertiesArgsDict']] properties: The properties of an Autonomous Database.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseState.__new__(_AutonomousDatabaseState)

        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["database"] = database
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["entitlement_id"] = entitlement_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["odb_network"] = odb_network
        __props__.__dict__["odb_subnet"] = odb_subnet
        __props__.__dict__["project"] = project
        __props__.__dict__["properties"] = properties
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        return AutonomousDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password for the default ADMIN user.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Autonomous Database to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.
        """
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subnet CIDR range for the Autonmous Database.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the Autonomous Database was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Autonomous Database. The database name must be unique in
        the project. The name must begin with a letter and can
        contain a maximum of 30 alphanumeric characters.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name for the Autonomous Database. The name does not have to
        be unique within your project.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subscription entitlement associated with the Autonomous
        Database.
        """
        return pulumi.get(self, "entitlement_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels or tags associated with the Autonomous Database.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/AutonomousDatabaseBackup`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The name of the Autonomous Database resource in the following format:
        projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the VPC network used by the Autonomous Database.
        Format: projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="odbNetwork")
    def odb_network(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OdbNetwork associated with the Autonomous Database.
        Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}
        It is optional but if specified, this should match the parent ODBNetwork of
        the odb_subnet and backup_odb_subnet.
        """
        return pulumi.get(self, "odb_network")

    @_builtins.property
    @pulumi.getter(name="odbSubnet")
    def odb_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OdbSubnet associated with the Autonomous Database for
        IP allocation. Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "odb_subnet")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.AutonomousDatabaseProperties']:
        """
        The properties of an Autonomous Database.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

