# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbSystemArgs', 'DbSystem']

@pulumi.input_type
class DbSystemArgs:
    def __init__(__self__, *,
                 db_system_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 odb_subnet: pulumi.Input[_builtins.str],
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input['DbSystemPropertiesArgs']] = None):
        """
        The set of arguments for constructing a DbSystem resource.
        :param pulumi.Input[_builtins.str] db_system_id: The ID of the DbSystem to create. This value is
               restricted to (^a-z?$) and must be a maximum of
               63 characters in length. The value must start with a letter and end with a
               letter or a number.
        :param pulumi.Input[_builtins.str] display_name: The display name for the System db. The name does not have to
               be unique within your project.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the DbSystem for IP
               allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] gcp_oracle_zone: The GCP Oracle zone where Oracle DbSystem is hosted.
               Example: us-east4-b-r2.
               If not specified, the system will pick a zone based on availability.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the DbSystem.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the DbSystem.
               Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the OdbSubnet.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['DbSystemPropertiesArgs'] properties: The properties of a DbSystem.
               Structure is documented below.
        """
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "odb_subnet", odb_subnet)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if gcp_oracle_zone is not None:
            pulumi.set(__self__, "gcp_oracle_zone", gcp_oracle_zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if odb_network is not None:
            pulumi.set(__self__, "odb_network", odb_network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the DbSystem to create. This value is
        restricted to (^a-z?$) and must be a maximum of
        63 characters in length. The value must start with a letter and end with a
        letter or a number.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name for the System db. The name does not have to
        be unique within your project.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="odbSubnet")
    def odb_subnet(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the OdbSubnet associated with the DbSystem for IP
        allocation. Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "odb_subnet")

    @odb_subnet.setter
    def odb_subnet(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "odb_subnet", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP Oracle zone where Oracle DbSystem is hosted.
        Example: us-east4-b-r2.
        If not specified, the system will pick a zone based on availability.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @gcp_oracle_zone.setter
    def gcp_oracle_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_oracle_zone", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels or tags associated with the DbSystem.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="odbNetwork")
    def odb_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OdbNetwork associated with the DbSystem.
        Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
        It is optional but if specified, this should match the parent ODBNetwork of
        the OdbSubnet.
        """
        return pulumi.get(self, "odb_network")

    @odb_network.setter
    def odb_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DbSystemPropertiesArgs']]:
        """
        The properties of a DbSystem.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DbSystemPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class _DbSystemState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 entitlement_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_url: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input['DbSystemPropertiesArgs']] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DbSystem resources.
        :param pulumi.Input[_builtins.str] create_time: The date and time that the DbSystem was created.
        :param pulumi.Input[_builtins.str] db_system_id: The ID of the DbSystem to create. This value is
               restricted to (^a-z?$) and must be a maximum of
               63 characters in length. The value must start with a letter and end with a
               letter or a number.
        :param pulumi.Input[_builtins.str] display_name: The display name for the System db. The name does not have to
               be unique within your project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] entitlement_id: The ID of the subscription entitlement associated with the DbSystem
        :param pulumi.Input[_builtins.str] gcp_oracle_zone: The GCP Oracle zone where Oracle DbSystem is hosted.
               Example: us-east4-b-r2.
               If not specified, the system will pick a zone based on availability.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the DbSystem.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the DbSystem resource in the following format:
               projects/{project}/locations/{region}/dbSystems/{db_system}
        :param pulumi.Input[_builtins.str] oci_url: HTTPS link to OCI resources exposed to Customer via UI Interface.
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the DbSystem.
               Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the OdbSubnet.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the DbSystem for IP
               allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['DbSystemPropertiesArgs'] properties: The properties of a DbSystem.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if entitlement_id is not None:
            pulumi.set(__self__, "entitlement_id", entitlement_id)
        if gcp_oracle_zone is not None:
            pulumi.set(__self__, "gcp_oracle_zone", gcp_oracle_zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oci_url is not None:
            pulumi.set(__self__, "oci_url", oci_url)
        if odb_network is not None:
            pulumi.set(__self__, "odb_network", odb_network)
        if odb_subnet is not None:
            pulumi.set(__self__, "odb_subnet", odb_subnet)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the DbSystem was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the DbSystem to create. This value is
        restricted to (^a-z?$) and must be a maximum of
        63 characters in length. The value must start with a letter and end with a
        letter or a number.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the System db. The name does not have to
        be unique within your project.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subscription entitlement associated with the DbSystem
        """
        return pulumi.get(self, "entitlement_id")

    @entitlement_id.setter
    def entitlement_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entitlement_id", value)

    @_builtins.property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP Oracle zone where Oracle DbSystem is hosted.
        Example: us-east4-b-r2.
        If not specified, the system will pick a zone based on availability.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @gcp_oracle_zone.setter
    def gcp_oracle_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_oracle_zone", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels or tags associated with the DbSystem.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The name of the DbSystem resource in the following format:
        projects/{project}/locations/{region}/dbSystems/{db_system}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTPS link to OCI resources exposed to Customer via UI Interface.
        """
        return pulumi.get(self, "oci_url")

    @oci_url.setter
    def oci_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_url", value)

    @_builtins.property
    @pulumi.getter(name="odbNetwork")
    def odb_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OdbNetwork associated with the DbSystem.
        Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
        It is optional but if specified, this should match the parent ODBNetwork of
        the OdbSubnet.
        """
        return pulumi.get(self, "odb_network")

    @odb_network.setter
    def odb_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network", value)

    @_builtins.property
    @pulumi.getter(name="odbSubnet")
    def odb_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OdbSubnet associated with the DbSystem for IP
        allocation. Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "odb_subnet")

    @odb_subnet.setter
    def odb_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_subnet", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DbSystemPropertiesArgs']]:
        """
        The properties of a DbSystem.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DbSystemPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)


@pulumi.type_token("gcp:oracledatabase/dbSystem:DbSystem")
class DbSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['DbSystemPropertiesArgs', 'DbSystemPropertiesArgsDict']]] = None,
                 __props__=None):
        """
        A DbSystem Resource

        ## Example Usage

        ### Oracledatabase Db System Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_db_system = gcp.oracledatabase.DbSystem("my_db_system",
            db_system_id="my-instance",
            display_name="my-instance displayname",
            location="europe-west2",
            project="my-project",
            odb_network="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork",
            odb_subnet="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork/odbSubnets/my-odbsubnet",
            properties={
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "compute_count": 4,
                "hostname_prefix": "hostname1",
                "shape": "VM.Standard.x86",
                "initial_data_storage_size_gb": 256,
                "database_edition": "STANDARD_EDITION",
                "license_model": "LICENSE_INCLUDED",
                "time_zone": {
                    "id": "UTC",
                },
                "db_home": {
                    "db_version": "19.0.0.0",
                    "database": {
                        "admin_password": "ABcde_1#234",
                        "database_id": "mydb",
                        "db_name": "db",
                    },
                },
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Db System Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_db_system = gcp.oracledatabase.DbSystem("my_db_system",
            db_system_id="my-instance",
            display_name="my-instance displayname",
            location="europe-west2",
            project="my-project",
            odb_network="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork",
            odb_subnet="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork/odbSubnets/my-odbsubnet",
            properties={
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "compute_count": 4,
                "hostname_prefix": "hostname3",
                "compute_model": "ECPU",
                "data_storage_size_gb": 256,
                "memory_size_gb": 8,
                "shape": "VM.Standard.x86",
                "initial_data_storage_size_gb": 256,
                "database_edition": "STANDARD_EDITION",
                "license_model": "LICENSE_INCLUDED",
                "private_ip": "10.1.2.127",
                "db_home": {
                    "db_version": "19.0.0.0",
                    "database": {
                        "db_name": "db",
                        "db_unique_name": "dbunique",
                        "admin_password": "ABcde_1#2345",
                        "tde_wallet_password": "ABcde_1#2345",
                        "database_id": "mydb",
                    },
                    "is_unified_auditing_enabled": True,
                },
            },
            deletion_protection=True)
        ```

        ## Import

        DbSystem can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dbSystems/{{db_system_id}}`

        * `{{project}}/{{location}}/{{db_system_id}}`

        * `{{location}}/{{db_system_id}}`

        When using the `pulumi import` command, DbSystem can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/dbSystem:DbSystem default projects/{{project}}/locations/{{location}}/dbSystems/{{db_system_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/dbSystem:DbSystem default {{project}}/{{location}}/{{db_system_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/dbSystem:DbSystem default {{location}}/{{db_system_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_system_id: The ID of the DbSystem to create. This value is
               restricted to (^a-z?$) and must be a maximum of
               63 characters in length. The value must start with a letter and end with a
               letter or a number.
        :param pulumi.Input[_builtins.str] display_name: The display name for the System db. The name does not have to
               be unique within your project.
        :param pulumi.Input[_builtins.str] gcp_oracle_zone: The GCP Oracle zone where Oracle DbSystem is hosted.
               Example: us-east4-b-r2.
               If not specified, the system will pick a zone based on availability.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the DbSystem.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the DbSystem.
               Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the OdbSubnet.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the DbSystem for IP
               allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['DbSystemPropertiesArgs', 'DbSystemPropertiesArgsDict']] properties: The properties of a DbSystem.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A DbSystem Resource

        ## Example Usage

        ### Oracledatabase Db System Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_db_system = gcp.oracledatabase.DbSystem("my_db_system",
            db_system_id="my-instance",
            display_name="my-instance displayname",
            location="europe-west2",
            project="my-project",
            odb_network="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork",
            odb_subnet="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork/odbSubnets/my-odbsubnet",
            properties={
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "compute_count": 4,
                "hostname_prefix": "hostname1",
                "shape": "VM.Standard.x86",
                "initial_data_storage_size_gb": 256,
                "database_edition": "STANDARD_EDITION",
                "license_model": "LICENSE_INCLUDED",
                "time_zone": {
                    "id": "UTC",
                },
                "db_home": {
                    "db_version": "19.0.0.0",
                    "database": {
                        "admin_password": "ABcde_1#234",
                        "database_id": "mydb",
                        "db_name": "db",
                    },
                },
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Db System Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_db_system = gcp.oracledatabase.DbSystem("my_db_system",
            db_system_id="my-instance",
            display_name="my-instance displayname",
            location="europe-west2",
            project="my-project",
            odb_network="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork",
            odb_subnet="projects/my-project/locations/europe-west2/odbNetworks/my-odbnetwork/odbSubnets/my-odbsubnet",
            properties={
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "compute_count": 4,
                "hostname_prefix": "hostname3",
                "compute_model": "ECPU",
                "data_storage_size_gb": 256,
                "memory_size_gb": 8,
                "shape": "VM.Standard.x86",
                "initial_data_storage_size_gb": 256,
                "database_edition": "STANDARD_EDITION",
                "license_model": "LICENSE_INCLUDED",
                "private_ip": "10.1.2.127",
                "db_home": {
                    "db_version": "19.0.0.0",
                    "database": {
                        "db_name": "db",
                        "db_unique_name": "dbunique",
                        "admin_password": "ABcde_1#2345",
                        "tde_wallet_password": "ABcde_1#2345",
                        "database_id": "mydb",
                    },
                    "is_unified_auditing_enabled": True,
                },
            },
            deletion_protection=True)
        ```

        ## Import

        DbSystem can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dbSystems/{{db_system_id}}`

        * `{{project}}/{{location}}/{{db_system_id}}`

        * `{{location}}/{{db_system_id}}`

        When using the `pulumi import` command, DbSystem can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/dbSystem:DbSystem default projects/{{project}}/locations/{{location}}/dbSystems/{{db_system_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/dbSystem:DbSystem default {{project}}/{{location}}/{{db_system_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/dbSystem:DbSystem default {{location}}/{{db_system_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DbSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['DbSystemPropertiesArgs', 'DbSystemPropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbSystemArgs.__new__(DbSystemArgs)

            if db_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_system_id'")
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["gcp_oracle_zone"] = gcp_oracle_zone
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["odb_network"] = odb_network
            if odb_subnet is None and not opts.urn:
                raise TypeError("Missing required property 'odb_subnet'")
            __props__.__dict__["odb_subnet"] = odb_subnet
            __props__.__dict__["project"] = project
            __props__.__dict__["properties"] = properties
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["entitlement_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["oci_url"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DbSystem, __self__).__init__(
            'gcp:oracledatabase/dbSystem:DbSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            entitlement_id: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_oracle_zone: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_url: Optional[pulumi.Input[_builtins.str]] = None,
            odb_network: Optional[pulumi.Input[_builtins.str]] = None,
            odb_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Union['DbSystemPropertiesArgs', 'DbSystemPropertiesArgsDict']]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DbSystem':
        """
        Get an existing DbSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The date and time that the DbSystem was created.
        :param pulumi.Input[_builtins.str] db_system_id: The ID of the DbSystem to create. This value is
               restricted to (^a-z?$) and must be a maximum of
               63 characters in length. The value must start with a letter and end with a
               letter or a number.
        :param pulumi.Input[_builtins.str] display_name: The display name for the System db. The name does not have to
               be unique within your project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] entitlement_id: The ID of the subscription entitlement associated with the DbSystem
        :param pulumi.Input[_builtins.str] gcp_oracle_zone: The GCP Oracle zone where Oracle DbSystem is hosted.
               Example: us-east4-b-r2.
               If not specified, the system will pick a zone based on availability.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels or tags associated with the DbSystem.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the DbSystem resource in the following format:
               projects/{project}/locations/{region}/dbSystems/{db_system}
        :param pulumi.Input[_builtins.str] oci_url: HTTPS link to OCI resources exposed to Customer via UI Interface.
        :param pulumi.Input[_builtins.str] odb_network: The name of the OdbNetwork associated with the DbSystem.
               Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
               It is optional but if specified, this should match the parent ODBNetwork of
               the OdbSubnet.
        :param pulumi.Input[_builtins.str] odb_subnet: The name of the OdbSubnet associated with the DbSystem for IP
               allocation. Format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['DbSystemPropertiesArgs', 'DbSystemPropertiesArgsDict']] properties: The properties of a DbSystem.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbSystemState.__new__(_DbSystemState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["entitlement_id"] = entitlement_id
        __props__.__dict__["gcp_oracle_zone"] = gcp_oracle_zone
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["oci_url"] = oci_url
        __props__.__dict__["odb_network"] = odb_network
        __props__.__dict__["odb_subnet"] = odb_subnet
        __props__.__dict__["project"] = project
        __props__.__dict__["properties"] = properties
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        return DbSystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the DbSystem was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the DbSystem to create. This value is
        restricted to (^a-z?$) and must be a maximum of
        63 characters in length. The value must start with a letter and end with a
        letter or a number.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name for the System db. The name does not have to
        be unique within your project.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subscription entitlement associated with the DbSystem
        """
        return pulumi.get(self, "entitlement_id")

    @_builtins.property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The GCP Oracle zone where Oracle DbSystem is hosted.
        Example: us-east4-b-r2.
        If not specified, the system will pick a zone based on availability.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels or tags associated with the DbSystem.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The name of the DbSystem resource in the following format:
        projects/{project}/locations/{region}/dbSystems/{db_system}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> pulumi.Output[_builtins.str]:
        """
        HTTPS link to OCI resources exposed to Customer via UI Interface.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter(name="odbNetwork")
    def odb_network(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the OdbNetwork associated with the DbSystem.
        Format: projects/{project}/locations/{location}/odbNetworks/{odb_network}
        It is optional but if specified, this should match the parent ODBNetwork of
        the OdbSubnet.
        """
        return pulumi.get(self, "odb_network")

    @_builtins.property
    @pulumi.getter(name="odbSubnet")
    def odb_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OdbSubnet associated with the DbSystem for IP
        allocation. Format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "odb_subnet")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional['outputs.DbSystemProperties']]:
        """
        The properties of a DbSystem.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

