# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetClientConfigResult',
    'AwaitableGetClientConfigResult',
    'get_client_config',
    'get_client_config_output',
]

@pulumi.output_type
class GetClientConfigResult:
    """
    A collection of values returned by getClientConfig.
    """
    def __init__(__self__, access_token=None, default_labels=None, id=None, project=None, region=None, zone=None):
        if access_token and not isinstance(access_token, str):
            raise TypeError("Expected argument 'access_token' to be a str")
        pulumi.set(__self__, "access_token", access_token)
        if default_labels and not isinstance(default_labels, dict):
            raise TypeError("Expected argument 'default_labels' to be a dict")
        pulumi.set(__self__, "default_labels", default_labels)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> _builtins.str:
        """
        The OAuth2 access token used by the client to authenticate against the Google Cloud API.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="defaultLabels")
    def default_labels(self) -> Mapping[str, _builtins.str]:
        """
        The default labels configured on the provider.
        """
        return pulumi.get(self, "default_labels")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project to apply any resources to.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region to operate under.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The zone to operate under.
        """
        return pulumi.get(self, "zone")


class AwaitableGetClientConfigResult(GetClientConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientConfigResult(
            access_token=self.access_token,
            default_labels=self.default_labels,
            id=self.id,
            project=self.project,
            region=self.region,
            zone=self.zone)


def get_client_config(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientConfigResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    current = gcp.organizations.get_client_config()
    pulumi.export("project", current.project)
    ```

    ### Configure Kubernetes Provider With OAuth2 Access Token
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:organizations/getClientConfig:getClientConfig', __args__, opts=opts, typ=GetClientConfigResult).value

    return AwaitableGetClientConfigResult(
        access_token=pulumi.get(__ret__, 'access_token'),
        default_labels=pulumi.get(__ret__, 'default_labels'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'),
        zone=pulumi.get(__ret__, 'zone'))
def get_client_config_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClientConfigResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    current = gcp.organizations.get_client_config()
    pulumi.export("project", current.project)
    ```

    ### Configure Kubernetes Provider With OAuth2 Access Token
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:organizations/getClientConfig:getClientConfig', __args__, opts=opts, typ=GetClientConfigResult)
    return __ret__.apply(lambda __response__: GetClientConfigResult(
        access_token=pulumi.get(__response__, 'access_token'),
        default_labels=pulumi.get(__response__, 'default_labels'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region'),
        zone=pulumi.get(__response__, 'zone')))
