# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2PolicyOrchestratorForOrganizationArgs', 'V2PolicyOrchestratorForOrganization']

@pulumi.input_type
class V2PolicyOrchestratorForOrganizationArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 orchestrated_resource: pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs'],
                 organization_id: pulumi.Input[_builtins.str],
                 policy_orchestrator_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 orchestration_scope: Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a V2PolicyOrchestratorForOrganization resource.
        :param pulumi.Input[_builtins.str] action: Required. Action to be done by the orchestrator in
               `projects/{project_id}/zones/{zone_id}` locations defined by the
               `orchestration_scope`. Allowed values:
               - `UPSERT` - Orchestrator will create or update target resources.
               - `DELETE` - Orchestrator will delete target resources, if they exist
        :param pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs'] orchestrated_resource: Represents a resource that is being orchestrated by the policy orchestrator.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] organization_id: Part of `parent`. Required. The parent resource name in the form of:
               * `organizations/{organization_id}/locations/global`
               * `folders/{folder_id}/locations/global`
               * `projects/{project_id_or_number}/locations/global`
        :param pulumi.Input[_builtins.str] policy_orchestrator_id: Required. The logical identifier of the policy orchestrator, with the following
               restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the parent.
        :param pulumi.Input[_builtins.str] description: Optional. Freeform text describing the purpose of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs'] orchestration_scope: Defines a set of selectors which drive which resources are in scope of policy
               orchestration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: Optional. State of the orchestrator. Can be updated to change orchestrator behaviour.
               Allowed values:
               - `ACTIVE` - orchestrator is actively looking for actions to be taken.
               - `STOPPED` - orchestrator won't make any changes.
               Note: There might be more states added in the future. We use string here
               instead of an enum, to avoid the need of propagating new states to all the
               client code.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "orchestrated_resource", orchestrated_resource)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "policy_orchestrator_id", policy_orchestrator_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if orchestration_scope is not None:
            pulumi.set(__self__, "orchestration_scope", orchestration_scope)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Required. Action to be done by the orchestrator in
        `projects/{project_id}/zones/{zone_id}` locations defined by the
        `orchestration_scope`. Allowed values:
        - `UPSERT` - Orchestrator will create or update target resources.
        - `DELETE` - Orchestrator will delete target resources, if they exist
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="orchestratedResource")
    def orchestrated_resource(self) -> pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs']:
        """
        Represents a resource that is being orchestrated by the policy orchestrator.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestrated_resource")

    @orchestrated_resource.setter
    def orchestrated_resource(self, value: pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs']):
        pulumi.set(self, "orchestrated_resource", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        Part of `parent`. Required. The parent resource name in the form of:
        * `organizations/{organization_id}/locations/global`
        * `folders/{folder_id}/locations/global`
        * `projects/{project_id_or_number}/locations/global`
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="policyOrchestratorId")
    def policy_orchestrator_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The logical identifier of the policy orchestrator, with the following
        restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the parent.
        """
        return pulumi.get(self, "policy_orchestrator_id")

    @policy_orchestrator_id.setter
    def policy_orchestrator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_orchestrator_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Freeform text describing the purpose of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="orchestrationScope")
    def orchestration_scope(self) -> Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs']]:
        """
        Defines a set of selectors which drive which resources are in scope of policy
        orchestration.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestration_scope")

    @orchestration_scope.setter
    def orchestration_scope(self, value: Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs']]):
        pulumi.set(self, "orchestration_scope", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. State of the orchestrator. Can be updated to change orchestrator behaviour.
        Allowed values:
        - `ACTIVE` - orchestrator is actively looking for actions to be taken.
        - `STOPPED` - orchestrator won't make any changes.
        Note: There might be more states added in the future. We use string here
        instead of an enum, to avoid the need of propagating new states to all the
        client code.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _V2PolicyOrchestratorForOrganizationState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 orchestrated_resource: Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs']] = None,
                 orchestration_scope: Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs']] = None,
                 orchestration_states: Optional[pulumi.Input[Sequence[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationStateArgs']]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering V2PolicyOrchestratorForOrganization resources.
        :param pulumi.Input[_builtins.str] action: Required. Action to be done by the orchestrator in
               `projects/{project_id}/zones/{zone_id}` locations defined by the
               `orchestration_scope`. Allowed values:
               - `UPSERT` - Orchestrator will create or update target resources.
               - `DELETE` - Orchestrator will delete target resources, if they exist
        :param pulumi.Input[_builtins.str] create_time: Output only. Timestamp when the policy orchestrator resource was created.
        :param pulumi.Input[_builtins.str] description: Optional. Freeform text describing the purpose of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Output only. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Immutable. Identifier. In form of
               * `organizations/{organization_id}/locations/global/policyOrchestrators/{orchestrator_id}`
               * `folders/{folder_id}/locations/global/policyOrchestrators/{orchestrator_id}`
               * `projects/{project_id_or_number}/locations/global/policyOrchestrators/{orchestrator_id}`
        :param pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs'] orchestrated_resource: Represents a resource that is being orchestrated by the policy orchestrator.
               Structure is documented below.
        :param pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs'] orchestration_scope: Defines a set of selectors which drive which resources are in scope of policy
               orchestration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationStateArgs']]] orchestration_states: Describes the state of the orchestration process.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] organization_id: Part of `parent`. Required. The parent resource name in the form of:
               * `organizations/{organization_id}/locations/global`
               * `folders/{folder_id}/locations/global`
               * `projects/{project_id_or_number}/locations/global`
        :param pulumi.Input[_builtins.str] policy_orchestrator_id: Required. The logical identifier of the policy orchestrator, with the following
               restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the parent.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Output only. Set to true, if the there are ongoing changes being applied by the
               orchestrator.
        :param pulumi.Input[_builtins.str] state: Optional. State of the orchestrator. Can be updated to change orchestrator behaviour.
               Allowed values:
               - `ACTIVE` - orchestrator is actively looking for actions to be taken.
               - `STOPPED` - orchestrator won't make any changes.
               Note: There might be more states added in the future. We use string here
               instead of an enum, to avoid the need of propagating new states to all the
               client code.
        :param pulumi.Input[_builtins.str] update_time: Output only. Timestamp when the policy orchestrator resource was last modified.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if orchestrated_resource is not None:
            pulumi.set(__self__, "orchestrated_resource", orchestrated_resource)
        if orchestration_scope is not None:
            pulumi.set(__self__, "orchestration_scope", orchestration_scope)
        if orchestration_states is not None:
            pulumi.set(__self__, "orchestration_states", orchestration_states)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if policy_orchestrator_id is not None:
            pulumi.set(__self__, "policy_orchestrator_id", policy_orchestrator_id)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. Action to be done by the orchestrator in
        `projects/{project_id}/zones/{zone_id}` locations defined by the
        `orchestration_scope`. Allowed values:
        - `UPSERT` - Orchestrator will create or update target resources.
        - `DELETE` - Orchestrator will delete target resources, if they exist
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Timestamp when the policy orchestrator resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Freeform text describing the purpose of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutable. Identifier. In form of
        * `organizations/{organization_id}/locations/global/policyOrchestrators/{orchestrator_id}`
        * `folders/{folder_id}/locations/global/policyOrchestrators/{orchestrator_id}`
        * `projects/{project_id_or_number}/locations/global/policyOrchestrators/{orchestrator_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orchestratedResource")
    def orchestrated_resource(self) -> Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs']]:
        """
        Represents a resource that is being orchestrated by the policy orchestrator.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestrated_resource")

    @orchestrated_resource.setter
    def orchestrated_resource(self, value: Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs']]):
        pulumi.set(self, "orchestrated_resource", value)

    @_builtins.property
    @pulumi.getter(name="orchestrationScope")
    def orchestration_scope(self) -> Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs']]:
        """
        Defines a set of selectors which drive which resources are in scope of policy
        orchestration.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestration_scope")

    @orchestration_scope.setter
    def orchestration_scope(self, value: Optional[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs']]):
        pulumi.set(self, "orchestration_scope", value)

    @_builtins.property
    @pulumi.getter(name="orchestrationStates")
    def orchestration_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationStateArgs']]]]:
        """
        Describes the state of the orchestration process.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestration_states")

    @orchestration_states.setter
    def orchestration_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2PolicyOrchestratorForOrganizationOrchestrationStateArgs']]]]):
        pulumi.set(self, "orchestration_states", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Part of `parent`. Required. The parent resource name in the form of:
        * `organizations/{organization_id}/locations/global`
        * `folders/{folder_id}/locations/global`
        * `projects/{project_id_or_number}/locations/global`
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="policyOrchestratorId")
    def policy_orchestrator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The logical identifier of the policy orchestrator, with the following
        restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the parent.
        """
        return pulumi.get(self, "policy_orchestrator_id")

    @policy_orchestrator_id.setter
    def policy_orchestrator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_orchestrator_id", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Output only. Set to true, if the there are ongoing changes being applied by the
        orchestrator.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. State of the orchestrator. Can be updated to change orchestrator behaviour.
        Allowed values:
        - `ACTIVE` - orchestrator is actively looking for actions to be taken.
        - `STOPPED` - orchestrator won't make any changes.
        Note: There might be more states added in the future. We use string here
        instead of an enum, to avoid the need of propagating new states to all the
        client code.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Timestamp when the policy orchestrator resource was last modified.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:osconfig/v2PolicyOrchestratorForOrganization:V2PolicyOrchestratorForOrganization")
class V2PolicyOrchestratorForOrganization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 orchestrated_resource: Optional[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs', 'V2PolicyOrchestratorForOrganizationOrchestratedResourceArgsDict']]] = None,
                 orchestration_scope: Optional[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs', 'V2PolicyOrchestratorForOrganizationOrchestrationScopeArgsDict']]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        PolicyOrchestrator helps managing project+zone level policy resources (e.g.
        OS Policy Assignments), by providing tools to create, update and delete them
        across projects and locations, at scale.

        ## Example Usage

        ### Osconfigv2 Policy Orchestrator For Organization Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy_orchestrator_for_organization = gcp.osconfig.V2PolicyOrchestratorForOrganization("policy_orchestrator_for_organization",
            policy_orchestrator_id="po-org",
            organization_id="123456789",
            state="ACTIVE",
            action="UPSERT",
            orchestrated_resource={
                "id": "test-orchestrated-resource-org",
                "os_policy_assignment_v1_payload": {
                    "os_policies": [{
                        "id": "test-os-policy-org",
                        "mode": "VALIDATION",
                        "resource_groups": [{
                            "resources": [{
                                "id": "resource-tf",
                                "file": {
                                    "content": "file-content-tf",
                                    "path": "file-path-tf-1",
                                    "state": "PRESENT",
                                },
                            }],
                        }],
                    }],
                    "instance_filter": {
                        "inventories": [{
                            "os_short_name": "windows-10",
                        }],
                    },
                    "rollout": {
                        "disruption_budget": {
                            "percent": 100,
                        },
                        "min_wait_duration": "60s",
                    },
                },
            },
            labels={
                "state": "active",
            },
            orchestration_scope={
                "selectors": [{
                    "location_selector": {
                        "included_locations": [""],
                    },
                }],
            })
        ```

        ## Import

        PolicyOrchestratorForOrganization can be imported using any of these accepted formats:

        * `organizations/{{organization_id}}/locations/global/policyOrchestrators/{{policy_orchestrator_id}}`

        * `{{organization_id}}/{{policy_orchestrator_id}}`

        When using the `pulumi import` command, PolicyOrchestratorForOrganization can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:osconfig/v2PolicyOrchestratorForOrganization:V2PolicyOrchestratorForOrganization default organizations/{{organization_id}}/locations/global/policyOrchestrators/{{policy_orchestrator_id}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/v2PolicyOrchestratorForOrganization:V2PolicyOrchestratorForOrganization default {{organization_id}}/{{policy_orchestrator_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Required. Action to be done by the orchestrator in
               `projects/{project_id}/zones/{zone_id}` locations defined by the
               `orchestration_scope`. Allowed values:
               - `UPSERT` - Orchestrator will create or update target resources.
               - `DELETE` - Orchestrator will delete target resources, if they exist
        :param pulumi.Input[_builtins.str] description: Optional. Freeform text describing the purpose of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs', 'V2PolicyOrchestratorForOrganizationOrchestratedResourceArgsDict']] orchestrated_resource: Represents a resource that is being orchestrated by the policy orchestrator.
               Structure is documented below.
        :param pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs', 'V2PolicyOrchestratorForOrganizationOrchestrationScopeArgsDict']] orchestration_scope: Defines a set of selectors which drive which resources are in scope of policy
               orchestration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] organization_id: Part of `parent`. Required. The parent resource name in the form of:
               * `organizations/{organization_id}/locations/global`
               * `folders/{folder_id}/locations/global`
               * `projects/{project_id_or_number}/locations/global`
        :param pulumi.Input[_builtins.str] policy_orchestrator_id: Required. The logical identifier of the policy orchestrator, with the following
               restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the parent.
        :param pulumi.Input[_builtins.str] state: Optional. State of the orchestrator. Can be updated to change orchestrator behaviour.
               Allowed values:
               - `ACTIVE` - orchestrator is actively looking for actions to be taken.
               - `STOPPED` - orchestrator won't make any changes.
               Note: There might be more states added in the future. We use string here
               instead of an enum, to avoid the need of propagating new states to all the
               client code.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2PolicyOrchestratorForOrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        PolicyOrchestrator helps managing project+zone level policy resources (e.g.
        OS Policy Assignments), by providing tools to create, update and delete them
        across projects and locations, at scale.

        ## Example Usage

        ### Osconfigv2 Policy Orchestrator For Organization Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy_orchestrator_for_organization = gcp.osconfig.V2PolicyOrchestratorForOrganization("policy_orchestrator_for_organization",
            policy_orchestrator_id="po-org",
            organization_id="123456789",
            state="ACTIVE",
            action="UPSERT",
            orchestrated_resource={
                "id": "test-orchestrated-resource-org",
                "os_policy_assignment_v1_payload": {
                    "os_policies": [{
                        "id": "test-os-policy-org",
                        "mode": "VALIDATION",
                        "resource_groups": [{
                            "resources": [{
                                "id": "resource-tf",
                                "file": {
                                    "content": "file-content-tf",
                                    "path": "file-path-tf-1",
                                    "state": "PRESENT",
                                },
                            }],
                        }],
                    }],
                    "instance_filter": {
                        "inventories": [{
                            "os_short_name": "windows-10",
                        }],
                    },
                    "rollout": {
                        "disruption_budget": {
                            "percent": 100,
                        },
                        "min_wait_duration": "60s",
                    },
                },
            },
            labels={
                "state": "active",
            },
            orchestration_scope={
                "selectors": [{
                    "location_selector": {
                        "included_locations": [""],
                    },
                }],
            })
        ```

        ## Import

        PolicyOrchestratorForOrganization can be imported using any of these accepted formats:

        * `organizations/{{organization_id}}/locations/global/policyOrchestrators/{{policy_orchestrator_id}}`

        * `{{organization_id}}/{{policy_orchestrator_id}}`

        When using the `pulumi import` command, PolicyOrchestratorForOrganization can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:osconfig/v2PolicyOrchestratorForOrganization:V2PolicyOrchestratorForOrganization default organizations/{{organization_id}}/locations/global/policyOrchestrators/{{policy_orchestrator_id}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/v2PolicyOrchestratorForOrganization:V2PolicyOrchestratorForOrganization default {{organization_id}}/{{policy_orchestrator_id}}
        ```

        :param str resource_name: The name of the resource.
        :param V2PolicyOrchestratorForOrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2PolicyOrchestratorForOrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 orchestrated_resource: Optional[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs', 'V2PolicyOrchestratorForOrganizationOrchestratedResourceArgsDict']]] = None,
                 orchestration_scope: Optional[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs', 'V2PolicyOrchestratorForOrganizationOrchestrationScopeArgsDict']]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2PolicyOrchestratorForOrganizationArgs.__new__(V2PolicyOrchestratorForOrganizationArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if orchestrated_resource is None and not opts.urn:
                raise TypeError("Missing required property 'orchestrated_resource'")
            __props__.__dict__["orchestrated_resource"] = orchestrated_resource
            __props__.__dict__["orchestration_scope"] = orchestration_scope
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if policy_orchestrator_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_orchestrator_id'")
            __props__.__dict__["policy_orchestrator_id"] = policy_orchestrator_id
            __props__.__dict__["state"] = state
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["orchestration_states"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(V2PolicyOrchestratorForOrganization, __self__).__init__(
            'gcp:osconfig/v2PolicyOrchestratorForOrganization:V2PolicyOrchestratorForOrganization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            orchestrated_resource: Optional[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs', 'V2PolicyOrchestratorForOrganizationOrchestratedResourceArgsDict']]] = None,
            orchestration_scope: Optional[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs', 'V2PolicyOrchestratorForOrganizationOrchestrationScopeArgsDict']]] = None,
            orchestration_states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestrationStateArgs', 'V2PolicyOrchestratorForOrganizationOrchestrationStateArgsDict']]]]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_orchestrator_id: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'V2PolicyOrchestratorForOrganization':
        """
        Get an existing V2PolicyOrchestratorForOrganization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Required. Action to be done by the orchestrator in
               `projects/{project_id}/zones/{zone_id}` locations defined by the
               `orchestration_scope`. Allowed values:
               - `UPSERT` - Orchestrator will create or update target resources.
               - `DELETE` - Orchestrator will delete target resources, if they exist
        :param pulumi.Input[_builtins.str] create_time: Output only. Timestamp when the policy orchestrator resource was created.
        :param pulumi.Input[_builtins.str] description: Optional. Freeform text describing the purpose of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Output only. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Immutable. Identifier. In form of
               * `organizations/{organization_id}/locations/global/policyOrchestrators/{orchestrator_id}`
               * `folders/{folder_id}/locations/global/policyOrchestrators/{orchestrator_id}`
               * `projects/{project_id_or_number}/locations/global/policyOrchestrators/{orchestrator_id}`
        :param pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestratedResourceArgs', 'V2PolicyOrchestratorForOrganizationOrchestratedResourceArgsDict']] orchestrated_resource: Represents a resource that is being orchestrated by the policy orchestrator.
               Structure is documented below.
        :param pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestrationScopeArgs', 'V2PolicyOrchestratorForOrganizationOrchestrationScopeArgsDict']] orchestration_scope: Defines a set of selectors which drive which resources are in scope of policy
               orchestration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2PolicyOrchestratorForOrganizationOrchestrationStateArgs', 'V2PolicyOrchestratorForOrganizationOrchestrationStateArgsDict']]]] orchestration_states: Describes the state of the orchestration process.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] organization_id: Part of `parent`. Required. The parent resource name in the form of:
               * `organizations/{organization_id}/locations/global`
               * `folders/{folder_id}/locations/global`
               * `projects/{project_id_or_number}/locations/global`
        :param pulumi.Input[_builtins.str] policy_orchestrator_id: Required. The logical identifier of the policy orchestrator, with the following
               restrictions:
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               * Must be unique within the parent.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Output only. Set to true, if the there are ongoing changes being applied by the
               orchestrator.
        :param pulumi.Input[_builtins.str] state: Optional. State of the orchestrator. Can be updated to change orchestrator behaviour.
               Allowed values:
               - `ACTIVE` - orchestrator is actively looking for actions to be taken.
               - `STOPPED` - orchestrator won't make any changes.
               Note: There might be more states added in the future. We use string here
               instead of an enum, to avoid the need of propagating new states to all the
               client code.
        :param pulumi.Input[_builtins.str] update_time: Output only. Timestamp when the policy orchestrator resource was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2PolicyOrchestratorForOrganizationState.__new__(_V2PolicyOrchestratorForOrganizationState)

        __props__.__dict__["action"] = action
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["orchestrated_resource"] = orchestrated_resource
        __props__.__dict__["orchestration_scope"] = orchestration_scope
        __props__.__dict__["orchestration_states"] = orchestration_states
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["policy_orchestrator_id"] = policy_orchestrator_id
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return V2PolicyOrchestratorForOrganization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Required. Action to be done by the orchestrator in
        `projects/{project_id}/zones/{zone_id}` locations defined by the
        `orchestration_scope`. Allowed values:
        - `UPSERT` - Orchestrator will create or update target resources.
        - `DELETE` - Orchestrator will delete target resources, if they exist
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Timestamp when the policy orchestrator resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Freeform text describing the purpose of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Immutable. Identifier. In form of
        * `organizations/{organization_id}/locations/global/policyOrchestrators/{orchestrator_id}`
        * `folders/{folder_id}/locations/global/policyOrchestrators/{orchestrator_id}`
        * `projects/{project_id_or_number}/locations/global/policyOrchestrators/{orchestrator_id}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orchestratedResource")
    def orchestrated_resource(self) -> pulumi.Output['outputs.V2PolicyOrchestratorForOrganizationOrchestratedResource']:
        """
        Represents a resource that is being orchestrated by the policy orchestrator.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestrated_resource")

    @_builtins.property
    @pulumi.getter(name="orchestrationScope")
    def orchestration_scope(self) -> pulumi.Output[Optional['outputs.V2PolicyOrchestratorForOrganizationOrchestrationScope']]:
        """
        Defines a set of selectors which drive which resources are in scope of policy
        orchestration.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestration_scope")

    @_builtins.property
    @pulumi.getter(name="orchestrationStates")
    def orchestration_states(self) -> pulumi.Output[Sequence['outputs.V2PolicyOrchestratorForOrganizationOrchestrationState']]:
        """
        Describes the state of the orchestration process.
        Structure is documented below.
        """
        return pulumi.get(self, "orchestration_states")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        Part of `parent`. Required. The parent resource name in the form of:
        * `organizations/{organization_id}/locations/global`
        * `folders/{folder_id}/locations/global`
        * `projects/{project_id_or_number}/locations/global`
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="policyOrchestratorId")
    def policy_orchestrator_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The logical identifier of the policy orchestrator, with the following
        restrictions:
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.
        * Must be unique within the parent.
        """
        return pulumi.get(self, "policy_orchestrator_id")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Output only. Set to true, if the there are ongoing changes being applied by the
        orchestrator.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. State of the orchestrator. Can be updated to change orchestrator behaviour.
        Allowed values:
        - `ACTIVE` - orchestrator is actively looking for actions to be taken.
        - `STOPPED` - orchestrator won't make any changes.
        Note: There might be more states added in the future. We use string here
        instead of an enum, to avoid the need of propagating new states to all the
        client code.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Timestamp when the policy orchestrator resource was last modified.
        """
        return pulumi.get(self, "update_time")

