# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SettingsArgs', 'Settings']

@pulumi.input_type
class SettingsArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 parent: pulumi.Input[_builtins.str],
                 email_notification_settings: Optional[pulumi.Input['SettingsEmailNotificationSettingsArgs']] = None,
                 service_account_approver_settings: Optional[pulumi.Input['SettingsServiceAccountApproverSettingsArgs']] = None):
        """
        The set of arguments for constructing a Settings resource.
        :param pulumi.Input[_builtins.str] location: The region of the PAM settings resource.
        :param pulumi.Input[_builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input['SettingsEmailNotificationSettingsArgs'] email_notification_settings: EmailNotificationSettings defines node-wide email notification preferences for various PAM events.
               Structure is documented below.
        :param pulumi.Input['SettingsServiceAccountApproverSettingsArgs'] service_account_approver_settings: This controls the node-level settings for allowing service accounts as approvers.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "parent", parent)
        if email_notification_settings is not None:
            pulumi.set(__self__, "email_notification_settings", email_notification_settings)
        if service_account_approver_settings is not None:
            pulumi.set(__self__, "service_account_approver_settings", service_account_approver_settings)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the PAM settings resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Input[_builtins.str]:
        """
        Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="emailNotificationSettings")
    def email_notification_settings(self) -> Optional[pulumi.Input['SettingsEmailNotificationSettingsArgs']]:
        """
        EmailNotificationSettings defines node-wide email notification preferences for various PAM events.
        Structure is documented below.
        """
        return pulumi.get(self, "email_notification_settings")

    @email_notification_settings.setter
    def email_notification_settings(self, value: Optional[pulumi.Input['SettingsEmailNotificationSettingsArgs']]):
        pulumi.set(self, "email_notification_settings", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountApproverSettings")
    def service_account_approver_settings(self) -> Optional[pulumi.Input['SettingsServiceAccountApproverSettingsArgs']]:
        """
        This controls the node-level settings for allowing service accounts as approvers.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account_approver_settings")

    @service_account_approver_settings.setter
    def service_account_approver_settings(self, value: Optional[pulumi.Input['SettingsServiceAccountApproverSettingsArgs']]):
        pulumi.set(self, "service_account_approver_settings", value)


@pulumi.input_type
class _SettingsState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 email_notification_settings: Optional[pulumi.Input['SettingsEmailNotificationSettingsArgs']] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_approver_settings: Optional[pulumi.Input['SettingsServiceAccountApproverSettingsArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Settings resources.
        :param pulumi.Input[_builtins.str] create_time: Create timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input['SettingsEmailNotificationSettingsArgs'] email_notification_settings: EmailNotificationSettings defines node-wide email notification preferences for various PAM events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] etag: Fingerprint for optimistic concurrency returned in the response of GetSettings. Must be provided in the requests to UpdateSettings. If the value provided does not match the value known to the server, ABORTED will be thrown, and the client should retry the read-modify-write cycle.
        :param pulumi.Input[_builtins.str] location: The region of the PAM settings resource.
        :param pulumi.Input[_builtins.str] name: Name of the settings resource. Possible formats:
               projects/{project-id|project-number}/locations/{location}/settings folders/{folder-number}/locations/{location}/settings organizations/{organization-number}/locations/{location}/settings
        :param pulumi.Input[_builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input['SettingsServiceAccountApproverSettingsArgs'] service_account_approver_settings: This controls the node-level settings for allowing service accounts as approvers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: Update timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if email_notification_settings is not None:
            pulumi.set(__self__, "email_notification_settings", email_notification_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if service_account_approver_settings is not None:
            pulumi.set(__self__, "service_account_approver_settings", service_account_approver_settings)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="emailNotificationSettings")
    def email_notification_settings(self) -> Optional[pulumi.Input['SettingsEmailNotificationSettingsArgs']]:
        """
        EmailNotificationSettings defines node-wide email notification preferences for various PAM events.
        Structure is documented below.
        """
        return pulumi.get(self, "email_notification_settings")

    @email_notification_settings.setter
    def email_notification_settings(self, value: Optional[pulumi.Input['SettingsEmailNotificationSettingsArgs']]):
        pulumi.set(self, "email_notification_settings", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint for optimistic concurrency returned in the response of GetSettings. Must be provided in the requests to UpdateSettings. If the value provided does not match the value known to the server, ABORTED will be thrown, and the client should retry the read-modify-write cycle.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the PAM settings resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the settings resource. Possible formats:
        projects/{project-id|project-number}/locations/{location}/settings folders/{folder-number}/locations/{location}/settings organizations/{organization-number}/locations/{location}/settings
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountApproverSettings")
    def service_account_approver_settings(self) -> Optional[pulumi.Input['SettingsServiceAccountApproverSettingsArgs']]:
        """
        This controls the node-level settings for allowing service accounts as approvers.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account_approver_settings")

    @service_account_approver_settings.setter
    def service_account_approver_settings(self, value: Optional[pulumi.Input['SettingsServiceAccountApproverSettingsArgs']]):
        pulumi.set(self, "service_account_approver_settings", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:privilegedaccessmanager/settings:Settings")
class Settings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email_notification_settings: Optional[pulumi.Input[Union['SettingsEmailNotificationSettingsArgs', 'SettingsEmailNotificationSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_approver_settings: Optional[pulumi.Input[Union['SettingsServiceAccountApproverSettingsArgs', 'SettingsServiceAccountApproverSettingsArgsDict']]] = None,
                 __props__=None):
        """
        Settings resource defines the properties, applied directly to the resource or inherited through the hierarchy, to enable consistent, federated use of PAM.

        To get more information about Settings, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/pam/rest/v1beta/folders.locations/updateSettings)
        * How-to Guides
            * [Configure Privileged Access Manager settings](https://cloud.google.com/iam/docs/pam-configure-settings)
            * [Official Documentation](https://cloud.google.com/iam/docs/pam-overview)

        ## Example Usage

        ### Privileged Access Manager Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            name="your-project-name",
            project_id="your-project-id",
            org_id="1234567")
        settings = gcp.privilegedaccessmanager.Settings("settings",
            location="global",
            parent=project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            service_account_approver_settings={
                "enabled": False,
            },
            email_notification_settings={
                "custom_notification_behavior": {
                    "requester_notifications": {
                        "entitlement_assigned": "DISABLED",
                        "grant_activated": "DISABLED",
                        "grant_denied": "ENABLED",
                        "grant_expired": "DISABLED",
                        "grant_ended": "DISABLED",
                        "grant_revoked": "DISABLED",
                        "grant_externally_modified": "DISABLED",
                        "grant_activation_failed": "DISABLED",
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[wait90s]))
        ```

        ## Import

        Settings can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/settings`

        When using the `pulumi import` command, Settings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:privilegedaccessmanager/settings:Settings default {{parent}}/locations/{{location}}/settings
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SettingsEmailNotificationSettingsArgs', 'SettingsEmailNotificationSettingsArgsDict']] email_notification_settings: EmailNotificationSettings defines node-wide email notification preferences for various PAM events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The region of the PAM settings resource.
        :param pulumi.Input[_builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input[Union['SettingsServiceAccountApproverSettingsArgs', 'SettingsServiceAccountApproverSettingsArgsDict']] service_account_approver_settings: This controls the node-level settings for allowing service accounts as approvers.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Settings resource defines the properties, applied directly to the resource or inherited through the hierarchy, to enable consistent, federated use of PAM.

        To get more information about Settings, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/pam/rest/v1beta/folders.locations/updateSettings)
        * How-to Guides
            * [Configure Privileged Access Manager settings](https://cloud.google.com/iam/docs/pam-configure-settings)
            * [Official Documentation](https://cloud.google.com/iam/docs/pam-overview)

        ## Example Usage

        ### Privileged Access Manager Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            name="your-project-name",
            project_id="your-project-id",
            org_id="1234567")
        settings = gcp.privilegedaccessmanager.Settings("settings",
            location="global",
            parent=project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            service_account_approver_settings={
                "enabled": False,
            },
            email_notification_settings={
                "custom_notification_behavior": {
                    "requester_notifications": {
                        "entitlement_assigned": "DISABLED",
                        "grant_activated": "DISABLED",
                        "grant_denied": "ENABLED",
                        "grant_expired": "DISABLED",
                        "grant_ended": "DISABLED",
                        "grant_revoked": "DISABLED",
                        "grant_externally_modified": "DISABLED",
                        "grant_activation_failed": "DISABLED",
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[wait90s]))
        ```

        ## Import

        Settings can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/settings`

        When using the `pulumi import` command, Settings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:privilegedaccessmanager/settings:Settings default {{parent}}/locations/{{location}}/settings
        ```

        :param str resource_name: The name of the resource.
        :param SettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email_notification_settings: Optional[pulumi.Input[Union['SettingsEmailNotificationSettingsArgs', 'SettingsEmailNotificationSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_approver_settings: Optional[pulumi.Input[Union['SettingsServiceAccountApproverSettingsArgs', 'SettingsServiceAccountApproverSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingsArgs.__new__(SettingsArgs)

            __props__.__dict__["email_notification_settings"] = email_notification_settings
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["service_account_approver_settings"] = service_account_approver_settings
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Settings, __self__).__init__(
            'gcp:privilegedaccessmanager/settings:Settings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            email_notification_settings: Optional[pulumi.Input[Union['SettingsEmailNotificationSettingsArgs', 'SettingsEmailNotificationSettingsArgsDict']]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_approver_settings: Optional[pulumi.Input[Union['SettingsServiceAccountApproverSettingsArgs', 'SettingsServiceAccountApproverSettingsArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Settings':
        """
        Get an existing Settings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Create timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input[Union['SettingsEmailNotificationSettingsArgs', 'SettingsEmailNotificationSettingsArgsDict']] email_notification_settings: EmailNotificationSettings defines node-wide email notification preferences for various PAM events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] etag: Fingerprint for optimistic concurrency returned in the response of GetSettings. Must be provided in the requests to UpdateSettings. If the value provided does not match the value known to the server, ABORTED will be thrown, and the client should retry the read-modify-write cycle.
        :param pulumi.Input[_builtins.str] location: The region of the PAM settings resource.
        :param pulumi.Input[_builtins.str] name: Name of the settings resource. Possible formats:
               projects/{project-id|project-number}/locations/{location}/settings folders/{folder-number}/locations/{location}/settings organizations/{organization-number}/locations/{location}/settings
        :param pulumi.Input[_builtins.str] parent: Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        :param pulumi.Input[Union['SettingsServiceAccountApproverSettingsArgs', 'SettingsServiceAccountApproverSettingsArgsDict']] service_account_approver_settings: This controls the node-level settings for allowing service accounts as approvers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: Update timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
               Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SettingsState.__new__(_SettingsState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["email_notification_settings"] = email_notification_settings
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["service_account_approver_settings"] = service_account_approver_settings
        __props__.__dict__["update_time"] = update_time
        return Settings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="emailNotificationSettings")
    def email_notification_settings(self) -> pulumi.Output[Optional['outputs.SettingsEmailNotificationSettings']]:
        """
        EmailNotificationSettings defines node-wide email notification preferences for various PAM events.
        Structure is documented below.
        """
        return pulumi.get(self, "email_notification_settings")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint for optimistic concurrency returned in the response of GetSettings. Must be provided in the requests to UpdateSettings. If the value provided does not match the value known to the server, ABORTED will be thrown, and the client should retry the read-modify-write cycle.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the PAM settings resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the settings resource. Possible formats:
        projects/{project-id|project-number}/locations/{location}/settings folders/{folder-number}/locations/{location}/settings organizations/{organization-number}/locations/{location}/settings
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        Format: projects/{project-id|project-number} or organizations/{organization-number} or folders/{folder-number}
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="serviceAccountApproverSettings")
    def service_account_approver_settings(self) -> pulumi.Output[Optional['outputs.SettingsServiceAccountApproverSettings']]:
        """
        This controls the node-level settings for allowing service accounts as approvers.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account_approver_settings")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Update timestamp. Uses RFC 3339, where generated output will always be Z-normalized and use 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "update_time")

