# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionArgs', 'Subscription']

@pulumi.input_type
class SubscriptionArgs:
    def __init__(__self__, *,
                 topic: pulumi.Input[_builtins.str],
                 ack_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 bigquery_config: Optional[pulumi.Input['SubscriptionBigqueryConfigArgs']] = None,
                 cloud_storage_config: Optional[pulumi.Input['SubscriptionCloudStorageConfigArgs']] = None,
                 dead_letter_policy: Optional[pulumi.Input['SubscriptionDeadLetterPolicyArgs']] = None,
                 enable_exactly_once_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_message_ordering: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_policy: Optional[pulumi.Input['SubscriptionExpirationPolicyArgs']] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 message_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 message_transforms: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_config: Optional[pulumi.Input['SubscriptionPushConfigArgs']] = None,
                 retain_acked_messages: Optional[pulumi.Input[_builtins.bool]] = None,
                 retry_policy: Optional[pulumi.Input['SubscriptionRetryPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Subscription resource.
        :param pulumi.Input[_builtins.str] topic: A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
               (as in the id property of a google_pubsub_topic), or just a topic name if
               the topic is in the same project as the subscription.
        :param pulumi.Input[_builtins.int] ack_deadline_seconds: This value is the maximum time after a subscriber receives a message
               before the subscriber should acknowledge the message. After message
               delivery but before the ack deadline expires and before the message is
               acknowledged, it is an outstanding message and will not be delivered
               again during that time (on a best-effort basis).
               For pull subscriptions, this value is used as the initial value for
               the ack deadline. To override this value for a given message, call
               subscriptions.modifyAckDeadline with the corresponding ackId if using
               pull. The minimum custom deadline you can specify is 10 seconds. The
               maximum custom deadline you can specify is 600 seconds (10 minutes).
               If this parameter is 0, a default value of 10 seconds is used.
               For push delivery, this value is also used to set the request timeout
               for the call to the push endpoint.
               If the subscriber never acknowledges the message, the Pub/Sub system
               will eventually redeliver the message.
        :param pulumi.Input['SubscriptionBigqueryConfigArgs'] bigquery_config: If delivery to BigQuery is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input['SubscriptionCloudStorageConfigArgs'] cloud_storage_config: If delivery to Cloud Storage is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input['SubscriptionDeadLetterPolicyArgs'] dead_letter_policy: A policy that specifies the conditions for dead lettering messages in
               this subscription. If dead_letter_policy is not set, dead lettering
               is disabled.
               The Cloud Pub/Sub service account associated with this subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Acknowledge() messages on this subscription.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_exactly_once_delivery: If `true`, Pub/Sub provides the following guarantees for the delivery
               of a message with a given value of messageId on this Subscriptions':
               - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
               - An acknowledged message will not be resent to a subscriber.
               Note that subscribers may still receive multiple copies of a message when `enable_exactly_once_delivery`
               is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
        :param pulumi.Input[_builtins.bool] enable_message_ordering: If `true`, messages published with the same orderingKey in PubsubMessage will be delivered to
               the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
               may be delivered in any order.
        :param pulumi.Input['SubscriptionExpirationPolicyArgs'] expiration_policy: A policy that specifies the conditions for this subscription's expiration.
               A subscription is considered active as long as any connected subscriber
               is successfully consuming messages from the subscription or is issuing
               operations on the subscription. If expirationPolicy is not set, a default
               policy with ttl of 31 days will be used.  If it is set but ttl is "", the
               resource never expires.  The minimum allowed value for expirationPolicy.ttl
               is 1 day.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The subscription only delivers the messages that match the filter.
               Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
               by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
               you can't modify the filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this Subscription.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] message_retention_duration: How long to retain unacknowledged messages in the subscription's
               backlog, from the moment a message is published. If
               retain_acked_messages is true, then this also configures the retention
               of acknowledged messages, and thus configures how far back in time a
               subscriptions.seek can be done. Defaults to 7 days. Cannot be more
               than 31 days (`"2678400s"`) or less than 10 minutes (`"600s"`).
               A duration in seconds with up to nine fractional digits, terminated
               by 's'. Example: `"600.5s"`.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]] message_transforms: Transforms to be applied to messages published to the topic. Transforms are applied in the
               order specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the subscription.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SubscriptionPushConfigArgs'] push_config: If push delivery is used with this subscription, this field is used to
               configure it. An empty pushConfig signifies that the subscriber will
               pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] retain_acked_messages: Indicates whether to retain acknowledged messages. If `true`, then
               messages are not expunged from the subscription's backlog, even if
               they are acknowledged, until they fall out of the
               messageRetentionDuration window.
        :param pulumi.Input['SubscriptionRetryPolicyArgs'] retry_policy: A policy that specifies how Pub/Sub retries message delivery for this subscription.
               If not set, the default retry policy is applied. This generally implies that messages will be retried as soon as possible for healthy subscribers.
               RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded events for a given message
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Input only. Resource manager tags to be bound to the subscription. Tag
               keys and values have the same definition as resource manager tags. Keys
               must be in the format tagKeys/{tag_key_id}, and values are in the format
               tagValues/456. The field is ignored when empty. The field is immutable and
               causes resource replacement when mutated. This field is only set at create
               time and modifying this field after creation will trigger recreation. To
               apply tags to an existing resource, see the `tags.TagValue`
               resource.
        """
        pulumi.set(__self__, "topic", topic)
        if ack_deadline_seconds is not None:
            pulumi.set(__self__, "ack_deadline_seconds", ack_deadline_seconds)
        if bigquery_config is not None:
            pulumi.set(__self__, "bigquery_config", bigquery_config)
        if cloud_storage_config is not None:
            pulumi.set(__self__, "cloud_storage_config", cloud_storage_config)
        if dead_letter_policy is not None:
            pulumi.set(__self__, "dead_letter_policy", dead_letter_policy)
        if enable_exactly_once_delivery is not None:
            pulumi.set(__self__, "enable_exactly_once_delivery", enable_exactly_once_delivery)
        if enable_message_ordering is not None:
            pulumi.set(__self__, "enable_message_ordering", enable_message_ordering)
        if expiration_policy is not None:
            pulumi.set(__self__, "expiration_policy", expiration_policy)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if message_retention_duration is not None:
            pulumi.set(__self__, "message_retention_duration", message_retention_duration)
        if message_transforms is not None:
            pulumi.set(__self__, "message_transforms", message_transforms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if push_config is not None:
            pulumi.set(__self__, "push_config", push_config)
        if retain_acked_messages is not None:
            pulumi.set(__self__, "retain_acked_messages", retain_acked_messages)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Input[_builtins.str]:
        """
        A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
        (as in the id property of a google_pubsub_topic), or just a topic name if
        the topic is in the same project as the subscription.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic", value)

    @_builtins.property
    @pulumi.getter(name="ackDeadlineSeconds")
    def ack_deadline_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This value is the maximum time after a subscriber receives a message
        before the subscriber should acknowledge the message. After message
        delivery but before the ack deadline expires and before the message is
        acknowledged, it is an outstanding message and will not be delivered
        again during that time (on a best-effort basis).
        For pull subscriptions, this value is used as the initial value for
        the ack deadline. To override this value for a given message, call
        subscriptions.modifyAckDeadline with the corresponding ackId if using
        pull. The minimum custom deadline you can specify is 10 seconds. The
        maximum custom deadline you can specify is 600 seconds (10 minutes).
        If this parameter is 0, a default value of 10 seconds is used.
        For push delivery, this value is also used to set the request timeout
        for the call to the push endpoint.
        If the subscriber never acknowledges the message, the Pub/Sub system
        will eventually redeliver the message.
        """
        return pulumi.get(self, "ack_deadline_seconds")

    @ack_deadline_seconds.setter
    def ack_deadline_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ack_deadline_seconds", value)

    @_builtins.property
    @pulumi.getter(name="bigqueryConfig")
    def bigquery_config(self) -> Optional[pulumi.Input['SubscriptionBigqueryConfigArgs']]:
        """
        If delivery to BigQuery is used with this subscription, this field is used to configure it.
        Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
        If all three are empty, then the subscriber will pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_config")

    @bigquery_config.setter
    def bigquery_config(self, value: Optional[pulumi.Input['SubscriptionBigqueryConfigArgs']]):
        pulumi.set(self, "bigquery_config", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorageConfig")
    def cloud_storage_config(self) -> Optional[pulumi.Input['SubscriptionCloudStorageConfigArgs']]:
        """
        If delivery to Cloud Storage is used with this subscription, this field is used to configure it.
        Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
        If all three are empty, then the subscriber will pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_storage_config")

    @cloud_storage_config.setter
    def cloud_storage_config(self, value: Optional[pulumi.Input['SubscriptionCloudStorageConfigArgs']]):
        pulumi.set(self, "cloud_storage_config", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterPolicy")
    def dead_letter_policy(self) -> Optional[pulumi.Input['SubscriptionDeadLetterPolicyArgs']]:
        """
        A policy that specifies the conditions for dead lettering messages in
        this subscription. If dead_letter_policy is not set, dead lettering
        is disabled.
        The Cloud Pub/Sub service account associated with this subscription's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Acknowledge() messages on this subscription.
        Structure is documented below.
        """
        return pulumi.get(self, "dead_letter_policy")

    @dead_letter_policy.setter
    def dead_letter_policy(self, value: Optional[pulumi.Input['SubscriptionDeadLetterPolicyArgs']]):
        pulumi.set(self, "dead_letter_policy", value)

    @_builtins.property
    @pulumi.getter(name="enableExactlyOnceDelivery")
    def enable_exactly_once_delivery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, Pub/Sub provides the following guarantees for the delivery
        of a message with a given value of messageId on this Subscriptions':
        - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
        - An acknowledged message will not be resent to a subscriber.
        Note that subscribers may still receive multiple copies of a message when `enable_exactly_once_delivery`
        is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
        """
        return pulumi.get(self, "enable_exactly_once_delivery")

    @enable_exactly_once_delivery.setter
    def enable_exactly_once_delivery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_exactly_once_delivery", value)

    @_builtins.property
    @pulumi.getter(name="enableMessageOrdering")
    def enable_message_ordering(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, messages published with the same orderingKey in PubsubMessage will be delivered to
        the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
        may be delivered in any order.
        """
        return pulumi.get(self, "enable_message_ordering")

    @enable_message_ordering.setter
    def enable_message_ordering(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_message_ordering", value)

    @_builtins.property
    @pulumi.getter(name="expirationPolicy")
    def expiration_policy(self) -> Optional[pulumi.Input['SubscriptionExpirationPolicyArgs']]:
        """
        A policy that specifies the conditions for this subscription's expiration.
        A subscription is considered active as long as any connected subscriber
        is successfully consuming messages from the subscription or is issuing
        operations on the subscription. If expirationPolicy is not set, a default
        policy with ttl of 31 days will be used.  If it is set but ttl is "", the
        resource never expires.  The minimum allowed value for expirationPolicy.ttl
        is 1 day.
        Structure is documented below.
        """
        return pulumi.get(self, "expiration_policy")

    @expiration_policy.setter
    def expiration_policy(self, value: Optional[pulumi.Input['SubscriptionExpirationPolicyArgs']]):
        pulumi.set(self, "expiration_policy", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription only delivers the messages that match the filter.
        Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
        by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
        you can't modify the filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to this Subscription.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="messageRetentionDuration")
    def message_retention_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to retain unacknowledged messages in the subscription's
        backlog, from the moment a message is published. If
        retain_acked_messages is true, then this also configures the retention
        of acknowledged messages, and thus configures how far back in time a
        subscriptions.seek can be done. Defaults to 7 days. Cannot be more
        than 31 days (`"2678400s"`) or less than 10 minutes (`"600s"`).
        A duration in seconds with up to nine fractional digits, terminated
        by 's'. Example: `"600.5s"`.
        """
        return pulumi.get(self, "message_retention_duration")

    @message_retention_duration.setter
    def message_retention_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_retention_duration", value)

    @_builtins.property
    @pulumi.getter(name="messageTransforms")
    def message_transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]]]:
        """
        Transforms to be applied to messages published to the topic. Transforms are applied in the
        order specified.
        Structure is documented below.
        """
        return pulumi.get(self, "message_transforms")

    @message_transforms.setter
    def message_transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]]]):
        pulumi.set(self, "message_transforms", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subscription.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pushConfig")
    def push_config(self) -> Optional[pulumi.Input['SubscriptionPushConfigArgs']]:
        """
        If push delivery is used with this subscription, this field is used to
        configure it. An empty pushConfig signifies that the subscriber will
        pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "push_config")

    @push_config.setter
    def push_config(self, value: Optional[pulumi.Input['SubscriptionPushConfigArgs']]):
        pulumi.set(self, "push_config", value)

    @_builtins.property
    @pulumi.getter(name="retainAckedMessages")
    def retain_acked_messages(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to retain acknowledged messages. If `true`, then
        messages are not expunged from the subscription's backlog, even if
        they are acknowledged, until they fall out of the
        messageRetentionDuration window.
        """
        return pulumi.get(self, "retain_acked_messages")

    @retain_acked_messages.setter
    def retain_acked_messages(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_acked_messages", value)

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['SubscriptionRetryPolicyArgs']]:
        """
        A policy that specifies how Pub/Sub retries message delivery for this subscription.
        If not set, the default retry policy is applied. This generally implies that messages will be retried as soon as possible for healthy subscribers.
        RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded events for a given message
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['SubscriptionRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Input only. Resource manager tags to be bound to the subscription. Tag
        keys and values have the same definition as resource manager tags. Keys
        must be in the format tagKeys/{tag_key_id}, and values are in the format
        tagValues/456. The field is ignored when empty. The field is immutable and
        causes resource replacement when mutated. This field is only set at create
        time and modifying this field after creation will trigger recreation. To
        apply tags to an existing resource, see the `tags.TagValue`
        resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SubscriptionState:
    def __init__(__self__, *,
                 ack_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 bigquery_config: Optional[pulumi.Input['SubscriptionBigqueryConfigArgs']] = None,
                 cloud_storage_config: Optional[pulumi.Input['SubscriptionCloudStorageConfigArgs']] = None,
                 dead_letter_policy: Optional[pulumi.Input['SubscriptionDeadLetterPolicyArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_exactly_once_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_message_ordering: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_policy: Optional[pulumi.Input['SubscriptionExpirationPolicyArgs']] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 message_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 message_transforms: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 push_config: Optional[pulumi.Input['SubscriptionPushConfigArgs']] = None,
                 retain_acked_messages: Optional[pulumi.Input[_builtins.bool]] = None,
                 retry_policy: Optional[pulumi.Input['SubscriptionRetryPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Subscription resources.
        :param pulumi.Input[_builtins.int] ack_deadline_seconds: This value is the maximum time after a subscriber receives a message
               before the subscriber should acknowledge the message. After message
               delivery but before the ack deadline expires and before the message is
               acknowledged, it is an outstanding message and will not be delivered
               again during that time (on a best-effort basis).
               For pull subscriptions, this value is used as the initial value for
               the ack deadline. To override this value for a given message, call
               subscriptions.modifyAckDeadline with the corresponding ackId if using
               pull. The minimum custom deadline you can specify is 10 seconds. The
               maximum custom deadline you can specify is 600 seconds (10 minutes).
               If this parameter is 0, a default value of 10 seconds is used.
               For push delivery, this value is also used to set the request timeout
               for the call to the push endpoint.
               If the subscriber never acknowledges the message, the Pub/Sub system
               will eventually redeliver the message.
        :param pulumi.Input['SubscriptionBigqueryConfigArgs'] bigquery_config: If delivery to BigQuery is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input['SubscriptionCloudStorageConfigArgs'] cloud_storage_config: If delivery to Cloud Storage is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input['SubscriptionDeadLetterPolicyArgs'] dead_letter_policy: A policy that specifies the conditions for dead lettering messages in
               this subscription. If dead_letter_policy is not set, dead lettering
               is disabled.
               The Cloud Pub/Sub service account associated with this subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Acknowledge() messages on this subscription.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_exactly_once_delivery: If `true`, Pub/Sub provides the following guarantees for the delivery
               of a message with a given value of messageId on this Subscriptions':
               - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
               - An acknowledged message will not be resent to a subscriber.
               Note that subscribers may still receive multiple copies of a message when `enable_exactly_once_delivery`
               is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
        :param pulumi.Input[_builtins.bool] enable_message_ordering: If `true`, messages published with the same orderingKey in PubsubMessage will be delivered to
               the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
               may be delivered in any order.
        :param pulumi.Input['SubscriptionExpirationPolicyArgs'] expiration_policy: A policy that specifies the conditions for this subscription's expiration.
               A subscription is considered active as long as any connected subscriber
               is successfully consuming messages from the subscription or is issuing
               operations on the subscription. If expirationPolicy is not set, a default
               policy with ttl of 31 days will be used.  If it is set but ttl is "", the
               resource never expires.  The minimum allowed value for expirationPolicy.ttl
               is 1 day.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The subscription only delivers the messages that match the filter.
               Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
               by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
               you can't modify the filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this Subscription.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] message_retention_duration: How long to retain unacknowledged messages in the subscription's
               backlog, from the moment a message is published. If
               retain_acked_messages is true, then this also configures the retention
               of acknowledged messages, and thus configures how far back in time a
               subscriptions.seek can be done. Defaults to 7 days. Cannot be more
               than 31 days (`"2678400s"`) or less than 10 minutes (`"600s"`).
               A duration in seconds with up to nine fractional digits, terminated
               by 's'. Example: `"600.5s"`.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]] message_transforms: Transforms to be applied to messages published to the topic. Transforms are applied in the
               order specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the subscription.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['SubscriptionPushConfigArgs'] push_config: If push delivery is used with this subscription, this field is used to
               configure it. An empty pushConfig signifies that the subscriber will
               pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] retain_acked_messages: Indicates whether to retain acknowledged messages. If `true`, then
               messages are not expunged from the subscription's backlog, even if
               they are acknowledged, until they fall out of the
               messageRetentionDuration window.
        :param pulumi.Input['SubscriptionRetryPolicyArgs'] retry_policy: A policy that specifies how Pub/Sub retries message delivery for this subscription.
               If not set, the default retry policy is applied. This generally implies that messages will be retried as soon as possible for healthy subscribers.
               RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded events for a given message
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Input only. Resource manager tags to be bound to the subscription. Tag
               keys and values have the same definition as resource manager tags. Keys
               must be in the format tagKeys/{tag_key_id}, and values are in the format
               tagValues/456. The field is ignored when empty. The field is immutable and
               causes resource replacement when mutated. This field is only set at create
               time and modifying this field after creation will trigger recreation. To
               apply tags to an existing resource, see the `tags.TagValue`
               resource.
        :param pulumi.Input[_builtins.str] topic: A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
               (as in the id property of a google_pubsub_topic), or just a topic name if
               the topic is in the same project as the subscription.
        """
        if ack_deadline_seconds is not None:
            pulumi.set(__self__, "ack_deadline_seconds", ack_deadline_seconds)
        if bigquery_config is not None:
            pulumi.set(__self__, "bigquery_config", bigquery_config)
        if cloud_storage_config is not None:
            pulumi.set(__self__, "cloud_storage_config", cloud_storage_config)
        if dead_letter_policy is not None:
            pulumi.set(__self__, "dead_letter_policy", dead_letter_policy)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_exactly_once_delivery is not None:
            pulumi.set(__self__, "enable_exactly_once_delivery", enable_exactly_once_delivery)
        if enable_message_ordering is not None:
            pulumi.set(__self__, "enable_message_ordering", enable_message_ordering)
        if expiration_policy is not None:
            pulumi.set(__self__, "expiration_policy", expiration_policy)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if message_retention_duration is not None:
            pulumi.set(__self__, "message_retention_duration", message_retention_duration)
        if message_transforms is not None:
            pulumi.set(__self__, "message_transforms", message_transforms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if push_config is not None:
            pulumi.set(__self__, "push_config", push_config)
        if retain_acked_messages is not None:
            pulumi.set(__self__, "retain_acked_messages", retain_acked_messages)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter(name="ackDeadlineSeconds")
    def ack_deadline_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This value is the maximum time after a subscriber receives a message
        before the subscriber should acknowledge the message. After message
        delivery but before the ack deadline expires and before the message is
        acknowledged, it is an outstanding message and will not be delivered
        again during that time (on a best-effort basis).
        For pull subscriptions, this value is used as the initial value for
        the ack deadline. To override this value for a given message, call
        subscriptions.modifyAckDeadline with the corresponding ackId if using
        pull. The minimum custom deadline you can specify is 10 seconds. The
        maximum custom deadline you can specify is 600 seconds (10 minutes).
        If this parameter is 0, a default value of 10 seconds is used.
        For push delivery, this value is also used to set the request timeout
        for the call to the push endpoint.
        If the subscriber never acknowledges the message, the Pub/Sub system
        will eventually redeliver the message.
        """
        return pulumi.get(self, "ack_deadline_seconds")

    @ack_deadline_seconds.setter
    def ack_deadline_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ack_deadline_seconds", value)

    @_builtins.property
    @pulumi.getter(name="bigqueryConfig")
    def bigquery_config(self) -> Optional[pulumi.Input['SubscriptionBigqueryConfigArgs']]:
        """
        If delivery to BigQuery is used with this subscription, this field is used to configure it.
        Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
        If all three are empty, then the subscriber will pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_config")

    @bigquery_config.setter
    def bigquery_config(self, value: Optional[pulumi.Input['SubscriptionBigqueryConfigArgs']]):
        pulumi.set(self, "bigquery_config", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorageConfig")
    def cloud_storage_config(self) -> Optional[pulumi.Input['SubscriptionCloudStorageConfigArgs']]:
        """
        If delivery to Cloud Storage is used with this subscription, this field is used to configure it.
        Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
        If all three are empty, then the subscriber will pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_storage_config")

    @cloud_storage_config.setter
    def cloud_storage_config(self, value: Optional[pulumi.Input['SubscriptionCloudStorageConfigArgs']]):
        pulumi.set(self, "cloud_storage_config", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterPolicy")
    def dead_letter_policy(self) -> Optional[pulumi.Input['SubscriptionDeadLetterPolicyArgs']]:
        """
        A policy that specifies the conditions for dead lettering messages in
        this subscription. If dead_letter_policy is not set, dead lettering
        is disabled.
        The Cloud Pub/Sub service account associated with this subscription's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Acknowledge() messages on this subscription.
        Structure is documented below.
        """
        return pulumi.get(self, "dead_letter_policy")

    @dead_letter_policy.setter
    def dead_letter_policy(self, value: Optional[pulumi.Input['SubscriptionDeadLetterPolicyArgs']]):
        pulumi.set(self, "dead_letter_policy", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="enableExactlyOnceDelivery")
    def enable_exactly_once_delivery(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, Pub/Sub provides the following guarantees for the delivery
        of a message with a given value of messageId on this Subscriptions':
        - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
        - An acknowledged message will not be resent to a subscriber.
        Note that subscribers may still receive multiple copies of a message when `enable_exactly_once_delivery`
        is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
        """
        return pulumi.get(self, "enable_exactly_once_delivery")

    @enable_exactly_once_delivery.setter
    def enable_exactly_once_delivery(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_exactly_once_delivery", value)

    @_builtins.property
    @pulumi.getter(name="enableMessageOrdering")
    def enable_message_ordering(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, messages published with the same orderingKey in PubsubMessage will be delivered to
        the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
        may be delivered in any order.
        """
        return pulumi.get(self, "enable_message_ordering")

    @enable_message_ordering.setter
    def enable_message_ordering(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_message_ordering", value)

    @_builtins.property
    @pulumi.getter(name="expirationPolicy")
    def expiration_policy(self) -> Optional[pulumi.Input['SubscriptionExpirationPolicyArgs']]:
        """
        A policy that specifies the conditions for this subscription's expiration.
        A subscription is considered active as long as any connected subscriber
        is successfully consuming messages from the subscription or is issuing
        operations on the subscription. If expirationPolicy is not set, a default
        policy with ttl of 31 days will be used.  If it is set but ttl is "", the
        resource never expires.  The minimum allowed value for expirationPolicy.ttl
        is 1 day.
        Structure is documented below.
        """
        return pulumi.get(self, "expiration_policy")

    @expiration_policy.setter
    def expiration_policy(self, value: Optional[pulumi.Input['SubscriptionExpirationPolicyArgs']]):
        pulumi.set(self, "expiration_policy", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription only delivers the messages that match the filter.
        Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
        by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
        you can't modify the filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to this Subscription.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="messageRetentionDuration")
    def message_retention_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to retain unacknowledged messages in the subscription's
        backlog, from the moment a message is published. If
        retain_acked_messages is true, then this also configures the retention
        of acknowledged messages, and thus configures how far back in time a
        subscriptions.seek can be done. Defaults to 7 days. Cannot be more
        than 31 days (`"2678400s"`) or less than 10 minutes (`"600s"`).
        A duration in seconds with up to nine fractional digits, terminated
        by 's'. Example: `"600.5s"`.
        """
        return pulumi.get(self, "message_retention_duration")

    @message_retention_duration.setter
    def message_retention_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_retention_duration", value)

    @_builtins.property
    @pulumi.getter(name="messageTransforms")
    def message_transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]]]:
        """
        Transforms to be applied to messages published to the topic. Transforms are applied in the
        order specified.
        Structure is documented below.
        """
        return pulumi.get(self, "message_transforms")

    @message_transforms.setter
    def message_transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageTransformArgs']]]]):
        pulumi.set(self, "message_transforms", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subscription.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="pushConfig")
    def push_config(self) -> Optional[pulumi.Input['SubscriptionPushConfigArgs']]:
        """
        If push delivery is used with this subscription, this field is used to
        configure it. An empty pushConfig signifies that the subscriber will
        pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "push_config")

    @push_config.setter
    def push_config(self, value: Optional[pulumi.Input['SubscriptionPushConfigArgs']]):
        pulumi.set(self, "push_config", value)

    @_builtins.property
    @pulumi.getter(name="retainAckedMessages")
    def retain_acked_messages(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to retain acknowledged messages. If `true`, then
        messages are not expunged from the subscription's backlog, even if
        they are acknowledged, until they fall out of the
        messageRetentionDuration window.
        """
        return pulumi.get(self, "retain_acked_messages")

    @retain_acked_messages.setter
    def retain_acked_messages(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_acked_messages", value)

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['SubscriptionRetryPolicyArgs']]:
        """
        A policy that specifies how Pub/Sub retries message delivery for this subscription.
        If not set, the default retry policy is applied. This generally implies that messages will be retried as soon as possible for healthy subscribers.
        RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded events for a given message
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['SubscriptionRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Input only. Resource manager tags to be bound to the subscription. Tag
        keys and values have the same definition as resource manager tags. Keys
        must be in the format tagKeys/{tag_key_id}, and values are in the format
        tagValues/456. The field is ignored when empty. The field is immutable and
        causes resource replacement when mutated. This field is only set at create
        time and modifying this field after creation will trigger recreation. To
        apply tags to an existing resource, see the `tags.TagValue`
        resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
        (as in the id property of a google_pubsub_topic), or just a topic name if
        the topic is in the same project as the subscription.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic", value)


@pulumi.type_token("gcp:pubsub/subscription:Subscription")
class Subscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ack_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 bigquery_config: Optional[pulumi.Input[Union['SubscriptionBigqueryConfigArgs', 'SubscriptionBigqueryConfigArgsDict']]] = None,
                 cloud_storage_config: Optional[pulumi.Input[Union['SubscriptionCloudStorageConfigArgs', 'SubscriptionCloudStorageConfigArgsDict']]] = None,
                 dead_letter_policy: Optional[pulumi.Input[Union['SubscriptionDeadLetterPolicyArgs', 'SubscriptionDeadLetterPolicyArgsDict']]] = None,
                 enable_exactly_once_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_message_ordering: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_policy: Optional[pulumi.Input[Union['SubscriptionExpirationPolicyArgs', 'SubscriptionExpirationPolicyArgsDict']]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 message_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 message_transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionMessageTransformArgs', 'SubscriptionMessageTransformArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_config: Optional[pulumi.Input[Union['SubscriptionPushConfigArgs', 'SubscriptionPushConfigArgsDict']]] = None,
                 retain_acked_messages: Optional[pulumi.Input[_builtins.bool]] = None,
                 retry_policy: Optional[pulumi.Input[Union['SubscriptionRetryPolicyArgs', 'SubscriptionRetryPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A named resource representing the stream of messages from a single,
        specific topic, to be delivered to the subscribing application.

        To get more information about Subscription, see:

        * [API documentation](https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.subscriptions)
        * How-to Guides
            * [Managing Subscriptions](https://cloud.google.com/pubsub/docs/admin#managing_subscriptions)

        > **Note:** You can retrieve the email of the Google Managed Pub/Sub Service Account used for forwarding
        by using the `projects.ServiceIdentity` resource.

        ## Example Usage

        ### Pubsub Subscription Push

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            ack_deadline_seconds=20,
            labels={
                "foo": "bar",
            },
            push_config={
                "push_endpoint": "https://example.com/push",
                "attributes": {
                    "x-goog-version": "v1",
                },
            })
        ```
        ### Pubsub Subscription Pull

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            labels={
                "foo": "bar",
            },
            message_retention_duration="1200s",
            retain_acked_messages=True,
            ack_deadline_seconds=20,
            expiration_policy={
                "ttl": "300000.5s",
            },
            retry_policy={
                "minimum_backoff": "10s",
            },
            enable_message_ordering=False)
        ```
        ### Pubsub Subscription Pull Filter

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            labels={
                "foo": "bar",
            },
            filter=\"\"\"    attributes.foo = \\"foo\\"
            AND attributes.bar = \\"bar\\"
        \"\"\",
            ack_deadline_seconds=20)
        ```
        ### Pubsub Subscription Dead Letter

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_dead_letter = gcp.pubsub.Topic("example_dead_letter", name="example-topic-dead-letter")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            dead_letter_policy={
                "dead_letter_topic": example_dead_letter.id,
                "max_delivery_attempts": 10,
            })
        ```
        ### Pubsub Subscription Push Bq

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        test = gcp.bigquery.Dataset("test", dataset_id="example_dataset")
        test_table = gcp.bigquery.Table("test",
            table_id="example_table",
            dataset_id=test.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"data\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\",
            \\"description\\": \\"The data\\"
          }
        ]
        \"\"\",
            deletion_protection=False)
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            bigquery_config={
                "table": pulumi.Output.all(
                    project=test_table.project,
                    dataset_id=test_table.dataset_id,
                    table_id=test_table.table_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
            })
        project = gcp.organizations.get_project()
        ```
        ### Pubsub Subscription Push Bq Table Schema

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        test = gcp.bigquery.Dataset("test", dataset_id="example_dataset")
        test_table = gcp.bigquery.Table("test",
            table_id="example_table",
            dataset_id=test.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"data\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\",
            \\"description\\": \\"The data\\"
          }
        ]
        \"\"\",
            deletion_protection=False)
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            bigquery_config={
                "table": pulumi.Output.all(
                    project=test_table.project,
                    dataset_id=test_table.dataset_id,
                    table_id=test_table.table_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "use_table_schema": True,
            })
        project = gcp.organizations.get_project()
        ```
        ### Pubsub Subscription Push Bq Service Account

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        bq_write_service_account = gcp.serviceaccount.Account("bq_write_service_account",
            account_id="example-bqw",
            display_name="BQ Write Service Account")
        project = gcp.organizations.get_project()
        bigquery_metadata_viewer = gcp.projects.IAMMember("bigquery_metadata_viewer",
            project=project.project_id,
            role="roles/bigquery.metadataViewer",
            member=bq_write_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        bigquery_data_editor = gcp.projects.IAMMember("bigquery_data_editor",
            project=project.project_id,
            role="roles/bigquery.dataEditor",
            member=bq_write_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        test = gcp.bigquery.Dataset("test", dataset_id="example_dataset")
        test_table = gcp.bigquery.Table("test",
            deletion_protection=False,
            table_id="example_table",
            dataset_id=test.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"data\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\",
            \\"description\\": \\"The data\\"
          }
        ]
        \"\"\")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            bigquery_config={
                "table": pulumi.Output.all(
                    project=test_table.project,
                    dataset_id=test_table.dataset_id,
                    table_id=test_table.table_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "service_account_email": bq_write_service_account.email,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    bq_write_service_account,
                    bigquery_metadata_viewer,
                    bigquery_data_editor,
                ]))
        ```
        ### Pubsub Subscription Push Cloudstorage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.Bucket("example",
            name="example-bucket",
            location="US",
            uniform_bucket_level_access=True)
        example_topic = gcp.pubsub.Topic("example", name="example-topic")
        project = gcp.organizations.get_project()
        admin = gcp.storage.BucketIAMMember("admin",
            bucket=example.name,
            role="roles/storage.admin",
            member=f"serviceAccount:service-{project.number}@gcp-sa-pubsub.iam.gserviceaccount.com")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example_topic.id,
            cloud_storage_config={
                "bucket": example.name,
                "filename_prefix": "pre-",
                "filename_suffix": "-_32270",
                "filename_datetime_format": "YYYY-MM-DD/hh_mm_ssZ",
                "max_bytes": 1000,
                "max_duration": "300s",
                "max_messages": 1000,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example,
                    admin,
                ]))
        ```
        ### Pubsub Subscription Push Cloudstorage Avro

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.Bucket("example",
            name="example-bucket",
            location="US",
            uniform_bucket_level_access=True)
        example_topic = gcp.pubsub.Topic("example", name="example-topic")
        project = gcp.organizations.get_project()
        admin = gcp.storage.BucketIAMMember("admin",
            bucket=example.name,
            role="roles/storage.admin",
            member=f"serviceAccount:service-{project.number}@gcp-sa-pubsub.iam.gserviceaccount.com")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example_topic.id,
            cloud_storage_config={
                "bucket": example.name,
                "filename_prefix": "pre-",
                "filename_suffix": "-_44703",
                "filename_datetime_format": "YYYY-MM-DD/hh_mm_ssZ",
                "max_bytes": 1000,
                "max_duration": "300s",
                "max_messages": 1000,
                "avro_config": {
                    "write_metadata": True,
                    "use_topic_schema": True,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example,
                    admin,
                ]))
        ```
        ### Pubsub Subscription Push Cloudstorage Service Account

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.Bucket("example",
            name="example-bucket",
            location="US",
            uniform_bucket_level_access=True)
        example_topic = gcp.pubsub.Topic("example", name="example-topic")
        storage_write_service_account = gcp.serviceaccount.Account("storage_write_service_account",
            account_id="example-stw",
            display_name="Storage Write Service Account")
        admin = gcp.storage.BucketIAMMember("admin",
            bucket=example.name,
            role="roles/storage.admin",
            member=storage_write_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example_topic.id,
            cloud_storage_config={
                "bucket": example.name,
                "filename_prefix": "pre-",
                "filename_suffix": "-_9329",
                "filename_datetime_format": "YYYY-MM-DD/hh_mm_ssZ",
                "max_bytes": 1000,
                "max_duration": "300s",
                "service_account_email": storage_write_service_account.email,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    storage_write_service_account,
                    example,
                    admin,
                ]))
        project = gcp.organizations.get_project()
        ```
        ### Pubsub Subscription Single Smt

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            message_transforms=[{
                "javascript_udf": {
                    "function_name": "isYearEven",
                    "code": \"\"\"function isYearEven(message, metadata) {
          const data = JSON.parse(message.data);
          return message.year %2 === 0;
        }
        \"\"\",
                },
            }])
        ```
        ### Pubsub Subscription Multiple Smts

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            message_transforms=[
                {
                    "javascript_udf": {
                        "function_name": "redactSSN",
                        "code": \"\"\"function redactSSN(message, metadata) {
          const data = JSON.parse(message.data);
          delete data['ssn'];
          message.data = JSON.stringify(data);
          return message;
        }
        \"\"\",
                    },
                },
                {
                    "javascript_udf": {
                        "function_name": "otherFunc",
                        "code": \"\"\"function otherFunc(message, metadata) {
          return null;
        }
        \"\"\",
                    },
                },
                {
                    "disabled": True,
                    "javascript_udf": {
                        "function_name": "someSMTWeDisabled",
                        "code": "...",
                    },
                },
            ])
        ```
        ### Pubsub Subscription Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        project = gcp.organizations.get_project()
        tag_key = gcp.tags.TagKey("tag_key",
            parent=project.id,
            short_name="tag_key",
            opts = pulumi.ResourceOptions(depends_on=[example]))
        tag_value = gcp.tags.TagValue("tag_value",
            parent=tag_key.id,
            short_name="tag_value")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            tags=pulumi.Output.all(
                namespaced_name=tag_key.namespaced_name,
                short_name=tag_value.short_name
        ).apply(lambda resolved_outputs: {
                resolved_outputs['namespaced_name']: resolved_outputs['short_name'],
            })
        )
        ```

        ## Import

        Subscription can be imported using any of these accepted formats:

        * `projects/{{project}}/subscriptions/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Subscription can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:pubsub/subscription:Subscription default projects/{{project}}/subscriptions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:pubsub/subscription:Subscription default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:pubsub/subscription:Subscription default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] ack_deadline_seconds: This value is the maximum time after a subscriber receives a message
               before the subscriber should acknowledge the message. After message
               delivery but before the ack deadline expires and before the message is
               acknowledged, it is an outstanding message and will not be delivered
               again during that time (on a best-effort basis).
               For pull subscriptions, this value is used as the initial value for
               the ack deadline. To override this value for a given message, call
               subscriptions.modifyAckDeadline with the corresponding ackId if using
               pull. The minimum custom deadline you can specify is 10 seconds. The
               maximum custom deadline you can specify is 600 seconds (10 minutes).
               If this parameter is 0, a default value of 10 seconds is used.
               For push delivery, this value is also used to set the request timeout
               for the call to the push endpoint.
               If the subscriber never acknowledges the message, the Pub/Sub system
               will eventually redeliver the message.
        :param pulumi.Input[Union['SubscriptionBigqueryConfigArgs', 'SubscriptionBigqueryConfigArgsDict']] bigquery_config: If delivery to BigQuery is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[Union['SubscriptionCloudStorageConfigArgs', 'SubscriptionCloudStorageConfigArgsDict']] cloud_storage_config: If delivery to Cloud Storage is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[Union['SubscriptionDeadLetterPolicyArgs', 'SubscriptionDeadLetterPolicyArgsDict']] dead_letter_policy: A policy that specifies the conditions for dead lettering messages in
               this subscription. If dead_letter_policy is not set, dead lettering
               is disabled.
               The Cloud Pub/Sub service account associated with this subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Acknowledge() messages on this subscription.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_exactly_once_delivery: If `true`, Pub/Sub provides the following guarantees for the delivery
               of a message with a given value of messageId on this Subscriptions':
               - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
               - An acknowledged message will not be resent to a subscriber.
               Note that subscribers may still receive multiple copies of a message when `enable_exactly_once_delivery`
               is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
        :param pulumi.Input[_builtins.bool] enable_message_ordering: If `true`, messages published with the same orderingKey in PubsubMessage will be delivered to
               the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
               may be delivered in any order.
        :param pulumi.Input[Union['SubscriptionExpirationPolicyArgs', 'SubscriptionExpirationPolicyArgsDict']] expiration_policy: A policy that specifies the conditions for this subscription's expiration.
               A subscription is considered active as long as any connected subscriber
               is successfully consuming messages from the subscription or is issuing
               operations on the subscription. If expirationPolicy is not set, a default
               policy with ttl of 31 days will be used.  If it is set but ttl is "", the
               resource never expires.  The minimum allowed value for expirationPolicy.ttl
               is 1 day.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The subscription only delivers the messages that match the filter.
               Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
               by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
               you can't modify the filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this Subscription.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] message_retention_duration: How long to retain unacknowledged messages in the subscription's
               backlog, from the moment a message is published. If
               retain_acked_messages is true, then this also configures the retention
               of acknowledged messages, and thus configures how far back in time a
               subscriptions.seek can be done. Defaults to 7 days. Cannot be more
               than 31 days (`"2678400s"`) or less than 10 minutes (`"600s"`).
               A duration in seconds with up to nine fractional digits, terminated
               by 's'. Example: `"600.5s"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionMessageTransformArgs', 'SubscriptionMessageTransformArgsDict']]]] message_transforms: Transforms to be applied to messages published to the topic. Transforms are applied in the
               order specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the subscription.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SubscriptionPushConfigArgs', 'SubscriptionPushConfigArgsDict']] push_config: If push delivery is used with this subscription, this field is used to
               configure it. An empty pushConfig signifies that the subscriber will
               pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] retain_acked_messages: Indicates whether to retain acknowledged messages. If `true`, then
               messages are not expunged from the subscription's backlog, even if
               they are acknowledged, until they fall out of the
               messageRetentionDuration window.
        :param pulumi.Input[Union['SubscriptionRetryPolicyArgs', 'SubscriptionRetryPolicyArgsDict']] retry_policy: A policy that specifies how Pub/Sub retries message delivery for this subscription.
               If not set, the default retry policy is applied. This generally implies that messages will be retried as soon as possible for healthy subscribers.
               RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded events for a given message
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Input only. Resource manager tags to be bound to the subscription. Tag
               keys and values have the same definition as resource manager tags. Keys
               must be in the format tagKeys/{tag_key_id}, and values are in the format
               tagValues/456. The field is ignored when empty. The field is immutable and
               causes resource replacement when mutated. This field is only set at create
               time and modifying this field after creation will trigger recreation. To
               apply tags to an existing resource, see the `tags.TagValue`
               resource.
        :param pulumi.Input[_builtins.str] topic: A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
               (as in the id property of a google_pubsub_topic), or just a topic name if
               the topic is in the same project as the subscription.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A named resource representing the stream of messages from a single,
        specific topic, to be delivered to the subscribing application.

        To get more information about Subscription, see:

        * [API documentation](https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.subscriptions)
        * How-to Guides
            * [Managing Subscriptions](https://cloud.google.com/pubsub/docs/admin#managing_subscriptions)

        > **Note:** You can retrieve the email of the Google Managed Pub/Sub Service Account used for forwarding
        by using the `projects.ServiceIdentity` resource.

        ## Example Usage

        ### Pubsub Subscription Push

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            ack_deadline_seconds=20,
            labels={
                "foo": "bar",
            },
            push_config={
                "push_endpoint": "https://example.com/push",
                "attributes": {
                    "x-goog-version": "v1",
                },
            })
        ```
        ### Pubsub Subscription Pull

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            labels={
                "foo": "bar",
            },
            message_retention_duration="1200s",
            retain_acked_messages=True,
            ack_deadline_seconds=20,
            expiration_policy={
                "ttl": "300000.5s",
            },
            retry_policy={
                "minimum_backoff": "10s",
            },
            enable_message_ordering=False)
        ```
        ### Pubsub Subscription Pull Filter

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            labels={
                "foo": "bar",
            },
            filter=\"\"\"    attributes.foo = \\"foo\\"
            AND attributes.bar = \\"bar\\"
        \"\"\",
            ack_deadline_seconds=20)
        ```
        ### Pubsub Subscription Dead Letter

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_dead_letter = gcp.pubsub.Topic("example_dead_letter", name="example-topic-dead-letter")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            dead_letter_policy={
                "dead_letter_topic": example_dead_letter.id,
                "max_delivery_attempts": 10,
            })
        ```
        ### Pubsub Subscription Push Bq

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        test = gcp.bigquery.Dataset("test", dataset_id="example_dataset")
        test_table = gcp.bigquery.Table("test",
            table_id="example_table",
            dataset_id=test.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"data\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\",
            \\"description\\": \\"The data\\"
          }
        ]
        \"\"\",
            deletion_protection=False)
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            bigquery_config={
                "table": pulumi.Output.all(
                    project=test_table.project,
                    dataset_id=test_table.dataset_id,
                    table_id=test_table.table_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
            })
        project = gcp.organizations.get_project()
        ```
        ### Pubsub Subscription Push Bq Table Schema

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        test = gcp.bigquery.Dataset("test", dataset_id="example_dataset")
        test_table = gcp.bigquery.Table("test",
            table_id="example_table",
            dataset_id=test.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"data\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\",
            \\"description\\": \\"The data\\"
          }
        ]
        \"\"\",
            deletion_protection=False)
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            bigquery_config={
                "table": pulumi.Output.all(
                    project=test_table.project,
                    dataset_id=test_table.dataset_id,
                    table_id=test_table.table_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "use_table_schema": True,
            })
        project = gcp.organizations.get_project()
        ```
        ### Pubsub Subscription Push Bq Service Account

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        bq_write_service_account = gcp.serviceaccount.Account("bq_write_service_account",
            account_id="example-bqw",
            display_name="BQ Write Service Account")
        project = gcp.organizations.get_project()
        bigquery_metadata_viewer = gcp.projects.IAMMember("bigquery_metadata_viewer",
            project=project.project_id,
            role="roles/bigquery.metadataViewer",
            member=bq_write_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        bigquery_data_editor = gcp.projects.IAMMember("bigquery_data_editor",
            project=project.project_id,
            role="roles/bigquery.dataEditor",
            member=bq_write_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        test = gcp.bigquery.Dataset("test", dataset_id="example_dataset")
        test_table = gcp.bigquery.Table("test",
            deletion_protection=False,
            table_id="example_table",
            dataset_id=test.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"data\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\",
            \\"description\\": \\"The data\\"
          }
        ]
        \"\"\")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            bigquery_config={
                "table": pulumi.Output.all(
                    project=test_table.project,
                    dataset_id=test_table.dataset_id,
                    table_id=test_table.table_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "service_account_email": bq_write_service_account.email,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    bq_write_service_account,
                    bigquery_metadata_viewer,
                    bigquery_data_editor,
                ]))
        ```
        ### Pubsub Subscription Push Cloudstorage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.Bucket("example",
            name="example-bucket",
            location="US",
            uniform_bucket_level_access=True)
        example_topic = gcp.pubsub.Topic("example", name="example-topic")
        project = gcp.organizations.get_project()
        admin = gcp.storage.BucketIAMMember("admin",
            bucket=example.name,
            role="roles/storage.admin",
            member=f"serviceAccount:service-{project.number}@gcp-sa-pubsub.iam.gserviceaccount.com")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example_topic.id,
            cloud_storage_config={
                "bucket": example.name,
                "filename_prefix": "pre-",
                "filename_suffix": "-_32270",
                "filename_datetime_format": "YYYY-MM-DD/hh_mm_ssZ",
                "max_bytes": 1000,
                "max_duration": "300s",
                "max_messages": 1000,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example,
                    admin,
                ]))
        ```
        ### Pubsub Subscription Push Cloudstorage Avro

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.Bucket("example",
            name="example-bucket",
            location="US",
            uniform_bucket_level_access=True)
        example_topic = gcp.pubsub.Topic("example", name="example-topic")
        project = gcp.organizations.get_project()
        admin = gcp.storage.BucketIAMMember("admin",
            bucket=example.name,
            role="roles/storage.admin",
            member=f"serviceAccount:service-{project.number}@gcp-sa-pubsub.iam.gserviceaccount.com")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example_topic.id,
            cloud_storage_config={
                "bucket": example.name,
                "filename_prefix": "pre-",
                "filename_suffix": "-_44703",
                "filename_datetime_format": "YYYY-MM-DD/hh_mm_ssZ",
                "max_bytes": 1000,
                "max_duration": "300s",
                "max_messages": 1000,
                "avro_config": {
                    "write_metadata": True,
                    "use_topic_schema": True,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example,
                    admin,
                ]))
        ```
        ### Pubsub Subscription Push Cloudstorage Service Account

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.Bucket("example",
            name="example-bucket",
            location="US",
            uniform_bucket_level_access=True)
        example_topic = gcp.pubsub.Topic("example", name="example-topic")
        storage_write_service_account = gcp.serviceaccount.Account("storage_write_service_account",
            account_id="example-stw",
            display_name="Storage Write Service Account")
        admin = gcp.storage.BucketIAMMember("admin",
            bucket=example.name,
            role="roles/storage.admin",
            member=storage_write_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example_topic.id,
            cloud_storage_config={
                "bucket": example.name,
                "filename_prefix": "pre-",
                "filename_suffix": "-_9329",
                "filename_datetime_format": "YYYY-MM-DD/hh_mm_ssZ",
                "max_bytes": 1000,
                "max_duration": "300s",
                "service_account_email": storage_write_service_account.email,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    storage_write_service_account,
                    example,
                    admin,
                ]))
        project = gcp.organizations.get_project()
        ```
        ### Pubsub Subscription Single Smt

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            message_transforms=[{
                "javascript_udf": {
                    "function_name": "isYearEven",
                    "code": \"\"\"function isYearEven(message, metadata) {
          const data = JSON.parse(message.data);
          return message.year %2 === 0;
        }
        \"\"\",
                },
            }])
        ```
        ### Pubsub Subscription Multiple Smts

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            message_transforms=[
                {
                    "javascript_udf": {
                        "function_name": "redactSSN",
                        "code": \"\"\"function redactSSN(message, metadata) {
          const data = JSON.parse(message.data);
          delete data['ssn'];
          message.data = JSON.stringify(data);
          return message;
        }
        \"\"\",
                    },
                },
                {
                    "javascript_udf": {
                        "function_name": "otherFunc",
                        "code": \"\"\"function otherFunc(message, metadata) {
          return null;
        }
        \"\"\",
                    },
                },
                {
                    "disabled": True,
                    "javascript_udf": {
                        "function_name": "someSMTWeDisabled",
                        "code": "...",
                    },
                },
            ])
        ```
        ### Pubsub Subscription Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.pubsub.Topic("example", name="example-topic")
        project = gcp.organizations.get_project()
        tag_key = gcp.tags.TagKey("tag_key",
            parent=project.id,
            short_name="tag_key",
            opts = pulumi.ResourceOptions(depends_on=[example]))
        tag_value = gcp.tags.TagValue("tag_value",
            parent=tag_key.id,
            short_name="tag_value")
        example_subscription = gcp.pubsub.Subscription("example",
            name="example-subscription",
            topic=example.id,
            tags=pulumi.Output.all(
                namespaced_name=tag_key.namespaced_name,
                short_name=tag_value.short_name
        ).apply(lambda resolved_outputs: {
                resolved_outputs['namespaced_name']: resolved_outputs['short_name'],
            })
        )
        ```

        ## Import

        Subscription can be imported using any of these accepted formats:

        * `projects/{{project}}/subscriptions/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Subscription can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:pubsub/subscription:Subscription default projects/{{project}}/subscriptions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:pubsub/subscription:Subscription default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:pubsub/subscription:Subscription default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ack_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 bigquery_config: Optional[pulumi.Input[Union['SubscriptionBigqueryConfigArgs', 'SubscriptionBigqueryConfigArgsDict']]] = None,
                 cloud_storage_config: Optional[pulumi.Input[Union['SubscriptionCloudStorageConfigArgs', 'SubscriptionCloudStorageConfigArgsDict']]] = None,
                 dead_letter_policy: Optional[pulumi.Input[Union['SubscriptionDeadLetterPolicyArgs', 'SubscriptionDeadLetterPolicyArgsDict']]] = None,
                 enable_exactly_once_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_message_ordering: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_policy: Optional[pulumi.Input[Union['SubscriptionExpirationPolicyArgs', 'SubscriptionExpirationPolicyArgsDict']]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 message_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 message_transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionMessageTransformArgs', 'SubscriptionMessageTransformArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_config: Optional[pulumi.Input[Union['SubscriptionPushConfigArgs', 'SubscriptionPushConfigArgsDict']]] = None,
                 retain_acked_messages: Optional[pulumi.Input[_builtins.bool]] = None,
                 retry_policy: Optional[pulumi.Input[Union['SubscriptionRetryPolicyArgs', 'SubscriptionRetryPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

            __props__.__dict__["ack_deadline_seconds"] = ack_deadline_seconds
            __props__.__dict__["bigquery_config"] = bigquery_config
            __props__.__dict__["cloud_storage_config"] = cloud_storage_config
            __props__.__dict__["dead_letter_policy"] = dead_letter_policy
            __props__.__dict__["enable_exactly_once_delivery"] = enable_exactly_once_delivery
            __props__.__dict__["enable_message_ordering"] = enable_message_ordering
            __props__.__dict__["expiration_policy"] = expiration_policy
            __props__.__dict__["filter"] = filter
            __props__.__dict__["labels"] = labels
            __props__.__dict__["message_retention_duration"] = message_retention_duration
            __props__.__dict__["message_transforms"] = message_transforms
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["push_config"] = push_config
            __props__.__dict__["retain_acked_messages"] = retain_acked_messages
            __props__.__dict__["retry_policy"] = retry_policy
            __props__.__dict__["tags"] = tags
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Subscription, __self__).__init__(
            'gcp:pubsub/subscription:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ack_deadline_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            bigquery_config: Optional[pulumi.Input[Union['SubscriptionBigqueryConfigArgs', 'SubscriptionBigqueryConfigArgsDict']]] = None,
            cloud_storage_config: Optional[pulumi.Input[Union['SubscriptionCloudStorageConfigArgs', 'SubscriptionCloudStorageConfigArgsDict']]] = None,
            dead_letter_policy: Optional[pulumi.Input[Union['SubscriptionDeadLetterPolicyArgs', 'SubscriptionDeadLetterPolicyArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_exactly_once_delivery: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_message_ordering: Optional[pulumi.Input[_builtins.bool]] = None,
            expiration_policy: Optional[pulumi.Input[Union['SubscriptionExpirationPolicyArgs', 'SubscriptionExpirationPolicyArgsDict']]] = None,
            filter: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            message_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
            message_transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionMessageTransformArgs', 'SubscriptionMessageTransformArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            push_config: Optional[pulumi.Input[Union['SubscriptionPushConfigArgs', 'SubscriptionPushConfigArgsDict']]] = None,
            retain_acked_messages: Optional[pulumi.Input[_builtins.bool]] = None,
            retry_policy: Optional[pulumi.Input[Union['SubscriptionRetryPolicyArgs', 'SubscriptionRetryPolicyArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            topic: Optional[pulumi.Input[_builtins.str]] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] ack_deadline_seconds: This value is the maximum time after a subscriber receives a message
               before the subscriber should acknowledge the message. After message
               delivery but before the ack deadline expires and before the message is
               acknowledged, it is an outstanding message and will not be delivered
               again during that time (on a best-effort basis).
               For pull subscriptions, this value is used as the initial value for
               the ack deadline. To override this value for a given message, call
               subscriptions.modifyAckDeadline with the corresponding ackId if using
               pull. The minimum custom deadline you can specify is 10 seconds. The
               maximum custom deadline you can specify is 600 seconds (10 minutes).
               If this parameter is 0, a default value of 10 seconds is used.
               For push delivery, this value is also used to set the request timeout
               for the call to the push endpoint.
               If the subscriber never acknowledges the message, the Pub/Sub system
               will eventually redeliver the message.
        :param pulumi.Input[Union['SubscriptionBigqueryConfigArgs', 'SubscriptionBigqueryConfigArgsDict']] bigquery_config: If delivery to BigQuery is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[Union['SubscriptionCloudStorageConfigArgs', 'SubscriptionCloudStorageConfigArgsDict']] cloud_storage_config: If delivery to Cloud Storage is used with this subscription, this field is used to configure it.
               Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
               If all three are empty, then the subscriber will pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[Union['SubscriptionDeadLetterPolicyArgs', 'SubscriptionDeadLetterPolicyArgsDict']] dead_letter_policy: A policy that specifies the conditions for dead lettering messages in
               this subscription. If dead_letter_policy is not set, dead lettering
               is disabled.
               The Cloud Pub/Sub service account associated with this subscription's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Acknowledge() messages on this subscription.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_exactly_once_delivery: If `true`, Pub/Sub provides the following guarantees for the delivery
               of a message with a given value of messageId on this Subscriptions':
               - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
               - An acknowledged message will not be resent to a subscriber.
               Note that subscribers may still receive multiple copies of a message when `enable_exactly_once_delivery`
               is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
        :param pulumi.Input[_builtins.bool] enable_message_ordering: If `true`, messages published with the same orderingKey in PubsubMessage will be delivered to
               the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
               may be delivered in any order.
        :param pulumi.Input[Union['SubscriptionExpirationPolicyArgs', 'SubscriptionExpirationPolicyArgsDict']] expiration_policy: A policy that specifies the conditions for this subscription's expiration.
               A subscription is considered active as long as any connected subscriber
               is successfully consuming messages from the subscription or is issuing
               operations on the subscription. If expirationPolicy is not set, a default
               policy with ttl of 31 days will be used.  If it is set but ttl is "", the
               resource never expires.  The minimum allowed value for expirationPolicy.ttl
               is 1 day.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The subscription only delivers the messages that match the filter.
               Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
               by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
               you can't modify the filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this Subscription.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] message_retention_duration: How long to retain unacknowledged messages in the subscription's
               backlog, from the moment a message is published. If
               retain_acked_messages is true, then this also configures the retention
               of acknowledged messages, and thus configures how far back in time a
               subscriptions.seek can be done. Defaults to 7 days. Cannot be more
               than 31 days (`"2678400s"`) or less than 10 minutes (`"600s"`).
               A duration in seconds with up to nine fractional digits, terminated
               by 's'. Example: `"600.5s"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionMessageTransformArgs', 'SubscriptionMessageTransformArgsDict']]]] message_transforms: Transforms to be applied to messages published to the topic. Transforms are applied in the
               order specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the subscription.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['SubscriptionPushConfigArgs', 'SubscriptionPushConfigArgsDict']] push_config: If push delivery is used with this subscription, this field is used to
               configure it. An empty pushConfig signifies that the subscriber will
               pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] retain_acked_messages: Indicates whether to retain acknowledged messages. If `true`, then
               messages are not expunged from the subscription's backlog, even if
               they are acknowledged, until they fall out of the
               messageRetentionDuration window.
        :param pulumi.Input[Union['SubscriptionRetryPolicyArgs', 'SubscriptionRetryPolicyArgsDict']] retry_policy: A policy that specifies how Pub/Sub retries message delivery for this subscription.
               If not set, the default retry policy is applied. This generally implies that messages will be retried as soon as possible for healthy subscribers.
               RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded events for a given message
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Input only. Resource manager tags to be bound to the subscription. Tag
               keys and values have the same definition as resource manager tags. Keys
               must be in the format tagKeys/{tag_key_id}, and values are in the format
               tagValues/456. The field is ignored when empty. The field is immutable and
               causes resource replacement when mutated. This field is only set at create
               time and modifying this field after creation will trigger recreation. To
               apply tags to an existing resource, see the `tags.TagValue`
               resource.
        :param pulumi.Input[_builtins.str] topic: A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
               (as in the id property of a google_pubsub_topic), or just a topic name if
               the topic is in the same project as the subscription.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionState.__new__(_SubscriptionState)

        __props__.__dict__["ack_deadline_seconds"] = ack_deadline_seconds
        __props__.__dict__["bigquery_config"] = bigquery_config
        __props__.__dict__["cloud_storage_config"] = cloud_storage_config
        __props__.__dict__["dead_letter_policy"] = dead_letter_policy
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_exactly_once_delivery"] = enable_exactly_once_delivery
        __props__.__dict__["enable_message_ordering"] = enable_message_ordering
        __props__.__dict__["expiration_policy"] = expiration_policy
        __props__.__dict__["filter"] = filter
        __props__.__dict__["labels"] = labels
        __props__.__dict__["message_retention_duration"] = message_retention_duration
        __props__.__dict__["message_transforms"] = message_transforms
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["push_config"] = push_config
        __props__.__dict__["retain_acked_messages"] = retain_acked_messages
        __props__.__dict__["retry_policy"] = retry_policy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["topic"] = topic
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ackDeadlineSeconds")
    def ack_deadline_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        This value is the maximum time after a subscriber receives a message
        before the subscriber should acknowledge the message. After message
        delivery but before the ack deadline expires and before the message is
        acknowledged, it is an outstanding message and will not be delivered
        again during that time (on a best-effort basis).
        For pull subscriptions, this value is used as the initial value for
        the ack deadline. To override this value for a given message, call
        subscriptions.modifyAckDeadline with the corresponding ackId if using
        pull. The minimum custom deadline you can specify is 10 seconds. The
        maximum custom deadline you can specify is 600 seconds (10 minutes).
        If this parameter is 0, a default value of 10 seconds is used.
        For push delivery, this value is also used to set the request timeout
        for the call to the push endpoint.
        If the subscriber never acknowledges the message, the Pub/Sub system
        will eventually redeliver the message.
        """
        return pulumi.get(self, "ack_deadline_seconds")

    @_builtins.property
    @pulumi.getter(name="bigqueryConfig")
    def bigquery_config(self) -> pulumi.Output[Optional['outputs.SubscriptionBigqueryConfig']]:
        """
        If delivery to BigQuery is used with this subscription, this field is used to configure it.
        Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
        If all three are empty, then the subscriber will pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_config")

    @_builtins.property
    @pulumi.getter(name="cloudStorageConfig")
    def cloud_storage_config(self) -> pulumi.Output[Optional['outputs.SubscriptionCloudStorageConfig']]:
        """
        If delivery to Cloud Storage is used with this subscription, this field is used to configure it.
        Either pushConfig, bigQueryConfig or cloudStorageConfig can be set, but not combined.
        If all three are empty, then the subscriber will pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_storage_config")

    @_builtins.property
    @pulumi.getter(name="deadLetterPolicy")
    def dead_letter_policy(self) -> pulumi.Output[Optional['outputs.SubscriptionDeadLetterPolicy']]:
        """
        A policy that specifies the conditions for dead lettering messages in
        this subscription. If dead_letter_policy is not set, dead lettering
        is disabled.
        The Cloud Pub/Sub service account associated with this subscription's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Acknowledge() messages on this subscription.
        Structure is documented below.
        """
        return pulumi.get(self, "dead_letter_policy")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="enableExactlyOnceDelivery")
    def enable_exactly_once_delivery(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, Pub/Sub provides the following guarantees for the delivery
        of a message with a given value of messageId on this Subscriptions':
        - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
        - An acknowledged message will not be resent to a subscriber.
        Note that subscribers may still receive multiple copies of a message when `enable_exactly_once_delivery`
        is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
        """
        return pulumi.get(self, "enable_exactly_once_delivery")

    @_builtins.property
    @pulumi.getter(name="enableMessageOrdering")
    def enable_message_ordering(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, messages published with the same orderingKey in PubsubMessage will be delivered to
        the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
        may be delivered in any order.
        """
        return pulumi.get(self, "enable_message_ordering")

    @_builtins.property
    @pulumi.getter(name="expirationPolicy")
    def expiration_policy(self) -> pulumi.Output['outputs.SubscriptionExpirationPolicy']:
        """
        A policy that specifies the conditions for this subscription's expiration.
        A subscription is considered active as long as any connected subscriber
        is successfully consuming messages from the subscription or is issuing
        operations on the subscription. If expirationPolicy is not set, a default
        policy with ttl of 31 days will be used.  If it is set but ttl is "", the
        resource never expires.  The minimum allowed value for expirationPolicy.ttl
        is 1 day.
        Structure is documented below.
        """
        return pulumi.get(self, "expiration_policy")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subscription only delivers the messages that match the filter.
        Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
        by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
        you can't modify the filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs to assign to this Subscription.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="messageRetentionDuration")
    def message_retention_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How long to retain unacknowledged messages in the subscription's
        backlog, from the moment a message is published. If
        retain_acked_messages is true, then this also configures the retention
        of acknowledged messages, and thus configures how far back in time a
        subscriptions.seek can be done. Defaults to 7 days. Cannot be more
        than 31 days (`"2678400s"`) or less than 10 minutes (`"600s"`).
        A duration in seconds with up to nine fractional digits, terminated
        by 's'. Example: `"600.5s"`.
        """
        return pulumi.get(self, "message_retention_duration")

    @_builtins.property
    @pulumi.getter(name="messageTransforms")
    def message_transforms(self) -> pulumi.Output[Optional[Sequence['outputs.SubscriptionMessageTransform']]]:
        """
        Transforms to be applied to messages published to the topic. Transforms are applied in the
        order specified.
        Structure is documented below.
        """
        return pulumi.get(self, "message_transforms")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the subscription.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="pushConfig")
    def push_config(self) -> pulumi.Output[Optional['outputs.SubscriptionPushConfig']]:
        """
        If push delivery is used with this subscription, this field is used to
        configure it. An empty pushConfig signifies that the subscriber will
        pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "push_config")

    @_builtins.property
    @pulumi.getter(name="retainAckedMessages")
    def retain_acked_messages(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether to retain acknowledged messages. If `true`, then
        messages are not expunged from the subscription's backlog, even if
        they are acknowledged, until they fall out of the
        messageRetentionDuration window.
        """
        return pulumi.get(self, "retain_acked_messages")

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> pulumi.Output[Optional['outputs.SubscriptionRetryPolicy']]:
        """
        A policy that specifies how Pub/Sub retries message delivery for this subscription.
        If not set, the default retry policy is applied. This generally implies that messages will be retried as soon as possible for healthy subscribers.
        RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded events for a given message
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Input only. Resource manager tags to be bound to the subscription. Tag
        keys and values have the same definition as resource manager tags. Keys
        must be in the format tagKeys/{tag_key_id}, and values are in the format
        tagValues/456. The field is ignored when empty. The field is immutable and
        causes resource replacement when mutated. This field is only set at create
        time and modifying this field after creation will trigger recreation. To
        apply tags to an existing resource, see the `tags.TagValue`
        resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
        (as in the id property of a google_pubsub_topic), or just a topic name if
        the topic is in the same project as the subscription.
        """
        return pulumi.get(self, "topic")

