# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnterpriseKeyArgs', 'EnterpriseKey']

@pulumi.input_type
class EnterpriseKeyArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 android_settings: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']] = None,
                 ios_settings: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_options: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']] = None,
                 waf_settings: Optional[pulumi.Input['EnterpriseKeyWafSettingsArgs']] = None,
                 web_settings: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']] = None):
        """
        The set of arguments for constructing a EnterpriseKey resource.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of this key. Modifiable by user.
               
               
               
               - - -
        :param pulumi.Input['EnterpriseKeyAndroidSettingsArgs'] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input['EnterpriseKeyIosSettingsArgs'] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input['EnterpriseKeyTestingOptionsArgs'] testing_options: Options for user acceptance testing.
        :param pulumi.Input['EnterpriseKeyWafSettingsArgs'] waf_settings: Settings specific to keys that can be used for WAF (Web Application Firewall).
        :param pulumi.Input['EnterpriseKeyWebSettingsArgs'] web_settings: Settings for keys that can be used by websites.
        """
        pulumi.set(__self__, "display_name", display_name)
        if android_settings is not None:
            pulumi.set(__self__, "android_settings", android_settings)
        if ios_settings is not None:
            pulumi.set(__self__, "ios_settings", ios_settings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if testing_options is not None:
            pulumi.set(__self__, "testing_options", testing_options)
        if waf_settings is not None:
            pulumi.set(__self__, "waf_settings", waf_settings)
        if web_settings is not None:
            pulumi.set(__self__, "web_settings", web_settings)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Human-readable display name of this key. Modifiable by user.



        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="androidSettings")
    def android_settings(self) -> Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]:
        """
        Settings for keys that can be used by Android apps.
        """
        return pulumi.get(self, "android_settings")

    @android_settings.setter
    def android_settings(self, value: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]):
        pulumi.set(self, "android_settings", value)

    @_builtins.property
    @pulumi.getter(name="iosSettings")
    def ios_settings(self) -> Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]:
        """
        Settings for keys that can be used by iOS apps.
        """
        return pulumi.get(self, "ios_settings")

    @ios_settings.setter
    def ios_settings(self, value: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]):
        pulumi.set(self, "ios_settings", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="testingOptions")
    def testing_options(self) -> Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]:
        """
        Options for user acceptance testing.
        """
        return pulumi.get(self, "testing_options")

    @testing_options.setter
    def testing_options(self, value: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]):
        pulumi.set(self, "testing_options", value)

    @_builtins.property
    @pulumi.getter(name="wafSettings")
    def waf_settings(self) -> Optional[pulumi.Input['EnterpriseKeyWafSettingsArgs']]:
        """
        Settings specific to keys that can be used for WAF (Web Application Firewall).
        """
        return pulumi.get(self, "waf_settings")

    @waf_settings.setter
    def waf_settings(self, value: Optional[pulumi.Input['EnterpriseKeyWafSettingsArgs']]):
        pulumi.set(self, "waf_settings", value)

    @_builtins.property
    @pulumi.getter(name="webSettings")
    def web_settings(self) -> Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]:
        """
        Settings for keys that can be used by websites.
        """
        return pulumi.get(self, "web_settings")

    @web_settings.setter
    def web_settings(self, value: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]):
        pulumi.set(self, "web_settings", value)


@pulumi.input_type
class _EnterpriseKeyState:
    def __init__(__self__, *,
                 android_settings: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ios_settings: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 testing_options: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']] = None,
                 waf_settings: Optional[pulumi.Input['EnterpriseKeyWafSettingsArgs']] = None,
                 web_settings: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering EnterpriseKey resources.
        :param pulumi.Input['EnterpriseKeyAndroidSettingsArgs'] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input[_builtins.str] create_time: The timestamp corresponding to the creation of this Key.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of this key. Modifiable by user.
               
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['EnterpriseKeyIosSettingsArgs'] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource id for the Key, which is the same as the Site Key itself.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input['EnterpriseKeyTestingOptionsArgs'] testing_options: Options for user acceptance testing.
        :param pulumi.Input['EnterpriseKeyWafSettingsArgs'] waf_settings: Settings specific to keys that can be used for WAF (Web Application Firewall).
        :param pulumi.Input['EnterpriseKeyWebSettingsArgs'] web_settings: Settings for keys that can be used by websites.
        """
        if android_settings is not None:
            pulumi.set(__self__, "android_settings", android_settings)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if ios_settings is not None:
            pulumi.set(__self__, "ios_settings", ios_settings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if testing_options is not None:
            pulumi.set(__self__, "testing_options", testing_options)
        if waf_settings is not None:
            pulumi.set(__self__, "waf_settings", waf_settings)
        if web_settings is not None:
            pulumi.set(__self__, "web_settings", web_settings)

    @_builtins.property
    @pulumi.getter(name="androidSettings")
    def android_settings(self) -> Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]:
        """
        Settings for keys that can be used by Android apps.
        """
        return pulumi.get(self, "android_settings")

    @android_settings.setter
    def android_settings(self, value: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]):
        pulumi.set(self, "android_settings", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp corresponding to the creation of this Key.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable display name of this key. Modifiable by user.



        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="iosSettings")
    def ios_settings(self) -> Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]:
        """
        Settings for keys that can be used by iOS apps.
        """
        return pulumi.get(self, "ios_settings")

    @ios_settings.setter
    def ios_settings(self, value: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]):
        pulumi.set(self, "ios_settings", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource id for the Key, which is the same as the Site Key itself.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="testingOptions")
    def testing_options(self) -> Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]:
        """
        Options for user acceptance testing.
        """
        return pulumi.get(self, "testing_options")

    @testing_options.setter
    def testing_options(self, value: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]):
        pulumi.set(self, "testing_options", value)

    @_builtins.property
    @pulumi.getter(name="wafSettings")
    def waf_settings(self) -> Optional[pulumi.Input['EnterpriseKeyWafSettingsArgs']]:
        """
        Settings specific to keys that can be used for WAF (Web Application Firewall).
        """
        return pulumi.get(self, "waf_settings")

    @waf_settings.setter
    def waf_settings(self, value: Optional[pulumi.Input['EnterpriseKeyWafSettingsArgs']]):
        pulumi.set(self, "waf_settings", value)

    @_builtins.property
    @pulumi.getter(name="webSettings")
    def web_settings(self) -> Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]:
        """
        Settings for keys that can be used by websites.
        """
        return pulumi.get(self, "web_settings")

    @web_settings.setter
    def web_settings(self, value: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]):
        pulumi.set(self, "web_settings", value)


@pulumi.type_token("gcp:recaptcha/enterpriseKey:EnterpriseKey")
class EnterpriseKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 android_settings: Optional[pulumi.Input[Union['EnterpriseKeyAndroidSettingsArgs', 'EnterpriseKeyAndroidSettingsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ios_settings: Optional[pulumi.Input[Union['EnterpriseKeyIosSettingsArgs', 'EnterpriseKeyIosSettingsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_options: Optional[pulumi.Input[Union['EnterpriseKeyTestingOptionsArgs', 'EnterpriseKeyTestingOptionsArgsDict']]] = None,
                 waf_settings: Optional[pulumi.Input[Union['EnterpriseKeyWafSettingsArgs', 'EnterpriseKeyWafSettingsArgsDict']]] = None,
                 web_settings: Optional[pulumi.Input[Union['EnterpriseKeyWebSettingsArgs', 'EnterpriseKeyWebSettingsArgsDict']]] = None,
                 __props__=None):
        """
        The RecaptchaEnterprise Key resource

        ## Example Usage

        ### Android_key
        A basic test of recaptcha enterprise key that can be used by Android apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            android_settings={
                "allow_all_package_names": True,
                "allowed_package_names": [],
            },
            project="my-project-name",
            testing_options={
                "testing_score": 0.8,
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Ios_key
        A basic test of recaptcha enterprise key that can be used by iOS apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            ios_settings={
                "allow_all_bundle_ids": True,
                "allowed_bundle_ids": [],
            },
            project="my-project-name",
            testing_options={
                "testing_score": 1,
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Minimal_key
        A minimal test of recaptcha enterprise key
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            web_settings={
                "integration_type": "SCORE",
                "allow_all_domains": True,
            },
            labels={})
        ```
        ### Waf_key
        A basic test of recaptcha enterprise key that includes WAF settings
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            testing_options={
                "testing_challenge": "NOCAPTCHA",
                "testing_score": 0.5,
            },
            waf_settings={
                "waf_feature": "CHALLENGE_PAGE",
                "waf_service": "CA",
            },
            web_settings={
                "integration_type": "INVISIBLE",
                "allow_all_domains": True,
                "allowed_domains": [],
                "challenge_security_preference": "USABILITY",
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Web_key
        A basic test of recaptcha enterprise key that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            testing_options={
                "testing_challenge": "NOCAPTCHA",
                "testing_score": 0.5,
            },
            web_settings={
                "integration_type": "CHECKBOX",
                "allow_all_domains": True,
                "allowed_domains": [],
                "challenge_security_preference": "USABILITY",
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Web_score_key
        A basic test of recaptcha enterprise key with score integration type that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            testing_options={
                "testing_score": 0.5,
            },
            web_settings={
                "integration_type": "SCORE",
                "allow_all_domains": True,
                "allow_amp_traffic": False,
                "allowed_domains": [],
            },
            labels={
                "label-one": "value-one",
            })
        ```

        ## Import

        Key can be imported using any of these accepted formats:

        * `projects/{{project}}/keys/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Key can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default projects/{{project}}/keys/{{name}}
        ```

        ```sh
        $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EnterpriseKeyAndroidSettingsArgs', 'EnterpriseKeyAndroidSettingsArgsDict']] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of this key. Modifiable by user.
               
               
               
               - - -
        :param pulumi.Input[Union['EnterpriseKeyIosSettingsArgs', 'EnterpriseKeyIosSettingsArgsDict']] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Union['EnterpriseKeyTestingOptionsArgs', 'EnterpriseKeyTestingOptionsArgsDict']] testing_options: Options for user acceptance testing.
        :param pulumi.Input[Union['EnterpriseKeyWafSettingsArgs', 'EnterpriseKeyWafSettingsArgsDict']] waf_settings: Settings specific to keys that can be used for WAF (Web Application Firewall).
        :param pulumi.Input[Union['EnterpriseKeyWebSettingsArgs', 'EnterpriseKeyWebSettingsArgsDict']] web_settings: Settings for keys that can be used by websites.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The RecaptchaEnterprise Key resource

        ## Example Usage

        ### Android_key
        A basic test of recaptcha enterprise key that can be used by Android apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            android_settings={
                "allow_all_package_names": True,
                "allowed_package_names": [],
            },
            project="my-project-name",
            testing_options={
                "testing_score": 0.8,
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Ios_key
        A basic test of recaptcha enterprise key that can be used by iOS apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            ios_settings={
                "allow_all_bundle_ids": True,
                "allowed_bundle_ids": [],
            },
            project="my-project-name",
            testing_options={
                "testing_score": 1,
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Minimal_key
        A minimal test of recaptcha enterprise key
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            web_settings={
                "integration_type": "SCORE",
                "allow_all_domains": True,
            },
            labels={})
        ```
        ### Waf_key
        A basic test of recaptcha enterprise key that includes WAF settings
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            testing_options={
                "testing_challenge": "NOCAPTCHA",
                "testing_score": 0.5,
            },
            waf_settings={
                "waf_feature": "CHALLENGE_PAGE",
                "waf_service": "CA",
            },
            web_settings={
                "integration_type": "INVISIBLE",
                "allow_all_domains": True,
                "allowed_domains": [],
                "challenge_security_preference": "USABILITY",
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Web_key
        A basic test of recaptcha enterprise key that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            testing_options={
                "testing_challenge": "NOCAPTCHA",
                "testing_score": 0.5,
            },
            web_settings={
                "integration_type": "CHECKBOX",
                "allow_all_domains": True,
                "allowed_domains": [],
                "challenge_security_preference": "USABILITY",
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Web_score_key
        A basic test of recaptcha enterprise key with score integration type that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            project="my-project-name",
            testing_options={
                "testing_score": 0.5,
            },
            web_settings={
                "integration_type": "SCORE",
                "allow_all_domains": True,
                "allow_amp_traffic": False,
                "allowed_domains": [],
            },
            labels={
                "label-one": "value-one",
            })
        ```

        ## Import

        Key can be imported using any of these accepted formats:

        * `projects/{{project}}/keys/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Key can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default projects/{{project}}/keys/{{name}}
        ```

        ```sh
        $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 android_settings: Optional[pulumi.Input[Union['EnterpriseKeyAndroidSettingsArgs', 'EnterpriseKeyAndroidSettingsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ios_settings: Optional[pulumi.Input[Union['EnterpriseKeyIosSettingsArgs', 'EnterpriseKeyIosSettingsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_options: Optional[pulumi.Input[Union['EnterpriseKeyTestingOptionsArgs', 'EnterpriseKeyTestingOptionsArgsDict']]] = None,
                 waf_settings: Optional[pulumi.Input[Union['EnterpriseKeyWafSettingsArgs', 'EnterpriseKeyWafSettingsArgsDict']]] = None,
                 web_settings: Optional[pulumi.Input[Union['EnterpriseKeyWebSettingsArgs', 'EnterpriseKeyWebSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseKeyArgs.__new__(EnterpriseKeyArgs)

            __props__.__dict__["android_settings"] = android_settings
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["ios_settings"] = ios_settings
            __props__.__dict__["labels"] = labels
            __props__.__dict__["project"] = project
            __props__.__dict__["testing_options"] = testing_options
            __props__.__dict__["waf_settings"] = waf_settings
            __props__.__dict__["web_settings"] = web_settings
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EnterpriseKey, __self__).__init__(
            'gcp:recaptcha/enterpriseKey:EnterpriseKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            android_settings: Optional[pulumi.Input[Union['EnterpriseKeyAndroidSettingsArgs', 'EnterpriseKeyAndroidSettingsArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ios_settings: Optional[pulumi.Input[Union['EnterpriseKeyIosSettingsArgs', 'EnterpriseKeyIosSettingsArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            testing_options: Optional[pulumi.Input[Union['EnterpriseKeyTestingOptionsArgs', 'EnterpriseKeyTestingOptionsArgsDict']]] = None,
            waf_settings: Optional[pulumi.Input[Union['EnterpriseKeyWafSettingsArgs', 'EnterpriseKeyWafSettingsArgsDict']]] = None,
            web_settings: Optional[pulumi.Input[Union['EnterpriseKeyWebSettingsArgs', 'EnterpriseKeyWebSettingsArgsDict']]] = None) -> 'EnterpriseKey':
        """
        Get an existing EnterpriseKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EnterpriseKeyAndroidSettingsArgs', 'EnterpriseKeyAndroidSettingsArgsDict']] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input[_builtins.str] create_time: The timestamp corresponding to the creation of this Key.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of this key. Modifiable by user.
               
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['EnterpriseKeyIosSettingsArgs', 'EnterpriseKeyIosSettingsArgsDict']] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource id for the Key, which is the same as the Site Key itself.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[Union['EnterpriseKeyTestingOptionsArgs', 'EnterpriseKeyTestingOptionsArgsDict']] testing_options: Options for user acceptance testing.
        :param pulumi.Input[Union['EnterpriseKeyWafSettingsArgs', 'EnterpriseKeyWafSettingsArgsDict']] waf_settings: Settings specific to keys that can be used for WAF (Web Application Firewall).
        :param pulumi.Input[Union['EnterpriseKeyWebSettingsArgs', 'EnterpriseKeyWebSettingsArgsDict']] web_settings: Settings for keys that can be used by websites.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseKeyState.__new__(_EnterpriseKeyState)

        __props__.__dict__["android_settings"] = android_settings
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["ios_settings"] = ios_settings
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["testing_options"] = testing_options
        __props__.__dict__["waf_settings"] = waf_settings
        __props__.__dict__["web_settings"] = web_settings
        return EnterpriseKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="androidSettings")
    def android_settings(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyAndroidSettings']]:
        """
        Settings for keys that can be used by Android apps.
        """
        return pulumi.get(self, "android_settings")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp corresponding to the creation of this Key.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable display name of this key. Modifiable by user.



        - - -
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="iosSettings")
    def ios_settings(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyIosSettings']]:
        """
        Settings for keys that can be used by iOS apps.
        """
        return pulumi.get(self, "ios_settings")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource id for the Key, which is the same as the Site Key itself.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="testingOptions")
    def testing_options(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyTestingOptions']]:
        """
        Options for user acceptance testing.
        """
        return pulumi.get(self, "testing_options")

    @_builtins.property
    @pulumi.getter(name="wafSettings")
    def waf_settings(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyWafSettings']]:
        """
        Settings specific to keys that can be used for WAF (Web Application Firewall).
        """
        return pulumi.get(self, "waf_settings")

    @_builtins.property
    @pulumi.getter(name="webSettings")
    def web_settings(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyWebSettings']]:
        """
        Settings for keys that can be used by websites.
        """
        return pulumi.get(self, "web_settings")

