# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 shard_count: pulumi.Input[_builtins.int],
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input['ClusterAutomatedBackupConfigArgs']] = None,
                 cross_cluster_replication_config: Optional[pulumi.Input['ClusterCrossClusterReplicationConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcs_source: Optional[pulumi.Input['ClusterGcsSourceArgs']] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input['ClusterManagedBackupSourceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input['ClusterPersistenceConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value is `AUTH_MODE_DISABLED`.
               Possible values are: `AUTH_MODE_UNSPECIFIED`, `AUTH_MODE_IAM_AUTH`, `AUTH_MODE_DISABLED`.
        :param pulumi.Input['ClusterAutomatedBackupConfigArgs'] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input['ClusterCrossClusterReplicationConfigArgs'] cross_cluster_replication_config: Cross cluster replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not.
               If the value if set to true, any delete cluster operation will fail.
               Default value is true.
        :param pulumi.Input['ClusterGcsSourceArgs'] gcs_source: Backups stored in Cloud Storage buckets. The Cloud Storage buckets need to be the same region as the clusters.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster.
        :param pulumi.Input['ClusterMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input['ClusterManagedBackupSourceArgs'] managed_backup_source: Backups that generated and managed by memorystore.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[_builtins.str] node_type: The nodeType for the Redis cluster.
               If not provided, REDIS_HIGHMEM_MEDIUM will be used as default
               Possible values are: `REDIS_SHARED_CORE_NANO`, `REDIS_HIGHMEM_MEDIUM`, `REDIS_HIGHMEM_XLARGE`, `REDIS_STANDARD_SMALL`.
        :param pulumi.Input['ClusterPersistenceConfigArgs'] persistence_config: Persistence config (RDB, AOF) for the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster.
               If not provided, encryption is disabled for the cluster.
               Default value is `TRANSIT_ENCRYPTION_MODE_DISABLED`.
               Possible values are: `TRANSIT_ENCRYPTION_MODE_UNSPECIFIED`, `TRANSIT_ENCRYPTION_MODE_DISABLED`, `TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION`.
        :param pulumi.Input['ClusterZoneDistributionConfigArgs'] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "shard_count", shard_count)
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if automated_backup_config is not None:
            pulumi.set(__self__, "automated_backup_config", automated_backup_config)
        if cross_cluster_replication_config is not None:
            pulumi.set(__self__, "cross_cluster_replication_config", cross_cluster_replication_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if gcs_source is not None:
            pulumi.set(__self__, "gcs_source", gcs_source)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if managed_backup_source is not None:
            pulumi.set(__self__, "managed_backup_source", managed_backup_source)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_configs is not None:
            pulumi.set(__self__, "psc_configs", psc_configs)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Input[_builtins.int]:
        """
        Required. Number of shards for the Redis cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
        Default value is `AUTH_MODE_DISABLED`.
        Possible values are: `AUTH_MODE_UNSPECIFIED`, `AUTH_MODE_IAM_AUTH`, `AUTH_MODE_DISABLED`.
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_mode", value)

    @_builtins.property
    @pulumi.getter(name="automatedBackupConfig")
    def automated_backup_config(self) -> Optional[pulumi.Input['ClusterAutomatedBackupConfigArgs']]:
        """
        The automated backup config for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_config")

    @automated_backup_config.setter
    def automated_backup_config(self, value: Optional[pulumi.Input['ClusterAutomatedBackupConfigArgs']]):
        pulumi.set(self, "automated_backup_config", value)

    @_builtins.property
    @pulumi.getter(name="crossClusterReplicationConfig")
    def cross_cluster_replication_config(self) -> Optional[pulumi.Input['ClusterCrossClusterReplicationConfigArgs']]:
        """
        Cross cluster replication config
        Structure is documented below.
        """
        return pulumi.get(self, "cross_cluster_replication_config")

    @cross_cluster_replication_config.setter
    def cross_cluster_replication_config(self, value: Optional[pulumi.Input['ClusterCrossClusterReplicationConfigArgs']]):
        pulumi.set(self, "cross_cluster_replication_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Indicates if the cluster is deletion protected or not.
        If the value if set to true, any delete cluster operation will fail.
        Default value is true.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> Optional[pulumi.Input['ClusterGcsSourceArgs']]:
        """
        Backups stored in Cloud Storage buckets. The Cloud Storage buckets need to be the same region as the clusters.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_source")

    @gcs_source.setter
    def gcs_source(self, value: Optional[pulumi.Input['ClusterGcsSourceArgs']]):
        pulumi.set(self, "gcs_source", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key used to encrypt the at-rest data of the cluster.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]:
        """
        Maintenance policy for a cluster
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
        *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="managedBackupSource")
    def managed_backup_source(self) -> Optional[pulumi.Input['ClusterManagedBackupSourceArgs']]:
        """
        Backups that generated and managed by memorystore.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_backup_source")

    @managed_backup_source.setter
    def managed_backup_source(self, value: Optional[pulumi.Input['ClusterManagedBackupSourceArgs']]):
        pulumi.set(self, "managed_backup_source", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the resource in this scope including project and location using the form:
        projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The nodeType for the Redis cluster.
        If not provided, REDIS_HIGHMEM_MEDIUM will be used as default
        Possible values are: `REDIS_SHARED_CORE_NANO`, `REDIS_HIGHMEM_MEDIUM`, `REDIS_HIGHMEM_XLARGE`, `REDIS_STANDARD_SMALL`.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['ClusterPersistenceConfigArgs']]:
        """
        Persistence config (RDB, AOF) for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['ClusterPersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]]:
        """
        Required. Each PscConfig configures the consumer network where two
        network addresses will be designated to the cluster for client access.
        Currently, only one PscConfig is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_configs")

    @psc_configs.setter
    def psc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]]):
        pulumi.set(self, "psc_configs", value)

    @_builtins.property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configure Redis Cluster behavior using a subset of native Redis configuration parameters.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_configs", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the region of the Redis cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. The number of replica nodes per shard.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The in-transit encryption for the Redis cluster.
        If not provided, encryption is disabled for the cluster.
        Default value is `TRANSIT_ENCRYPTION_MODE_DISABLED`.
        Possible values are: `TRANSIT_ENCRYPTION_MODE_UNSPECIFIED`, `TRANSIT_ENCRYPTION_MODE_DISABLED`, `TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION`.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]:
        """
        Immutable. Zone distribution config for Memorystore Redis cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input['ClusterAutomatedBackupConfigArgs']] = None,
                 available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_collection: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_cluster_replication_config: Optional[pulumi.Input['ClusterCrossClusterReplicationConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]]] = None,
                 effective_maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_source: Optional[pulumi.Input['ClusterGcsSourceArgs']] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']] = None,
                 maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input['ClusterManagedBackupSourceArgs']] = None,
                 managed_server_cas: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterManagedServerCaArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input['ClusterPersistenceConfigArgs']] = None,
                 precise_size_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]] = None,
                 psc_connections: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]]] = None,
                 psc_service_attachments: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscServiceAttachmentArgs']]]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value is `AUTH_MODE_DISABLED`.
               Possible values are: `AUTH_MODE_UNSPECIFIED`, `AUTH_MODE_IAM_AUTH`, `AUTH_MODE_DISABLED`.
        :param pulumi.Input['ClusterAutomatedBackupConfigArgs'] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_maintenance_versions: This field is used to determine the available maintenance versions for the self service update.
        :param pulumi.Input[_builtins.str] backup_collection: The backup collection full resource name.
               Example: projects/{project}/locations/{location}/backupCollections/{collection}
        :param pulumi.Input[_builtins.str] create_time: The timestamp associated with the cluster creation request. A timestamp in
               RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
               digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input['ClusterCrossClusterReplicationConfigArgs'] cross_cluster_replication_config: Cross cluster replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not.
               If the value if set to true, any delete cluster operation will fail.
               Default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]] discovery_endpoints: Output only. Endpoints created on each given network,
               for Redis clients to connect to the cluster.
               Currently only one endpoint is supported.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] effective_maintenance_version: This field represents the actual maintenance version of the cluster.
        :param pulumi.Input['ClusterGcsSourceArgs'] gcs_source: Backups stored in Cloud Storage buckets. The Cloud Storage buckets need to be the same region as the clusters.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster.
        :param pulumi.Input['ClusterMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input['ClusterManagedBackupSourceArgs'] managed_backup_source: Backups that generated and managed by memorystore.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterManagedServerCaArgs']]] managed_server_cas: Cluster's Certificate Authority. This field will only be populated if Redis Cluster's transit_encryption_mode is TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[_builtins.str] node_type: The nodeType for the Redis cluster.
               If not provided, REDIS_HIGHMEM_MEDIUM will be used as default
               Possible values are: `REDIS_SHARED_CORE_NANO`, `REDIS_HIGHMEM_MEDIUM`, `REDIS_HIGHMEM_XLARGE`, `REDIS_STANDARD_SMALL`.
        :param pulumi.Input['ClusterPersistenceConfigArgs'] persistence_config: Persistence config (RDB, AOF) for the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.float] precise_size_gb: Output only. Redis memory precise size in GB for the entire cluster.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]] psc_connections: Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPscServiceAttachmentArgs']]] psc_service_attachments: Service attachment details to configure Psc connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[_builtins.int] size_gb: Output only. Redis memory size in GB for the entire cluster.
        :param pulumi.Input[_builtins.str] state: The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        :param pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]] state_infos: Output only. Additional information about the current state of the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster.
               If not provided, encryption is disabled for the cluster.
               Default value is `TRANSIT_ENCRYPTION_MODE_DISABLED`.
               Possible values are: `TRANSIT_ENCRYPTION_MODE_UNSPECIFIED`, `TRANSIT_ENCRYPTION_MODE_DISABLED`, `TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION`.
        :param pulumi.Input[_builtins.str] uid: System assigned, unique identifier for the cluster.
        :param pulumi.Input['ClusterZoneDistributionConfigArgs'] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
               Structure is documented below.
        """
        if authorization_mode is not None:
            pulumi.set(__self__, "authorization_mode", authorization_mode)
        if automated_backup_config is not None:
            pulumi.set(__self__, "automated_backup_config", automated_backup_config)
        if available_maintenance_versions is not None:
            pulumi.set(__self__, "available_maintenance_versions", available_maintenance_versions)
        if backup_collection is not None:
            pulumi.set(__self__, "backup_collection", backup_collection)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_cluster_replication_config is not None:
            pulumi.set(__self__, "cross_cluster_replication_config", cross_cluster_replication_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if discovery_endpoints is not None:
            pulumi.set(__self__, "discovery_endpoints", discovery_endpoints)
        if effective_maintenance_version is not None:
            pulumi.set(__self__, "effective_maintenance_version", effective_maintenance_version)
        if gcs_source is not None:
            pulumi.set(__self__, "gcs_source", gcs_source)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if managed_backup_source is not None:
            pulumi.set(__self__, "managed_backup_source", managed_backup_source)
        if managed_server_cas is not None:
            pulumi.set(__self__, "managed_server_cas", managed_server_cas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if precise_size_gb is not None:
            pulumi.set(__self__, "precise_size_gb", precise_size_gb)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_configs is not None:
            pulumi.set(__self__, "psc_configs", psc_configs)
        if psc_connections is not None:
            pulumi.set(__self__, "psc_connections", psc_connections)
        if psc_service_attachments is not None:
            pulumi.set(__self__, "psc_service_attachments", psc_service_attachments)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_infos is not None:
            pulumi.set(__self__, "state_infos", state_infos)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if zone_distribution_config is not None:
            pulumi.set(__self__, "zone_distribution_config", zone_distribution_config)

    @_builtins.property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
        Default value is `AUTH_MODE_DISABLED`.
        Possible values are: `AUTH_MODE_UNSPECIFIED`, `AUTH_MODE_IAM_AUTH`, `AUTH_MODE_DISABLED`.
        """
        return pulumi.get(self, "authorization_mode")

    @authorization_mode.setter
    def authorization_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_mode", value)

    @_builtins.property
    @pulumi.getter(name="automatedBackupConfig")
    def automated_backup_config(self) -> Optional[pulumi.Input['ClusterAutomatedBackupConfigArgs']]:
        """
        The automated backup config for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_config")

    @automated_backup_config.setter
    def automated_backup_config(self, value: Optional[pulumi.Input['ClusterAutomatedBackupConfigArgs']]):
        pulumi.set(self, "automated_backup_config", value)

    @_builtins.property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        This field is used to determine the available maintenance versions for the self service update.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @available_maintenance_versions.setter
    def available_maintenance_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_maintenance_versions", value)

    @_builtins.property
    @pulumi.getter(name="backupCollection")
    def backup_collection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup collection full resource name.
        Example: projects/{project}/locations/{location}/backupCollections/{collection}
        """
        return pulumi.get(self, "backup_collection")

    @backup_collection.setter
    def backup_collection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_collection", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp associated with the cluster creation request. A timestamp in
        RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
        digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossClusterReplicationConfig")
    def cross_cluster_replication_config(self) -> Optional[pulumi.Input['ClusterCrossClusterReplicationConfigArgs']]:
        """
        Cross cluster replication config
        Structure is documented below.
        """
        return pulumi.get(self, "cross_cluster_replication_config")

    @cross_cluster_replication_config.setter
    def cross_cluster_replication_config(self, value: Optional[pulumi.Input['ClusterCrossClusterReplicationConfigArgs']]):
        pulumi.set(self, "cross_cluster_replication_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Indicates if the cluster is deletion protected or not.
        If the value if set to true, any delete cluster operation will fail.
        Default value is true.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="discoveryEndpoints")
    def discovery_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]]]:
        """
        Output only. Endpoints created on each given network,
        for Redis clients to connect to the cluster.
        Currently only one endpoint is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @discovery_endpoints.setter
    def discovery_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDiscoveryEndpointArgs']]]]):
        pulumi.set(self, "discovery_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="effectiveMaintenanceVersion")
    def effective_maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field represents the actual maintenance version of the cluster.
        """
        return pulumi.get(self, "effective_maintenance_version")

    @effective_maintenance_version.setter
    def effective_maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> Optional[pulumi.Input['ClusterGcsSourceArgs']]:
        """
        Backups stored in Cloud Storage buckets. The Cloud Storage buckets need to be the same region as the clusters.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_source")

    @gcs_source.setter
    def gcs_source(self, value: Optional[pulumi.Input['ClusterGcsSourceArgs']]):
        pulumi.set(self, "gcs_source", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key used to encrypt the at-rest data of the cluster.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]:
        """
        Maintenance policy for a cluster
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]]]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @maintenance_schedules.setter
    def maintenance_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceScheduleArgs']]]]):
        pulumi.set(self, "maintenance_schedules", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
        *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="managedBackupSource")
    def managed_backup_source(self) -> Optional[pulumi.Input['ClusterManagedBackupSourceArgs']]:
        """
        Backups that generated and managed by memorystore.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_backup_source")

    @managed_backup_source.setter
    def managed_backup_source(self, value: Optional[pulumi.Input['ClusterManagedBackupSourceArgs']]):
        pulumi.set(self, "managed_backup_source", value)

    @_builtins.property
    @pulumi.getter(name="managedServerCas")
    def managed_server_cas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterManagedServerCaArgs']]]]:
        """
        Cluster's Certificate Authority. This field will only be populated if Redis Cluster's transit_encryption_mode is TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION
        Structure is documented below.
        """
        return pulumi.get(self, "managed_server_cas")

    @managed_server_cas.setter
    def managed_server_cas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterManagedServerCaArgs']]]]):
        pulumi.set(self, "managed_server_cas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the resource in this scope including project and location using the form:
        projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The nodeType for the Redis cluster.
        If not provided, REDIS_HIGHMEM_MEDIUM will be used as default
        Possible values are: `REDIS_SHARED_CORE_NANO`, `REDIS_HIGHMEM_MEDIUM`, `REDIS_HIGHMEM_XLARGE`, `REDIS_STANDARD_SMALL`.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['ClusterPersistenceConfigArgs']]:
        """
        Persistence config (RDB, AOF) for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['ClusterPersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @_builtins.property
    @pulumi.getter(name="preciseSizeGb")
    def precise_size_gb(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Output only. Redis memory precise size in GB for the entire cluster.
        """
        return pulumi.get(self, "precise_size_gb")

    @precise_size_gb.setter
    def precise_size_gb(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "precise_size_gb", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]]:
        """
        Required. Each PscConfig configures the consumer network where two
        network addresses will be designated to the cluster for client access.
        Currently, only one PscConfig is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_configs")

    @psc_configs.setter
    def psc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConfigArgs']]]]):
        pulumi.set(self, "psc_configs", value)

    @_builtins.property
    @pulumi.getter(name="pscConnections")
    def psc_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]]]:
        """
        Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connections")

    @psc_connections.setter
    def psc_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscConnectionArgs']]]]):
        pulumi.set(self, "psc_connections", value)

    @_builtins.property
    @pulumi.getter(name="pscServiceAttachments")
    def psc_service_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscServiceAttachmentArgs']]]]:
        """
        Service attachment details to configure Psc connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_service_attachments")

    @psc_service_attachments.setter
    def psc_service_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPscServiceAttachmentArgs']]]]):
        pulumi.set(self, "psc_service_attachments", value)

    @_builtins.property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configure Redis Cluster behavior using a subset of native Redis configuration parameters.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_configs", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the region of the Redis cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. The number of replica nodes per shard.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Required. Number of shards for the Redis cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Output only. Redis memory size in GB for the entire cluster.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_gb", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]]]:
        """
        Output only. Additional information about the current state of the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @state_infos.setter
    def state_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterStateInfoArgs']]]]):
        pulumi.set(self, "state_infos", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The in-transit encryption for the Redis cluster.
        If not provided, encryption is disabled for the cluster.
        Default value is `TRANSIT_ENCRYPTION_MODE_DISABLED`.
        Possible values are: `TRANSIT_ENCRYPTION_MODE_UNSPECIFIED`, `TRANSIT_ENCRYPTION_MODE_DISABLED`, `TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION`.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System assigned, unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]:
        """
        Immutable. Zone distribution config for Memorystore Redis cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

    @zone_distribution_config.setter
    def zone_distribution_config(self, value: Optional[pulumi.Input['ClusterZoneDistributionConfigArgs']]):
        pulumi.set(self, "zone_distribution_config", value)


@pulumi.type_token("gcp:redis/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input[Union['ClusterAutomatedBackupConfigArgs', 'ClusterAutomatedBackupConfigArgsDict']]] = None,
                 cross_cluster_replication_config: Optional[pulumi.Input[Union['ClusterCrossClusterReplicationConfigArgs', 'ClusterCrossClusterReplicationConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcs_source: Optional[pulumi.Input[Union['ClusterGcsSourceArgs', 'ClusterGcsSourceArgsDict']]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input[Union['ClusterManagedBackupSourceArgs', 'ClusterManagedBackupSourceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['ClusterPersistenceConfigArgs', 'ClusterPersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Redis Cluster Ha

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_ha = gcp.redis.Cluster("cluster-ha",
            name="ha-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            replica_count=1,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Ha Single Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_ha_single_zone = gcp.redis.Cluster("cluster-ha-single-zone",
            name="ha-cluster-single-zone",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-f",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Secondary

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="mynetwork",
            auto_create_subnetworks=False)
        primary_cluster_consumer_subnet = gcp.compute.Subnetwork("primary_cluster_consumer_subnet",
            name="mysubnet-primary-cluster",
            ip_cidr_range="10.0.1.0/29",
            region="us-east1",
            network=consumer_net.id)
        primary_cluster_region_scp = gcp.networkconnectivity.ServiceConnectionPolicy("primary_cluster_region_scp",
            name="mypolicy-primary-cluster",
            location="us-east1",
            service_class="gcp-memorystore-redis",
            description="Primary cluster service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [primary_cluster_consumer_subnet.id],
            })
        # Primary cluster
        primary_cluster = gcp.redis.Cluster("primary_cluster",
            name="my-primary-cluster",
            region="us-east1",
            psc_configs=[{
                "network": consumer_net.id,
            }],
            authorization_mode="AUTH_MODE_DISABLED",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            shard_count=3,
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            node_type="REDIS_HIGHMEM_MEDIUM",
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            replica_count=1,
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[primary_cluster_region_scp]))
        secondary_cluster_consumer_subnet = gcp.compute.Subnetwork("secondary_cluster_consumer_subnet",
            name="mysubnet-secondary-cluster",
            ip_cidr_range="10.0.2.0/29",
            region="europe-west1",
            network=consumer_net.id)
        secondary_cluster_region_scp = gcp.networkconnectivity.ServiceConnectionPolicy("secondary_cluster_region_scp",
            name="mypolicy-secondary-cluster",
            location="europe-west1",
            service_class="gcp-memorystore-redis",
            description="Secondary cluster service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [secondary_cluster_consumer_subnet.id],
            })
        # Secondary cluster
        secondary_cluster = gcp.redis.Cluster("secondary_cluster",
            name="my-secondary-cluster",
            region="europe-west1",
            psc_configs=[{
                "network": consumer_net.id,
            }],
            authorization_mode="AUTH_MODE_DISABLED",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            shard_count=3,
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            node_type="REDIS_HIGHMEM_MEDIUM",
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            replica_count=2,
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "WEDNESDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            cross_cluster_replication_config={
                "cluster_role": "SECONDARY",
                "primary_cluster": {
                    "cluster": primary_cluster.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[secondary_cluster_region_scp]))
        ```
        ### Redis Cluster Rdb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_rdb = gcp.redis.Cluster("cluster-rdb",
            name="rdb-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            replica_count=0,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Aof

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_aof = gcp.redis.Cluster("cluster-aof",
            name="aof-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            replica_count=0,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            persistence_config={
                "mode": "AOF",
                "aof_config": {
                    "append_fsync": "EVERYSEC",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_cmek = gcp.redis.Cluster("cluster-cmek",
            name="cmek-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            kms_key="my-key",
            region="us-central1",
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        project = gcp.organizations.get_project()
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/clusters/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default projects/{{project}}/locations/{{region}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value is `AUTH_MODE_DISABLED`.
               Possible values are: `AUTH_MODE_UNSPECIFIED`, `AUTH_MODE_IAM_AUTH`, `AUTH_MODE_DISABLED`.
        :param pulumi.Input[Union['ClusterAutomatedBackupConfigArgs', 'ClusterAutomatedBackupConfigArgsDict']] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterCrossClusterReplicationConfigArgs', 'ClusterCrossClusterReplicationConfigArgsDict']] cross_cluster_replication_config: Cross cluster replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not.
               If the value if set to true, any delete cluster operation will fail.
               Default value is true.
        :param pulumi.Input[Union['ClusterGcsSourceArgs', 'ClusterGcsSourceArgsDict']] gcs_source: Backups stored in Cloud Storage buckets. The Cloud Storage buckets need to be the same region as the clusters.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster.
        :param pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input[Union['ClusterManagedBackupSourceArgs', 'ClusterManagedBackupSourceArgsDict']] managed_backup_source: Backups that generated and managed by memorystore.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[_builtins.str] node_type: The nodeType for the Redis cluster.
               If not provided, REDIS_HIGHMEM_MEDIUM will be used as default
               Possible values are: `REDIS_SHARED_CORE_NANO`, `REDIS_HIGHMEM_MEDIUM`, `REDIS_HIGHMEM_XLARGE`, `REDIS_STANDARD_SMALL`.
        :param pulumi.Input[Union['ClusterPersistenceConfigArgs', 'ClusterPersistenceConfigArgsDict']] persistence_config: Persistence config (RDB, AOF) for the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster.
               If not provided, encryption is disabled for the cluster.
               Default value is `TRANSIT_ENCRYPTION_MODE_DISABLED`.
               Possible values are: `TRANSIT_ENCRYPTION_MODE_UNSPECIFIED`, `TRANSIT_ENCRYPTION_MODE_DISABLED`, `TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION`.
        :param pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Redis Cluster Ha

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_ha = gcp.redis.Cluster("cluster-ha",
            name="ha-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            replica_count=1,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Ha Single Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_ha_single_zone = gcp.redis.Cluster("cluster-ha-single-zone",
            name="ha-cluster-single-zone",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            zone_distribution_config={
                "mode": "SINGLE_ZONE",
                "zone": "us-central1-f",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Secondary

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="mynetwork",
            auto_create_subnetworks=False)
        primary_cluster_consumer_subnet = gcp.compute.Subnetwork("primary_cluster_consumer_subnet",
            name="mysubnet-primary-cluster",
            ip_cidr_range="10.0.1.0/29",
            region="us-east1",
            network=consumer_net.id)
        primary_cluster_region_scp = gcp.networkconnectivity.ServiceConnectionPolicy("primary_cluster_region_scp",
            name="mypolicy-primary-cluster",
            location="us-east1",
            service_class="gcp-memorystore-redis",
            description="Primary cluster service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [primary_cluster_consumer_subnet.id],
            })
        # Primary cluster
        primary_cluster = gcp.redis.Cluster("primary_cluster",
            name="my-primary-cluster",
            region="us-east1",
            psc_configs=[{
                "network": consumer_net.id,
            }],
            authorization_mode="AUTH_MODE_DISABLED",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            shard_count=3,
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            node_type="REDIS_HIGHMEM_MEDIUM",
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            replica_count=1,
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[primary_cluster_region_scp]))
        secondary_cluster_consumer_subnet = gcp.compute.Subnetwork("secondary_cluster_consumer_subnet",
            name="mysubnet-secondary-cluster",
            ip_cidr_range="10.0.2.0/29",
            region="europe-west1",
            network=consumer_net.id)
        secondary_cluster_region_scp = gcp.networkconnectivity.ServiceConnectionPolicy("secondary_cluster_region_scp",
            name="mypolicy-secondary-cluster",
            location="europe-west1",
            service_class="gcp-memorystore-redis",
            description="Secondary cluster service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [secondary_cluster_consumer_subnet.id],
            })
        # Secondary cluster
        secondary_cluster = gcp.redis.Cluster("secondary_cluster",
            name="my-secondary-cluster",
            region="europe-west1",
            psc_configs=[{
                "network": consumer_net.id,
            }],
            authorization_mode="AUTH_MODE_DISABLED",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            shard_count=3,
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            node_type="REDIS_HIGHMEM_MEDIUM",
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            replica_count=2,
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "WEDNESDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            deletion_protection_enabled=True,
            cross_cluster_replication_config={
                "cluster_role": "SECONDARY",
                "primary_cluster": {
                    "cluster": primary_cluster.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[secondary_cluster_region_scp]))
        ```
        ### Redis Cluster Rdb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_rdb = gcp.redis.Cluster("cluster-rdb",
            name="rdb-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            replica_count=0,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            persistence_config={
                "mode": "RDB",
                "rdb_config": {
                    "rdb_snapshot_period": "ONE_HOUR",
                    "rdb_snapshot_start_time": "2024-10-02T15:01:23Z",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Aof

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_aof = gcp.redis.Cluster("cluster-aof",
            name="aof-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            region="us-central1",
            replica_count=0,
            node_type="REDIS_SHARED_CORE_NANO",
            transit_encryption_mode="TRANSIT_ENCRYPTION_MODE_DISABLED",
            authorization_mode="AUTH_MODE_DISABLED",
            redis_configs={
                "maxmemory-policy": "volatile-ttl",
            },
            deletion_protection_enabled=True,
            zone_distribution_config={
                "mode": "MULTI_ZONE",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "MONDAY",
                    "start_time": {
                        "hours": 1,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            },
            persistence_config={
                "mode": "AOF",
                "aof_config": {
                    "append_fsync": "EVERYSEC",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```
        ### Redis Cluster Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        consumer_net = gcp.compute.Network("consumer_net",
            name="my-network",
            auto_create_subnetworks=False)
        consumer_subnet = gcp.compute.Subnetwork("consumer_subnet",
            name="my-subnet",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=consumer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-policy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=consumer_net.id,
            psc_config={
                "subnetworks": [consumer_subnet.id],
            })
        cluster_cmek = gcp.redis.Cluster("cluster-cmek",
            name="cmek-cluster",
            shard_count=3,
            psc_configs=[{
                "network": consumer_net.id,
            }],
            kms_key="my-key",
            region="us-central1",
            deletion_protection_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[default]))
        project = gcp.organizations.get_project()
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/clusters/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default projects/{{project}}/locations/{{region}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/cluster:Cluster default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 automated_backup_config: Optional[pulumi.Input[Union['ClusterAutomatedBackupConfigArgs', 'ClusterAutomatedBackupConfigArgsDict']]] = None,
                 cross_cluster_replication_config: Optional[pulumi.Input[Union['ClusterCrossClusterReplicationConfigArgs', 'ClusterCrossClusterReplicationConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcs_source: Optional[pulumi.Input[Union['ClusterGcsSourceArgs', 'ClusterGcsSourceArgsDict']]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_backup_source: Optional[pulumi.Input[Union['ClusterManagedBackupSourceArgs', 'ClusterManagedBackupSourceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['ClusterPersistenceConfigArgs', 'ClusterPersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_distribution_config: Optional[pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["authorization_mode"] = authorization_mode
            __props__.__dict__["automated_backup_config"] = automated_backup_config
            __props__.__dict__["cross_cluster_replication_config"] = cross_cluster_replication_config
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["gcs_source"] = gcs_source
            __props__.__dict__["kms_key"] = kms_key
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["maintenance_version"] = maintenance_version
            __props__.__dict__["managed_backup_source"] = managed_backup_source
            __props__.__dict__["name"] = name
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["persistence_config"] = persistence_config
            __props__.__dict__["project"] = project
            __props__.__dict__["psc_configs"] = psc_configs
            __props__.__dict__["redis_configs"] = redis_configs
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_count"] = replica_count
            if shard_count is None and not opts.urn:
                raise TypeError("Missing required property 'shard_count'")
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["zone_distribution_config"] = zone_distribution_config
            __props__.__dict__["available_maintenance_versions"] = None
            __props__.__dict__["backup_collection"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["discovery_endpoints"] = None
            __props__.__dict__["effective_maintenance_version"] = None
            __props__.__dict__["maintenance_schedules"] = None
            __props__.__dict__["managed_server_cas"] = None
            __props__.__dict__["precise_size_gb"] = None
            __props__.__dict__["psc_connections"] = None
            __props__.__dict__["psc_service_attachments"] = None
            __props__.__dict__["size_gb"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_infos"] = None
            __props__.__dict__["uid"] = None
        super(Cluster, __self__).__init__(
            'gcp:redis/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_mode: Optional[pulumi.Input[_builtins.str]] = None,
            automated_backup_config: Optional[pulumi.Input[Union['ClusterAutomatedBackupConfigArgs', 'ClusterAutomatedBackupConfigArgsDict']]] = None,
            available_maintenance_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_collection: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_cluster_replication_config: Optional[pulumi.Input[Union['ClusterCrossClusterReplicationConfigArgs', 'ClusterCrossClusterReplicationConfigArgsDict']]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            discovery_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterDiscoveryEndpointArgs', 'ClusterDiscoveryEndpointArgsDict']]]]] = None,
            effective_maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
            gcs_source: Optional[pulumi.Input[Union['ClusterGcsSourceArgs', 'ClusterGcsSourceArgsDict']]] = None,
            kms_key: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']]] = None,
            maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintenanceScheduleArgs', 'ClusterMaintenanceScheduleArgsDict']]]]] = None,
            maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
            managed_backup_source: Optional[pulumi.Input[Union['ClusterManagedBackupSourceArgs', 'ClusterManagedBackupSourceArgsDict']]] = None,
            managed_server_cas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterManagedServerCaArgs', 'ClusterManagedServerCaArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            persistence_config: Optional[pulumi.Input[Union['ClusterPersistenceConfigArgs', 'ClusterPersistenceConfigArgsDict']]] = None,
            precise_size_gb: Optional[pulumi.Input[_builtins.float]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]]] = None,
            psc_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConnectionArgs', 'ClusterPscConnectionArgsDict']]]]] = None,
            psc_service_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscServiceAttachmentArgs', 'ClusterPscServiceAttachmentArgsDict']]]]] = None,
            redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterStateInfoArgs', 'ClusterStateInfoArgsDict']]]]] = None,
            transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            zone_distribution_config: Optional[pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_mode: Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
               Default value is `AUTH_MODE_DISABLED`.
               Possible values are: `AUTH_MODE_UNSPECIFIED`, `AUTH_MODE_IAM_AUTH`, `AUTH_MODE_DISABLED`.
        :param pulumi.Input[Union['ClusterAutomatedBackupConfigArgs', 'ClusterAutomatedBackupConfigArgsDict']] automated_backup_config: The automated backup config for a instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_maintenance_versions: This field is used to determine the available maintenance versions for the self service update.
        :param pulumi.Input[_builtins.str] backup_collection: The backup collection full resource name.
               Example: projects/{project}/locations/{location}/backupCollections/{collection}
        :param pulumi.Input[_builtins.str] create_time: The timestamp associated with the cluster creation request. A timestamp in
               RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
               digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[Union['ClusterCrossClusterReplicationConfigArgs', 'ClusterCrossClusterReplicationConfigArgsDict']] cross_cluster_replication_config: Cross cluster replication config
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Optional. Indicates if the cluster is deletion protected or not.
               If the value if set to true, any delete cluster operation will fail.
               Default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterDiscoveryEndpointArgs', 'ClusterDiscoveryEndpointArgsDict']]]] discovery_endpoints: Output only. Endpoints created on each given network,
               for Redis clients to connect to the cluster.
               Currently only one endpoint is supported.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] effective_maintenance_version: This field represents the actual maintenance version of the cluster.
        :param pulumi.Input[Union['ClusterGcsSourceArgs', 'ClusterGcsSourceArgsDict']] gcs_source: Backups stored in Cloud Storage buckets. The Cloud Storage buckets need to be the same region as the clusters.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] kms_key: The KMS key used to encrypt the at-rest data of the cluster.
        :param pulumi.Input[Union['ClusterMaintenancePolicyArgs', 'ClusterMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for a cluster
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintenanceScheduleArgs', 'ClusterMaintenanceScheduleArgsDict']]]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
               *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        :param pulumi.Input[Union['ClusterManagedBackupSourceArgs', 'ClusterManagedBackupSourceArgsDict']] managed_backup_source: Backups that generated and managed by memorystore.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterManagedServerCaArgs', 'ClusterManagedServerCaArgsDict']]]] managed_server_cas: Cluster's Certificate Authority. This field will only be populated if Redis Cluster's transit_encryption_mode is TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Unique name of the resource in this scope including project and location using the form:
               projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        :param pulumi.Input[_builtins.str] node_type: The nodeType for the Redis cluster.
               If not provided, REDIS_HIGHMEM_MEDIUM will be used as default
               Possible values are: `REDIS_SHARED_CORE_NANO`, `REDIS_HIGHMEM_MEDIUM`, `REDIS_HIGHMEM_XLARGE`, `REDIS_STANDARD_SMALL`.
        :param pulumi.Input[Union['ClusterPersistenceConfigArgs', 'ClusterPersistenceConfigArgsDict']] persistence_config: Persistence config (RDB, AOF) for the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.float] precise_size_gb: Output only. Redis memory precise size in GB for the entire cluster.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]]] psc_configs: Required. Each PscConfig configures the consumer network where two
               network addresses will be designated to the cluster for client access.
               Currently, only one PscConfig is supported.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscConnectionArgs', 'ClusterPscConnectionArgsDict']]]] psc_connections: Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPscServiceAttachmentArgs', 'ClusterPscServiceAttachmentArgsDict']]]] psc_service_attachments: Service attachment details to configure Psc connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Configure Redis Cluster behavior using a subset of native Redis configuration parameters.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes per shard.
        :param pulumi.Input[_builtins.int] shard_count: Required. Number of shards for the Redis cluster.
        :param pulumi.Input[_builtins.int] size_gb: Output only. Redis memory size in GB for the entire cluster.
        :param pulumi.Input[_builtins.str] state: The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterStateInfoArgs', 'ClusterStateInfoArgsDict']]]] state_infos: Output only. Additional information about the current state of the cluster.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: Optional. The in-transit encryption for the Redis cluster.
               If not provided, encryption is disabled for the cluster.
               Default value is `TRANSIT_ENCRYPTION_MODE_DISABLED`.
               Possible values are: `TRANSIT_ENCRYPTION_MODE_UNSPECIFIED`, `TRANSIT_ENCRYPTION_MODE_DISABLED`, `TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION`.
        :param pulumi.Input[_builtins.str] uid: System assigned, unique identifier for the cluster.
        :param pulumi.Input[Union['ClusterZoneDistributionConfigArgs', 'ClusterZoneDistributionConfigArgsDict']] zone_distribution_config: Immutable. Zone distribution config for Memorystore Redis cluster.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["authorization_mode"] = authorization_mode
        __props__.__dict__["automated_backup_config"] = automated_backup_config
        __props__.__dict__["available_maintenance_versions"] = available_maintenance_versions
        __props__.__dict__["backup_collection"] = backup_collection
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_cluster_replication_config"] = cross_cluster_replication_config
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["discovery_endpoints"] = discovery_endpoints
        __props__.__dict__["effective_maintenance_version"] = effective_maintenance_version
        __props__.__dict__["gcs_source"] = gcs_source
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["maintenance_schedules"] = maintenance_schedules
        __props__.__dict__["maintenance_version"] = maintenance_version
        __props__.__dict__["managed_backup_source"] = managed_backup_source
        __props__.__dict__["managed_server_cas"] = managed_server_cas
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["persistence_config"] = persistence_config
        __props__.__dict__["precise_size_gb"] = precise_size_gb
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_configs"] = psc_configs
        __props__.__dict__["psc_connections"] = psc_connections
        __props__.__dict__["psc_service_attachments"] = psc_service_attachments
        __props__.__dict__["redis_configs"] = redis_configs
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["size_gb"] = size_gb
        __props__.__dict__["state"] = state
        __props__.__dict__["state_infos"] = state_infos
        __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
        __props__.__dict__["uid"] = uid
        __props__.__dict__["zone_distribution_config"] = zone_distribution_config
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizationMode")
    def authorization_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster.
        Default value is `AUTH_MODE_DISABLED`.
        Possible values are: `AUTH_MODE_UNSPECIFIED`, `AUTH_MODE_IAM_AUTH`, `AUTH_MODE_DISABLED`.
        """
        return pulumi.get(self, "authorization_mode")

    @_builtins.property
    @pulumi.getter(name="automatedBackupConfig")
    def automated_backup_config(self) -> pulumi.Output[Optional['outputs.ClusterAutomatedBackupConfig']]:
        """
        The automated backup config for a instance.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_config")

    @_builtins.property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        This field is used to determine the available maintenance versions for the self service update.
        """
        return pulumi.get(self, "available_maintenance_versions")

    @_builtins.property
    @pulumi.getter(name="backupCollection")
    def backup_collection(self) -> pulumi.Output[_builtins.str]:
        """
        The backup collection full resource name.
        Example: projects/{project}/locations/{location}/backupCollections/{collection}
        """
        return pulumi.get(self, "backup_collection")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp associated with the cluster creation request. A timestamp in
        RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional
        digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossClusterReplicationConfig")
    def cross_cluster_replication_config(self) -> pulumi.Output['outputs.ClusterCrossClusterReplicationConfig']:
        """
        Cross cluster replication config
        Structure is documented below.
        """
        return pulumi.get(self, "cross_cluster_replication_config")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Optional. Indicates if the cluster is deletion protected or not.
        If the value if set to true, any delete cluster operation will fail.
        Default value is true.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="discoveryEndpoints")
    def discovery_endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterDiscoveryEndpoint']]:
        """
        Output only. Endpoints created on each given network,
        for Redis clients to connect to the cluster.
        Currently only one endpoint is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "discovery_endpoints")

    @_builtins.property
    @pulumi.getter(name="effectiveMaintenanceVersion")
    def effective_maintenance_version(self) -> pulumi.Output[_builtins.str]:
        """
        This field represents the actual maintenance version of the cluster.
        """
        return pulumi.get(self, "effective_maintenance_version")

    @_builtins.property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> pulumi.Output[Optional['outputs.ClusterGcsSource']]:
        """
        Backups stored in Cloud Storage buckets. The Cloud Storage buckets need to be the same region as the clusters.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_source")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The KMS key used to encrypt the at-rest data of the cluster.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[Optional['outputs.ClusterMaintenancePolicy']]:
        """
        Maintenance policy for a cluster
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> pulumi.Output[Sequence['outputs.ClusterMaintenanceSchedule']]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This field can be used to trigger self service update to indicate the desired maintenance version. The input to this field can be determined by the available_maintenance_versions field.
        *Note*: This field can only be specified when updating an existing cluster to a newer version. Downgrades are currently not supported!
        """
        return pulumi.get(self, "maintenance_version")

    @_builtins.property
    @pulumi.getter(name="managedBackupSource")
    def managed_backup_source(self) -> pulumi.Output[Optional['outputs.ClusterManagedBackupSource']]:
        """
        Backups that generated and managed by memorystore.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_backup_source")

    @_builtins.property
    @pulumi.getter(name="managedServerCas")
    def managed_server_cas(self) -> pulumi.Output[Sequence['outputs.ClusterManagedServerCa']]:
        """
        Cluster's Certificate Authority. This field will only be populated if Redis Cluster's transit_encryption_mode is TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION
        Structure is documented below.
        """
        return pulumi.get(self, "managed_server_cas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name of the resource in this scope including project and location using the form:
        projects/{projectId}/locations/{locationId}/clusters/{clusterId}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        The nodeType for the Redis cluster.
        If not provided, REDIS_HIGHMEM_MEDIUM will be used as default
        Possible values are: `REDIS_SHARED_CORE_NANO`, `REDIS_HIGHMEM_MEDIUM`, `REDIS_HIGHMEM_XLARGE`, `REDIS_STANDARD_SMALL`.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> pulumi.Output['outputs.ClusterPersistenceConfig']:
        """
        Persistence config (RDB, AOF) for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @_builtins.property
    @pulumi.getter(name="preciseSizeGb")
    def precise_size_gb(self) -> pulumi.Output[_builtins.float]:
        """
        Output only. Redis memory precise size in GB for the entire cluster.
        """
        return pulumi.get(self, "precise_size_gb")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterPscConfig']]]:
        """
        Required. Each PscConfig configures the consumer network where two
        network addresses will be designated to the cluster for client access.
        Currently, only one PscConfig is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_configs")

    @_builtins.property
    @pulumi.getter(name="pscConnections")
    def psc_connections(self) -> pulumi.Output[Sequence['outputs.ClusterPscConnection']]:
        """
        Output only. PSC connections for discovery of the cluster topology and accessing the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connections")

    @_builtins.property
    @pulumi.getter(name="pscServiceAttachments")
    def psc_service_attachments(self) -> pulumi.Output[Sequence['outputs.ClusterPscServiceAttachment']]:
        """
        Service attachment details to configure Psc connections.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_service_attachments")

    @_builtins.property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Configure Redis Cluster behavior using a subset of native Redis configuration parameters.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/cluster/supported-instance-configurations
        """
        return pulumi.get(self, "redis_configs")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the region of the Redis cluster.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Optional. The number of replica nodes per shard.
        """
        return pulumi.get(self, "replica_count")

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[_builtins.int]:
        """
        Required. Number of shards for the Redis cluster.
        """
        return pulumi.get(self, "shard_count")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> pulumi.Output[_builtins.int]:
        """
        Output only. Redis memory size in GB for the entire cluster.
        """
        return pulumi.get(self, "size_gb")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of this cluster. Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateInfos")
    def state_infos(self) -> pulumi.Output[Sequence['outputs.ClusterStateInfo']]:
        """
        Output only. Additional information about the current state of the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "state_infos")

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The in-transit encryption for the Redis cluster.
        If not provided, encryption is disabled for the cluster.
        Default value is `TRANSIT_ENCRYPTION_MODE_DISABLED`.
        Possible values are: `TRANSIT_ENCRYPTION_MODE_UNSPECIFIED`, `TRANSIT_ENCRYPTION_MODE_DISABLED`, `TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION`.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        System assigned, unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="zoneDistributionConfig")
    def zone_distribution_config(self) -> pulumi.Output['outputs.ClusterZoneDistributionConfig']:
        """
        Immutable. Zone distribution config for Memorystore Redis cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "zone_distribution_config")

