# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReleaseArgs', 'Release']

@pulumi.input_type
class ReleaseArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 release_id: pulumi.Input[_builtins.str],
                 unit_kind: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 blueprint: Optional[pulumi.Input['ReleaseBlueprintArgs']] = None,
                 input_variable_defaults: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 release_requirements: Optional[pulumi.Input['ReleaseReleaseRequirementsArgs']] = None):
        """
        The set of arguments for constructing a Release resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] release_id: The ID value for the new release.
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Release corresponds to (required and
               immutable once created).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]] input_variable_defaults: Mapping of input variables to default values. Maximum 100
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ReleaseReleaseRequirementsArgs'] release_requirements: Set of requirements to be fulfilled on the Unit when using this Release.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "release_id", release_id)
        pulumi.set(__self__, "unit_kind", unit_kind)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if blueprint is not None:
            pulumi.set(__self__, "blueprint", blueprint)
        if input_variable_defaults is not None:
            pulumi.set(__self__, "input_variable_defaults", input_variable_defaults)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if release_requirements is not None:
            pulumi.set(__self__, "release_requirements", release_requirements)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="releaseId")
    def release_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID value for the new release.
        """
        return pulumi.get(self, "release_id")

    @release_id.setter
    def release_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "release_id", value)

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> pulumi.Input[_builtins.str]:
        """
        Reference to the UnitKind this Release corresponds to (required and
        immutable once created).
        """
        return pulumi.get(self, "unit_kind")

    @unit_kind.setter
    def unit_kind(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unit_kind", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def blueprint(self) -> Optional[pulumi.Input['ReleaseBlueprintArgs']]:
        return pulumi.get(self, "blueprint")

    @blueprint.setter
    def blueprint(self, value: Optional[pulumi.Input['ReleaseBlueprintArgs']]):
        pulumi.set(self, "blueprint", value)

    @_builtins.property
    @pulumi.getter(name="inputVariableDefaults")
    def input_variable_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]]]:
        """
        Mapping of input variables to default values. Maximum 100
        Structure is documented below.
        """
        return pulumi.get(self, "input_variable_defaults")

    @input_variable_defaults.setter
    def input_variable_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]]]):
        pulumi.set(self, "input_variable_defaults", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="releaseRequirements")
    def release_requirements(self) -> Optional[pulumi.Input['ReleaseReleaseRequirementsArgs']]:
        """
        Set of requirements to be fulfilled on the Unit when using this Release.
        Structure is documented below.
        """
        return pulumi.get(self, "release_requirements")

    @release_requirements.setter
    def release_requirements(self, value: Optional[pulumi.Input['ReleaseReleaseRequirementsArgs']]):
        pulumi.set(self, "release_requirements", value)


@pulumi.input_type
class _ReleaseState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 blueprint: Optional[pulumi.Input['ReleaseBlueprintArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 input_variable_defaults: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]]] = None,
                 input_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseOutputVariableArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 release_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_requirements: Optional[pulumi.Input['ReleaseReleaseRequirementsArgs']] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Release resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: An opaque value that uniquely identifies a version or
               generation of a resource. It can be used to confirm that the client
               and server agree on the ordering of a resource being written.
        :param pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]] input_variable_defaults: Mapping of input variables to default values. Maximum 100
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableArgs']]] input_variables: List of input variables declared on the blueprint and can be present with
               their values on the unit spec
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/releases/{release}"
        :param pulumi.Input[Sequence[pulumi.Input['ReleaseOutputVariableArgs']]] output_variables: List of output variables declared on the blueprint and can be present with
               their values on the unit status
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] release_id: The ID value for the new release.
        :param pulumi.Input['ReleaseReleaseRequirementsArgs'] release_requirements: Set of requirements to be fulfilled on the Unit when using this Release.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Release corresponds to (required and
               immutable once created).
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if blueprint is not None:
            pulumi.set(__self__, "blueprint", blueprint)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if input_variable_defaults is not None:
            pulumi.set(__self__, "input_variable_defaults", input_variable_defaults)
        if input_variables is not None:
            pulumi.set(__self__, "input_variables", input_variables)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_variables is not None:
            pulumi.set(__self__, "output_variables", output_variables)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if release_id is not None:
            pulumi.set(__self__, "release_id", release_id)
        if release_requirements is not None:
            pulumi.set(__self__, "release_requirements", release_requirements)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if unit_kind is not None:
            pulumi.set(__self__, "unit_kind", unit_kind)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def blueprint(self) -> Optional[pulumi.Input['ReleaseBlueprintArgs']]:
        return pulumi.get(self, "blueprint")

    @blueprint.setter
    def blueprint(self, value: Optional[pulumi.Input['ReleaseBlueprintArgs']]):
        pulumi.set(self, "blueprint", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An opaque value that uniquely identifies a version or
        generation of a resource. It can be used to confirm that the client
        and server agree on the ordering of a resource being written.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="inputVariableDefaults")
    def input_variable_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]]]:
        """
        Mapping of input variables to default values. Maximum 100
        Structure is documented below.
        """
        return pulumi.get(self, "input_variable_defaults")

    @input_variable_defaults.setter
    def input_variable_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableDefaultArgs']]]]):
        pulumi.set(self, "input_variable_defaults", value)

    @_builtins.property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableArgs']]]]:
        """
        List of input variables declared on the blueprint and can be present with
        their values on the unit spec
        Structure is documented below.
        """
        return pulumi.get(self, "input_variables")

    @input_variables.setter
    def input_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseInputVariableArgs']]]]):
        pulumi.set(self, "input_variables", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/releases/{release}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseOutputVariableArgs']]]]:
        """
        List of output variables declared on the blueprint and can be present with
        their values on the unit status
        Structure is documented below.
        """
        return pulumi.get(self, "output_variables")

    @output_variables.setter
    def output_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReleaseOutputVariableArgs']]]]):
        pulumi.set(self, "output_variables", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="releaseId")
    def release_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID value for the new release.
        """
        return pulumi.get(self, "release_id")

    @release_id.setter
    def release_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_id", value)

    @_builtins.property
    @pulumi.getter(name="releaseRequirements")
    def release_requirements(self) -> Optional[pulumi.Input['ReleaseReleaseRequirementsArgs']]:
        """
        Set of requirements to be fulfilled on the Unit when using this Release.
        Structure is documented below.
        """
        return pulumi.get(self, "release_requirements")

    @release_requirements.setter
    def release_requirements(self, value: Optional[pulumi.Input['ReleaseReleaseRequirementsArgs']]):
        pulumi.set(self, "release_requirements", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the UnitKind this Release corresponds to (required and
        immutable once created).
        """
        return pulumi.get(self, "unit_kind")

    @unit_kind.setter
    def unit_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_kind", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:saasruntime/release:Release")
class Release(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 blueprint: Optional[pulumi.Input[Union['ReleaseBlueprintArgs', 'ReleaseBlueprintArgsDict']]] = None,
                 input_variable_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReleaseInputVariableDefaultArgs', 'ReleaseInputVariableDefaultArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 release_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_requirements: Optional[pulumi.Input[Union['ReleaseReleaseRequirementsArgs', 'ReleaseReleaseRequirementsArgsDict']]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A version to be propagated and deployed to Units. It points to a specific version of a Blueprint that can be applied to Units, for example, via a Rollout.

        ## Example Usage

        ### Saas Runtime Release Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas = gcp.saasruntime.SaaS("example_saas",
            saas_id="example-saas",
            location="global",
            locations=[{
                "name": "us-central1",
            }])
        example_unitkind = gcp.saasruntime.UnitKind("example_unitkind",
            location="global",
            unit_kind_id="example-unitkind",
            saas=example_saas.id)
        example_previous = gcp.saasruntime.Release("example_previous",
            location="global",
            release_id="previous-release",
            unit_kind=example_unitkind.id,
            blueprint={
                "package": "us-central1-docker.pkg.dev/ci-test-project-188019/test-repo/tf-test-easysaas-alpha-image@sha256:7992fdbaeaf998ecd31a7f937bb26e38a781ecf49b24857a6176c1e9bfc299ee",
            })
        example = gcp.saasruntime.Release("example",
            location="global",
            release_id="example-release",
            unit_kind=example_unitkind.id,
            blueprint={
                "package": "us-central1-docker.pkg.dev/ci-test-project-188019/test-repo/tf-test-easysaas-beta-image@sha256:7bba0fa85b2956df7768f7b32e715b6fe11f4f4193e2a70a35bf3f286a6cdf9e",
            },
            input_variable_defaults=[{
                "variable": "name",
                "value": "test",
                "type": "STRING",
            }])
        ```

        ## Import

        Release can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/releases/{{release_id}}`

        * `{{project}}/{{location}}/{{release_id}}`

        * `{{location}}/{{release_id}}`

        When using the `pulumi import` command, Release can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/release:Release default projects/{{project}}/locations/{{location}}/releases/{{release_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/release:Release default {{project}}/{{location}}/{{release_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/release:Release default {{location}}/{{release_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReleaseInputVariableDefaultArgs', 'ReleaseInputVariableDefaultArgsDict']]]] input_variable_defaults: Mapping of input variables to default values. Maximum 100
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] release_id: The ID value for the new release.
        :param pulumi.Input[Union['ReleaseReleaseRequirementsArgs', 'ReleaseReleaseRequirementsArgsDict']] release_requirements: Set of requirements to be fulfilled on the Unit when using this Release.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Release corresponds to (required and
               immutable once created).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A version to be propagated and deployed to Units. It points to a specific version of a Blueprint that can be applied to Units, for example, via a Rollout.

        ## Example Usage

        ### Saas Runtime Release Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas = gcp.saasruntime.SaaS("example_saas",
            saas_id="example-saas",
            location="global",
            locations=[{
                "name": "us-central1",
            }])
        example_unitkind = gcp.saasruntime.UnitKind("example_unitkind",
            location="global",
            unit_kind_id="example-unitkind",
            saas=example_saas.id)
        example_previous = gcp.saasruntime.Release("example_previous",
            location="global",
            release_id="previous-release",
            unit_kind=example_unitkind.id,
            blueprint={
                "package": "us-central1-docker.pkg.dev/ci-test-project-188019/test-repo/tf-test-easysaas-alpha-image@sha256:7992fdbaeaf998ecd31a7f937bb26e38a781ecf49b24857a6176c1e9bfc299ee",
            })
        example = gcp.saasruntime.Release("example",
            location="global",
            release_id="example-release",
            unit_kind=example_unitkind.id,
            blueprint={
                "package": "us-central1-docker.pkg.dev/ci-test-project-188019/test-repo/tf-test-easysaas-beta-image@sha256:7bba0fa85b2956df7768f7b32e715b6fe11f4f4193e2a70a35bf3f286a6cdf9e",
            },
            input_variable_defaults=[{
                "variable": "name",
                "value": "test",
                "type": "STRING",
            }])
        ```

        ## Import

        Release can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/releases/{{release_id}}`

        * `{{project}}/{{location}}/{{release_id}}`

        * `{{location}}/{{release_id}}`

        When using the `pulumi import` command, Release can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/release:Release default projects/{{project}}/locations/{{location}}/releases/{{release_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/release:Release default {{project}}/{{location}}/{{release_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/release:Release default {{location}}/{{release_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 blueprint: Optional[pulumi.Input[Union['ReleaseBlueprintArgs', 'ReleaseBlueprintArgsDict']]] = None,
                 input_variable_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReleaseInputVariableDefaultArgs', 'ReleaseInputVariableDefaultArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 release_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_requirements: Optional[pulumi.Input[Union['ReleaseReleaseRequirementsArgs', 'ReleaseReleaseRequirementsArgsDict']]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReleaseArgs.__new__(ReleaseArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["blueprint"] = blueprint
            __props__.__dict__["input_variable_defaults"] = input_variable_defaults
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if release_id is None and not opts.urn:
                raise TypeError("Missing required property 'release_id'")
            __props__.__dict__["release_id"] = release_id
            __props__.__dict__["release_requirements"] = release_requirements
            if unit_kind is None and not opts.urn:
                raise TypeError("Missing required property 'unit_kind'")
            __props__.__dict__["unit_kind"] = unit_kind
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["input_variables"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["output_variables"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Release, __self__).__init__(
            'gcp:saasruntime/release:Release',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            blueprint: Optional[pulumi.Input[Union['ReleaseBlueprintArgs', 'ReleaseBlueprintArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            input_variable_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReleaseInputVariableDefaultArgs', 'ReleaseInputVariableDefaultArgsDict']]]]] = None,
            input_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReleaseInputVariableArgs', 'ReleaseInputVariableArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReleaseOutputVariableArgs', 'ReleaseOutputVariableArgsDict']]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            release_id: Optional[pulumi.Input[_builtins.str]] = None,
            release_requirements: Optional[pulumi.Input[Union['ReleaseReleaseRequirementsArgs', 'ReleaseReleaseRequirementsArgsDict']]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Release':
        """
        Get an existing Release resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: An opaque value that uniquely identifies a version or
               generation of a resource. It can be used to confirm that the client
               and server agree on the ordering of a resource being written.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReleaseInputVariableDefaultArgs', 'ReleaseInputVariableDefaultArgsDict']]]] input_variable_defaults: Mapping of input variables to default values. Maximum 100
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReleaseInputVariableArgs', 'ReleaseInputVariableArgsDict']]]] input_variables: List of input variables declared on the blueprint and can be present with
               their values on the unit spec
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/releases/{release}"
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReleaseOutputVariableArgs', 'ReleaseOutputVariableArgsDict']]]] output_variables: List of output variables declared on the blueprint and can be present with
               their values on the unit status
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] release_id: The ID value for the new release.
        :param pulumi.Input[Union['ReleaseReleaseRequirementsArgs', 'ReleaseReleaseRequirementsArgsDict']] release_requirements: Set of requirements to be fulfilled on the Unit when using this Release.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Release corresponds to (required and
               immutable once created).
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReleaseState.__new__(_ReleaseState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["blueprint"] = blueprint
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["input_variable_defaults"] = input_variable_defaults
        __props__.__dict__["input_variables"] = input_variables
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["output_variables"] = output_variables
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["release_id"] = release_id
        __props__.__dict__["release_requirements"] = release_requirements
        __props__.__dict__["uid"] = uid
        __props__.__dict__["unit_kind"] = unit_kind
        __props__.__dict__["update_time"] = update_time
        return Release(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def blueprint(self) -> pulumi.Output[Optional['outputs.ReleaseBlueprint']]:
        return pulumi.get(self, "blueprint")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        An opaque value that uniquely identifies a version or
        generation of a resource. It can be used to confirm that the client
        and server agree on the ordering of a resource being written.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="inputVariableDefaults")
    def input_variable_defaults(self) -> pulumi.Output[Optional[Sequence['outputs.ReleaseInputVariableDefault']]]:
        """
        Mapping of input variables to default values. Maximum 100
        Structure is documented below.
        """
        return pulumi.get(self, "input_variable_defaults")

    @_builtins.property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> pulumi.Output[Sequence['outputs.ReleaseInputVariable']]:
        """
        List of input variables declared on the blueprint and can be present with
        their values on the unit spec
        Structure is documented below.
        """
        return pulumi.get(self, "input_variables")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/releases/{release}"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> pulumi.Output[Sequence['outputs.ReleaseOutputVariable']]:
        """
        List of output variables declared on the blueprint and can be present with
        their values on the unit status
        Structure is documented below.
        """
        return pulumi.get(self, "output_variables")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="releaseId")
    def release_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID value for the new release.
        """
        return pulumi.get(self, "release_id")

    @_builtins.property
    @pulumi.getter(name="releaseRequirements")
    def release_requirements(self) -> pulumi.Output[Optional['outputs.ReleaseReleaseRequirements']]:
        """
        Set of requirements to be fulfilled on the Unit when using this Release.
        Structure is documented below.
        """
        return pulumi.get(self, "release_requirements")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> pulumi.Output[_builtins.str]:
        """
        Reference to the UnitKind this Release corresponds to (required and
        immutable once created).
        """
        return pulumi.get(self, "unit_kind")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

