# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RolloutKindArgs', 'RolloutKind']

@pulumi.input_type
class RolloutKindArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 rollout_kind_id: pulumi.Input[_builtins.str],
                 unit_kind: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_budget: Optional[pulumi.Input['RolloutKindErrorBudgetArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_orchestration_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 update_unit_kind_strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RolloutKind resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] rollout_kind_id: The ID value for the new rollout kind.
        :param pulumi.Input[_builtins.str] unit_kind: UnitKind that this rollout kind corresponds to. Rollouts stemming from this
               rollout kind will target the units of this unit kind. In other words, this
               defines the population of target units to be upgraded by rollouts.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['RolloutKindErrorBudgetArgs'] error_budget: The configuration for error budget. If the number of failed units exceeds
               max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rollout_orchestration_strategy: The strategy used for executing a Rollout. This is a required field.
               There are two supported values strategies which are used to control a rollout.
               - "Google.Cloud.Simple.AllAtOnce"
               - "Google.Cloud.Simple.OneLocationAtATime"
               A rollout with one of these simple strategies will rollout across
               all locations defined in the associated UnitKind's Saas Locations.
        :param pulumi.Input[_builtins.str] unit_filter: CEL(https://github.com/google/cel-spec) formatted filter string against
               Unit. The filter will be applied to determine the eligible unit population.
               This filter can only reduce, but not expand the scope of the rollout.
        :param pulumi.Input[_builtins.str] update_unit_kind_strategy: The config for updating the unit kind. By default, the unit kind will be
               updated on the rollout start.
               Possible values:
               UPDATE_UNIT_KIND_STRATEGY_ON_START
               UPDATE_UNIT_KIND_STRATEGY_NEVER
               Possible values are: `UPDATE_UNIT_KIND_STRATEGY_ON_START`, `UPDATE_UNIT_KIND_STRATEGY_NEVER`.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "rollout_kind_id", rollout_kind_id)
        pulumi.set(__self__, "unit_kind", unit_kind)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if error_budget is not None:
            pulumi.set(__self__, "error_budget", error_budget)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rollout_orchestration_strategy is not None:
            pulumi.set(__self__, "rollout_orchestration_strategy", rollout_orchestration_strategy)
        if unit_filter is not None:
            pulumi.set(__self__, "unit_filter", unit_filter)
        if update_unit_kind_strategy is not None:
            pulumi.set(__self__, "update_unit_kind_strategy", update_unit_kind_strategy)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="rolloutKindId")
    def rollout_kind_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID value for the new rollout kind.
        """
        return pulumi.get(self, "rollout_kind_id")

    @rollout_kind_id.setter
    def rollout_kind_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rollout_kind_id", value)

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> pulumi.Input[_builtins.str]:
        """
        UnitKind that this rollout kind corresponds to. Rollouts stemming from this
        rollout kind will target the units of this unit kind. In other words, this
        defines the population of target units to be upgraded by rollouts.
        """
        return pulumi.get(self, "unit_kind")

    @unit_kind.setter
    def unit_kind(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unit_kind", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="errorBudget")
    def error_budget(self) -> Optional[pulumi.Input['RolloutKindErrorBudgetArgs']]:
        """
        The configuration for error budget. If the number of failed units exceeds
        max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
        Structure is documented below.
        """
        return pulumi.get(self, "error_budget")

    @error_budget.setter
    def error_budget(self, value: Optional[pulumi.Input['RolloutKindErrorBudgetArgs']]):
        pulumi.set(self, "error_budget", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rolloutOrchestrationStrategy")
    def rollout_orchestration_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The strategy used for executing a Rollout. This is a required field.
        There are two supported values strategies which are used to control a rollout.
        - "Google.Cloud.Simple.AllAtOnce"
        - "Google.Cloud.Simple.OneLocationAtATime"
        A rollout with one of these simple strategies will rollout across
        all locations defined in the associated UnitKind's Saas Locations.
        """
        return pulumi.get(self, "rollout_orchestration_strategy")

    @rollout_orchestration_strategy.setter
    def rollout_orchestration_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rollout_orchestration_strategy", value)

    @_builtins.property
    @pulumi.getter(name="unitFilter")
    def unit_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CEL(https://github.com/google/cel-spec) formatted filter string against
        Unit. The filter will be applied to determine the eligible unit population.
        This filter can only reduce, but not expand the scope of the rollout.
        """
        return pulumi.get(self, "unit_filter")

    @unit_filter.setter
    def unit_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_filter", value)

    @_builtins.property
    @pulumi.getter(name="updateUnitKindStrategy")
    def update_unit_kind_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The config for updating the unit kind. By default, the unit kind will be
        updated on the rollout start.
        Possible values:
        UPDATE_UNIT_KIND_STRATEGY_ON_START
        UPDATE_UNIT_KIND_STRATEGY_NEVER
        Possible values are: `UPDATE_UNIT_KIND_STRATEGY_ON_START`, `UPDATE_UNIT_KIND_STRATEGY_NEVER`.
        """
        return pulumi.get(self, "update_unit_kind_strategy")

    @update_unit_kind_strategy.setter
    def update_unit_kind_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_unit_kind_strategy", value)


@pulumi.input_type
class _RolloutKindState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_budget: Optional[pulumi.Input['RolloutKindErrorBudgetArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rollout_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_orchestration_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 update_unit_kind_strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RolloutKind resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['RolloutKindErrorBudgetArgs'] error_budget: The configuration for error budget. If the number of failed units exceeds
               max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] rollout_kind_id: The ID value for the new rollout kind.
        :param pulumi.Input[_builtins.str] rollout_orchestration_strategy: The strategy used for executing a Rollout. This is a required field.
               There are two supported values strategies which are used to control a rollout.
               - "Google.Cloud.Simple.AllAtOnce"
               - "Google.Cloud.Simple.OneLocationAtATime"
               A rollout with one of these simple strategies will rollout across
               all locations defined in the associated UnitKind's Saas Locations.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_filter: CEL(https://github.com/google/cel-spec) formatted filter string against
               Unit. The filter will be applied to determine the eligible unit population.
               This filter can only reduce, but not expand the scope of the rollout.
        :param pulumi.Input[_builtins.str] unit_kind: UnitKind that this rollout kind corresponds to. Rollouts stemming from this
               rollout kind will target the units of this unit kind. In other words, this
               defines the population of target units to be upgraded by rollouts.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        :param pulumi.Input[_builtins.str] update_unit_kind_strategy: The config for updating the unit kind. By default, the unit kind will be
               updated on the rollout start.
               Possible values:
               UPDATE_UNIT_KIND_STRATEGY_ON_START
               UPDATE_UNIT_KIND_STRATEGY_NEVER
               Possible values are: `UPDATE_UNIT_KIND_STRATEGY_ON_START`, `UPDATE_UNIT_KIND_STRATEGY_NEVER`.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if error_budget is not None:
            pulumi.set(__self__, "error_budget", error_budget)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rollout_kind_id is not None:
            pulumi.set(__self__, "rollout_kind_id", rollout_kind_id)
        if rollout_orchestration_strategy is not None:
            pulumi.set(__self__, "rollout_orchestration_strategy", rollout_orchestration_strategy)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if unit_filter is not None:
            pulumi.set(__self__, "unit_filter", unit_filter)
        if unit_kind is not None:
            pulumi.set(__self__, "unit_kind", unit_kind)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if update_unit_kind_strategy is not None:
            pulumi.set(__self__, "update_unit_kind_strategy", update_unit_kind_strategy)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="errorBudget")
    def error_budget(self) -> Optional[pulumi.Input['RolloutKindErrorBudgetArgs']]:
        """
        The configuration for error budget. If the number of failed units exceeds
        max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
        Structure is documented below.
        """
        return pulumi.get(self, "error_budget")

    @error_budget.setter
    def error_budget(self, value: Optional[pulumi.Input['RolloutKindErrorBudgetArgs']]):
        pulumi.set(self, "error_budget", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="rolloutKindId")
    def rollout_kind_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID value for the new rollout kind.
        """
        return pulumi.get(self, "rollout_kind_id")

    @rollout_kind_id.setter
    def rollout_kind_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rollout_kind_id", value)

    @_builtins.property
    @pulumi.getter(name="rolloutOrchestrationStrategy")
    def rollout_orchestration_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The strategy used for executing a Rollout. This is a required field.
        There are two supported values strategies which are used to control a rollout.
        - "Google.Cloud.Simple.AllAtOnce"
        - "Google.Cloud.Simple.OneLocationAtATime"
        A rollout with one of these simple strategies will rollout across
        all locations defined in the associated UnitKind's Saas Locations.
        """
        return pulumi.get(self, "rollout_orchestration_strategy")

    @rollout_orchestration_strategy.setter
    def rollout_orchestration_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rollout_orchestration_strategy", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="unitFilter")
    def unit_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CEL(https://github.com/google/cel-spec) formatted filter string against
        Unit. The filter will be applied to determine the eligible unit population.
        This filter can only reduce, but not expand the scope of the rollout.
        """
        return pulumi.get(self, "unit_filter")

    @unit_filter.setter
    def unit_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_filter", value)

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UnitKind that this rollout kind corresponds to. Rollouts stemming from this
        rollout kind will target the units of this unit kind. In other words, this
        defines the population of target units to be upgraded by rollouts.
        """
        return pulumi.get(self, "unit_kind")

    @unit_kind.setter
    def unit_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_kind", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="updateUnitKindStrategy")
    def update_unit_kind_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The config for updating the unit kind. By default, the unit kind will be
        updated on the rollout start.
        Possible values:
        UPDATE_UNIT_KIND_STRATEGY_ON_START
        UPDATE_UNIT_KIND_STRATEGY_NEVER
        Possible values are: `UPDATE_UNIT_KIND_STRATEGY_ON_START`, `UPDATE_UNIT_KIND_STRATEGY_NEVER`.
        """
        return pulumi.get(self, "update_unit_kind_strategy")

    @update_unit_kind_strategy.setter
    def update_unit_kind_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_unit_kind_strategy", value)


@pulumi.type_token("gcp:saasruntime/rolloutKind:RolloutKind")
class RolloutKind(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_budget: Optional[pulumi.Input[Union['RolloutKindErrorBudgetArgs', 'RolloutKindErrorBudgetArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_orchestration_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 update_unit_kind_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A RolloutKind is a reusable configuration resource that defines the policies, strategies, and targeting for Rollout operations. It acts as a template for repeatable Rollouts, providing guardrails and ensuring that updates are executed in a consistent manner across a fleet of Units.

        ## Example Usage

        ### Saas Runtime Rollout Kind Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas = gcp.saasruntime.SaaS("example_saas",
            saas_id="example-saas",
            location="global",
            locations=[{
                "name": "us-central1",
            }])
        example_unitkind = gcp.saasruntime.UnitKind("example_unitkind",
            location="global",
            unit_kind_id="example-unitkind",
            saas=example_saas.id)
        example = gcp.saasruntime.RolloutKind("example",
            location="global",
            rollout_kind_id="example-rolloutkind",
            unit_kind=example_unitkind.id,
            rollout_orchestration_strategy="Google.Cloud.Simple.OneLocationAtATime",
            error_budget={
                "allowed_count": 1,
            },
            unit_filter="unit.labels['key1'] == 'value1'")
        ```

        ## Import

        RolloutKind can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/rolloutKinds/{{rollout_kind_id}}`

        * `{{project}}/{{location}}/{{rollout_kind_id}}`

        * `{{location}}/{{rollout_kind_id}}`

        When using the `pulumi import` command, RolloutKind can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/rolloutKind:RolloutKind default projects/{{project}}/locations/{{location}}/rolloutKinds/{{rollout_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/rolloutKind:RolloutKind default {{project}}/{{location}}/{{rollout_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/rolloutKind:RolloutKind default {{location}}/{{rollout_kind_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['RolloutKindErrorBudgetArgs', 'RolloutKindErrorBudgetArgsDict']] error_budget: The configuration for error budget. If the number of failed units exceeds
               max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rollout_kind_id: The ID value for the new rollout kind.
        :param pulumi.Input[_builtins.str] rollout_orchestration_strategy: The strategy used for executing a Rollout. This is a required field.
               There are two supported values strategies which are used to control a rollout.
               - "Google.Cloud.Simple.AllAtOnce"
               - "Google.Cloud.Simple.OneLocationAtATime"
               A rollout with one of these simple strategies will rollout across
               all locations defined in the associated UnitKind's Saas Locations.
        :param pulumi.Input[_builtins.str] unit_filter: CEL(https://github.com/google/cel-spec) formatted filter string against
               Unit. The filter will be applied to determine the eligible unit population.
               This filter can only reduce, but not expand the scope of the rollout.
        :param pulumi.Input[_builtins.str] unit_kind: UnitKind that this rollout kind corresponds to. Rollouts stemming from this
               rollout kind will target the units of this unit kind. In other words, this
               defines the population of target units to be upgraded by rollouts.
        :param pulumi.Input[_builtins.str] update_unit_kind_strategy: The config for updating the unit kind. By default, the unit kind will be
               updated on the rollout start.
               Possible values:
               UPDATE_UNIT_KIND_STRATEGY_ON_START
               UPDATE_UNIT_KIND_STRATEGY_NEVER
               Possible values are: `UPDATE_UNIT_KIND_STRATEGY_ON_START`, `UPDATE_UNIT_KIND_STRATEGY_NEVER`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RolloutKindArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A RolloutKind is a reusable configuration resource that defines the policies, strategies, and targeting for Rollout operations. It acts as a template for repeatable Rollouts, providing guardrails and ensuring that updates are executed in a consistent manner across a fleet of Units.

        ## Example Usage

        ### Saas Runtime Rollout Kind Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas = gcp.saasruntime.SaaS("example_saas",
            saas_id="example-saas",
            location="global",
            locations=[{
                "name": "us-central1",
            }])
        example_unitkind = gcp.saasruntime.UnitKind("example_unitkind",
            location="global",
            unit_kind_id="example-unitkind",
            saas=example_saas.id)
        example = gcp.saasruntime.RolloutKind("example",
            location="global",
            rollout_kind_id="example-rolloutkind",
            unit_kind=example_unitkind.id,
            rollout_orchestration_strategy="Google.Cloud.Simple.OneLocationAtATime",
            error_budget={
                "allowed_count": 1,
            },
            unit_filter="unit.labels['key1'] == 'value1'")
        ```

        ## Import

        RolloutKind can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/rolloutKinds/{{rollout_kind_id}}`

        * `{{project}}/{{location}}/{{rollout_kind_id}}`

        * `{{location}}/{{rollout_kind_id}}`

        When using the `pulumi import` command, RolloutKind can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/rolloutKind:RolloutKind default projects/{{project}}/locations/{{location}}/rolloutKinds/{{rollout_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/rolloutKind:RolloutKind default {{project}}/{{location}}/{{rollout_kind_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/rolloutKind:RolloutKind default {{location}}/{{rollout_kind_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RolloutKindArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RolloutKindArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_budget: Optional[pulumi.Input[Union['RolloutKindErrorBudgetArgs', 'RolloutKindErrorBudgetArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout_orchestration_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 update_unit_kind_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RolloutKindArgs.__new__(RolloutKindArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["error_budget"] = error_budget
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if rollout_kind_id is None and not opts.urn:
                raise TypeError("Missing required property 'rollout_kind_id'")
            __props__.__dict__["rollout_kind_id"] = rollout_kind_id
            __props__.__dict__["rollout_orchestration_strategy"] = rollout_orchestration_strategy
            __props__.__dict__["unit_filter"] = unit_filter
            if unit_kind is None and not opts.urn:
                raise TypeError("Missing required property 'unit_kind'")
            __props__.__dict__["unit_kind"] = unit_kind
            __props__.__dict__["update_unit_kind_strategy"] = update_unit_kind_strategy
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RolloutKind, __self__).__init__(
            'gcp:saasruntime/rolloutKind:RolloutKind',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            error_budget: Optional[pulumi.Input[Union['RolloutKindErrorBudgetArgs', 'RolloutKindErrorBudgetArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            rollout_kind_id: Optional[pulumi.Input[_builtins.str]] = None,
            rollout_orchestration_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            unit_filter: Optional[pulumi.Input[_builtins.str]] = None,
            unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            update_unit_kind_strategy: Optional[pulumi.Input[_builtins.str]] = None) -> 'RolloutKind':
        """
        Get an existing RolloutKind resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['RolloutKindErrorBudgetArgs', 'RolloutKindErrorBudgetArgsDict']] error_budget: The configuration for error budget. If the number of failed units exceeds
               max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] rollout_kind_id: The ID value for the new rollout kind.
        :param pulumi.Input[_builtins.str] rollout_orchestration_strategy: The strategy used for executing a Rollout. This is a required field.
               There are two supported values strategies which are used to control a rollout.
               - "Google.Cloud.Simple.AllAtOnce"
               - "Google.Cloud.Simple.OneLocationAtATime"
               A rollout with one of these simple strategies will rollout across
               all locations defined in the associated UnitKind's Saas Locations.
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_filter: CEL(https://github.com/google/cel-spec) formatted filter string against
               Unit. The filter will be applied to determine the eligible unit population.
               This filter can only reduce, but not expand the scope of the rollout.
        :param pulumi.Input[_builtins.str] unit_kind: UnitKind that this rollout kind corresponds to. Rollouts stemming from this
               rollout kind will target the units of this unit kind. In other words, this
               defines the population of target units to be upgraded by rollouts.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        :param pulumi.Input[_builtins.str] update_unit_kind_strategy: The config for updating the unit kind. By default, the unit kind will be
               updated on the rollout start.
               Possible values:
               UPDATE_UNIT_KIND_STRATEGY_ON_START
               UPDATE_UNIT_KIND_STRATEGY_NEVER
               Possible values are: `UPDATE_UNIT_KIND_STRATEGY_ON_START`, `UPDATE_UNIT_KIND_STRATEGY_NEVER`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RolloutKindState.__new__(_RolloutKindState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["error_budget"] = error_budget
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["rollout_kind_id"] = rollout_kind_id
        __props__.__dict__["rollout_orchestration_strategy"] = rollout_orchestration_strategy
        __props__.__dict__["uid"] = uid
        __props__.__dict__["unit_filter"] = unit_filter
        __props__.__dict__["unit_kind"] = unit_kind
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["update_unit_kind_strategy"] = update_unit_kind_strategy
        return RolloutKind(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="errorBudget")
    def error_budget(self) -> pulumi.Output[Optional['outputs.RolloutKindErrorBudget']]:
        """
        The configuration for error budget. If the number of failed units exceeds
        max(allowed_count, allowed_ratio * total_units), the rollout will be paused.
        Structure is documented below.
        """
        return pulumi.get(self, "error_budget")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="rolloutKindId")
    def rollout_kind_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID value for the new rollout kind.
        """
        return pulumi.get(self, "rollout_kind_id")

    @_builtins.property
    @pulumi.getter(name="rolloutOrchestrationStrategy")
    def rollout_orchestration_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The strategy used for executing a Rollout. This is a required field.
        There are two supported values strategies which are used to control a rollout.
        - "Google.Cloud.Simple.AllAtOnce"
        - "Google.Cloud.Simple.OneLocationAtATime"
        A rollout with one of these simple strategies will rollout across
        all locations defined in the associated UnitKind's Saas Locations.
        """
        return pulumi.get(self, "rollout_orchestration_strategy")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="unitFilter")
    def unit_filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CEL(https://github.com/google/cel-spec) formatted filter string against
        Unit. The filter will be applied to determine the eligible unit population.
        This filter can only reduce, but not expand the scope of the rollout.
        """
        return pulumi.get(self, "unit_filter")

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> pulumi.Output[_builtins.str]:
        """
        UnitKind that this rollout kind corresponds to. Rollouts stemming from this
        rollout kind will target the units of this unit kind. In other words, this
        defines the population of target units to be upgraded by rollouts.
        """
        return pulumi.get(self, "unit_kind")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="updateUnitKindStrategy")
    def update_unit_kind_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The config for updating the unit kind. By default, the unit kind will be
        updated on the rollout start.
        Possible values:
        UPDATE_UNIT_KIND_STRATEGY_ON_START
        UPDATE_UNIT_KIND_STRATEGY_NEVER
        Possible values are: `UPDATE_UNIT_KIND_STRATEGY_ON_START`, `UPDATE_UNIT_KIND_STRATEGY_NEVER`.
        """
        return pulumi.get(self, "update_unit_kind_strategy")

