# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UnitArgs', 'Unit']

@pulumi.input_type
class UnitArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 unit_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance: Optional[pulumi.Input['UnitMaintenanceArgs']] = None,
                 management_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Unit resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] unit_id: The ID value for the new unit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['UnitMaintenanceArgs'] maintenance: Captures requested directives for performing future maintenance on the
               unit. This includes a request for the unit to skip maintenance for a period
               of time and remain pinned to its current release as well as controls for
               postponing maintenance scheduled in future.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] management_mode: Indicates whether the Unit life cycle is controlled
               by the user or by the system.
               Immutable once created.
               Possible values:
               MANAGEMENT_MODE_USER
               MANAGEMENT_MODE_SYSTEM
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: Reference to the Saas Tenant resource this unit belongs to. This for
               example informs the maintenance policies to use for scheduling future
               updates on a unit. (optional and immutable once created)
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Unit belongs to. Immutable once set.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "unit_id", unit_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if management_mode is not None:
            pulumi.set(__self__, "management_mode", management_mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if unit_kind is not None:
            pulumi.set(__self__, "unit_kind", unit_kind)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="unitId")
    def unit_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID value for the new unit.
        """
        return pulumi.get(self, "unit_id")

    @unit_id.setter
    def unit_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unit_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['UnitMaintenanceArgs']]:
        """
        Captures requested directives for performing future maintenance on the
        unit. This includes a request for the unit to skip maintenance for a period
        of time and remain pinned to its current release as well as controls for
        postponing maintenance scheduled in future.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['UnitMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @_builtins.property
    @pulumi.getter(name="managementMode")
    def management_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the Unit life cycle is controlled
        by the user or by the system.
        Immutable once created.
        Possible values:
        MANAGEMENT_MODE_USER
        MANAGEMENT_MODE_SYSTEM
        """
        return pulumi.get(self, "management_mode")

    @management_mode.setter
    def management_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_mode", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the Saas Tenant resource this unit belongs to. This for
        example informs the maintenance policies to use for scheduling future
        updates on a unit. (optional and immutable once created)
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the UnitKind this Unit belongs to. Immutable once set.
        """
        return pulumi.get(self, "unit_kind")

    @unit_kind.setter
    def unit_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_kind", value)


@pulumi.input_type
class _UnitState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['UnitConditionArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['UnitDependencyArgs']]]] = None,
                 dependents: Optional[pulumi.Input[Sequence[pulumi.Input['UnitDependentArgs']]]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 input_variables: Optional[pulumi.Input[Sequence[pulumi.Input['UnitInputVariableArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input['UnitMaintenanceArgs']] = None,
                 management_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ongoing_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 output_variables: Optional[pulumi.Input[Sequence[pulumi.Input['UnitOutputVariableArgs']]]] = None,
                 pending_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 release: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_cleanup_at: Optional[pulumi.Input[_builtins.str]] = None,
                 system_managed_state: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Unit resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input['UnitConditionArgs']]] conditions: A set of conditions which indicate the various conditions this resource can
               have.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input['UnitDependencyArgs']]] dependencies: Set of dependencies for this unit. Maximum 10.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['UnitDependentArgs']]] dependents: List of Units that depend on this unit. Unit can only be deprovisioned if
               this list is empty. Maximum 1000.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['UnitInputVariableArgs']]] input_variables: Indicates the current input variables deployed by the unit
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['UnitMaintenanceArgs'] maintenance: Captures requested directives for performing future maintenance on the
               unit. This includes a request for the unit to skip maintenance for a period
               of time and remain pinned to its current release as well as controls for
               postponing maintenance scheduled in future.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] management_mode: Indicates whether the Unit life cycle is controlled
               by the user or by the system.
               Immutable once created.
               Possible values:
               MANAGEMENT_MODE_USER
               MANAGEMENT_MODE_SYSTEM
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/units/{unit}"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ongoing_operations: List of concurrent UnitOperations that are operating on this Unit.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pending_operations: List of pending (wait to be executed) UnitOperations for this unit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] release: The current Release object for this Unit.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scheduled_operations: List of scheduled UnitOperations for this unit.
        :param pulumi.Input[_builtins.str] state: Current lifecycle state of the resource (e.g. if it's being
               created or ready to use).
               Possible values:
               UNIT_STATE_NOT_PROVISIONED
               UNIT_STATE_PROVISIONING
               UNIT_STATE_UPDATING
               UNIT_STATE_DEPROVISIONING
               UNIT_STATE_READY
               UNIT_STATE_ERROR
        :param pulumi.Input[_builtins.str] system_cleanup_at: If set, indicates the time when the system will start removing the unit.
        :param pulumi.Input[_builtins.str] system_managed_state: Indicates the system managed state of the unit.
               Possible values:
               SYSTEM_MANAGED_STATE_ACTIVE
               SYSTEM_MANAGED_STATE_INACTIVE
               SYSTEM_MANAGED_STATE_DECOMMISSIONED
        :param pulumi.Input[_builtins.str] tenant: Reference to the Saas Tenant resource this unit belongs to. This for
               example informs the maintenance policies to use for scheduling future
               updates on a unit. (optional and immutable once created)
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_id: The ID value for the new unit.
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Unit belongs to. Immutable once set.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dependencies is not None:
            pulumi.set(__self__, "dependencies", dependencies)
        if dependents is not None:
            pulumi.set(__self__, "dependents", dependents)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if input_variables is not None:
            pulumi.set(__self__, "input_variables", input_variables)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if management_mode is not None:
            pulumi.set(__self__, "management_mode", management_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ongoing_operations is not None:
            pulumi.set(__self__, "ongoing_operations", ongoing_operations)
        if output_variables is not None:
            pulumi.set(__self__, "output_variables", output_variables)
        if pending_operations is not None:
            pulumi.set(__self__, "pending_operations", pending_operations)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if scheduled_operations is not None:
            pulumi.set(__self__, "scheduled_operations", scheduled_operations)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_cleanup_at is not None:
            pulumi.set(__self__, "system_cleanup_at", system_cleanup_at)
        if system_managed_state is not None:
            pulumi.set(__self__, "system_managed_state", system_managed_state)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if unit_id is not None:
            pulumi.set(__self__, "unit_id", unit_id)
        if unit_kind is not None:
            pulumi.set(__self__, "unit_kind", unit_kind)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitConditionArgs']]]]:
        """
        A set of conditions which indicate the various conditions this resource can
        have.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitDependencyArgs']]]]:
        """
        Set of dependencies for this unit. Maximum 10.
        Structure is documented below.
        """
        return pulumi.get(self, "dependencies")

    @dependencies.setter
    def dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitDependencyArgs']]]]):
        pulumi.set(self, "dependencies", value)

    @_builtins.property
    @pulumi.getter
    def dependents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitDependentArgs']]]]:
        """
        List of Units that depend on this unit. Unit can only be deprovisioned if
        this list is empty. Maximum 1000.
        Structure is documented below.
        """
        return pulumi.get(self, "dependents")

    @dependents.setter
    def dependents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitDependentArgs']]]]):
        pulumi.set(self, "dependents", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitInputVariableArgs']]]]:
        """
        Indicates the current input variables deployed by the unit
        Structure is documented below.
        """
        return pulumi.get(self, "input_variables")

    @input_variables.setter
    def input_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitInputVariableArgs']]]]):
        pulumi.set(self, "input_variables", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['UnitMaintenanceArgs']]:
        """
        Captures requested directives for performing future maintenance on the
        unit. This includes a request for the unit to skip maintenance for a period
        of time and remain pinned to its current release as well as controls for
        postponing maintenance scheduled in future.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['UnitMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @_builtins.property
    @pulumi.getter(name="managementMode")
    def management_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the Unit life cycle is controlled
        by the user or by the system.
        Immutable once created.
        Possible values:
        MANAGEMENT_MODE_USER
        MANAGEMENT_MODE_SYSTEM
        """
        return pulumi.get(self, "management_mode")

    @management_mode.setter
    def management_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/units/{unit}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ongoingOperations")
    def ongoing_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of concurrent UnitOperations that are operating on this Unit.
        """
        return pulumi.get(self, "ongoing_operations")

    @ongoing_operations.setter
    def ongoing_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ongoing_operations", value)

    @_builtins.property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnitOutputVariableArgs']]]]:
        return pulumi.get(self, "output_variables")

    @output_variables.setter
    def output_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnitOutputVariableArgs']]]]):
        pulumi.set(self, "output_variables", value)

    @_builtins.property
    @pulumi.getter(name="pendingOperations")
    def pending_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of pending (wait to be executed) UnitOperations for this unit.
        """
        return pulumi.get(self, "pending_operations")

    @pending_operations.setter
    def pending_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pending_operations", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current Release object for this Unit.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release", value)

    @_builtins.property
    @pulumi.getter(name="scheduledOperations")
    def scheduled_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of scheduled UnitOperations for this unit.
        """
        return pulumi.get(self, "scheduled_operations")

    @scheduled_operations.setter
    def scheduled_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scheduled_operations", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current lifecycle state of the resource (e.g. if it's being
        created or ready to use).
        Possible values:
        UNIT_STATE_NOT_PROVISIONED
        UNIT_STATE_PROVISIONING
        UNIT_STATE_UPDATING
        UNIT_STATE_DEPROVISIONING
        UNIT_STATE_READY
        UNIT_STATE_ERROR
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemCleanupAt")
    def system_cleanup_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set, indicates the time when the system will start removing the unit.
        """
        return pulumi.get(self, "system_cleanup_at")

    @system_cleanup_at.setter
    def system_cleanup_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_cleanup_at", value)

    @_builtins.property
    @pulumi.getter(name="systemManagedState")
    def system_managed_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the system managed state of the unit.
        Possible values:
        SYSTEM_MANAGED_STATE_ACTIVE
        SYSTEM_MANAGED_STATE_INACTIVE
        SYSTEM_MANAGED_STATE_DECOMMISSIONED
        """
        return pulumi.get(self, "system_managed_state")

    @system_managed_state.setter
    def system_managed_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_managed_state", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the Saas Tenant resource this unit belongs to. This for
        example informs the maintenance policies to use for scheduling future
        updates on a unit. (optional and immutable once created)
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="unitId")
    def unit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID value for the new unit.
        """
        return pulumi.get(self, "unit_id")

    @unit_id.setter
    def unit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_id", value)

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the UnitKind this Unit belongs to. Immutable once set.
        """
        return pulumi.get(self, "unit_kind")

    @unit_kind.setter
    def unit_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_kind", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:saasruntime/unit:Unit")
class Unit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[Union['UnitMaintenanceArgs', 'UnitMaintenanceArgsDict']]] = None,
                 management_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Unit is the fundamental structural building block of a SaaS offering. Each Unit is an instance of a UnitKind. It is a versioned, manageable component of a service that has its own lifecycle, representing elements like infrastructure, workloads, or an entire application stack that a service producer intends to manage as a single entity.

        ## Example Usage

        ### Saas Runtime Unit Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas_regional = gcp.saasruntime.SaaS("example_saas_regional",
            saas_id="example-saas",
            location="us-central1",
            locations=[{
                "name": "us-central1",
            }])
        example_unit_kind = gcp.saasruntime.UnitKind("example_unit_kind",
            location="us-central1",
            unit_kind_id="example-unitkind",
            saas=example_saas_regional.id)
        example = gcp.saasruntime.Unit("example",
            location="us-central1",
            unit_id="example-unit",
            unit_kind=example_unit_kind.id,
            management_mode="MANAGEMENT_MODE_USER")
        ```

        ## Import

        Unit can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/units/{{unit_id}}`

        * `{{project}}/{{location}}/{{unit_id}}`

        * `{{location}}/{{unit_id}}`

        When using the `pulumi import` command, Unit can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/unit:Unit default projects/{{project}}/locations/{{location}}/units/{{unit_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unit:Unit default {{project}}/{{location}}/{{unit_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unit:Unit default {{location}}/{{unit_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['UnitMaintenanceArgs', 'UnitMaintenanceArgsDict']] maintenance: Captures requested directives for performing future maintenance on the
               unit. This includes a request for the unit to skip maintenance for a period
               of time and remain pinned to its current release as well as controls for
               postponing maintenance scheduled in future.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] management_mode: Indicates whether the Unit life cycle is controlled
               by the user or by the system.
               Immutable once created.
               Possible values:
               MANAGEMENT_MODE_USER
               MANAGEMENT_MODE_SYSTEM
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: Reference to the Saas Tenant resource this unit belongs to. This for
               example informs the maintenance policies to use for scheduling future
               updates on a unit. (optional and immutable once created)
        :param pulumi.Input[_builtins.str] unit_id: The ID value for the new unit.
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Unit belongs to. Immutable once set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UnitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Unit is the fundamental structural building block of a SaaS offering. Each Unit is an instance of a UnitKind. It is a versioned, manageable component of a service that has its own lifecycle, representing elements like infrastructure, workloads, or an entire application stack that a service producer intends to manage as a single entity.

        ## Example Usage

        ### Saas Runtime Unit Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_saas_regional = gcp.saasruntime.SaaS("example_saas_regional",
            saas_id="example-saas",
            location="us-central1",
            locations=[{
                "name": "us-central1",
            }])
        example_unit_kind = gcp.saasruntime.UnitKind("example_unit_kind",
            location="us-central1",
            unit_kind_id="example-unitkind",
            saas=example_saas_regional.id)
        example = gcp.saasruntime.Unit("example",
            location="us-central1",
            unit_id="example-unit",
            unit_kind=example_unit_kind.id,
            management_mode="MANAGEMENT_MODE_USER")
        ```

        ## Import

        Unit can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/units/{{unit_id}}`

        * `{{project}}/{{location}}/{{unit_id}}`

        * `{{location}}/{{unit_id}}`

        When using the `pulumi import` command, Unit can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:saasruntime/unit:Unit default projects/{{project}}/locations/{{location}}/units/{{unit_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unit:Unit default {{project}}/{{location}}/{{unit_id}}
        ```

        ```sh
        $ pulumi import gcp:saasruntime/unit:Unit default {{location}}/{{unit_id}}
        ```

        :param str resource_name: The name of the resource.
        :param UnitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UnitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[Union['UnitMaintenanceArgs', 'UnitMaintenanceArgsDict']]] = None,
                 management_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UnitArgs.__new__(UnitArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance"] = maintenance
            __props__.__dict__["management_mode"] = management_mode
            __props__.__dict__["project"] = project
            __props__.__dict__["tenant"] = tenant
            if unit_id is None and not opts.urn:
                raise TypeError("Missing required property 'unit_id'")
            __props__.__dict__["unit_id"] = unit_id
            __props__.__dict__["unit_kind"] = unit_kind
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dependencies"] = None
            __props__.__dict__["dependents"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["input_variables"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["ongoing_operations"] = None
            __props__.__dict__["output_variables"] = None
            __props__.__dict__["pending_operations"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["release"] = None
            __props__.__dict__["scheduled_operations"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_cleanup_at"] = None
            __props__.__dict__["system_managed_state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Unit, __self__).__init__(
            'gcp:saasruntime/unit:Unit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitConditionArgs', 'UnitConditionArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitDependencyArgs', 'UnitDependencyArgsDict']]]]] = None,
            dependents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitDependentArgs', 'UnitDependentArgsDict']]]]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            input_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitInputVariableArgs', 'UnitInputVariableArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance: Optional[pulumi.Input[Union['UnitMaintenanceArgs', 'UnitMaintenanceArgsDict']]] = None,
            management_mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ongoing_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            output_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UnitOutputVariableArgs', 'UnitOutputVariableArgsDict']]]]] = None,
            pending_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            release: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_operations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_cleanup_at: Optional[pulumi.Input[_builtins.str]] = None,
            system_managed_state: Optional[pulumi.Input[_builtins.str]] = None,
            tenant: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            unit_id: Optional[pulumi.Input[_builtins.str]] = None,
            unit_kind: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Unit':
        """
        Get an existing Unit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations is an unstructured key-value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata.
               They are not queryable and should be preserved when modifying objects.
               More info: https://kubernetes.io/docs/user-guide/annotations
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitConditionArgs', 'UnitConditionArgsDict']]]] conditions: A set of conditions which indicate the various conditions this resource can
               have.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitDependencyArgs', 'UnitDependencyArgsDict']]]] dependencies: Set of dependencies for this unit. Maximum 10.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitDependentArgs', 'UnitDependentArgsDict']]]] dependents: List of Units that depend on this unit. Unit can only be deprovisioned if
               this list is empty. Maximum 1000.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UnitInputVariableArgs', 'UnitInputVariableArgsDict']]]] input_variables: Indicates the current input variables deployed by the unit
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels on the resource, which can be used for categorization.
               similar to Kubernetes resource labels.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['UnitMaintenanceArgs', 'UnitMaintenanceArgsDict']] maintenance: Captures requested directives for performing future maintenance on the
               unit. This includes a request for the unit to skip maintenance for a period
               of time and remain pinned to its current release as well as controls for
               postponing maintenance scheduled in future.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] management_mode: Indicates whether the Unit life cycle is controlled
               by the user or by the system.
               Immutable once created.
               Possible values:
               MANAGEMENT_MODE_USER
               MANAGEMENT_MODE_SYSTEM
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name (full URI of the resource) following the standard naming
               scheme:
               "projects/{project}/locations/{location}/units/{unit}"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ongoing_operations: List of concurrent UnitOperations that are operating on this Unit.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pending_operations: List of pending (wait to be executed) UnitOperations for this unit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] release: The current Release object for this Unit.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scheduled_operations: List of scheduled UnitOperations for this unit.
        :param pulumi.Input[_builtins.str] state: Current lifecycle state of the resource (e.g. if it's being
               created or ready to use).
               Possible values:
               UNIT_STATE_NOT_PROVISIONED
               UNIT_STATE_PROVISIONING
               UNIT_STATE_UPDATING
               UNIT_STATE_DEPROVISIONING
               UNIT_STATE_READY
               UNIT_STATE_ERROR
        :param pulumi.Input[_builtins.str] system_cleanup_at: If set, indicates the time when the system will start removing the unit.
        :param pulumi.Input[_builtins.str] system_managed_state: Indicates the system managed state of the unit.
               Possible values:
               SYSTEM_MANAGED_STATE_ACTIVE
               SYSTEM_MANAGED_STATE_INACTIVE
               SYSTEM_MANAGED_STATE_DECOMMISSIONED
        :param pulumi.Input[_builtins.str] tenant: Reference to the Saas Tenant resource this unit belongs to. This for
               example informs the maintenance policies to use for scheduling future
               updates on a unit. (optional and immutable once created)
        :param pulumi.Input[_builtins.str] uid: The unique identifier of the resource. UID is unique in the time
               and space for this resource within the scope of the service. It is
               typically generated by the server on successful creation of a resource
               and must not be changed. UID is used to uniquely identify resources
               with resource name reuses. This should be a UUID4.
        :param pulumi.Input[_builtins.str] unit_id: The ID value for the new unit.
        :param pulumi.Input[_builtins.str] unit_kind: Reference to the UnitKind this Unit belongs to. Immutable once set.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was last updated. Any
               change to the resource made by users must refresh this value.
               Changes to a resource made by the service should refresh this value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UnitState.__new__(_UnitState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dependencies"] = dependencies
        __props__.__dict__["dependents"] = dependents
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["input_variables"] = input_variables
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance"] = maintenance
        __props__.__dict__["management_mode"] = management_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["ongoing_operations"] = ongoing_operations
        __props__.__dict__["output_variables"] = output_variables
        __props__.__dict__["pending_operations"] = pending_operations
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["release"] = release
        __props__.__dict__["scheduled_operations"] = scheduled_operations
        __props__.__dict__["state"] = state
        __props__.__dict__["system_cleanup_at"] = system_cleanup_at
        __props__.__dict__["system_managed_state"] = system_managed_state
        __props__.__dict__["tenant"] = tenant
        __props__.__dict__["uid"] = uid
        __props__.__dict__["unit_id"] = unit_id
        __props__.__dict__["unit_kind"] = unit_kind
        __props__.__dict__["update_time"] = update_time
        return Unit(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Annotations is an unstructured key-value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata.
        They are not queryable and should be preserved when modifying objects.
        More info: https://kubernetes.io/docs/user-guide/annotations
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.UnitCondition']]:
        """
        A set of conditions which indicate the various conditions this resource can
        have.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def dependencies(self) -> pulumi.Output[Sequence['outputs.UnitDependency']]:
        """
        Set of dependencies for this unit. Maximum 10.
        Structure is documented below.
        """
        return pulumi.get(self, "dependencies")

    @_builtins.property
    @pulumi.getter
    def dependents(self) -> pulumi.Output[Sequence['outputs.UnitDependent']]:
        """
        List of Units that depend on this unit. Unit can only be deprovisioned if
        this list is empty. Maximum 1000.
        Structure is documented below.
        """
        return pulumi.get(self, "dependents")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> pulumi.Output[Sequence['outputs.UnitInputVariable']]:
        """
        Indicates the current input variables deployed by the unit
        Structure is documented below.
        """
        return pulumi.get(self, "input_variables")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels on the resource, which can be used for categorization.
        similar to Kubernetes resource labels.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> pulumi.Output[Optional['outputs.UnitMaintenance']]:
        """
        Captures requested directives for performing future maintenance on the
        unit. This includes a request for the unit to skip maintenance for a period
        of time and remain pinned to its current release as well as controls for
        postponing maintenance scheduled in future.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance")

    @_builtins.property
    @pulumi.getter(name="managementMode")
    def management_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether the Unit life cycle is controlled
        by the user or by the system.
        Immutable once created.
        Possible values:
        MANAGEMENT_MODE_USER
        MANAGEMENT_MODE_SYSTEM
        """
        return pulumi.get(self, "management_mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name (full URI of the resource) following the standard naming
        scheme:
        "projects/{project}/locations/{location}/units/{unit}"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ongoingOperations")
    def ongoing_operations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of concurrent UnitOperations that are operating on this Unit.
        """
        return pulumi.get(self, "ongoing_operations")

    @_builtins.property
    @pulumi.getter(name="outputVariables")
    def output_variables(self) -> pulumi.Output[Sequence['outputs.UnitOutputVariable']]:
        return pulumi.get(self, "output_variables")

    @_builtins.property
    @pulumi.getter(name="pendingOperations")
    def pending_operations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of pending (wait to be executed) UnitOperations for this unit.
        """
        return pulumi.get(self, "pending_operations")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def release(self) -> pulumi.Output[_builtins.str]:
        """
        The current Release object for this Unit.
        """
        return pulumi.get(self, "release")

    @_builtins.property
    @pulumi.getter(name="scheduledOperations")
    def scheduled_operations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of scheduled UnitOperations for this unit.
        """
        return pulumi.get(self, "scheduled_operations")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Current lifecycle state of the resource (e.g. if it's being
        created or ready to use).
        Possible values:
        UNIT_STATE_NOT_PROVISIONED
        UNIT_STATE_PROVISIONING
        UNIT_STATE_UPDATING
        UNIT_STATE_DEPROVISIONING
        UNIT_STATE_READY
        UNIT_STATE_ERROR
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemCleanupAt")
    def system_cleanup_at(self) -> pulumi.Output[_builtins.str]:
        """
        If set, indicates the time when the system will start removing the unit.
        """
        return pulumi.get(self, "system_cleanup_at")

    @_builtins.property
    @pulumi.getter(name="systemManagedState")
    def system_managed_state(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the system managed state of the unit.
        Possible values:
        SYSTEM_MANAGED_STATE_ACTIVE
        SYSTEM_MANAGED_STATE_INACTIVE
        SYSTEM_MANAGED_STATE_DECOMMISSIONED
        """
        return pulumi.get(self, "system_managed_state")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reference to the Saas Tenant resource this unit belongs to. This for
        example informs the maintenance policies to use for scheduling future
        updates on a unit. (optional and immutable once created)
        """
        return pulumi.get(self, "tenant")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the resource. UID is unique in the time
        and space for this resource within the scope of the service. It is
        typically generated by the server on successful creation of a resource
        and must not be changed. UID is used to uniquely identify resources
        with resource name reuses. This should be a UUID4.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="unitId")
    def unit_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID value for the new unit.
        """
        return pulumi.get(self, "unit_id")

    @_builtins.property
    @pulumi.getter(name="unitKind")
    def unit_kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reference to the UnitKind this Unit belongs to. Immutable once set.
        """
        return pulumi.get(self, "unit_kind")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was last updated. Any
        change to the resource made by users must refresh this value.
        Changes to a resource made by the service should refresh this value.
        """
        return pulumi.get(self, "update_time")

