# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegionalSecretVersionAccessResult',
    'AwaitableGetRegionalSecretVersionAccessResult',
    'get_regional_secret_version_access',
    'get_regional_secret_version_access_output',
]

@pulumi.output_type
class GetRegionalSecretVersionAccessResult:
    """
    A collection of values returned by getRegionalSecretVersionAccess.
    """
    def __init__(__self__, id=None, is_secret_data_base64=None, location=None, name=None, project=None, secret=None, secret_data=None, version=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_secret_data_base64 and not isinstance(is_secret_data_base64, bool):
            raise TypeError("Expected argument 'is_secret_data_base64' to be a bool")
        pulumi.set(__self__, "is_secret_data_base64", is_secret_data_base64)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if secret_data and not isinstance(secret_data, str):
            raise TypeError("Expected argument 'secret_data' to be a str")
        pulumi.set(__self__, "secret_data", secret_data)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_secret_data_base64")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name of the regional SecretVersion. Format:
        `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> _builtins.str:
        """
        The secret data. No larger than 64KiB.
        """
        return pulumi.get(self, "secret_data")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetRegionalSecretVersionAccessResult(GetRegionalSecretVersionAccessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalSecretVersionAccessResult(
            id=self.id,
            is_secret_data_base64=self.is_secret_data_base64,
            location=self.location,
            name=self.name,
            project=self.project,
            secret=self.secret,
            secret_data=self.secret_data,
            version=self.version)


def get_regional_secret_version_access(is_secret_data_base64: Optional[_builtins.bool] = None,
                                       location: Optional[_builtins.str] = None,
                                       project: Optional[_builtins.str] = None,
                                       secret: Optional[_builtins.str] = None,
                                       version: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalSecretVersionAccessResult:
    """
    subcategory: "Secret Manager"
    page_title: "Google: secretmanager_get_regional_secret_version_access"
    description: |-
      Get a payload of Secret Manager regional secret's version.
    ---

    Get the value from a Secret Manager regional secret version. This is similar to the secretmanager.RegionalSecretVersion datasource, but it only requires the [Secret Manager Secret Accessor](https://cloud.google.com/secret-manager/docs/access-control#secretmanager.secretAccessor) role. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/regional-secrets-overview) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.locations.secrets.versions/access).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    latest = gcp.secretmanager.get_regional_secret_version_access(secret="my-secret",
        location="us-central1")
    ```


    :param _builtins.bool is_secret_data_base64: If set to 'true', the secret data is
           expected to be base64-encoded string.
    :param _builtins.str location: Location of Secret Manager regional secret resource.
           It must be provided when the `secret` field provided consists of only the name of the regional secret.
    :param _builtins.str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param _builtins.str secret: The regional secret to get the secret version for.
           This can be either the reference of the regional secret as in `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}` or only the name of the regional secret as in `{{secret_id}}`. If only the name of the regional secret is provided, the location must also be provided.
    :param _builtins.str version: The version of the regional secret to get. If it
           is not provided, the latest version is retrieved.
    """
    __args__ = dict()
    __args__['isSecretDataBase64'] = is_secret_data_base64
    __args__['location'] = location
    __args__['project'] = project
    __args__['secret'] = secret
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:secretmanager/getRegionalSecretVersionAccess:getRegionalSecretVersionAccess', __args__, opts=opts, typ=GetRegionalSecretVersionAccessResult).value

    return AwaitableGetRegionalSecretVersionAccessResult(
        id=pulumi.get(__ret__, 'id'),
        is_secret_data_base64=pulumi.get(__ret__, 'is_secret_data_base64'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        secret=pulumi.get(__ret__, 'secret'),
        secret_data=pulumi.get(__ret__, 'secret_data'),
        version=pulumi.get(__ret__, 'version'))
def get_regional_secret_version_access_output(is_secret_data_base64: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                              location: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              secret: Optional[pulumi.Input[_builtins.str]] = None,
                                              version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionalSecretVersionAccessResult]:
    """
    subcategory: "Secret Manager"
    page_title: "Google: secretmanager_get_regional_secret_version_access"
    description: |-
      Get a payload of Secret Manager regional secret's version.
    ---

    Get the value from a Secret Manager regional secret version. This is similar to the secretmanager.RegionalSecretVersion datasource, but it only requires the [Secret Manager Secret Accessor](https://cloud.google.com/secret-manager/docs/access-control#secretmanager.secretAccessor) role. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/regional-secrets-overview) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.locations.secrets.versions/access).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    latest = gcp.secretmanager.get_regional_secret_version_access(secret="my-secret",
        location="us-central1")
    ```


    :param _builtins.bool is_secret_data_base64: If set to 'true', the secret data is
           expected to be base64-encoded string.
    :param _builtins.str location: Location of Secret Manager regional secret resource.
           It must be provided when the `secret` field provided consists of only the name of the regional secret.
    :param _builtins.str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param _builtins.str secret: The regional secret to get the secret version for.
           This can be either the reference of the regional secret as in `projects/{{project}}/locations/{{location}}/secrets/{{secret_id}}` or only the name of the regional secret as in `{{secret_id}}`. If only the name of the regional secret is provided, the location must also be provided.
    :param _builtins.str version: The version of the regional secret to get. If it
           is not provided, the latest version is retrieved.
    """
    __args__ = dict()
    __args__['isSecretDataBase64'] = is_secret_data_base64
    __args__['location'] = location
    __args__['project'] = project
    __args__['secret'] = secret
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:secretmanager/getRegionalSecretVersionAccess:getRegionalSecretVersionAccess', __args__, opts=opts, typ=GetRegionalSecretVersionAccessResult)
    return __ret__.apply(lambda __response__: GetRegionalSecretVersionAccessResult(
        id=pulumi.get(__response__, 'id'),
        is_secret_data_base64=pulumi.get(__response__, 'is_secret_data_base64'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        secret=pulumi.get(__response__, 'secret'),
        secret_data=pulumi.get(__response__, 'secret_data'),
        version=pulumi.get(__response__, 'version')))
