# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HookArgs', 'Hook']

@pulumi.input_type
class HookArgs:
    def __init__(__self__, *,
                 hook_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 repository_id: pulumi.Input[_builtins.str],
                 target_uri: pulumi.Input[_builtins.str],
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_option: Optional[pulumi.Input['HookPushOptionArgs']] = None,
                 sensitive_query_string: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Hook resource.
        :param pulumi.Input[_builtins.str] hook_id: The ID for the Hook.
        :param pulumi.Input[_builtins.str] location: The location for the Repository.
        :param pulumi.Input[_builtins.str] repository_id: The ID for the Repository.
        :param pulumi.Input[_builtins.str] target_uri: The target URI to which the payloads will be delivered.
        :param pulumi.Input[_builtins.bool] disabled: Determines if the hook disabled or not.
               Set to true to stop sending traffic.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: The events that trigger hook on.
               Each value may be one of: `PUSH`, `PULL_REQUEST`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['HookPushOptionArgs'] push_option: The trigger option for push events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] sensitive_query_string: The sensitive query string to be appended to the target URI.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "hook_id", hook_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "target_uri", target_uri)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if push_option is not None:
            pulumi.set(__self__, "push_option", push_option)
        if sensitive_query_string is not None:
            pulumi.set(__self__, "sensitive_query_string", sensitive_query_string)

    @_builtins.property
    @pulumi.getter(name="hookId")
    def hook_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID for the Hook.
        """
        return pulumi.get(self, "hook_id")

    @hook_id.setter
    def hook_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hook_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID for the Repository.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> pulumi.Input[_builtins.str]:
        """
        The target URI to which the payloads will be delivered.
        """
        return pulumi.get(self, "target_uri")

    @target_uri.setter
    def target_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_uri", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the hook disabled or not.
        Set to true to stop sending traffic.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The events that trigger hook on.
        Each value may be one of: `PUSH`, `PULL_REQUEST`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "events", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pushOption")
    def push_option(self) -> Optional[pulumi.Input['HookPushOptionArgs']]:
        """
        The trigger option for push events.
        Structure is documented below.
        """
        return pulumi.get(self, "push_option")

    @push_option.setter
    def push_option(self, value: Optional[pulumi.Input['HookPushOptionArgs']]):
        pulumi.set(self, "push_option", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveQueryString")
    def sensitive_query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sensitive query string to be appended to the target URI.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "sensitive_query_string")

    @sensitive_query_string.setter
    def sensitive_query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sensitive_query_string", value)


@pulumi.input_type
class _HookState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_option: Optional[pulumi.Input['HookPushOptionArgs']] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 target_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Hook resources.
        :param pulumi.Input[_builtins.str] create_time: Create timestamp.
        :param pulumi.Input[_builtins.bool] disabled: Determines if the hook disabled or not.
               Set to true to stop sending traffic.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: The events that trigger hook on.
               Each value may be one of: `PUSH`, `PULL_REQUEST`.
        :param pulumi.Input[_builtins.str] hook_id: The ID for the Hook.
        :param pulumi.Input[_builtins.str] location: The location for the Repository.
        :param pulumi.Input[_builtins.str] name: A unique identifier for a Hook. The name should be of the format:
               `projects/{project}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['HookPushOptionArgs'] push_option: The trigger option for push events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] repository_id: The ID for the Repository.
        :param pulumi.Input[_builtins.str] sensitive_query_string: The sensitive query string to be appended to the target URI.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] target_uri: The target URI to which the payloads will be delivered.
        :param pulumi.Input[_builtins.str] uid: Unique identifier of the hook.
        :param pulumi.Input[_builtins.str] update_time: Update timestamp.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if hook_id is not None:
            pulumi.set(__self__, "hook_id", hook_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if push_option is not None:
            pulumi.set(__self__, "push_option", push_option)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if sensitive_query_string is not None:
            pulumi.set(__self__, "sensitive_query_string", sensitive_query_string)
        if target_uri is not None:
            pulumi.set(__self__, "target_uri", target_uri)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create timestamp.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the hook disabled or not.
        Set to true to stop sending traffic.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The events that trigger hook on.
        Each value may be one of: `PUSH`, `PULL_REQUEST`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "events", value)

    @_builtins.property
    @pulumi.getter(name="hookId")
    def hook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID for the Hook.
        """
        return pulumi.get(self, "hook_id")

    @hook_id.setter
    def hook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hook_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for a Hook. The name should be of the format:
        `projects/{project}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pushOption")
    def push_option(self) -> Optional[pulumi.Input['HookPushOptionArgs']]:
        """
        The trigger option for push events.
        Structure is documented below.
        """
        return pulumi.get(self, "push_option")

    @push_option.setter
    def push_option(self, value: Optional[pulumi.Input['HookPushOptionArgs']]):
        pulumi.set(self, "push_option", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID for the Repository.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveQueryString")
    def sensitive_query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sensitive query string to be appended to the target URI.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "sensitive_query_string")

    @sensitive_query_string.setter
    def sensitive_query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sensitive_query_string", value)

    @_builtins.property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The target URI to which the payloads will be delivered.
        """
        return pulumi.get(self, "target_uri")

    @target_uri.setter
    def target_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_uri", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the hook.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update timestamp.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:securesourcemanager/hook:Hook")
class Hook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_option: Optional[pulumi.Input[Union['HookPushOptionArgs', 'HookPushOptionArgsDict']]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 target_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Hook is a user-defined HTTP callback triggered by an event.

        To get more information about Hook, see:
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/overview)

        ## Example Usage

        ## Import

        Hook can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/hooks/{{hook_id}}`

        * `{{project}}/{{location}}/{{repository_id}}/{{hook_id}}`

        * `{{location}}/{{repository_id}}/{{hook_id}}`

        * `{{hook_id}}`

        When using the `pulumi import` command, Hook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/hooks/{{hook_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default {{project}}/{{location}}/{{repository_id}}/{{hook_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default {{location}}/{{repository_id}}/{{hook_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default {{hook_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: Determines if the hook disabled or not.
               Set to true to stop sending traffic.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: The events that trigger hook on.
               Each value may be one of: `PUSH`, `PULL_REQUEST`.
        :param pulumi.Input[_builtins.str] hook_id: The ID for the Hook.
        :param pulumi.Input[_builtins.str] location: The location for the Repository.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['HookPushOptionArgs', 'HookPushOptionArgsDict']] push_option: The trigger option for push events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] repository_id: The ID for the Repository.
        :param pulumi.Input[_builtins.str] sensitive_query_string: The sensitive query string to be appended to the target URI.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] target_uri: The target URI to which the payloads will be delivered.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Hook is a user-defined HTTP callback triggered by an event.

        To get more information about Hook, see:
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/overview)

        ## Example Usage

        ## Import

        Hook can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/hooks/{{hook_id}}`

        * `{{project}}/{{location}}/{{repository_id}}/{{hook_id}}`

        * `{{location}}/{{repository_id}}/{{hook_id}}`

        * `{{hook_id}}`

        When using the `pulumi import` command, Hook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/hooks/{{hook_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default {{project}}/{{location}}/{{repository_id}}/{{hook_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default {{location}}/{{repository_id}}/{{hook_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/hook:Hook default {{hook_id}}
        ```

        :param str resource_name: The name of the resource.
        :param HookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 push_option: Optional[pulumi.Input[Union['HookPushOptionArgs', 'HookPushOptionArgsDict']]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 target_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HookArgs.__new__(HookArgs)

            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["events"] = events
            if hook_id is None and not opts.urn:
                raise TypeError("Missing required property 'hook_id'")
            __props__.__dict__["hook_id"] = hook_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["push_option"] = push_option
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["sensitive_query_string"] = None if sensitive_query_string is None else pulumi.Output.secret(sensitive_query_string)
            if target_uri is None and not opts.urn:
                raise TypeError("Missing required property 'target_uri'")
            __props__.__dict__["target_uri"] = target_uri
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sensitiveQueryString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Hook, __self__).__init__(
            'gcp:securesourcemanager/hook:Hook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hook_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            push_option: Optional[pulumi.Input[Union['HookPushOptionArgs', 'HookPushOptionArgsDict']]] = None,
            repository_id: Optional[pulumi.Input[_builtins.str]] = None,
            sensitive_query_string: Optional[pulumi.Input[_builtins.str]] = None,
            target_uri: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Hook':
        """
        Get an existing Hook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Create timestamp.
        :param pulumi.Input[_builtins.bool] disabled: Determines if the hook disabled or not.
               Set to true to stop sending traffic.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: The events that trigger hook on.
               Each value may be one of: `PUSH`, `PULL_REQUEST`.
        :param pulumi.Input[_builtins.str] hook_id: The ID for the Hook.
        :param pulumi.Input[_builtins.str] location: The location for the Repository.
        :param pulumi.Input[_builtins.str] name: A unique identifier for a Hook. The name should be of the format:
               `projects/{project}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['HookPushOptionArgs', 'HookPushOptionArgsDict']] push_option: The trigger option for push events.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] repository_id: The ID for the Repository.
        :param pulumi.Input[_builtins.str] sensitive_query_string: The sensitive query string to be appended to the target URI.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] target_uri: The target URI to which the payloads will be delivered.
        :param pulumi.Input[_builtins.str] uid: Unique identifier of the hook.
        :param pulumi.Input[_builtins.str] update_time: Update timestamp.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HookState.__new__(_HookState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["events"] = events
        __props__.__dict__["hook_id"] = hook_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["push_option"] = push_option
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["sensitive_query_string"] = sensitive_query_string
        __props__.__dict__["target_uri"] = target_uri
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Hook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create timestamp.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines if the hook disabled or not.
        Set to true to stop sending traffic.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def events(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The events that trigger hook on.
        Each value may be one of: `PUSH`, `PULL_REQUEST`.
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter(name="hookId")
    def hook_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID for the Hook.
        """
        return pulumi.get(self, "hook_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the Repository.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for a Hook. The name should be of the format:
        `projects/{project}/locations/{location_id}/repositories/{repository_id}/hooks/{hook_id}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pushOption")
    def push_option(self) -> pulumi.Output['outputs.HookPushOption']:
        """
        The trigger option for push events.
        Structure is documented below.
        """
        return pulumi.get(self, "push_option")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID for the Repository.
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="sensitiveQueryString")
    def sensitive_query_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The sensitive query string to be appended to the target URI.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "sensitive_query_string")

    @_builtins.property
    @pulumi.getter(name="targetUri")
    def target_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The target URI to which the payloads will be delivered.
        """
        return pulumi.get(self, "target_uri")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the hook.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Update timestamp.
        """
        return pulumi.get(self, "update_time")

