# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FolderNotificationConfigArgs', 'FolderNotificationConfig']

@pulumi.input_type
class FolderNotificationConfigArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.str],
                 folder: pulumi.Input[_builtins.str],
                 pubsub_topic: pulumi.Input[_builtins.str],
                 streaming_config: pulumi.Input['FolderNotificationConfigStreamingConfigArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FolderNotificationConfig resource.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] folder: Numerical ID of the parent folder.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        :param pulumi.Input['FolderNotificationConfigStreamingConfigArgs'] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "folder", folder)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        pulumi.set(__self__, "streaming_config", streaming_config)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.str]:
        """
        This must be unique within the organization.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Input[_builtins.str]:
        """
        Numerical ID of the parent folder.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> pulumi.Input[_builtins.str]:
        """
        The Pub/Sub topic to send notifications to. Its format is
        "projects/[project_id]/topics/[topic]".
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pubsub_topic", value)

    @_builtins.property
    @pulumi.getter(name="streamingConfig")
    def streaming_config(self) -> pulumi.Input['FolderNotificationConfigStreamingConfigArgs']:
        """
        The config for triggering streaming-based notifications.
        Structure is documented below.
        """
        return pulumi.get(self, "streaming_config")

    @streaming_config.setter
    def streaming_config(self, value: pulumi.Input['FolderNotificationConfigStreamingConfigArgs']):
        pulumi.set(self, "streaming_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _FolderNotificationConfigState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_config: Optional[pulumi.Input['FolderNotificationConfigStreamingConfigArgs']] = None):
        """
        Input properties used for looking up and filtering FolderNotificationConfig resources.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] folder: Numerical ID of the parent folder.
        :param pulumi.Input[_builtins.str] name: The resource name of this notification config, in the format
               `folders/{{folder}}/notificationConfigs/{{config_id}}`.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        :param pulumi.Input[_builtins.str] service_account: The service account that needs "pubsub.topics.publish" permission to
               publish to the Pub/Sub topic.
        :param pulumi.Input['FolderNotificationConfigStreamingConfigArgs'] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if streaming_config is not None:
            pulumi.set(__self__, "streaming_config", streaming_config)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This must be unique within the organization.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Numerical ID of the parent folder.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of this notification config, in the format
        `folders/{{folder}}/notificationConfigs/{{config_id}}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Pub/Sub topic to send notifications to. Its format is
        "projects/[project_id]/topics/[topic]".
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pubsub_topic", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account that needs "pubsub.topics.publish" permission to
        publish to the Pub/Sub topic.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="streamingConfig")
    def streaming_config(self) -> Optional[pulumi.Input['FolderNotificationConfigStreamingConfigArgs']]:
        """
        The config for triggering streaming-based notifications.
        Structure is documented below.
        """
        return pulumi.get(self, "streaming_config")

    @streaming_config.setter
    def streaming_config(self, value: Optional[pulumi.Input['FolderNotificationConfigStreamingConfigArgs']]):
        pulumi.set(self, "streaming_config", value)


@pulumi.type_token("gcp:securitycenter/folderNotificationConfig:FolderNotificationConfig")
class FolderNotificationConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_config: Optional[pulumi.Input[Union['FolderNotificationConfigStreamingConfigArgs', 'FolderNotificationConfigStreamingConfigArgsDict']]] = None,
                 __props__=None):
        """
        A Cloud Security Command Center (Cloud SCC) notification configs. A
        notification config is a Cloud SCC resource that contains the
        configuration to send notifications for create/update events of
        findings, assets and etc.
        > **Note:** In order to use Cloud SCC resources, your organization must be enrolled
        in [SCC Standard/Premium](https://cloud.google.com/security-command-center/docs/quickstart-security-command-center).
        Without doing so, you may run into errors during resource creation.

        To get more information about FolderNotificationConfig, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/folders.notificationConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs)

        ## Example Usage

        ### Scc Folder Notification Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            parent="organizations/123456789",
            display_name="folder-name")
        scc_folder_notification_config = gcp.pubsub.Topic("scc_folder_notification_config", name="my-topic")
        custom_notification_config = gcp.securitycenter.FolderNotificationConfig("custom_notification_config",
            config_id="my-config",
            folder=folder.folder_id,
            location="global",
            description="My custom Cloud Security Command Center Finding Notification Configuration",
            pubsub_topic=scc_folder_notification_config.id,
            streaming_config={
                "filter": "category = \\"OPEN_FIREWALL\\" AND state = \\"ACTIVE\\"",
            })
        ```

        ## Import

        FolderNotificationConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/notificationConfigs/{{config_id}}`

        * `{{folder}}/{{config_id}}`

        When using the `pulumi import` command, FolderNotificationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/folderNotificationConfig:FolderNotificationConfig default folders/{{folder}}/notificationConfigs/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/folderNotificationConfig:FolderNotificationConfig default {{folder}}/{{config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] folder: Numerical ID of the parent folder.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        :param pulumi.Input[Union['FolderNotificationConfigStreamingConfigArgs', 'FolderNotificationConfigStreamingConfigArgsDict']] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FolderNotificationConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Security Command Center (Cloud SCC) notification configs. A
        notification config is a Cloud SCC resource that contains the
        configuration to send notifications for create/update events of
        findings, assets and etc.
        > **Note:** In order to use Cloud SCC resources, your organization must be enrolled
        in [SCC Standard/Premium](https://cloud.google.com/security-command-center/docs/quickstart-security-command-center).
        Without doing so, you may run into errors during resource creation.

        To get more information about FolderNotificationConfig, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/folders.notificationConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs)

        ## Example Usage

        ### Scc Folder Notification Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            parent="organizations/123456789",
            display_name="folder-name")
        scc_folder_notification_config = gcp.pubsub.Topic("scc_folder_notification_config", name="my-topic")
        custom_notification_config = gcp.securitycenter.FolderNotificationConfig("custom_notification_config",
            config_id="my-config",
            folder=folder.folder_id,
            location="global",
            description="My custom Cloud Security Command Center Finding Notification Configuration",
            pubsub_topic=scc_folder_notification_config.id,
            streaming_config={
                "filter": "category = \\"OPEN_FIREWALL\\" AND state = \\"ACTIVE\\"",
            })
        ```

        ## Import

        FolderNotificationConfig can be imported using any of these accepted formats:

        * `folders/{{folder}}/notificationConfigs/{{config_id}}`

        * `{{folder}}/{{config_id}}`

        When using the `pulumi import` command, FolderNotificationConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/folderNotificationConfig:FolderNotificationConfig default folders/{{folder}}/notificationConfigs/{{config_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/folderNotificationConfig:FolderNotificationConfig default {{folder}}/{{config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param FolderNotificationConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderNotificationConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_config: Optional[pulumi.Input[Union['FolderNotificationConfigStreamingConfigArgs', 'FolderNotificationConfigStreamingConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderNotificationConfigArgs.__new__(FolderNotificationConfigArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["description"] = description
            if folder is None and not opts.urn:
                raise TypeError("Missing required property 'folder'")
            __props__.__dict__["folder"] = folder
            if pubsub_topic is None and not opts.urn:
                raise TypeError("Missing required property 'pubsub_topic'")
            __props__.__dict__["pubsub_topic"] = pubsub_topic
            if streaming_config is None and not opts.urn:
                raise TypeError("Missing required property 'streaming_config'")
            __props__.__dict__["streaming_config"] = streaming_config
            __props__.__dict__["name"] = None
            __props__.__dict__["service_account"] = None
        super(FolderNotificationConfig, __self__).__init__(
            'gcp:securitycenter/folderNotificationConfig:FolderNotificationConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            streaming_config: Optional[pulumi.Input[Union['FolderNotificationConfigStreamingConfigArgs', 'FolderNotificationConfigStreamingConfigArgsDict']]] = None) -> 'FolderNotificationConfig':
        """
        Get an existing FolderNotificationConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] folder: Numerical ID of the parent folder.
        :param pulumi.Input[_builtins.str] name: The resource name of this notification config, in the format
               `folders/{{folder}}/notificationConfigs/{{config_id}}`.
        :param pulumi.Input[_builtins.str] pubsub_topic: The Pub/Sub topic to send notifications to. Its format is
               "projects/[project_id]/topics/[topic]".
        :param pulumi.Input[_builtins.str] service_account: The service account that needs "pubsub.topics.publish" permission to
               publish to the Pub/Sub topic.
        :param pulumi.Input[Union['FolderNotificationConfigStreamingConfigArgs', 'FolderNotificationConfigStreamingConfigArgsDict']] streaming_config: The config for triggering streaming-based notifications.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FolderNotificationConfigState.__new__(_FolderNotificationConfigState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["description"] = description
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["pubsub_topic"] = pubsub_topic
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["streaming_config"] = streaming_config
        return FolderNotificationConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.str]:
        """
        This must be unique within the organization.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[_builtins.str]:
        """
        Numerical ID of the parent folder.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of this notification config, in the format
        `folders/{{folder}}/notificationConfigs/{{config_id}}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> pulumi.Output[_builtins.str]:
        """
        The Pub/Sub topic to send notifications to. Its format is
        "projects/[project_id]/topics/[topic]".
        """
        return pulumi.get(self, "pubsub_topic")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[_builtins.str]:
        """
        The service account that needs "pubsub.topics.publish" permission to
        publish to the Pub/Sub topic.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="streamingConfig")
    def streaming_config(self) -> pulumi.Output['outputs.FolderNotificationConfigStreamingConfig']:
        """
        The config for triggering streaming-based notifications.
        Structure is documented below.
        """
        return pulumi.get(self, "streaming_config")

