# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OrganizationSccBigQueryExportArgs', 'OrganizationSccBigQueryExport']

@pulumi.input_type
class OrganizationSccBigQueryExportArgs:
    def __init__(__self__, *,
                 big_query_export_id: pulumi.Input[_builtins.str],
                 organization: pulumi.Input[_builtins.str],
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationSccBigQueryExport resource.
        :param pulumi.Input[_builtins.str] big_query_export_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] organization: The organization whose Cloud Security Command Center the Big Query Export
               Config lives in.
        :param pulumi.Input[_builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * \\>, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        """
        pulumi.set(__self__, "big_query_export_id", big_query_export_id)
        pulumi.set(__self__, "organization", organization)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @_builtins.property
    @pulumi.getter(name="bigQueryExportId")
    def big_query_export_id(self) -> pulumi.Input[_builtins.str]:
        """
        This must be unique within the organization.
        """
        return pulumi.get(self, "big_query_export_id")

    @big_query_export_id.setter
    def big_query_export_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "big_query_export_id", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        The organization whose Cloud Security Command Center the Big Query Export
        Config lives in.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataset to write findings' updates to.
        Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
        BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expression that defines the filter to apply across create/update
        events of findings. The
        expression is a list of zero or more restrictions combined via
        logical operators AND and OR. Parentheses are supported, and OR
        has higher precedence than AND.
        Restrictions have the form <field> <operator> <value> and may have
        a - character in front of them to indicate negation. The fields
        map to those defined in the corresponding resource.
        The supported operators are:
        * = for all value types.
        * \\>, <, >=, <= for integer values.
        * :, meaning substring matching, for strings.
        The supported value types are:
        * string literals in quotes.
        * integer literals without quotes.
        * boolean literals true and false without quotes.
        See
        [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
        for information on how to write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class _OrganizationSccBigQueryExportState:
    def __init__(__self__, *,
                 big_query_export_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 most_recent_editor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationSccBigQueryExport resources.
        :param pulumi.Input[_builtins.str] big_query_export_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] create_time: The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * \\>, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        :param pulumi.Input[_builtins.str] most_recent_editor: Email address of the user who last edited the BigQuery export.
               This field is set by the server and will be ignored if provided on export creation or update.
        :param pulumi.Input[_builtins.str] name: The resource name of this export, in the format
               `organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}`.
               This field is provided in responses, and is ignored when provided in create requests.
        :param pulumi.Input[_builtins.str] organization: The organization whose Cloud Security Command Center the Big Query Export
               Config lives in.
        :param pulumi.Input[_builtins.str] principal: The service account that needs permission to create table and upload data to the BigQuery dataset.
        :param pulumi.Input[_builtins.str] update_time: The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if big_query_export_id is not None:
            pulumi.set(__self__, "big_query_export_id", big_query_export_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if most_recent_editor is not None:
            pulumi.set(__self__, "most_recent_editor", most_recent_editor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="bigQueryExportId")
    def big_query_export_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This must be unique within the organization.
        """
        return pulumi.get(self, "big_query_export_id")

    @big_query_export_id.setter
    def big_query_export_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "big_query_export_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataset to write findings' updates to.
        Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
        BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expression that defines the filter to apply across create/update
        events of findings. The
        expression is a list of zero or more restrictions combined via
        logical operators AND and OR. Parentheses are supported, and OR
        has higher precedence than AND.
        Restrictions have the form <field> <operator> <value> and may have
        a - character in front of them to indicate negation. The fields
        map to those defined in the corresponding resource.
        The supported operators are:
        * = for all value types.
        * \\>, <, >=, <= for integer values.
        * :, meaning substring matching, for strings.
        The supported value types are:
        * string literals in quotes.
        * integer literals without quotes.
        * boolean literals true and false without quotes.
        See
        [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
        for information on how to write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the user who last edited the BigQuery export.
        This field is set by the server and will be ignored if provided on export creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @most_recent_editor.setter
    def most_recent_editor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "most_recent_editor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of this export, in the format
        `organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}`.
        This field is provided in responses, and is ignored when provided in create requests.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization whose Cloud Security Command Center the Big Query Export
        Config lives in.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account that needs permission to create table and upload data to the BigQuery dataset.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:securitycenter/organizationSccBigQueryExport:OrganizationSccBigQueryExport")
class OrganizationSccBigQueryExport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_query_export_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Cloud Security Command Center (Cloud SCC) Big Query Export Config.
        It represents exporting Security Command Center data, including assets, findings, and security marks
        using gcloud scc bqexports
        > **Note:** In order to use Cloud SCC resources, your organization must be enrolled
        in [SCC Standard/Premium](https://cloud.google.com/security-command-center/docs/quickstart-security-command-center).
        Without doing so, you may run into errors during resource creation.

        To get more information about OrganizationSccBigQueryExport, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/organizations.bigQueryExports)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs/how-to-analyze-findings-in-big-query)

        ## Example Usage

        ### Scc Organization Big Query Export Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.bigquery.Dataset("default",
            dataset_id="my-dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            default_table_expiration_ms=3600000,
            default_partition_expiration_ms=None,
            labels={
                "env": "default",
            })
        custom_big_query_export_config = gcp.securitycenter.OrganizationSccBigQueryExport("custom_big_query_export_config",
            name="my-export",
            big_query_export_id="my-export",
            organization="123456789",
            dataset=default.id,
            description="Cloud Security Command Center Findings Big Query Export Config",
            filter="state=\\"ACTIVE\\" AND NOT mute=\\"MUTED\\"")
        ```

        ## Import

        OrganizationSccBigQueryExport can be imported using any of these accepted formats:

        * `organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}`

        * `{{organization}}/{{big_query_export_id}}`

        When using the `pulumi import` command, OrganizationSccBigQueryExport can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/organizationSccBigQueryExport:OrganizationSccBigQueryExport default organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/organizationSccBigQueryExport:OrganizationSccBigQueryExport default {{organization}}/{{big_query_export_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] big_query_export_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * \\>, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        :param pulumi.Input[_builtins.str] organization: The organization whose Cloud Security Command Center the Big Query Export
               Config lives in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationSccBigQueryExportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Security Command Center (Cloud SCC) Big Query Export Config.
        It represents exporting Security Command Center data, including assets, findings, and security marks
        using gcloud scc bqexports
        > **Note:** In order to use Cloud SCC resources, your organization must be enrolled
        in [SCC Standard/Premium](https://cloud.google.com/security-command-center/docs/quickstart-security-command-center).
        Without doing so, you may run into errors during resource creation.

        To get more information about OrganizationSccBigQueryExport, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/rest/v1/organizations.bigQueryExports)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/security-command-center/docs/how-to-analyze-findings-in-big-query)

        ## Example Usage

        ### Scc Organization Big Query Export Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.bigquery.Dataset("default",
            dataset_id="my-dataset",
            friendly_name="test",
            description="This is a test description",
            location="US",
            default_table_expiration_ms=3600000,
            default_partition_expiration_ms=None,
            labels={
                "env": "default",
            })
        custom_big_query_export_config = gcp.securitycenter.OrganizationSccBigQueryExport("custom_big_query_export_config",
            name="my-export",
            big_query_export_id="my-export",
            organization="123456789",
            dataset=default.id,
            description="Cloud Security Command Center Findings Big Query Export Config",
            filter="state=\\"ACTIVE\\" AND NOT mute=\\"MUTED\\"")
        ```

        ## Import

        OrganizationSccBigQueryExport can be imported using any of these accepted formats:

        * `organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}`

        * `{{organization}}/{{big_query_export_id}}`

        When using the `pulumi import` command, OrganizationSccBigQueryExport can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securitycenter/organizationSccBigQueryExport:OrganizationSccBigQueryExport default organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}
        ```

        ```sh
        $ pulumi import gcp:securitycenter/organizationSccBigQueryExport:OrganizationSccBigQueryExport default {{organization}}/{{big_query_export_id}}
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationSccBigQueryExportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationSccBigQueryExportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_query_export_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationSccBigQueryExportArgs.__new__(OrganizationSccBigQueryExportArgs)

            if big_query_export_id is None and not opts.urn:
                raise TypeError("Missing required property 'big_query_export_id'")
            __props__.__dict__["big_query_export_id"] = big_query_export_id
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["description"] = description
            __props__.__dict__["filter"] = filter
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["create_time"] = None
            __props__.__dict__["most_recent_editor"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["principal"] = None
            __props__.__dict__["update_time"] = None
        super(OrganizationSccBigQueryExport, __self__).__init__(
            'gcp:securitycenter/organizationSccBigQueryExport:OrganizationSccBigQueryExport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            big_query_export_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dataset: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[_builtins.str]] = None,
            most_recent_editor: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationSccBigQueryExport':
        """
        Get an existing OrganizationSccBigQueryExport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] big_query_export_id: This must be unique within the organization.
        :param pulumi.Input[_builtins.str] create_time: The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] dataset: The dataset to write findings' updates to.
               Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
               BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        :param pulumi.Input[_builtins.str] description: The description of the notification config (max of 1024 characters).
        :param pulumi.Input[_builtins.str] filter: Expression that defines the filter to apply across create/update
               events of findings. The
               expression is a list of zero or more restrictions combined via
               logical operators AND and OR. Parentheses are supported, and OR
               has higher precedence than AND.
               Restrictions have the form <field> <operator> <value> and may have
               a - character in front of them to indicate negation. The fields
               map to those defined in the corresponding resource.
               The supported operators are:
               * = for all value types.
               * \\>, <, >=, <= for integer values.
               * :, meaning substring matching, for strings.
               The supported value types are:
               * string literals in quotes.
               * integer literals without quotes.
               * boolean literals true and false without quotes.
               See
               [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
               for information on how to write a filter.
        :param pulumi.Input[_builtins.str] most_recent_editor: Email address of the user who last edited the BigQuery export.
               This field is set by the server and will be ignored if provided on export creation or update.
        :param pulumi.Input[_builtins.str] name: The resource name of this export, in the format
               `organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}`.
               This field is provided in responses, and is ignored when provided in create requests.
        :param pulumi.Input[_builtins.str] organization: The organization whose Cloud Security Command Center the Big Query Export
               Config lives in.
        :param pulumi.Input[_builtins.str] principal: The service account that needs permission to create table and upload data to the BigQuery dataset.
        :param pulumi.Input[_builtins.str] update_time: The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationSccBigQueryExportState.__new__(_OrganizationSccBigQueryExportState)

        __props__.__dict__["big_query_export_id"] = big_query_export_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["description"] = description
        __props__.__dict__["filter"] = filter
        __props__.__dict__["most_recent_editor"] = most_recent_editor
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["principal"] = principal
        __props__.__dict__["update_time"] = update_time
        return OrganizationSccBigQueryExport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bigQueryExportId")
    def big_query_export_id(self) -> pulumi.Output[_builtins.str]:
        """
        This must be unique within the organization.
        """
        return pulumi.get(self, "big_query_export_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the BigQuery export was created. This field is set by the server and will be ignored if provided on export on creation.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The dataset to write findings' updates to.
        Its format is "projects/[projectId]/datasets/[bigquery_dataset_id]".
        BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Expression that defines the filter to apply across create/update
        events of findings. The
        expression is a list of zero or more restrictions combined via
        logical operators AND and OR. Parentheses are supported, and OR
        has higher precedence than AND.
        Restrictions have the form <field> <operator> <value> and may have
        a - character in front of them to indicate negation. The fields
        map to those defined in the corresponding resource.
        The supported operators are:
        * = for all value types.
        * \\>, <, >=, <= for integer values.
        * :, meaning substring matching, for strings.
        The supported value types are:
        * string literals in quotes.
        * integer literals without quotes.
        * boolean literals true and false without quotes.
        See
        [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
        for information on how to write a filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the user who last edited the BigQuery export.
        This field is set by the server and will be ignored if provided on export creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of this export, in the format
        `organizations/{{organization}}/bigQueryExports/{{big_query_export_id}}`.
        This field is provided in responses, and is ignored when provided in create requests.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        The organization whose Cloud Security Command Center the Big Query Export
        Config lives in.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        The service account that needs permission to create table and upload data to the BigQuery dataset.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The most recent time at which the BigQuery export was updated. This field is set by the server and will be ignored if provided on export creation or update.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

