# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['V2OrganizationSourceIamPolicyArgs', 'V2OrganizationSourceIamPolicy']

@pulumi.input_type
class V2OrganizationSourceIamPolicyArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[_builtins.str],
                 policy_data: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a V2OrganizationSourceIamPolicy resource.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] source: Used to find the parent resource to bind the IAM policy to
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "policy_data", policy_data)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Input[_builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_data", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _V2OrganizationSourceIamPolicyState:
    def __init__(__self__, *,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering V2OrganizationSourceIamPolicy resources.
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] source: Used to find the parent resource to bind the IAM policy to
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if policy_data is not None:
            pulumi.set(__self__, "policy_data", policy_data)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_data", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.type_token("gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy")
class V2OrganizationSourceIamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Three different resources help you manage your IAM policy for Security Command Center (SCC) v2 API OrganizationSource. Each of these resources serves a different use case:

        * `securitycenter.V2OrganizationSourceIamPolicy`: Authoritative. Sets the IAM policy for the organizationsource and replaces any existing policy already attached.
        * `securitycenter.V2OrganizationSourceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the organizationsource are preserved.
        * `securitycenter.V2OrganizationSourceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the organizationsource are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `securitycenter.V2OrganizationSourceIamPolicy`: Retrieves the IAM policy for the organizationsource

        > **Note:** `securitycenter.V2OrganizationSourceIamPolicy` **cannot** be used in conjunction with `securitycenter.V2OrganizationSourceIamBinding` and `securitycenter.V2OrganizationSourceIamMember` or they will fight over what your policy should be.

        > **Note:** `securitycenter.V2OrganizationSourceIamBinding` resources **can be** used in conjunction with `securitycenter.V2OrganizationSourceIamMember` resources **only if** they do not grant privilege to the same role.

        ## securitycenter.V2OrganizationSourceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/viewer",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.securitycenter.V2OrganizationSourceIamPolicy("policy",
            source=custom_source["name"],
            policy_data=admin.policy_data)
        ```

        ## securitycenter.V2OrganizationSourceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.securitycenter.V2OrganizationSourceIamBinding("binding",
            source=custom_source["name"],
            role="roles/viewer",
            members=["user:jane@example.com"])
        ```

        ## securitycenter.V2OrganizationSourceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.securitycenter.V2OrganizationSourceIamMember("member",
            source=custom_source["name"],
            role="roles/viewer",
            member="user:jane@example.com")
        ```

        ## > **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.
        ---

        # IAM policy for Security Command Center (SCC) v2 API OrganizationSource

        Three different resources help you manage your IAM policy for Security Command Center (SCC) v2 API OrganizationSource. Each of these resources serves a different use case:

        * `securitycenter.V2OrganizationSourceIamPolicy`: Authoritative. Sets the IAM policy for the organizationsource and replaces any existing policy already attached.
        * `securitycenter.V2OrganizationSourceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the organizationsource are preserved.
        * `securitycenter.V2OrganizationSourceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the organizationsource are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `securitycenter.V2OrganizationSourceIamPolicy`: Retrieves the IAM policy for the organizationsource

        > **Note:** `securitycenter.V2OrganizationSourceIamPolicy` **cannot** be used in conjunction with `securitycenter.V2OrganizationSourceIamBinding` and `securitycenter.V2OrganizationSourceIamMember` or they will fight over what your policy should be.

        > **Note:** `securitycenter.V2OrganizationSourceIamBinding` resources **can be** used in conjunction with `securitycenter.V2OrganizationSourceIamMember` resources **only if** they do not grant privilege to the same role.

        ## securitycenter.V2OrganizationSourceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/viewer",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.securitycenter.V2OrganizationSourceIamPolicy("policy",
            source=custom_source["name"],
            policy_data=admin.policy_data)
        ```

        ## securitycenter.V2OrganizationSourceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.securitycenter.V2OrganizationSourceIamBinding("binding",
            source=custom_source["name"],
            role="roles/viewer",
            members=["user:jane@example.com"])
        ```

        ## securitycenter.V2OrganizationSourceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.securitycenter.V2OrganizationSourceIamMember("member",
            source=custom_source["name"],
            role="roles/viewer",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * organizations/{{organization}}/sources/{{source}}

        * {{organization}}/{{source}}

        * {{source}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Security Command Center (SCC) v2 API organizationsource IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy editor "organizations/{{organization}}/sources/{{source}} roles/viewer user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy editor "organizations/{{organization}}/sources/{{source}} roles/viewer"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy editor organizations/{{organization}}/sources/{{source}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] source: Used to find the parent resource to bind the IAM policy to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2OrganizationSourceIamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Three different resources help you manage your IAM policy for Security Command Center (SCC) v2 API OrganizationSource. Each of these resources serves a different use case:

        * `securitycenter.V2OrganizationSourceIamPolicy`: Authoritative. Sets the IAM policy for the organizationsource and replaces any existing policy already attached.
        * `securitycenter.V2OrganizationSourceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the organizationsource are preserved.
        * `securitycenter.V2OrganizationSourceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the organizationsource are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `securitycenter.V2OrganizationSourceIamPolicy`: Retrieves the IAM policy for the organizationsource

        > **Note:** `securitycenter.V2OrganizationSourceIamPolicy` **cannot** be used in conjunction with `securitycenter.V2OrganizationSourceIamBinding` and `securitycenter.V2OrganizationSourceIamMember` or they will fight over what your policy should be.

        > **Note:** `securitycenter.V2OrganizationSourceIamBinding` resources **can be** used in conjunction with `securitycenter.V2OrganizationSourceIamMember` resources **only if** they do not grant privilege to the same role.

        ## securitycenter.V2OrganizationSourceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/viewer",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.securitycenter.V2OrganizationSourceIamPolicy("policy",
            source=custom_source["name"],
            policy_data=admin.policy_data)
        ```

        ## securitycenter.V2OrganizationSourceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.securitycenter.V2OrganizationSourceIamBinding("binding",
            source=custom_source["name"],
            role="roles/viewer",
            members=["user:jane@example.com"])
        ```

        ## securitycenter.V2OrganizationSourceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.securitycenter.V2OrganizationSourceIamMember("member",
            source=custom_source["name"],
            role="roles/viewer",
            member="user:jane@example.com")
        ```

        ## > **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.
        ---

        # IAM policy for Security Command Center (SCC) v2 API OrganizationSource

        Three different resources help you manage your IAM policy for Security Command Center (SCC) v2 API OrganizationSource. Each of these resources serves a different use case:

        * `securitycenter.V2OrganizationSourceIamPolicy`: Authoritative. Sets the IAM policy for the organizationsource and replaces any existing policy already attached.
        * `securitycenter.V2OrganizationSourceIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the organizationsource are preserved.
        * `securitycenter.V2OrganizationSourceIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the organizationsource are preserved.

        A data source can be used to retrieve policy data in advent you do not need creation

        * `securitycenter.V2OrganizationSourceIamPolicy`: Retrieves the IAM policy for the organizationsource

        > **Note:** `securitycenter.V2OrganizationSourceIamPolicy` **cannot** be used in conjunction with `securitycenter.V2OrganizationSourceIamBinding` and `securitycenter.V2OrganizationSourceIamMember` or they will fight over what your policy should be.

        > **Note:** `securitycenter.V2OrganizationSourceIamBinding` resources **can be** used in conjunction with `securitycenter.V2OrganizationSourceIamMember` resources **only if** they do not grant privilege to the same role.

        ## securitycenter.V2OrganizationSourceIamPolicy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/viewer",
            "members": ["user:jane@example.com"],
        }])
        policy = gcp.securitycenter.V2OrganizationSourceIamPolicy("policy",
            source=custom_source["name"],
            policy_data=admin.policy_data)
        ```

        ## securitycenter.V2OrganizationSourceIamBinding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.securitycenter.V2OrganizationSourceIamBinding("binding",
            source=custom_source["name"],
            role="roles/viewer",
            members=["user:jane@example.com"])
        ```

        ## securitycenter.V2OrganizationSourceIamMember

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.securitycenter.V2OrganizationSourceIamMember("member",
            source=custom_source["name"],
            role="roles/viewer",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms:

        * organizations/{{organization}}/sources/{{source}}

        * {{organization}}/{{source}}

        * {{source}}

        Any variables not passed in the import command will be taken from the provider configuration.

        Security Command Center (SCC) v2 API organizationsource IAM resources can be imported using the resource identifiers, role, and member.

        IAM member imports use space-delimited identifiers: the resource in question, the role, and the member identity, e.g.

        ```sh
        $ pulumi import gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy editor "organizations/{{organization}}/sources/{{source}} roles/viewer user:jane@example.com"
        ```

        IAM binding imports use space-delimited identifiers: the resource in question and the role, e.g.

        ```sh
        $ pulumi import gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy editor "organizations/{{organization}}/sources/{{source}} roles/viewer"
        ```

        IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
        $ pulumi import gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy editor organizations/{{organization}}/sources/{{source}}
        ```

        -> **Custom Roles** If you're importing a IAM resource with a custom role, make sure to use the

         full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param V2OrganizationSourceIamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2OrganizationSourceIamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2OrganizationSourceIamPolicyArgs.__new__(V2OrganizationSourceIamPolicyArgs)

            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'policy_data'")
            __props__.__dict__["policy_data"] = policy_data
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["etag"] = None
        super(V2OrganizationSourceIamPolicy, __self__).__init__(
            'gcp:securitycenter/v2OrganizationSourceIamPolicy:V2OrganizationSourceIamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            policy_data: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None) -> 'V2OrganizationSourceIamPolicy':
        """
        Get an existing V2OrganizationSourceIamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[_builtins.str] policy_data: The policy data generated by
               a `organizations_get_iam_policy` data source.
        :param pulumi.Input[_builtins.str] source: Used to find the parent resource to bind the IAM policy to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2OrganizationSourceIamPolicyState.__new__(_V2OrganizationSourceIamPolicyState)

        __props__.__dict__["etag"] = etag
        __props__.__dict__["organization"] = organization
        __props__.__dict__["policy_data"] = policy_data
        __props__.__dict__["source"] = source
        return V2OrganizationSourceIamPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Output[_builtins.str]:
        """
        The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        Used to find the parent resource to bind the IAM policy to
        """
        return pulumi.get(self, "source")

