# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PostureDeploymentArgs', 'PostureDeployment']

@pulumi.input_type
class PostureDeploymentArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 parent: pulumi.Input[_builtins.str],
                 posture_deployment_id: pulumi.Input[_builtins.str],
                 posture_id: pulumi.Input[_builtins.str],
                 posture_revision_id: pulumi.Input[_builtins.str],
                 target_resource: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PostureDeployment resource.
        :param pulumi.Input[_builtins.str] location: The location of the resource, eg. global`.
        :param pulumi.Input[_builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
        :param pulumi.Input[_builtins.str] posture_deployment_id: ID of the posture deployment.
        :param pulumi.Input[_builtins.str] posture_id: Relative name of the posture which needs to be deployed. It should be in the format:
               organizations/{organization_id}/locations/{location}/postures/{posture_id}
        :param pulumi.Input[_builtins.str] posture_revision_id: Revision_id the posture which needs to be deployed.
        :param pulumi.Input[_builtins.str] target_resource: The resource on which the posture should be deployed. This can be in one of the following formats:
               projects/{project_number},
               folders/{folder_number},
               organizations/{organization_id}
        :param pulumi.Input[_builtins.str] description: Description of the posture deployment.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "posture_deployment_id", posture_deployment_id)
        pulumi.set(__self__, "posture_id", posture_id)
        pulumi.set(__self__, "posture_revision_id", posture_revision_id)
        pulumi.set(__self__, "target_resource", target_resource)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the resource, eg. global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Input[_builtins.str]:
        """
        The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="postureDeploymentId")
    def posture_deployment_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the posture deployment.
        """
        return pulumi.get(self, "posture_deployment_id")

    @posture_deployment_id.setter
    def posture_deployment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "posture_deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="postureId")
    def posture_id(self) -> pulumi.Input[_builtins.str]:
        """
        Relative name of the posture which needs to be deployed. It should be in the format:
        organizations/{organization_id}/locations/{location}/postures/{posture_id}
        """
        return pulumi.get(self, "posture_id")

    @posture_id.setter
    def posture_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "posture_id", value)

    @_builtins.property
    @pulumi.getter(name="postureRevisionId")
    def posture_revision_id(self) -> pulumi.Input[_builtins.str]:
        """
        Revision_id the posture which needs to be deployed.
        """
        return pulumi.get(self, "posture_revision_id")

    @posture_revision_id.setter
    def posture_revision_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "posture_revision_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResource")
    def target_resource(self) -> pulumi.Input[_builtins.str]:
        """
        The resource on which the posture should be deployed. This can be in one of the following formats:
        projects/{project_number},
        folders/{folder_number},
        organizations/{organization_id}
        """
        return pulumi.get(self, "target_resource")

    @target_resource.setter
    def target_resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the posture deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _PostureDeploymentState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_posture_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_posture_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_message: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_id: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PostureDeployment resources.
        :param pulumi.Input[_builtins.str] create_time: Time the posture deployment was created in UTC.
        :param pulumi.Input[_builtins.str] description: Description of the posture deployment.
        :param pulumi.Input[_builtins.str] desired_posture_id: This is an output only optional field which will be filled in case when
               PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
               It denotes the desired posture to be deployed.
        :param pulumi.Input[_builtins.str] desired_posture_revision_id: This is an output only optional field which will be filled in case when
               PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
               It denotes the desired posture revision_id to be deployed.
        :param pulumi.Input[_builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input[_builtins.str] failure_message: This is a output only optional field which will be filled in case where
               PostureDeployment enters a failure state like UPDATE_FAILED or
               CREATE_FAILED or DELETE_FAILED. It will have the failure message for posture deployment's
               CREATE/UPDATE/DELETE methods.
        :param pulumi.Input[_builtins.str] location: The location of the resource, eg. global`.
        :param pulumi.Input[_builtins.str] name: Name of the posture deployment instance.
        :param pulumi.Input[_builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
        :param pulumi.Input[_builtins.str] posture_deployment_id: ID of the posture deployment.
        :param pulumi.Input[_builtins.str] posture_id: Relative name of the posture which needs to be deployed. It should be in the format:
               organizations/{organization_id}/locations/{location}/postures/{posture_id}
        :param pulumi.Input[_builtins.str] posture_revision_id: Revision_id the posture which needs to be deployed.
        :param pulumi.Input[_builtins.bool] reconciling: If set, there are currently changes in flight to the posture deployment.
        :param pulumi.Input[_builtins.str] state: State of the posture deployment. A posture deployment can be in the following terminal states:
               ACTIVE, CREATE_FAILED, UPDATE_FAILED, DELETE_FAILED.
        :param pulumi.Input[_builtins.str] target_resource: The resource on which the posture should be deployed. This can be in one of the following formats:
               projects/{project_number},
               folders/{folder_number},
               organizations/{organization_id}
        :param pulumi.Input[_builtins.str] update_time: Time the posture deployment was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_posture_id is not None:
            pulumi.set(__self__, "desired_posture_id", desired_posture_id)
        if desired_posture_revision_id is not None:
            pulumi.set(__self__, "desired_posture_revision_id", desired_posture_revision_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if failure_message is not None:
            pulumi.set(__self__, "failure_message", failure_message)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if posture_deployment_id is not None:
            pulumi.set(__self__, "posture_deployment_id", posture_deployment_id)
        if posture_id is not None:
            pulumi.set(__self__, "posture_id", posture_id)
        if posture_revision_id is not None:
            pulumi.set(__self__, "posture_revision_id", posture_revision_id)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_resource is not None:
            pulumi.set(__self__, "target_resource", target_resource)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the posture deployment was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the posture deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desiredPostureId")
    def desired_posture_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is an output only optional field which will be filled in case when
        PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
        It denotes the desired posture to be deployed.
        """
        return pulumi.get(self, "desired_posture_id")

    @desired_posture_id.setter
    def desired_posture_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_posture_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredPostureRevisionId")
    def desired_posture_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is an output only optional field which will be filled in case when
        PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
        It denotes the desired posture revision_id to be deployed.
        """
        return pulumi.get(self, "desired_posture_revision_id")

    @desired_posture_revision_id.setter
    def desired_posture_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_posture_revision_id", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Resource freshness validation (https://google.aip.dev/154)
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="failureMessage")
    def failure_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is a output only optional field which will be filled in case where
        PostureDeployment enters a failure state like UPDATE_FAILED or
        CREATE_FAILED or DELETE_FAILED. It will have the failure message for posture deployment's
        CREATE/UPDATE/DELETE methods.
        """
        return pulumi.get(self, "failure_message")

    @failure_message.setter
    def failure_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failure_message", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource, eg. global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the posture deployment instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="postureDeploymentId")
    def posture_deployment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the posture deployment.
        """
        return pulumi.get(self, "posture_deployment_id")

    @posture_deployment_id.setter
    def posture_deployment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "posture_deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="postureId")
    def posture_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative name of the posture which needs to be deployed. It should be in the format:
        organizations/{organization_id}/locations/{location}/postures/{posture_id}
        """
        return pulumi.get(self, "posture_id")

    @posture_id.setter
    def posture_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "posture_id", value)

    @_builtins.property
    @pulumi.getter(name="postureRevisionId")
    def posture_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Revision_id the posture which needs to be deployed.
        """
        return pulumi.get(self, "posture_revision_id")

    @posture_revision_id.setter
    def posture_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "posture_revision_id", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, there are currently changes in flight to the posture deployment.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the posture deployment. A posture deployment can be in the following terminal states:
        ACTIVE, CREATE_FAILED, UPDATE_FAILED, DELETE_FAILED.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="targetResource")
    def target_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource on which the posture should be deployed. This can be in one of the following formats:
        projects/{project_number},
        folders/{folder_number},
        organizations/{organization_id}
        """
        return pulumi.get(self, "target_resource")

    @target_resource.setter
    def target_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the posture deployment was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:securityposture/postureDeployment:PostureDeployment")
class PostureDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_id: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a deployment of a security posture on a resource. A posture contains user curated policy sets. A posture can
        be deployed on a project or on a folder or on an organization. To deploy a posture we need to populate the posture's name
        and its revision_id in the posture deployment configuration. Every update to a deployed posture generates a new revision_id.
        Thus, the updated revision_id should be used in the respective posture deployment's configuration to deploy that posture
        on a resource.

        To get more information about PostureDeployment, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/securityposture/rest/v1/organizations.locations.postureDeployments)
        * How-to Guides
            * [Create and deploy a posture](https://cloud.google.com/security-command-center/docs/how-to-use-security-posture)

        ## Import

        PostureDeployment can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/postureDeployments/{{posture_deployment_id}}`

        When using the `pulumi import` command, PostureDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securityposture/postureDeployment:PostureDeployment default {{parent}}/locations/{{location}}/postureDeployments/{{posture_deployment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the posture deployment.
        :param pulumi.Input[_builtins.str] location: The location of the resource, eg. global`.
        :param pulumi.Input[_builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
        :param pulumi.Input[_builtins.str] posture_deployment_id: ID of the posture deployment.
        :param pulumi.Input[_builtins.str] posture_id: Relative name of the posture which needs to be deployed. It should be in the format:
               organizations/{organization_id}/locations/{location}/postures/{posture_id}
        :param pulumi.Input[_builtins.str] posture_revision_id: Revision_id the posture which needs to be deployed.
        :param pulumi.Input[_builtins.str] target_resource: The resource on which the posture should be deployed. This can be in one of the following formats:
               projects/{project_number},
               folders/{folder_number},
               organizations/{organization_id}
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PostureDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a deployment of a security posture on a resource. A posture contains user curated policy sets. A posture can
        be deployed on a project or on a folder or on an organization. To deploy a posture we need to populate the posture's name
        and its revision_id in the posture deployment configuration. Every update to a deployed posture generates a new revision_id.
        Thus, the updated revision_id should be used in the respective posture deployment's configuration to deploy that posture
        on a resource.

        To get more information about PostureDeployment, see:

        * [API documentation](https://cloud.google.com/security-command-center/docs/reference/securityposture/rest/v1/organizations.locations.postureDeployments)
        * How-to Guides
            * [Create and deploy a posture](https://cloud.google.com/security-command-center/docs/how-to-use-security-posture)

        ## Import

        PostureDeployment can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/postureDeployments/{{posture_deployment_id}}`

        When using the `pulumi import` command, PostureDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securityposture/postureDeployment:PostureDeployment default {{parent}}/locations/{{location}}/postureDeployments/{{posture_deployment_id}}
        ```

        :param str resource_name: The name of the resource.
        :param PostureDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PostureDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_id: Optional[pulumi.Input[_builtins.str]] = None,
                 posture_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PostureDeploymentArgs.__new__(PostureDeploymentArgs)

            __props__.__dict__["description"] = description
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if posture_deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'posture_deployment_id'")
            __props__.__dict__["posture_deployment_id"] = posture_deployment_id
            if posture_id is None and not opts.urn:
                raise TypeError("Missing required property 'posture_id'")
            __props__.__dict__["posture_id"] = posture_id
            if posture_revision_id is None and not opts.urn:
                raise TypeError("Missing required property 'posture_revision_id'")
            __props__.__dict__["posture_revision_id"] = posture_revision_id
            if target_resource is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource'")
            __props__.__dict__["target_resource"] = target_resource
            __props__.__dict__["create_time"] = None
            __props__.__dict__["desired_posture_id"] = None
            __props__.__dict__["desired_posture_revision_id"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["failure_message"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(PostureDeployment, __self__).__init__(
            'gcp:securityposture/postureDeployment:PostureDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            desired_posture_id: Optional[pulumi.Input[_builtins.str]] = None,
            desired_posture_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            failure_message: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            posture_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
            posture_id: Optional[pulumi.Input[_builtins.str]] = None,
            posture_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'PostureDeployment':
        """
        Get an existing PostureDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Time the posture deployment was created in UTC.
        :param pulumi.Input[_builtins.str] description: Description of the posture deployment.
        :param pulumi.Input[_builtins.str] desired_posture_id: This is an output only optional field which will be filled in case when
               PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
               It denotes the desired posture to be deployed.
        :param pulumi.Input[_builtins.str] desired_posture_revision_id: This is an output only optional field which will be filled in case when
               PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
               It denotes the desired posture revision_id to be deployed.
        :param pulumi.Input[_builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input[_builtins.str] failure_message: This is a output only optional field which will be filled in case where
               PostureDeployment enters a failure state like UPDATE_FAILED or
               CREATE_FAILED or DELETE_FAILED. It will have the failure message for posture deployment's
               CREATE/UPDATE/DELETE methods.
        :param pulumi.Input[_builtins.str] location: The location of the resource, eg. global`.
        :param pulumi.Input[_builtins.str] name: Name of the posture deployment instance.
        :param pulumi.Input[_builtins.str] parent: The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
        :param pulumi.Input[_builtins.str] posture_deployment_id: ID of the posture deployment.
        :param pulumi.Input[_builtins.str] posture_id: Relative name of the posture which needs to be deployed. It should be in the format:
               organizations/{organization_id}/locations/{location}/postures/{posture_id}
        :param pulumi.Input[_builtins.str] posture_revision_id: Revision_id the posture which needs to be deployed.
        :param pulumi.Input[_builtins.bool] reconciling: If set, there are currently changes in flight to the posture deployment.
        :param pulumi.Input[_builtins.str] state: State of the posture deployment. A posture deployment can be in the following terminal states:
               ACTIVE, CREATE_FAILED, UPDATE_FAILED, DELETE_FAILED.
        :param pulumi.Input[_builtins.str] target_resource: The resource on which the posture should be deployed. This can be in one of the following formats:
               projects/{project_number},
               folders/{folder_number},
               organizations/{organization_id}
        :param pulumi.Input[_builtins.str] update_time: Time the posture deployment was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PostureDeploymentState.__new__(_PostureDeploymentState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_posture_id"] = desired_posture_id
        __props__.__dict__["desired_posture_revision_id"] = desired_posture_revision_id
        __props__.__dict__["etag"] = etag
        __props__.__dict__["failure_message"] = failure_message
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["posture_deployment_id"] = posture_deployment_id
        __props__.__dict__["posture_id"] = posture_id
        __props__.__dict__["posture_revision_id"] = posture_revision_id
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["target_resource"] = target_resource
        __props__.__dict__["update_time"] = update_time
        return PostureDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the posture deployment was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the posture deployment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="desiredPostureId")
    def desired_posture_id(self) -> pulumi.Output[_builtins.str]:
        """
        This is an output only optional field which will be filled in case when
        PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
        It denotes the desired posture to be deployed.
        """
        return pulumi.get(self, "desired_posture_id")

    @_builtins.property
    @pulumi.getter(name="desiredPostureRevisionId")
    def desired_posture_revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        This is an output only optional field which will be filled in case when
        PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
        It denotes the desired posture revision_id to be deployed.
        """
        return pulumi.get(self, "desired_posture_revision_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        For Resource freshness validation (https://google.aip.dev/154)
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="failureMessage")
    def failure_message(self) -> pulumi.Output[_builtins.str]:
        """
        This is a output only optional field which will be filled in case where
        PostureDeployment enters a failure state like UPDATE_FAILED or
        CREATE_FAILED or DELETE_FAILED. It will have the failure message for posture deployment's
        CREATE/UPDATE/DELETE methods.
        """
        return pulumi.get(self, "failure_message")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource, eg. global`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the posture deployment instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        The parent of the resource, an organization. Format should be `organizations/{organization_id}`.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="postureDeploymentId")
    def posture_deployment_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the posture deployment.
        """
        return pulumi.get(self, "posture_deployment_id")

    @_builtins.property
    @pulumi.getter(name="postureId")
    def posture_id(self) -> pulumi.Output[_builtins.str]:
        """
        Relative name of the posture which needs to be deployed. It should be in the format:
        organizations/{organization_id}/locations/{location}/postures/{posture_id}
        """
        return pulumi.get(self, "posture_id")

    @_builtins.property
    @pulumi.getter(name="postureRevisionId")
    def posture_revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        Revision_id the posture which needs to be deployed.
        """
        return pulumi.get(self, "posture_revision_id")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        If set, there are currently changes in flight to the posture deployment.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the posture deployment. A posture deployment can be in the following terminal states:
        ACTIVE, CREATE_FAILED, UPDATE_FAILED, DELETE_FAILED.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetResource")
    def target_resource(self) -> pulumi.Output[_builtins.str]:
        """
        The resource on which the posture should be deployed. This can be in one of the following formats:
        projects/{project_number},
        folders/{folder_number},
        organizations/{organization_id}
        """
        return pulumi.get(self, "target_resource")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the posture deployment was updated in UTC.
        """
        return pulumi.get(self, "update_time")

