# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[_builtins.str],
                 reserved_peering_ranges: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 service: pulumi.Input[_builtins.str],
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 update_on_creation_fail: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[_builtins.str] network: Name of VPC network connected with service producers using VPC peering.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_peering_ranges: Named IP address range(s) of PEERING type reserved for
               this service provider. Note that invoking this method with a different range when connection
               is already established will not reallocate already provisioned service producer subnetworks.
        :param pulumi.Input[_builtins.str] service: Provider peering service that is managing peering connectivity for a
               service provider organization. For Google services that support this functionality it is
               'servicenetworking.googleapis.com'.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the service networking connection. Setting to ABANDON allows the resource to be abandoned rather than deleted. This will enable a successful pulumi destroy when destroying CloudSQL instances. Use with care as it can lead to dangling resources.
        :param pulumi.Input[_builtins.bool] update_on_creation_fail: When set to true, enforce an update of the reserved peering ranges on the existing service networking connection in case of a new connection creation failure.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "reserved_peering_ranges", reserved_peering_ranges)
        pulumi.set(__self__, "service", service)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if update_on_creation_fail is not None:
            pulumi.set(__self__, "update_on_creation_fail", update_on_creation_fail)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        Name of VPC network connected with service producers using VPC peering.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="reservedPeeringRanges")
    def reserved_peering_ranges(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Named IP address range(s) of PEERING type reserved for
        this service provider. Note that invoking this method with a different range when connection
        is already established will not reallocate already provisioned service producer subnetworks.
        """
        return pulumi.get(self, "reserved_peering_ranges")

    @reserved_peering_ranges.setter
    def reserved_peering_ranges(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "reserved_peering_ranges", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        Provider peering service that is managing peering connectivity for a
        service provider organization. For Google services that support this functionality it is
        'servicenetworking.googleapis.com'.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deletion policy for the service networking connection. Setting to ABANDON allows the resource to be abandoned rather than deleted. This will enable a successful pulumi destroy when destroying CloudSQL instances. Use with care as it can lead to dangling resources.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter(name="updateOnCreationFail")
    def update_on_creation_fail(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, enforce an update of the reserved peering ranges on the existing service networking connection in case of a new connection creation failure.
        """
        return pulumi.get(self, "update_on_creation_fail")

    @update_on_creation_fail.setter
    def update_on_creation_fail(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_on_creation_fail", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 peering: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_peering_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 update_on_creation_fail: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the service networking connection. Setting to ABANDON allows the resource to be abandoned rather than deleted. This will enable a successful pulumi destroy when destroying CloudSQL instances. Use with care as it can lead to dangling resources.
        :param pulumi.Input[_builtins.str] network: Name of VPC network connected with service producers using VPC peering.
        :param pulumi.Input[_builtins.str] peering: (Computed) The name of the VPC Network Peering connection that was created by the service producer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_peering_ranges: Named IP address range(s) of PEERING type reserved for
               this service provider. Note that invoking this method with a different range when connection
               is already established will not reallocate already provisioned service producer subnetworks.
        :param pulumi.Input[_builtins.str] service: Provider peering service that is managing peering connectivity for a
               service provider organization. For Google services that support this functionality it is
               'servicenetworking.googleapis.com'.
        :param pulumi.Input[_builtins.bool] update_on_creation_fail: When set to true, enforce an update of the reserved peering ranges on the existing service networking connection in case of a new connection creation failure.
        """
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if peering is not None:
            pulumi.set(__self__, "peering", peering)
        if reserved_peering_ranges is not None:
            pulumi.set(__self__, "reserved_peering_ranges", reserved_peering_ranges)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if update_on_creation_fail is not None:
            pulumi.set(__self__, "update_on_creation_fail", update_on_creation_fail)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deletion policy for the service networking connection. Setting to ABANDON allows the resource to be abandoned rather than deleted. This will enable a successful pulumi destroy when destroying CloudSQL instances. Use with care as it can lead to dangling resources.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of VPC network connected with service producers using VPC peering.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def peering(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The name of the VPC Network Peering connection that was created by the service producer.
        """
        return pulumi.get(self, "peering")

    @peering.setter
    def peering(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering", value)

    @_builtins.property
    @pulumi.getter(name="reservedPeeringRanges")
    def reserved_peering_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Named IP address range(s) of PEERING type reserved for
        this service provider. Note that invoking this method with a different range when connection
        is already established will not reallocate already provisioned service producer subnetworks.
        """
        return pulumi.get(self, "reserved_peering_ranges")

    @reserved_peering_ranges.setter
    def reserved_peering_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "reserved_peering_ranges", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider peering service that is managing peering connectivity for a
        service provider organization. For Google services that support this functionality it is
        'servicenetworking.googleapis.com'.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter(name="updateOnCreationFail")
    def update_on_creation_fail(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, enforce an update of the reserved peering ranges on the existing service networking connection in case of a new connection creation failure.
        """
        return pulumi.get(self, "update_on_creation_fail")

    @update_on_creation_fail.setter
    def update_on_creation_fail(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_on_creation_fail", value)


@pulumi.type_token("gcp:servicenetworking/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_peering_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 update_on_creation_fail: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a private VPC connection with a GCP service provider. For more information see
        [the official documentation](https://cloud.google.com/vpc/docs/configure-private-services-access#creating-connection)
        and
        [API](https://cloud.google.com/service-infrastructure/docs/service-networking/reference/rest/v1/services.connections).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Create a VPC network
        peering_network = gcp.compute.Network("peering_network", name="peering-network")
        # Create an IP address
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="private-ip-alloc",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=peering_network.id)
        # Create a private connection
        default = gcp.servicenetworking.Connection("default",
            network=peering_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        # (Optional) Import or export custom routes
        peering_routes = gcp.compute.NetworkPeeringRoutesConfig("peering_routes",
            peering=default.peering,
            network=peering_network.name,
            import_custom_routes=True,
            export_custom_routes=True)
        ```

        ## Import

        ServiceNetworkingConnection can be imported using any of these accepted formats

        * `{{peering-network}}:{{service}}`

        * `projects/{{project}}/global/networks/{{peering-network}}:{{service}}`

        When using the `pulumi import` command, NAME_HERE can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:servicenetworking/connection:Connection default {{peering-network}}:{{service}}
        ```

        ```sh
        $ pulumi import gcp:servicenetworking/connection:Connection default /projects/{{project}}/global/networks/{{peering-network}}:{{service}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the service networking connection. Setting to ABANDON allows the resource to be abandoned rather than deleted. This will enable a successful pulumi destroy when destroying CloudSQL instances. Use with care as it can lead to dangling resources.
        :param pulumi.Input[_builtins.str] network: Name of VPC network connected with service producers using VPC peering.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_peering_ranges: Named IP address range(s) of PEERING type reserved for
               this service provider. Note that invoking this method with a different range when connection
               is already established will not reallocate already provisioned service producer subnetworks.
        :param pulumi.Input[_builtins.str] service: Provider peering service that is managing peering connectivity for a
               service provider organization. For Google services that support this functionality it is
               'servicenetworking.googleapis.com'.
        :param pulumi.Input[_builtins.bool] update_on_creation_fail: When set to true, enforce an update of the reserved peering ranges on the existing service networking connection in case of a new connection creation failure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a private VPC connection with a GCP service provider. For more information see
        [the official documentation](https://cloud.google.com/vpc/docs/configure-private-services-access#creating-connection)
        and
        [API](https://cloud.google.com/service-infrastructure/docs/service-networking/reference/rest/v1/services.connections).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Create a VPC network
        peering_network = gcp.compute.Network("peering_network", name="peering-network")
        # Create an IP address
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="private-ip-alloc",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=peering_network.id)
        # Create a private connection
        default = gcp.servicenetworking.Connection("default",
            network=peering_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        # (Optional) Import or export custom routes
        peering_routes = gcp.compute.NetworkPeeringRoutesConfig("peering_routes",
            peering=default.peering,
            network=peering_network.name,
            import_custom_routes=True,
            export_custom_routes=True)
        ```

        ## Import

        ServiceNetworkingConnection can be imported using any of these accepted formats

        * `{{peering-network}}:{{service}}`

        * `projects/{{project}}/global/networks/{{peering-network}}:{{service}}`

        When using the `pulumi import` command, NAME_HERE can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:servicenetworking/connection:Connection default {{peering-network}}:{{service}}
        ```

        ```sh
        $ pulumi import gcp:servicenetworking/connection:Connection default /projects/{{project}}/global/networks/{{peering-network}}:{{service}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_peering_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 update_on_creation_fail: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["deletion_policy"] = deletion_policy
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if reserved_peering_ranges is None and not opts.urn:
                raise TypeError("Missing required property 'reserved_peering_ranges'")
            __props__.__dict__["reserved_peering_ranges"] = reserved_peering_ranges
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["update_on_creation_fail"] = update_on_creation_fail
            __props__.__dict__["peering"] = None
        super(Connection, __self__).__init__(
            'gcp:servicenetworking/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            peering: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_peering_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            update_on_creation_fail: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the service networking connection. Setting to ABANDON allows the resource to be abandoned rather than deleted. This will enable a successful pulumi destroy when destroying CloudSQL instances. Use with care as it can lead to dangling resources.
        :param pulumi.Input[_builtins.str] network: Name of VPC network connected with service producers using VPC peering.
        :param pulumi.Input[_builtins.str] peering: (Computed) The name of the VPC Network Peering connection that was created by the service producer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_peering_ranges: Named IP address range(s) of PEERING type reserved for
               this service provider. Note that invoking this method with a different range when connection
               is already established will not reallocate already provisioned service producer subnetworks.
        :param pulumi.Input[_builtins.str] service: Provider peering service that is managing peering connectivity for a
               service provider organization. For Google services that support this functionality it is
               'servicenetworking.googleapis.com'.
        :param pulumi.Input[_builtins.bool] update_on_creation_fail: When set to true, enforce an update of the reserved peering ranges on the existing service networking connection in case of a new connection creation failure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["network"] = network
        __props__.__dict__["peering"] = peering
        __props__.__dict__["reserved_peering_ranges"] = reserved_peering_ranges
        __props__.__dict__["service"] = service
        __props__.__dict__["update_on_creation_fail"] = update_on_creation_fail
        return Connection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The deletion policy for the service networking connection. Setting to ABANDON allows the resource to be abandoned rather than deleted. This will enable a successful pulumi destroy when destroying CloudSQL instances. Use with care as it can lead to dangling resources.
        """
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        Name of VPC network connected with service producers using VPC peering.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def peering(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The name of the VPC Network Peering connection that was created by the service producer.
        """
        return pulumi.get(self, "peering")

    @_builtins.property
    @pulumi.getter(name="reservedPeeringRanges")
    def reserved_peering_ranges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Named IP address range(s) of PEERING type reserved for
        this service provider. Note that invoking this method with a different range when connection
        is already established will not reallocate already provisioned service producer subnetworks.
        """
        return pulumi.get(self, "reserved_peering_ranges")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        Provider peering service that is managing peering connectivity for a
        service provider organization. For Google services that support this functionality it is
        'servicenetworking.googleapis.com'.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="updateOnCreationFail")
    def update_on_creation_fail(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When set to true, enforce an update of the reserved peering ranges on the existing service networking connection in case of a new connection creation failure.
        """
        return pulumi.get(self, "update_on_creation_fail")

