# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DatabaseInstanceCloneArgs',
    'DatabaseInstanceCloneArgsDict',
    'DatabaseInstanceDnsNameArgs',
    'DatabaseInstanceDnsNameArgsDict',
    'DatabaseInstanceIpAddressArgs',
    'DatabaseInstanceIpAddressArgsDict',
    'DatabaseInstancePointInTimeRestoreContextArgs',
    'DatabaseInstancePointInTimeRestoreContextArgsDict',
    'DatabaseInstanceReplicaConfigurationArgs',
    'DatabaseInstanceReplicaConfigurationArgsDict',
    'DatabaseInstanceReplicationClusterArgs',
    'DatabaseInstanceReplicationClusterArgsDict',
    'DatabaseInstanceRestoreBackupContextArgs',
    'DatabaseInstanceRestoreBackupContextArgsDict',
    'DatabaseInstanceServerCaCertArgs',
    'DatabaseInstanceServerCaCertArgsDict',
    'DatabaseInstanceSettingsArgs',
    'DatabaseInstanceSettingsArgsDict',
    'DatabaseInstanceSettingsActiveDirectoryConfigArgs',
    'DatabaseInstanceSettingsActiveDirectoryConfigArgsDict',
    'DatabaseInstanceSettingsAdvancedMachineFeaturesArgs',
    'DatabaseInstanceSettingsAdvancedMachineFeaturesArgsDict',
    'DatabaseInstanceSettingsBackupConfigurationArgs',
    'DatabaseInstanceSettingsBackupConfigurationArgsDict',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgsDict',
    'DatabaseInstanceSettingsConnectionPoolConfigArgs',
    'DatabaseInstanceSettingsConnectionPoolConfigArgsDict',
    'DatabaseInstanceSettingsConnectionPoolConfigFlagArgs',
    'DatabaseInstanceSettingsConnectionPoolConfigFlagArgsDict',
    'DatabaseInstanceSettingsDataCacheConfigArgs',
    'DatabaseInstanceSettingsDataCacheConfigArgsDict',
    'DatabaseInstanceSettingsDatabaseFlagArgs',
    'DatabaseInstanceSettingsDatabaseFlagArgsDict',
    'DatabaseInstanceSettingsDenyMaintenancePeriodArgs',
    'DatabaseInstanceSettingsDenyMaintenancePeriodArgsDict',
    'DatabaseInstanceSettingsFinalBackupConfigArgs',
    'DatabaseInstanceSettingsFinalBackupConfigArgsDict',
    'DatabaseInstanceSettingsInsightsConfigArgs',
    'DatabaseInstanceSettingsInsightsConfigArgsDict',
    'DatabaseInstanceSettingsIpConfigurationArgs',
    'DatabaseInstanceSettingsIpConfigurationArgsDict',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgsDict',
    'DatabaseInstanceSettingsIpConfigurationPscConfigArgs',
    'DatabaseInstanceSettingsIpConfigurationPscConfigArgsDict',
    'DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs',
    'DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgsDict',
    'DatabaseInstanceSettingsLocationPreferenceArgs',
    'DatabaseInstanceSettingsLocationPreferenceArgsDict',
    'DatabaseInstanceSettingsMaintenanceWindowArgs',
    'DatabaseInstanceSettingsMaintenanceWindowArgsDict',
    'DatabaseInstanceSettingsPasswordValidationPolicyArgs',
    'DatabaseInstanceSettingsPasswordValidationPolicyArgsDict',
    'DatabaseInstanceSettingsReadPoolAutoScaleConfigArgs',
    'DatabaseInstanceSettingsReadPoolAutoScaleConfigArgsDict',
    'DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgs',
    'DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgsDict',
    'DatabaseInstanceSettingsSqlServerAuditConfigArgs',
    'DatabaseInstanceSettingsSqlServerAuditConfigArgsDict',
    'UserPasswordPolicyArgs',
    'UserPasswordPolicyArgsDict',
    'UserPasswordPolicyStatusArgs',
    'UserPasswordPolicyStatusArgsDict',
    'UserSqlServerUserDetailArgs',
    'UserSqlServerUserDetailArgsDict',
]

MYPY = False

if not MYPY:
    class DatabaseInstanceCloneArgsDict(TypedDict):
        source_instance_name: pulumi.Input[_builtins.str]
        """
        Name of the source instance which will be cloned.
        """
        allocated_ip_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        database_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        """
        point_in_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The timestamp of the point in time that should be restored.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        preferred_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance. [clone-unavailable-instance](https://cloud.google.com/sql/docs/postgres/clone-instance#clone-unavailable-instance)
        """
        source_instance_deletion_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The timestamp of when the source instance was deleted for a clone from a deleted instance.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
elif False:
    DatabaseInstanceCloneArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceCloneArgs:
    def __init__(__self__, *,
                 source_instance_name: pulumi.Input[_builtins.str],
                 allocated_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 database_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 point_in_time: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 source_instance_deletion_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] source_instance_name: Name of the source instance which will be cloned.
        :param pulumi.Input[_builtins.str] allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] database_names: (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        :param pulumi.Input[_builtins.str] point_in_time: The timestamp of the point in time that should be restored.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] preferred_zone: (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance. [clone-unavailable-instance](https://cloud.google.com/sql/docs/postgres/clone-instance#clone-unavailable-instance)
        :param pulumi.Input[_builtins.str] source_instance_deletion_time: The timestamp of when the source instance was deleted for a clone from a deleted instance.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "source_instance_name", source_instance_name)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if database_names is not None:
            pulumi.set(__self__, "database_names", database_names)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)
        if preferred_zone is not None:
            pulumi.set(__self__, "preferred_zone", preferred_zone)
        if source_instance_deletion_time is not None:
            pulumi.set(__self__, "source_instance_deletion_time", source_instance_deletion_time)

    @_builtins.property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the source instance which will be cloned.
        """
        return pulumi.get(self, "source_instance_name")

    @source_instance_name.setter
    def source_instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @_builtins.property
    @pulumi.getter(name="databaseNames")
    def database_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (SQL Server only, use with `point_in_time`) Clone only the specified databases from the source instance. Clone all databases if empty.
        """
        return pulumi.get(self, "database_names")

    @database_names.setter
    def database_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "database_names", value)

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of the point in time that should be restored.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "point_in_time")

    @point_in_time.setter
    def point_in_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "point_in_time", value)

    @_builtins.property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Point-in-time recovery for PostgreSQL only) Clone to an instance in the specified zone. If no zone is specified, clone to the same zone as the source instance. [clone-unavailable-instance](https://cloud.google.com/sql/docs/postgres/clone-instance#clone-unavailable-instance)
        """
        return pulumi.get(self, "preferred_zone")

    @preferred_zone.setter
    def preferred_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_zone", value)

    @_builtins.property
    @pulumi.getter(name="sourceInstanceDeletionTime")
    def source_instance_deletion_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the source instance was deleted for a clone from a deleted instance.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "source_instance_deletion_time")

    @source_instance_deletion_time.setter
    def source_instance_deletion_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_instance_deletion_time", value)


if not MYPY:
    class DatabaseInstanceDnsNameArgsDict(TypedDict):
        connection_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection type of the DNS name. Can be either `PUBLIC`, `PRIVATE_SERVICES_ACCESS`, or `PRIVATE_SERVICE_CONNECT`.
        """
        dns_scope: NotRequired[pulumi.Input[_builtins.str]]
        """
        The scope that the DNS name applies to.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
elif False:
    DatabaseInstanceDnsNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceDnsNameArgs:
    def __init__(__self__, *,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] connection_type: The connection type of the DNS name. Can be either `PUBLIC`, `PRIVATE_SERVICES_ACCESS`, or `PRIVATE_SERVICE_CONNECT`.
        :param pulumi.Input[_builtins.str] dns_scope: The scope that the DNS name applies to.
        :param pulumi.Input[_builtins.str] name: The name of the instance. If the name is left
               blank, the provider will randomly generate one when the instance is first
               created. This is done because after a name is used, it cannot be reused for
               up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if dns_scope is not None:
            pulumi.set(__self__, "dns_scope", dns_scope)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection type of the DNS name. Can be either `PUBLIC`, `PRIVATE_SERVICES_ACCESS`, or `PRIVATE_SERVICE_CONNECT`.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @_builtins.property
    @pulumi.getter(name="dnsScope")
    def dns_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope that the DNS name applies to.
        """
        return pulumi.get(self, "dns_scope")

    @dns_scope.setter
    def dns_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_scope", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance. If the name is left
        blank, the provider will randomly generate one when the instance is first
        created. This is done because after a name is used, it cannot be reused for
        up to [one week](https://cloud.google.com/sql/docs/delete-instance).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DatabaseInstanceIpAddressArgsDict(TypedDict):
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv4 address assigned.
        """
        time_to_retire: NotRequired[pulumi.Input[_builtins.str]]
        """
        The time this IP address will be retired, in RFC
        3339 format.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of this IP address.
        """
elif False:
    DatabaseInstanceIpAddressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceIpAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 time_to_retire: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_address: The IPv4 address assigned.
        :param pulumi.Input[_builtins.str] time_to_retire: The time this IP address will be retired, in RFC
               3339 format.
        :param pulumi.Input[_builtins.str] type: The type of this IP address.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address assigned.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this IP address will be retired, in RFC
        3339 format.
        """
        return pulumi.get(self, "time_to_retire")

    @time_to_retire.setter
    def time_to_retire(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_to_retire", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of this IP address.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DatabaseInstancePointInTimeRestoreContextArgsDict(TypedDict):
        datasource: pulumi.Input[_builtins.str]
        """
        The Google Cloud Backup and Disaster Recovery Datasource URI.
        """
        allocated_ip_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        point_in_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The timestamp of the point in time that should be restored.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        preferred_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        Point-in-time recovery of an instance to the specified zone. If no zone is specified, then clone to the same primary zone as the source instance.
        """
        target_instance: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the target instance.
        """
elif False:
    DatabaseInstancePointInTimeRestoreContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstancePointInTimeRestoreContextArgs:
    def __init__(__self__, *,
                 datasource: pulumi.Input[_builtins.str],
                 allocated_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 target_instance: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] datasource: The Google Cloud Backup and Disaster Recovery Datasource URI.
        :param pulumi.Input[_builtins.str] allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param pulumi.Input[_builtins.str] point_in_time: The timestamp of the point in time that should be restored.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] preferred_zone: Point-in-time recovery of an instance to the specified zone. If no zone is specified, then clone to the same primary zone as the source instance.
        :param pulumi.Input[_builtins.str] target_instance: The name of the target instance.
        """
        pulumi.set(__self__, "datasource", datasource)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)
        if preferred_zone is not None:
            pulumi.set(__self__, "preferred_zone", preferred_zone)
        if target_instance is not None:
            pulumi.set(__self__, "target_instance", target_instance)

    @_builtins.property
    @pulumi.getter
    def datasource(self) -> pulumi.Input[_builtins.str]:
        """
        The Google Cloud Backup and Disaster Recovery Datasource URI.
        """
        return pulumi.get(self, "datasource")

    @datasource.setter
    def datasource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "datasource", value)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of the point in time that should be restored.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "point_in_time")

    @point_in_time.setter
    def point_in_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "point_in_time", value)

    @_builtins.property
    @pulumi.getter(name="preferredZone")
    def preferred_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Point-in-time recovery of an instance to the specified zone. If no zone is specified, then clone to the same primary zone as the source instance.
        """
        return pulumi.get(self, "preferred_zone")

    @preferred_zone.setter
    def preferred_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_zone", value)

    @_builtins.property
    @pulumi.getter(name="targetInstance")
    def target_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the target instance.
        """
        return pulumi.get(self, "target_instance")

    @target_instance.setter
    def target_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_instance", value)


if not MYPY:
    class DatabaseInstanceReplicaConfigurationArgsDict(TypedDict):
        ca_certificate: NotRequired[pulumi.Input[_builtins.str]]
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        cascadable_replica: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if the replica is a cascadable replica. If true, instance must be in different region from primary.

        > **NOTE:** Only supported for SQL Server database.
        """
        client_certificate: NotRequired[pulumi.Input[_builtins.str]]
        """
        PEM representation of the replica's x509
        certificate.
        """
        client_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        connect_retry_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of seconds
        between connect retries. MySQL's default is 60 seconds.
        """
        dump_file_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`. Note, if the master
        instance is a source representation instance this field must be present.
        """
        failover_target: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        > **NOTE:** Not supported for Postgres database.
        """
        master_heartbeat_period: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in ms between replication
        heartbeats.
        """
        password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Password for the replication connection.
        """
        ssl_cipher: NotRequired[pulumi.Input[_builtins.str]]
        """
        Permissible ciphers for use in SSL encryption.
        """
        username: NotRequired[pulumi.Input[_builtins.str]]
        """
        Username for replication connection.
        """
        verify_server_certificate: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
elif False:
    DatabaseInstanceReplicaConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceReplicaConfigurationArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 cascadable_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_retry_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 dump_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 failover_target: Optional[pulumi.Input[_builtins.bool]] = None,
                 master_heartbeat_period: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cipher: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_server_certificate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param pulumi.Input[_builtins.bool] cascadable_replica: Specifies if the replica is a cascadable replica. If true, instance must be in different region from primary.
               
               > **NOTE:** Only supported for SQL Server database.
        :param pulumi.Input[_builtins.str] client_certificate: PEM representation of the replica's x509
               certificate.
        :param pulumi.Input[_builtins.str] client_key: PEM representation of the replica's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param pulumi.Input[_builtins.int] connect_retry_interval: The number of seconds
               between connect retries. MySQL's default is 60 seconds.
        :param pulumi.Input[_builtins.str] dump_file_path: Path to a SQL file in GCS from which replica
               instances are created. Format is `gs://bucket/filename`. Note, if the master
               instance is a source representation instance this field must be present.
        :param pulumi.Input[_builtins.bool] failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
               > **NOTE:** Not supported for Postgres database.
        :param pulumi.Input[_builtins.int] master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param pulumi.Input[_builtins.str] password: Password for the replication connection.
        :param pulumi.Input[_builtins.str] ssl_cipher: Permissible ciphers for use in SSL encryption.
        :param pulumi.Input[_builtins.str] username: Username for replication connection.
        :param pulumi.Input[_builtins.bool] verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if cascadable_replica is not None:
            pulumi.set(__self__, "cascadable_replica", cascadable_replica)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @_builtins.property
    @pulumi.getter(name="cascadableReplica")
    def cascadable_replica(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the replica is a cascadable replica. If true, instance must be in different region from primary.

        > **NOTE:** Only supported for SQL Server database.
        """
        return pulumi.get(self, "cascadable_replica")

    @cascadable_replica.setter
    def cascadable_replica(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cascadable_replica", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM representation of the replica's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds
        between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @connect_retry_interval.setter
    def connect_retry_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connect_retry_interval", value)

    @_builtins.property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`. Note, if the master
        instance is a source representation instance this field must be present.
        """
        return pulumi.get(self, "dump_file_path")

    @dump_file_path.setter
    def dump_file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dump_file_path", value)

    @_builtins.property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        > **NOTE:** Not supported for Postgres database.
        """
        return pulumi.get(self, "failover_target")

    @failover_target.setter
    def failover_target(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "failover_target", value)

    @_builtins.property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @master_heartbeat_period.setter
    def master_heartbeat_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "master_heartbeat_period", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Permissible ciphers for use in SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @ssl_cipher.setter
    def ssl_cipher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cipher", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")

    @verify_server_certificate.setter
    def verify_server_certificate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify_server_certificate", value)


if not MYPY:
    class DatabaseInstanceReplicationClusterArgsDict(TypedDict):
        dr_replica: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        failover_dr_replica_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        psa_write_endpoint: NotRequired[pulumi.Input[_builtins.str]]
        """
        Read-only field which if set, indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
elif False:
    DatabaseInstanceReplicationClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceReplicationClusterArgs:
    def __init__(__self__, *,
                 dr_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 failover_dr_replica_name: Optional[pulumi.Input[_builtins.str]] = None,
                 psa_write_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] dr_replica: Read-only field that indicates whether the replica is a DR replica.
        :param pulumi.Input[_builtins.str] failover_dr_replica_name: If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        :param pulumi.Input[_builtins.str] psa_write_endpoint: Read-only field which if set, indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        if dr_replica is not None:
            pulumi.set(__self__, "dr_replica", dr_replica)
        if failover_dr_replica_name is not None:
            pulumi.set(__self__, "failover_dr_replica_name", failover_dr_replica_name)
        if psa_write_endpoint is not None:
            pulumi.set(__self__, "psa_write_endpoint", psa_write_endpoint)

    @_builtins.property
    @pulumi.getter(name="drReplica")
    def dr_replica(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Read-only field that indicates whether the replica is a DR replica.
        """
        return pulumi.get(self, "dr_replica")

    @dr_replica.setter
    def dr_replica(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dr_replica", value)

    @_builtins.property
    @pulumi.getter(name="failoverDrReplicaName")
    def failover_dr_replica_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the instance is a primary instance, then this field identifies the disaster recovery (DR) replica. The standard format of this field is "your-project:your-instance". You can also set this field to "your-instance", but cloud SQL backend will convert it to the aforementioned standard format.
        """
        return pulumi.get(self, "failover_dr_replica_name")

    @failover_dr_replica_name.setter
    def failover_dr_replica_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failover_dr_replica_name", value)

    @_builtins.property
    @pulumi.getter(name="psaWriteEndpoint")
    def psa_write_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Read-only field which if set, indicates this instance has a private service access (PSA) DNS endpoint that is pointing to the primary instance of the cluster. If this instance is the primary, then the DNS endpoint points to this instance. After a switchover or replica failover operation, this DNS endpoint points to the promoted instance. This is a read-only field, returned to the user as information. This field can exist even if a standalone instance doesn't have a DR replica yet or the DR replica is deleted.
        """
        return pulumi.get(self, "psa_write_endpoint")

    @psa_write_endpoint.setter
    def psa_write_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psa_write_endpoint", value)


if not MYPY:
    class DatabaseInstanceRestoreBackupContextArgsDict(TypedDict):
        backup_run_id: pulumi.Input[_builtins.int]
        """
        The ID of the backup run to restore from.
        """
        instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        project: NotRequired[pulumi.Input[_builtins.str]]
        """
        The full project ID of the source instance.`
        """
elif False:
    DatabaseInstanceRestoreBackupContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceRestoreBackupContextArgs:
    def __init__(__self__, *,
                 backup_run_id: pulumi.Input[_builtins.int],
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] backup_run_id: The ID of the backup run to restore from.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance that the backup was taken from. If left empty,
               this instance's ID will be used.
        :param pulumi.Input[_builtins.str] project: The full project ID of the source instance.`
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @backup_run_id.setter
    def backup_run_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "backup_run_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full project ID of the source instance.`
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


if not MYPY:
    class DatabaseInstanceServerCaCertArgsDict(TypedDict):
        cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        common_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CN valid for the CA Cert.
        """
        create_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        Creation time of the CA Cert.
        """
        expiration_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        Expiration time of the CA Cert.
        """
        sha1_fingerprint: NotRequired[pulumi.Input[_builtins.str]]
        """
        SHA Fingerprint of the CA Cert.
        """
elif False:
    DatabaseInstanceServerCaCertArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceServerCaCertArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time: Optional[pulumi.Input[_builtins.str]] = None,
                 sha1_fingerprint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] cert: The CA Certificate used to connect to the SQL Instance via SSL.
        :param pulumi.Input[_builtins.str] common_name: The CN valid for the CA Cert.
        :param pulumi.Input[_builtins.str] create_time: Creation time of the CA Cert.
        :param pulumi.Input[_builtins.str] expiration_time: Expiration time of the CA Cert.
        :param pulumi.Input[_builtins.str] sha1_fingerprint: SHA Fingerprint of the CA Cert.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA Certificate used to connect to the SQL Instance via SSL.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CN valid for the CA Cert.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time of the CA Cert.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration time of the CA Cert.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_time", value)

    @_builtins.property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SHA Fingerprint of the CA Cert.
        """
        return pulumi.get(self, "sha1_fingerprint")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sha1_fingerprint", value)


if not MYPY:
    class DatabaseInstanceSettingsArgsDict(TypedDict):
        tier: pulumi.Input[_builtins.str]
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        activation_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        active_directory_config: NotRequired[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgsDict']]
        advanced_machine_features: NotRequired[pulumi.Input['DatabaseInstanceSettingsAdvancedMachineFeaturesArgsDict']]
        availability_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`). For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`. Defaults to `ZONAL`.
        For read pool instances, this field is read-only. The availability type is changed by specifying
        the number of nodes (`node_count`).
        """
        backup_configuration: NotRequired[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgsDict']]
        collation: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of server instance collation.
        """
        connection_pool_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigArgsDict']]]]
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        connector_enforcement: NotRequired[pulumi.Input[_builtins.str]]
        """
        Control the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections, can be `REQUIRED` or `NOT_REQUIRED`. If enabled, all the direct connections are rejected.
        """
        data_cache_config: NotRequired[pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgsDict']]
        """
        Data cache configurations.
        """
        data_disk_provisioned_iops: NotRequired[pulumi.Input[_builtins.int]]
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        data_disk_provisioned_throughput: NotRequired[pulumi.Input[_builtins.int]]
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        database_flags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgsDict']]]]
        deletion_protection_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Configuration to protect against accidental instance deletion.
        """
        deny_maintenance_period: NotRequired[pulumi.Input['DatabaseInstanceSettingsDenyMaintenancePeriodArgsDict']]
        disk_autoresize: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables auto-resizing of the storage size. Defaults to `true`. Note that if `disk_size` is set, future `pulumi up` calls will attempt to delete the instance in order to resize the disk to the value specified in disk_size if it has been resized. To avoid this, ensure that `lifecycle.ignore_changes` is applied to `disk_size`.
        """
        disk_autoresize_limit: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        disk_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for `PD_SSD`, `PD_HDD` and 20GB for `HYPERDISK_BALANCED`. Note that this value will override the resizing from `disk_autoresize` if that feature is enabled. To avoid this, set `lifecycle.ignore_changes` on this field.
        """
        disk_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of data disk: `PD_SSD`, `PD_HDD`, or `HYPERDISK_BALANCED`. Defaults to `PD_SSD`. `HYPERDISK_BALANCED` is preview.
        """
        edition: NotRequired[pulumi.Input[_builtins.str]]
        """
        The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        """
        effective_availability_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Computed) The availability type of
        the Cloud SQL instance, high availability (REGIONAL) or single zone
        (ZONAL). This field always contains the value that is reported by the API (for
        read pools, `settings.0.effective_availability_type` may differ from
        `settings.0.availability_type`).
        """
        enable_dataplex_integration: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables [Cloud SQL instance integration with Dataplex](https://cloud.google.com/sql/docs/mysql/dataplex-catalog-integration). MySQL, Postgres and SQL Server instances are supported for this feature. Defaults to `false`.
        """
        enable_google_ml_integration: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables [Cloud SQL instances to connect to Vertex AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai) and pass requests for real-time predictions and insights. Defaults to `false`.
        """
        final_backup_config: NotRequired[pulumi.Input['DatabaseInstanceSettingsFinalBackupConfigArgsDict']]
        """
        Config used to determine the final backup settings for the instance
        """
        insights_config: NotRequired[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgsDict']]
        """
        Configuration of Query Insights.
        """
        ip_configuration: NotRequired[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgsDict']]
        location_preference: NotRequired[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgsDict']]
        maintenance_window: NotRequired[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgsDict']]
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        password_validation_policy: NotRequired[pulumi.Input['DatabaseInstanceSettingsPasswordValidationPolicyArgsDict']]
        pricing_plan: NotRequired[pulumi.Input[_builtins.str]]
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        read_pool_auto_scale_config: NotRequired[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigArgsDict']]
        """
        Configuration of Read Pool Auto Scale.
        """
        retain_backups_on_delete: NotRequired[pulumi.Input[_builtins.bool]]
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The `ON_DEMAND` backup will be retained until customer deletes the backup or the project. The `AUTOMATED` backup will be retained based on the backups retention setting.
        """
        sql_server_audit_config: NotRequired[pulumi.Input['DatabaseInstanceSettingsSqlServerAuditConfigArgsDict']]
        time_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        user_labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A set of key/value user label pairs to assign to the instance.
        """
        version: NotRequired[pulumi.Input[_builtins.int]]
        """
        Used to make sure changes to the `settings` block are
        atomic.
        """
elif False:
    DatabaseInstanceSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[_builtins.str],
                 activation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 active_directory_config: Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']] = None,
                 advanced_machine_features: Optional[pulumi.Input['DatabaseInstanceSettingsAdvancedMachineFeaturesArgs']] = None,
                 availability_type: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_pool_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigArgs']]]] = None,
                 connector_enforcement: Optional[pulumi.Input[_builtins.str]] = None,
                 data_cache_config: Optional[pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgs']] = None,
                 data_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 data_disk_provisioned_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 database_flags: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deny_maintenance_period: Optional[pulumi.Input['DatabaseInstanceSettingsDenyMaintenancePeriodArgs']] = None,
                 disk_autoresize: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_autoresize_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_availability_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dataplex_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_google_ml_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 final_backup_config: Optional[pulumi.Input['DatabaseInstanceSettingsFinalBackupConfigArgs']] = None,
                 insights_config: Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']] = None,
                 ip_configuration: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']] = None,
                 location_preference: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']] = None,
                 password_validation_policy: Optional[pulumi.Input['DatabaseInstanceSettingsPasswordValidationPolicyArgs']] = None,
                 pricing_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 read_pool_auto_scale_config: Optional[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigArgs']] = None,
                 retain_backups_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_server_audit_config: Optional[pulumi.Input['DatabaseInstanceSettingsSqlServerAuditConfigArgs']] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param pulumi.Input[_builtins.str] activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param pulumi.Input[_builtins.str] availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`). For all instances, ensure that
               `settings.backup_configuration.enabled` is set to `true`.
               For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
               For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
               is set to `true`. Defaults to `ZONAL`.
               For read pool instances, this field is read-only. The availability type is changed by specifying
               the number of nodes (`node_count`).
        :param pulumi.Input[_builtins.str] collation: The name of server instance collation.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigArgs']]] connection_pool_configs: The managed connection pool setting for a Cloud SQL instance.
        :param pulumi.Input[_builtins.str] connector_enforcement: Control the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections, can be `REQUIRED` or `NOT_REQUIRED`. If enabled, all the direct connections are rejected.
        :param pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgs'] data_cache_config: Data cache configurations.
        :param pulumi.Input[_builtins.int] data_disk_provisioned_iops: Provisioned number of I/O operations per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        :param pulumi.Input[_builtins.int] data_disk_provisioned_throughput: Provisioned throughput measured in MiB per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param pulumi.Input[_builtins.bool] disk_autoresize: Enables auto-resizing of the storage size. Defaults to `true`. Note that if `disk_size` is set, future `pulumi up` calls will attempt to delete the instance in order to resize the disk to the value specified in disk_size if it has been resized. To avoid this, ensure that `lifecycle.ignore_changes` is applied to `disk_size`.
        :param pulumi.Input[_builtins.int] disk_autoresize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param pulumi.Input[_builtins.int] disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for `PD_SSD`, `PD_HDD` and 20GB for `HYPERDISK_BALANCED`. Note that this value will override the resizing from `disk_autoresize` if that feature is enabled. To avoid this, set `lifecycle.ignore_changes` on this field.
        :param pulumi.Input[_builtins.str] disk_type: The type of data disk: `PD_SSD`, `PD_HDD`, or `HYPERDISK_BALANCED`. Defaults to `PD_SSD`. `HYPERDISK_BALANCED` is preview.
        :param pulumi.Input[_builtins.str] edition: The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        :param pulumi.Input[_builtins.str] effective_availability_type: (Computed) The availability type of
               the Cloud SQL instance, high availability (REGIONAL) or single zone
               (ZONAL). This field always contains the value that is reported by the API (for
               read pools, `settings.0.effective_availability_type` may differ from
               `settings.0.availability_type`).
        :param pulumi.Input[_builtins.bool] enable_dataplex_integration: Enables [Cloud SQL instance integration with Dataplex](https://cloud.google.com/sql/docs/mysql/dataplex-catalog-integration). MySQL, Postgres and SQL Server instances are supported for this feature. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_google_ml_integration: Enables [Cloud SQL instances to connect to Vertex AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai) and pass requests for real-time predictions and insights. Defaults to `false`.
        :param pulumi.Input['DatabaseInstanceSettingsFinalBackupConfigArgs'] final_backup_config: Config used to determine the final backup settings for the instance
        :param pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs'] insights_config: Configuration of Query Insights.
        :param pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs'] maintenance_window: Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        :param pulumi.Input[_builtins.str] pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigArgs'] read_pool_auto_scale_config: Configuration of Read Pool Auto Scale.
        :param pulumi.Input[_builtins.bool] retain_backups_on_delete: When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The `ON_DEMAND` backup will be retained until customer deletes the backup or the project. The `AUTOMATED` backup will be retained based on the backups retention setting.
        :param pulumi.Input[_builtins.str] time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] user_labels: A set of key/value user label pairs to assign to the instance.
        :param pulumi.Input[_builtins.int] version: Used to make sure changes to the `settings` block are
               atomic.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if connection_pool_configs is not None:
            pulumi.set(__self__, "connection_pool_configs", connection_pool_configs)
        if connector_enforcement is not None:
            pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        if data_cache_config is not None:
            pulumi.set(__self__, "data_cache_config", data_cache_config)
        if data_disk_provisioned_iops is not None:
            pulumi.set(__self__, "data_disk_provisioned_iops", data_disk_provisioned_iops)
        if data_disk_provisioned_throughput is not None:
            pulumi.set(__self__, "data_disk_provisioned_throughput", data_disk_provisioned_throughput)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deny_maintenance_period is not None:
            pulumi.set(__self__, "deny_maintenance_period", deny_maintenance_period)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_autoresize_limit is not None:
            pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if effective_availability_type is not None:
            pulumi.set(__self__, "effective_availability_type", effective_availability_type)
        if enable_dataplex_integration is not None:
            pulumi.set(__self__, "enable_dataplex_integration", enable_dataplex_integration)
        if enable_google_ml_integration is not None:
            pulumi.set(__self__, "enable_google_ml_integration", enable_google_ml_integration)
        if final_backup_config is not None:
            pulumi.set(__self__, "final_backup_config", final_backup_config)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if password_validation_policy is not None:
            pulumi.set(__self__, "password_validation_policy", password_validation_policy)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if read_pool_auto_scale_config is not None:
            pulumi.set(__self__, "read_pool_auto_scale_config", read_pool_auto_scale_config)
        if retain_backups_on_delete is not None:
            pulumi.set(__self__, "retain_backups_on_delete", retain_backups_on_delete)
        if sql_server_audit_config is not None:
            pulumi.set(__self__, "sql_server_audit_config", sql_server_audit_config)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Input[_builtins.str]:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_policy", value)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']]:
        return pulumi.get(self, "active_directory_config")

    @active_directory_config.setter
    def active_directory_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsActiveDirectoryConfigArgs']]):
        pulumi.set(self, "active_directory_config", value)

    @_builtins.property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsAdvancedMachineFeaturesArgs']]:
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @_builtins.property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`). For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`. Defaults to `ZONAL`.
        For read pool instances, this field is read-only. The availability type is changed by specifying
        the number of nodes (`node_count`).
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_type", value)

    @_builtins.property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]:
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationArgs']]):
        pulumi.set(self, "backup_configuration", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="connectionPoolConfigs")
    def connection_pool_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigArgs']]]]:
        """
        The managed connection pool setting for a Cloud SQL instance.
        """
        return pulumi.get(self, "connection_pool_configs")

    @connection_pool_configs.setter
    def connection_pool_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigArgs']]]]):
        pulumi.set(self, "connection_pool_configs", value)

    @_builtins.property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Control the enforcement of Cloud SQL Auth Proxy or Cloud SQL connectors for all the connections, can be `REQUIRED` or `NOT_REQUIRED`. If enabled, all the direct connections are rejected.
        """
        return pulumi.get(self, "connector_enforcement")

    @connector_enforcement.setter
    def connector_enforcement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_enforcement", value)

    @_builtins.property
    @pulumi.getter(name="dataCacheConfig")
    def data_cache_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgs']]:
        """
        Data cache configurations.
        """
        return pulumi.get(self, "data_cache_config")

    @data_cache_config.setter
    def data_cache_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsDataCacheConfigArgs']]):
        pulumi.set(self, "data_cache_config", value)

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedIops")
    def data_disk_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provisioned number of I/O operations per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_iops")

    @data_disk_provisioned_iops.setter
    def data_disk_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_disk_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="dataDiskProvisionedThroughput")
    def data_disk_provisioned_throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provisioned throughput measured in MiB per second for the data disk. This field is only used for `HYPERDISK_BALANCED` disk types.
        """
        return pulumi.get(self, "data_disk_provisioned_throughput")

    @data_disk_provisioned_throughput.setter
    def data_disk_provisioned_throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_disk_provisioned_throughput", value)

    @_builtins.property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]:
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsDatabaseFlagArgs']]]]):
        pulumi.set(self, "database_flags", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsDenyMaintenancePeriodArgs']]:
        return pulumi.get(self, "deny_maintenance_period")

    @deny_maintenance_period.setter
    def deny_maintenance_period(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsDenyMaintenancePeriodArgs']]):
        pulumi.set(self, "deny_maintenance_period", value)

    @_builtins.property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables auto-resizing of the storage size. Defaults to `true`. Note that if `disk_size` is set, future `pulumi up` calls will attempt to delete the instance in order to resize the disk to the value specified in disk_size if it has been resized. To avoid this, ensure that `lifecycle.ignore_changes` is applied to `disk_size`.
        """
        return pulumi.get(self, "disk_autoresize")

    @disk_autoresize.setter
    def disk_autoresize(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_autoresize", value)

    @_builtins.property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @disk_autoresize_limit.setter
    def disk_autoresize_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_autoresize_limit", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB for `PD_SSD`, `PD_HDD` and 20GB for `HYPERDISK_BALANCED`. Note that this value will override the resizing from `disk_autoresize` if that feature is enabled. To avoid this, set `lifecycle.ignore_changes` on this field.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of data disk: `PD_SSD`, `PD_HDD`, or `HYPERDISK_BALANCED`. Defaults to `PD_SSD`. `HYPERDISK_BALANCED` is preview.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the instance, can be `ENTERPRISE` or `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAvailabilityType")
    def effective_availability_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The availability type of
        the Cloud SQL instance, high availability (REGIONAL) or single zone
        (ZONAL). This field always contains the value that is reported by the API (for
        read pools, `settings.0.effective_availability_type` may differ from
        `settings.0.availability_type`).
        """
        return pulumi.get(self, "effective_availability_type")

    @effective_availability_type.setter
    def effective_availability_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_availability_type", value)

    @_builtins.property
    @pulumi.getter(name="enableDataplexIntegration")
    def enable_dataplex_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [Cloud SQL instance integration with Dataplex](https://cloud.google.com/sql/docs/mysql/dataplex-catalog-integration). MySQL, Postgres and SQL Server instances are supported for this feature. Defaults to `false`.
        """
        return pulumi.get(self, "enable_dataplex_integration")

    @enable_dataplex_integration.setter
    def enable_dataplex_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dataplex_integration", value)

    @_builtins.property
    @pulumi.getter(name="enableGoogleMlIntegration")
    def enable_google_ml_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [Cloud SQL instances to connect to Vertex AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai) and pass requests for real-time predictions and insights. Defaults to `false`.
        """
        return pulumi.get(self, "enable_google_ml_integration")

    @enable_google_ml_integration.setter
    def enable_google_ml_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_google_ml_integration", value)

    @_builtins.property
    @pulumi.getter(name="finalBackupConfig")
    def final_backup_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsFinalBackupConfigArgs']]:
        """
        Config used to determine the final backup settings for the instance
        """
        return pulumi.get(self, "final_backup_config")

    @final_backup_config.setter
    def final_backup_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsFinalBackupConfigArgs']]):
        pulumi.set(self, "final_backup_config", value)

    @_builtins.property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']]:
        """
        Configuration of Query Insights.
        """
        return pulumi.get(self, "insights_config")

    @insights_config.setter
    def insights_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsInsightsConfigArgs']]):
        pulumi.set(self, "insights_config", value)

    @_builtins.property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]:
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsIpConfigurationArgs']]):
        pulumi.set(self, "ip_configuration", value)

    @_builtins.property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]:
        return pulumi.get(self, "location_preference")

    @location_preference.setter
    def location_preference(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsLocationPreferenceArgs']]):
        pulumi.set(self, "location_preference", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]:
        """
        Declares a one-hour maintenance window when an Instance can automatically restart to apply updates. The maintenance window is specified in UTC time.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="passwordValidationPolicy")
    def password_validation_policy(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsPasswordValidationPolicyArgs']]:
        return pulumi.get(self, "password_validation_policy")

    @password_validation_policy.setter
    def password_validation_policy(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsPasswordValidationPolicyArgs']]):
        pulumi.set(self, "password_validation_policy", value)

    @_builtins.property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @pricing_plan.setter
    def pricing_plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_plan", value)

    @_builtins.property
    @pulumi.getter(name="readPoolAutoScaleConfig")
    def read_pool_auto_scale_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigArgs']]:
        """
        Configuration of Read Pool Auto Scale.
        """
        return pulumi.get(self, "read_pool_auto_scale_config")

    @read_pool_auto_scale_config.setter
    def read_pool_auto_scale_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigArgs']]):
        pulumi.set(self, "read_pool_auto_scale_config", value)

    @_builtins.property
    @pulumi.getter(name="retainBackupsOnDelete")
    def retain_backups_on_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When this parameter is set to true, Cloud SQL retains backups of the instance even after the instance is deleted. The `ON_DEMAND` backup will be retained until customer deletes the backup or the project. The `AUTOMATED` backup will be retained based on the backups retention setting.
        """
        return pulumi.get(self, "retain_backups_on_delete")

    @retain_backups_on_delete.setter
    def retain_backups_on_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_backups_on_delete", value)

    @_builtins.property
    @pulumi.getter(name="sqlServerAuditConfig")
    def sql_server_audit_config(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsSqlServerAuditConfigArgs']]:
        return pulumi.get(self, "sql_server_audit_config")

    @sql_server_audit_config.setter
    def sql_server_audit_config(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsSqlServerAuditConfigArgs']]):
        pulumi.set(self, "sql_server_audit_config", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_labels", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Used to make sure changes to the `settings` block are
        atomic.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class DatabaseInstanceSettingsActiveDirectoryConfigArgsDict(TypedDict):
        domain: pulumi.Input[_builtins.str]
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
elif False:
    DatabaseInstanceSettingsActiveDirectoryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsActiveDirectoryConfigArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] domain: The domain name for the active directory (e.g., mydomain.com).
               Can only be used with SQL Server.
        """
        pulumi.set(__self__, "domain", domain)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)


if not MYPY:
    class DatabaseInstanceSettingsAdvancedMachineFeaturesArgsDict(TypedDict):
        threads_per_core: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
elif False:
    DatabaseInstanceSettingsAdvancedMachineFeaturesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsAdvancedMachineFeaturesArgs:
    def __init__(__self__, *,
                 threads_per_core: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] threads_per_core: The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        if threads_per_core is not None:
            pulumi.set(__self__, "threads_per_core", threads_per_core)

    @_builtins.property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of threads per core. The value of this flag can be 1 or 2. To disable SMT, set this flag to 1. Only available in Cloud SQL for SQL Server instances. See [smt](https://cloud.google.com/sql/docs/sqlserver/create-instance#smt-create-instance) for more details.
        """
        return pulumi.get(self, "threads_per_core")

    @threads_per_core.setter
    def threads_per_core(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "threads_per_core", value)


if not MYPY:
    class DatabaseInstanceSettingsBackupConfigurationArgsDict(TypedDict):
        backup_retention_settings: NotRequired[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgsDict']]
        """
        Backup retention settings. The configuration is detailed below.
        """
        binary_log_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if backup configuration is enabled.
        """
        location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region where the backup will be stored
        """
        point_in_time_recovery_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances. Enabled by default for PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances.
        """
        start_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        transaction_log_retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. For PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances, the number of days of retained transaction logs can be set from 1 to 35.
        """
elif False:
    DatabaseInstanceSettingsBackupConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsBackupConfigurationArgs:
    def __init__(__self__, *,
                 backup_retention_settings: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']] = None,
                 binary_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_log_retention_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs'] backup_retention_settings: Backup retention settings. The configuration is detailed below.
        :param pulumi.Input[_builtins.bool] binary_log_enabled: True if binary logging is enabled.
               Can only be used with MySQL.
        :param pulumi.Input[_builtins.bool] enabled: True if backup configuration is enabled.
        :param pulumi.Input[_builtins.str] location: The region where the backup will be stored
        :param pulumi.Input[_builtins.bool] point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances. Enabled by default for PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances.
        :param pulumi.Input[_builtins.str] start_time: `HH:MM` format time indicating when backup
               configuration starts.
        :param pulumi.Input[_builtins.int] transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7. For PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances, the number of days of retained transaction logs can be set from 1 to 35.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @_builtins.property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']]:
        """
        Backup retention settings. The configuration is detailed below.
        """
        return pulumi.get(self, "backup_retention_settings")

    @backup_retention_settings.setter
    def backup_retention_settings(self, value: Optional[pulumi.Input['DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs']]):
        pulumi.set(self, "backup_retention_settings", value)

    @_builtins.property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @binary_log_enabled.setter
    def binary_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "binary_log_enabled", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the backup will be stored
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances. Enabled by default for PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @point_in_time_recovery_enabled.setter
    def point_in_time_recovery_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "point_in_time_recovery_enabled", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7. For PostgreSQL Enterprise Plus and SQL Server Enterprise Plus instances, the number of days of retained transaction logs can be set from 1 to 35.
        """
        return pulumi.get(self, "transaction_log_retention_days")

    @transaction_log_retention_days.setter
    def transaction_log_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "transaction_log_retention_days", value)


if not MYPY:
    class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgsDict(TypedDict):
        retained_backups: pulumi.Input[_builtins.int]
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        retention_unit: NotRequired[pulumi.Input[_builtins.str]]
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
elif False:
    DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs:
    def __init__(__self__, *,
                 retained_backups: pulumi.Input[_builtins.int],
                 retention_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
               is 'COUNT', we will retain this many backups.
        :param pulumi.Input[_builtins.str] retention_unit: The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @_builtins.property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> pulumi.Input[_builtins.int]:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @retained_backups.setter
    def retained_backups(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retained_backups", value)

    @_builtins.property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        return pulumi.get(self, "retention_unit")

    @retention_unit.setter
    def retention_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_unit", value)


if not MYPY:
    class DatabaseInstanceSettingsConnectionPoolConfigArgsDict(TypedDict):
        connection_pooling_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if the manager connection pooling configuration is enabled.
        """
        flags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigFlagArgsDict']]]]
        """
        List of connection pool configuration flags
        """
elif False:
    DatabaseInstanceSettingsConnectionPoolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsConnectionPoolConfigArgs:
    def __init__(__self__, *,
                 connection_pooling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 flags: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigFlagArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.bool] connection_pooling_enabled: True if the manager connection pooling configuration is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigFlagArgs']]] flags: List of connection pool configuration flags
        """
        if connection_pooling_enabled is not None:
            pulumi.set(__self__, "connection_pooling_enabled", connection_pooling_enabled)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @_builtins.property
    @pulumi.getter(name="connectionPoolingEnabled")
    def connection_pooling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the manager connection pooling configuration is enabled.
        """
        return pulumi.get(self, "connection_pooling_enabled")

    @connection_pooling_enabled.setter
    def connection_pooling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "connection_pooling_enabled", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigFlagArgs']]]]:
        """
        List of connection pool configuration flags
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsConnectionPoolConfigFlagArgs']]]]):
        pulumi.set(self, "flags", value)


if not MYPY:
    class DatabaseInstanceSettingsConnectionPoolConfigFlagArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Name of the flag.
        """
        value: pulumi.Input[_builtins.str]
        """
        Value of the flag.
        """
elif False:
    DatabaseInstanceSettingsConnectionPoolConfigFlagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsConnectionPoolConfigFlagArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Name of the flag.
        :param pulumi.Input[_builtins.str] value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DatabaseInstanceSettingsDataCacheConfigArgsDict(TypedDict):
        data_cache_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether data cache is enabled for the instance. Defaults to `true` for MYSQL Enterprise Plus and PostgreSQL Enterprise Plus instances only. For SQL Server Enterprise Plus instances it defaults to `false`.
        """
elif False:
    DatabaseInstanceSettingsDataCacheConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsDataCacheConfigArgs:
    def __init__(__self__, *,
                 data_cache_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] data_cache_enabled: Whether data cache is enabled for the instance. Defaults to `true` for MYSQL Enterprise Plus and PostgreSQL Enterprise Plus instances only. For SQL Server Enterprise Plus instances it defaults to `false`.
        """
        if data_cache_enabled is not None:
            pulumi.set(__self__, "data_cache_enabled", data_cache_enabled)

    @_builtins.property
    @pulumi.getter(name="dataCacheEnabled")
    def data_cache_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether data cache is enabled for the instance. Defaults to `true` for MYSQL Enterprise Plus and PostgreSQL Enterprise Plus instances only. For SQL Server Enterprise Plus instances it defaults to `false`.
        """
        return pulumi.get(self, "data_cache_enabled")

    @data_cache_enabled.setter
    def data_cache_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_cache_enabled", value)


if not MYPY:
    class DatabaseInstanceSettingsDatabaseFlagArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Name of the flag.
        """
        value: pulumi.Input[_builtins.str]
        """
        Value of the flag.
        """
elif False:
    DatabaseInstanceSettingsDatabaseFlagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsDatabaseFlagArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Name of the flag.
        :param pulumi.Input[_builtins.str] value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DatabaseInstanceSettingsDenyMaintenancePeriodArgsDict(TypedDict):
        end_date: pulumi.Input[_builtins.str]
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        start_date: pulumi.Input[_builtins.str]
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        time: pulumi.Input[_builtins.str]
        """
        Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
elif False:
    DatabaseInstanceSettingsDenyMaintenancePeriodArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsDenyMaintenancePeriodArgs:
    def __init__(__self__, *,
                 end_date: pulumi.Input[_builtins.str],
                 start_date: pulumi.Input[_builtins.str],
                 time: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] end_date: "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        :param pulumi.Input[_builtins.str] start_date: "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        :param pulumi.Input[_builtins.str] time: Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Input[_builtins.str]:
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_date", value)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Input[_builtins.str]:
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-m-dd (the month is without leading zeros)i.e., 2020-1-01, or 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_date", value)

    @_builtins.property
    @pulumi.getter
    def time(self) -> pulumi.Input[_builtins.str]:
        """
        Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time", value)


if not MYPY:
    class DatabaseInstanceSettingsFinalBackupConfigArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if enabled final backup.
        """
        retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of days we retain the final backup after instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years.
        """
elif False:
    DatabaseInstanceSettingsFinalBackupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsFinalBackupConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: True if enabled final backup.
        :param pulumi.Input[_builtins.int] retention_days: The number of days we retain the final backup after instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if enabled final backup.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days we retain the final backup after instance deletion. The valid range is between 1 and 365. For instances managed by BackupDR, the valid range is between 1 day and 99 years.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)


if not MYPY:
    class DatabaseInstanceSettingsInsightsConfigArgsDict(TypedDict):
        query_insights_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if Query Insights feature is enabled.
        """
        query_plans_per_minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        """
        query_string_length: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        """
        record_application_tags: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if Query Insights will record application tags from query when enabled.
        """
        record_client_address: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if Query Insights will record client address when enabled.
        """
elif False:
    DatabaseInstanceSettingsInsightsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsInsightsConfigArgs:
    def __init__(__self__, *,
                 query_insights_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 query_plans_per_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 query_string_length: Optional[pulumi.Input[_builtins.int]] = None,
                 record_application_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 record_client_address: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] query_insights_enabled: True if Query Insights feature is enabled.
        :param pulumi.Input[_builtins.int] query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        :param pulumi.Input[_builtins.int] query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        :param pulumi.Input[_builtins.bool] record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param pulumi.Input[_builtins.bool] record_client_address: True if Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @_builtins.property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @query_insights_enabled.setter
    def query_insights_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "query_insights_enabled", value)

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @query_plans_per_minute.setter
    def query_plans_per_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "query_plans_per_minute", value)

    @_builtins.property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024. Higher query lengths are more useful for analytical queries, but they also require more memory. Changing the query length requires you to restart the instance. You can still add tags to queries that exceed the length limit.
        """
        return pulumi.get(self, "query_string_length")

    @query_string_length.setter
    def query_string_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "query_string_length", value)

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @record_application_tags.setter
    def record_application_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "record_application_tags", value)

    @_builtins.property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")

    @record_client_address.setter
    def record_client_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "record_client_address", value)


if not MYPY:
    class DatabaseInstanceSettingsIpConfigurationArgsDict(TypedDict):
        allocated_ip_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        authorized_networks: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgsDict']]]]
        custom_subject_alternative_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The custom subject alternative names for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        enable_private_path_for_google_cloud_services: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        ipv4_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        private_network: NotRequired[pulumi.Input[_builtins.str]]
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        psc_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigArgsDict']]]]
        """
        PSC settings for a Cloud SQL instance.
        """
        server_ca_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specify how the server certificate's Certificate Authority is hosted. Supported values are `GOOGLE_MANAGED_INTERNAL_CA` and `GOOGLE_MANAGED_CAS_CA`.
        """
        server_ca_pool: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource name of the server CA pool for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        ssl_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specify how SSL connection should be enforced in DB connections. Supported values are `ALLOW_UNENCRYPTED_AND_ENCRYPTED`, `ENCRYPTED_ONLY`, and `TRUSTED_CLIENT_CERTIFICATE_REQUIRED` (not supported for SQL Server). See [API reference doc](https://cloud.google.com/sql/docs/postgres/admin-api/rest/v1/instances#ipconfiguration) for details.
        """
elif False:
    DatabaseInstanceSettingsIpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationArgs:
    def __init__(__self__, *,
                 allocated_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]] = None,
                 custom_subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_private_path_for_google_cloud_services: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv4_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_network: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigArgs']]]] = None,
                 server_ca_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 server_ca_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_subject_alternative_names: The custom subject alternative names for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        :param pulumi.Input[_builtins.bool] enable_private_path_for_google_cloud_services: Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        :param pulumi.Input[_builtins.bool] ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. At least `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param pulumi.Input[_builtins.str] private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigArgs']]] psc_configs: PSC settings for a Cloud SQL instance.
        :param pulumi.Input[_builtins.str] server_ca_mode: Specify how the server certificate's Certificate Authority is hosted. Supported values are `GOOGLE_MANAGED_INTERNAL_CA` and `GOOGLE_MANAGED_CAS_CA`.
        :param pulumi.Input[_builtins.str] server_ca_pool: The resource name of the server CA pool for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        :param pulumi.Input[_builtins.str] ssl_mode: Specify how SSL connection should be enforced in DB connections. Supported values are `ALLOW_UNENCRYPTED_AND_ENCRYPTED`, `ENCRYPTED_ONLY`, and `TRUSTED_CLIENT_CERTIFICATE_REQUIRED` (not supported for SQL Server). See [API reference doc](https://cloud.google.com/sql/docs/postgres/admin-api/rest/v1/instances#ipconfiguration) for details.
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if custom_subject_alternative_names is not None:
            pulumi.set(__self__, "custom_subject_alternative_names", custom_subject_alternative_names)
        if enable_private_path_for_google_cloud_services is not None:
            pulumi.set(__self__, "enable_private_path_for_google_cloud_services", enable_private_path_for_google_cloud_services)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if psc_configs is not None:
            pulumi.set(__self__, "psc_configs", psc_configs)
        if server_ca_mode is not None:
            pulumi.set(__self__, "server_ca_mode", server_ca_mode)
        if server_ca_pool is not None:
            pulumi.set(__self__, "server_ca_pool", server_ca_pool)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @_builtins.property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]:
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @_builtins.property
    @pulumi.getter(name="customSubjectAlternativeNames")
    def custom_subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The custom subject alternative names for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        return pulumi.get(self, "custom_subject_alternative_names")

    @custom_subject_alternative_names.setter
    def custom_subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_subject_alternative_names", value)

    @_builtins.property
    @pulumi.getter(name="enablePrivatePathForGoogleCloudServices")
    def enable_private_path_for_google_cloud_services(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Google Cloud services such as BigQuery are allowed to access data in this Cloud SQL instance over a private IP connection. SQLSERVER database type is not supported.
        """
        return pulumi.get(self, "enable_private_path_for_google_cloud_services")

    @enable_private_path_for_google_cloud_services.setter
    def enable_private_path_for_google_cloud_services(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_private_path_for_google_cloud_services", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_network", value)

    @_builtins.property
    @pulumi.getter(name="pscConfigs")
    def psc_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigArgs']]]]:
        """
        PSC settings for a Cloud SQL instance.
        """
        return pulumi.get(self, "psc_configs")

    @psc_configs.setter
    def psc_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigArgs']]]]):
        pulumi.set(self, "psc_configs", value)

    @_builtins.property
    @pulumi.getter(name="serverCaMode")
    def server_ca_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify how the server certificate's Certificate Authority is hosted. Supported values are `GOOGLE_MANAGED_INTERNAL_CA` and `GOOGLE_MANAGED_CAS_CA`.
        """
        return pulumi.get(self, "server_ca_mode")

    @server_ca_mode.setter
    def server_ca_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_ca_mode", value)

    @_builtins.property
    @pulumi.getter(name="serverCaPool")
    def server_ca_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the server CA pool for an instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`.
        """
        return pulumi.get(self, "server_ca_pool")

    @server_ca_pool.setter
    def server_ca_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_ca_pool", value)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify how SSL connection should be enforced in DB connections. Supported values are `ALLOW_UNENCRYPTED_AND_ENCRYPTED`, `ENCRYPTED_ONLY`, and `TRUSTED_CLIENT_CERTIFICATE_REQUIRED` (not supported for SQL Server). See [API reference doc](https://cloud.google.com/sql/docs/postgres/admin-api/rest/v1/instances#ipconfiguration) for details.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_mode", value)


if not MYPY:
    class DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgsDict(TypedDict):
        value: pulumi.Input[_builtins.str]
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        expiration_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        A name for this whitelist entry.
        """
elif False:
    DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[_builtins.str],
                 expiration_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param pulumi.Input[_builtins.str] expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param pulumi.Input[_builtins.str] name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DatabaseInstanceSettingsIpConfigurationPscConfigArgsDict(TypedDict):
        allowed_consumer_projects: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        network_attachment_uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        """
        psc_auto_connections: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgsDict']]]]
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        psc_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether PSC connectivity is enabled for this instance.
        """
elif False:
    DatabaseInstanceSettingsIpConfigurationPscConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationPscConfigArgs:
    def __init__(__self__, *,
                 allowed_consumer_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_attachment_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 psc_auto_connections: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs']]]] = None,
                 psc_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_consumer_projects: List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        :param pulumi.Input[_builtins.str] network_attachment_uri: Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs']]] psc_auto_connections: A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        :param pulumi.Input[_builtins.bool] psc_enabled: Whether PSC connectivity is enabled for this instance.
        """
        if allowed_consumer_projects is not None:
            pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        if network_attachment_uri is not None:
            pulumi.set(__self__, "network_attachment_uri", network_attachment_uri)
        if psc_auto_connections is not None:
            pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        if psc_enabled is not None:
            pulumi.set(__self__, "psc_enabled", psc_enabled)

    @_builtins.property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of consumer projects that are allow-listed for PSC connections to this instance. This instance can be connected to with PSC from any network in these projects. Each consumer project in this list may be represented by a project number (numeric) or by a project id (alphanumeric).
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @allowed_consumer_projects.setter
    def allowed_consumer_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_consumer_projects", value)

    @_builtins.property
    @pulumi.getter(name="networkAttachmentUri")
    def network_attachment_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of network attachment resource used to authorize a producer service to connect a PSC interface to the consumer's VPC. For example: "projects/myProject/regions/myRegion/networkAttachments/myNetworkAttachment". This is required to enable outbound connection on a PSC instance.
        """
        return pulumi.get(self, "network_attachment_uri")

    @network_attachment_uri.setter
    def network_attachment_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_attachment_uri", value)

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs']]]]:
        """
        A comma-separated list of networks or a comma-separated list of network-project pairs. Each project in this list is represented by a project number (numeric) or by a project ID (alphanumeric). This allows Private Service Connect connections to be created automatically for the specified networks.
        """
        return pulumi.get(self, "psc_auto_connections")

    @psc_auto_connections.setter
    def psc_auto_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs']]]]):
        pulumi.set(self, "psc_auto_connections", value)

    @_builtins.property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether PSC connectivity is enabled for this instance.
        """
        return pulumi.get(self, "psc_enabled")

    @psc_enabled.setter
    def psc_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "psc_enabled", value)


if not MYPY:
    class DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgsDict(TypedDict):
        consumer_network: pulumi.Input[_builtins.str]
        """
        "The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. For example, `projects/project1/global/networks/network1`. The consumer host project of this network might be different from the consumer service project."
        """
        consumer_network_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output) The connection policy status of the consumer network.
        """
        consumer_service_project_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output) The IP address of the consumer endpoint.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output) The connection status of the consumer endpoint.
        """
elif False:
    DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsIpConfigurationPscConfigPscAutoConnectionArgs:
    def __init__(__self__, *,
                 consumer_network: pulumi.Input[_builtins.str],
                 consumer_network_status: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_service_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] consumer_network: "The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. For example, `projects/project1/global/networks/network1`. The consumer host project of this network might be different from the consumer service project."
        :param pulumi.Input[_builtins.str] consumer_network_status: (Output) The connection policy status of the consumer network.
        :param pulumi.Input[_builtins.str] consumer_service_project_id: The project ID of consumer service project of this consumer endpoint.
        :param pulumi.Input[_builtins.str] ip_address: (Output) The IP address of the consumer endpoint.
        :param pulumi.Input[_builtins.str] status: (Output) The connection status of the consumer endpoint.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        if consumer_network_status is not None:
            pulumi.set(__self__, "consumer_network_status", consumer_network_status)
        if consumer_service_project_id is not None:
            pulumi.set(__self__, "consumer_service_project_id", consumer_service_project_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> pulumi.Input[_builtins.str]:
        """
        "The consumer network of this consumer endpoint. This must be a resource path that includes both the host project and the network name. For example, `projects/project1/global/networks/network1`. The consumer host project of this network might be different from the consumer service project."
        """
        return pulumi.get(self, "consumer_network")

    @consumer_network.setter
    def consumer_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "consumer_network", value)

    @_builtins.property
    @pulumi.getter(name="consumerNetworkStatus")
    def consumer_network_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output) The connection policy status of the consumer network.
        """
        return pulumi.get(self, "consumer_network_status")

    @consumer_network_status.setter
    def consumer_network_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumer_network_status", value)

    @_builtins.property
    @pulumi.getter(name="consumerServiceProjectId")
    def consumer_service_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of consumer service project of this consumer endpoint.
        """
        return pulumi.get(self, "consumer_service_project_id")

    @consumer_service_project_id.setter
    def consumer_service_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumer_service_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output) The IP address of the consumer endpoint.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output) The connection status of the consumer endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class DatabaseInstanceSettingsLocationPreferenceArgsDict(TypedDict):
        follow_gae_application: NotRequired[pulumi.Input[_builtins.str]]
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        secondary_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The preferred Compute Engine zone for the secondary/failover.
        """
        zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
elif False:
    DatabaseInstanceSettingsLocationPreferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsLocationPreferenceArgs:
    def __init__(__self__, *,
                 follow_gae_application: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param pulumi.Input[_builtins.str] secondary_zone: The preferred Compute Engine zone for the secondary/failover.
        :param pulumi.Input[_builtins.str] zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @follow_gae_application.setter
    def follow_gae_application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "follow_gae_application", value)

    @_builtins.property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred Compute Engine zone for the secondary/failover.
        """
        return pulumi.get(self, "secondary_zone")

    @secondary_zone.setter
    def secondary_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_zone", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class DatabaseInstanceSettingsMaintenanceWindowArgsDict(TypedDict):
        day: NotRequired[pulumi.Input[_builtins.int]]
        """
        Day of week (`1-7`), starting on Monday
        """
        hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        update_track: NotRequired[pulumi.Input[_builtins.str]]
        """
        Receive updates after one week (`canary`) or after two weeks (`stable`) or after five weeks (`week5`) of notification.
        """
elif False:
    DatabaseInstanceSettingsMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[_builtins.int]] = None,
                 hour: Optional[pulumi.Input[_builtins.int]] = None,
                 update_track: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] day: Day of week (`1-7`), starting on Monday
        :param pulumi.Input[_builtins.int] hour: Hour of day (`0-23`), ignored if `day` not set
        :param pulumi.Input[_builtins.str] update_track: Receive updates after one week (`canary`) or after two weeks (`stable`) or after five weeks (`week5`) of notification.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @_builtins.property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "day", value)

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour", value)

    @_builtins.property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Receive updates after one week (`canary`) or after two weeks (`stable`) or after five weeks (`week5`) of notification.
        """
        return pulumi.get(self, "update_track")

    @update_track.setter
    def update_track(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_track", value)


if not MYPY:
    class DatabaseInstanceSettingsPasswordValidationPolicyArgsDict(TypedDict):
        enable_password_policy: pulumi.Input[_builtins.bool]
        """
        Enables or disable the password validation policy.
        """
        complexity: NotRequired[pulumi.Input[_builtins.str]]
        """
        Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        """
        disallow_username_substring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Prevents the use of the username in the password.
        """
        min_length: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the minimum number of characters that the password must have.
        """
        password_change_interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the minimum duration after which you can change the password.
        """
        reuse_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the number of previous passwords that you can't reuse.
        """
elif False:
    DatabaseInstanceSettingsPasswordValidationPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsPasswordValidationPolicyArgs:
    def __init__(__self__, *,
                 enable_password_policy: pulumi.Input[_builtins.bool],
                 complexity: Optional[pulumi.Input[_builtins.str]] = None,
                 disallow_username_substring: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_change_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 reuse_interval: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_password_policy: Enables or disable the password validation policy.
        :param pulumi.Input[_builtins.str] complexity: Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        :param pulumi.Input[_builtins.bool] disallow_username_substring: Prevents the use of the username in the password.
        :param pulumi.Input[_builtins.int] min_length: Specifies the minimum number of characters that the password must have.
        :param pulumi.Input[_builtins.str] password_change_interval: Specifies the minimum duration after which you can change the password.
        :param pulumi.Input[_builtins.int] reuse_interval: Specifies the number of previous passwords that you can't reuse.
        """
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if disallow_username_substring is not None:
            pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if password_change_interval is not None:
            pulumi.set(__self__, "password_change_interval", password_change_interval)
        if reuse_interval is not None:
            pulumi.set(__self__, "reuse_interval", reuse_interval)

    @_builtins.property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> pulumi.Input[_builtins.bool]:
        """
        Enables or disable the password validation policy.
        """
        return pulumi.get(self, "enable_password_policy")

    @enable_password_policy.setter
    def enable_password_policy(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_password_policy", value)

    @_builtins.property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "complexity", value)

    @_builtins.property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevents the use of the username in the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @disallow_username_substring.setter
    def disallow_username_substring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disallow_username_substring", value)

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of characters that the password must have.
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_length", value)

    @_builtins.property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the minimum duration after which you can change the password.
        """
        return pulumi.get(self, "password_change_interval")

    @password_change_interval.setter
    def password_change_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_change_interval", value)

    @_builtins.property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of previous passwords that you can't reuse.
        """
        return pulumi.get(self, "reuse_interval")

    @reuse_interval.setter
    def reuse_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reuse_interval", value)


if not MYPY:
    class DatabaseInstanceSettingsReadPoolAutoScaleConfigArgsDict(TypedDict):
        disable_scale_in: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if auto scale in is disabled.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if Read Pool Auto Scale is enabled.
        """
        max_node_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of nodes in the read pool. If set to lower than current node count, node count will be updated.
        """
        min_node_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum number of nodes in the read pool. If set to higher than current node count, node count will be updated.
        """
        scale_in_cooldown_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The cooldown period for scale in operations.
        """
        scale_out_cooldown_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The cooldown period for scale out operations.
        """
        target_metrics: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgsDict']]]]
        """
        Target metrics for Read Pool Auto Scale. Must specify `target_metrics.metric` and `target_metrics.target_value` in subblock.
        """
elif False:
    DatabaseInstanceSettingsReadPoolAutoScaleConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsReadPoolAutoScaleConfigArgs:
    def __init__(__self__, *,
                 disable_scale_in: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 min_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_in_cooldown_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_out_cooldown_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 target_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.bool] disable_scale_in: True if auto scale in is disabled.
        :param pulumi.Input[_builtins.bool] enabled: True if Read Pool Auto Scale is enabled.
        :param pulumi.Input[_builtins.int] max_node_count: Maximum number of nodes in the read pool. If set to lower than current node count, node count will be updated.
        :param pulumi.Input[_builtins.int] min_node_count: Minimum number of nodes in the read pool. If set to higher than current node count, node count will be updated.
        :param pulumi.Input[_builtins.int] scale_in_cooldown_seconds: The cooldown period for scale in operations.
        :param pulumi.Input[_builtins.int] scale_out_cooldown_seconds: The cooldown period for scale out operations.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgs']]] target_metrics: Target metrics for Read Pool Auto Scale. Must specify `target_metrics.metric` and `target_metrics.target_value` in subblock.
        """
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if scale_in_cooldown_seconds is not None:
            pulumi.set(__self__, "scale_in_cooldown_seconds", scale_in_cooldown_seconds)
        if scale_out_cooldown_seconds is not None:
            pulumi.set(__self__, "scale_out_cooldown_seconds", scale_out_cooldown_seconds)
        if target_metrics is not None:
            pulumi.set(__self__, "target_metrics", target_metrics)

    @_builtins.property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if auto scale in is disabled.
        """
        return pulumi.get(self, "disable_scale_in")

    @disable_scale_in.setter
    def disable_scale_in(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_scale_in", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if Read Pool Auto Scale is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of nodes in the read pool. If set to lower than current node count, node count will be updated.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_node_count", value)

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of nodes in the read pool. If set to higher than current node count, node count will be updated.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_node_count", value)

    @_builtins.property
    @pulumi.getter(name="scaleInCooldownSeconds")
    def scale_in_cooldown_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The cooldown period for scale in operations.
        """
        return pulumi.get(self, "scale_in_cooldown_seconds")

    @scale_in_cooldown_seconds.setter
    def scale_in_cooldown_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_in_cooldown_seconds", value)

    @_builtins.property
    @pulumi.getter(name="scaleOutCooldownSeconds")
    def scale_out_cooldown_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The cooldown period for scale out operations.
        """
        return pulumi.get(self, "scale_out_cooldown_seconds")

    @scale_out_cooldown_seconds.setter
    def scale_out_cooldown_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_out_cooldown_seconds", value)

    @_builtins.property
    @pulumi.getter(name="targetMetrics")
    def target_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgs']]]]:
        """
        Target metrics for Read Pool Auto Scale. Must specify `target_metrics.metric` and `target_metrics.target_value` in subblock.
        """
        return pulumi.get(self, "target_metrics")

    @target_metrics.setter
    def target_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgs']]]]):
        pulumi.set(self, "target_metrics", value)


if not MYPY:
    class DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgsDict(TypedDict):
        metric: NotRequired[pulumi.Input[_builtins.str]]
        """
        Metric name for Read Pool Auto Scale.
        """
        target_value: NotRequired[pulumi.Input[_builtins.float]]
        """
        Target value for Read Pool Auto Scale.
        """
elif False:
    DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsReadPoolAutoScaleConfigTargetMetricArgs:
    def __init__(__self__, *,
                 metric: Optional[pulumi.Input[_builtins.str]] = None,
                 target_value: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.str] metric: Metric name for Read Pool Auto Scale.
        :param pulumi.Input[_builtins.float] target_value: Target value for Read Pool Auto Scale.
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target_value is not None:
            pulumi.set(__self__, "target_value", target_value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metric name for Read Pool Auto Scale.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Target value for Read Pool Auto Scale.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "target_value", value)


if not MYPY:
    class DatabaseInstanceSettingsSqlServerAuditConfigArgsDict(TypedDict):
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        retention_interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        upload_interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
elif False:
    DatabaseInstanceSettingsSqlServerAuditConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInstanceSettingsSqlServerAuditConfigArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 upload_interval: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param pulumi.Input[_builtins.str] retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[_builtins.str] upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if retention_interval is not None:
            pulumi.set(__self__, "retention_interval", retention_interval)
        if upload_interval is not None:
            pulumi.set(__self__, "upload_interval", upload_interval)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_interval")

    @retention_interval.setter
    def retention_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_interval", value)

    @_builtins.property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")

    @upload_interval.setter
    def upload_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upload_interval", value)


if not MYPY:
    class UserPasswordPolicyArgsDict(TypedDict):
        allowed_failed_attempts: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of failed attempts allowed before the user get locked.
        """
        enable_failed_attempts_check: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If true, the check that will lock user after too many failed login attempts will be enabled.
        """
        enable_password_verification: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        """
        password_expiration_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        Password expiration duration with one week grace period.
        """
        statuses: NotRequired[pulumi.Input[Sequence[pulumi.Input['UserPasswordPolicyStatusArgsDict']]]]
elif False:
    UserPasswordPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserPasswordPolicyArgs:
    def __init__(__self__, *,
                 allowed_failed_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_failed_attempts_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_password_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_expiration_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['UserPasswordPolicyStatusArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.int] allowed_failed_attempts: Number of failed attempts allowed before the user get locked.
        :param pulumi.Input[_builtins.bool] enable_failed_attempts_check: If true, the check that will lock user after too many failed login attempts will be enabled.
        :param pulumi.Input[_builtins.bool] enable_password_verification: If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        :param pulumi.Input[_builtins.str] password_expiration_duration: Password expiration duration with one week grace period.
        """
        if allowed_failed_attempts is not None:
            pulumi.set(__self__, "allowed_failed_attempts", allowed_failed_attempts)
        if enable_failed_attempts_check is not None:
            pulumi.set(__self__, "enable_failed_attempts_check", enable_failed_attempts_check)
        if enable_password_verification is not None:
            pulumi.set(__self__, "enable_password_verification", enable_password_verification)
        if password_expiration_duration is not None:
            pulumi.set(__self__, "password_expiration_duration", password_expiration_duration)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="allowedFailedAttempts")
    def allowed_failed_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of failed attempts allowed before the user get locked.
        """
        return pulumi.get(self, "allowed_failed_attempts")

    @allowed_failed_attempts.setter
    def allowed_failed_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allowed_failed_attempts", value)

    @_builtins.property
    @pulumi.getter(name="enableFailedAttemptsCheck")
    def enable_failed_attempts_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the check that will lock user after too many failed login attempts will be enabled.
        """
        return pulumi.get(self, "enable_failed_attempts_check")

    @enable_failed_attempts_check.setter
    def enable_failed_attempts_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_failed_attempts_check", value)

    @_builtins.property
    @pulumi.getter(name="enablePasswordVerification")
    def enable_password_verification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        """
        return pulumi.get(self, "enable_password_verification")

    @enable_password_verification.setter
    def enable_password_verification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_password_verification", value)

    @_builtins.property
    @pulumi.getter(name="passwordExpirationDuration")
    def password_expiration_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_duration")

    @password_expiration_duration.setter
    def password_expiration_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_expiration_duration", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserPasswordPolicyStatusArgs']]]]:
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserPasswordPolicyStatusArgs']]]]):
        pulumi.set(self, "statuses", value)


if not MYPY:
    class UserPasswordPolicyStatusArgsDict(TypedDict):
        locked: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If true, user does not have login privileges.
        """
        password_expiration_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        Password expiration duration with one week grace period.
        """
elif False:
    UserPasswordPolicyStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserPasswordPolicyStatusArgs:
    def __init__(__self__, *,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_expiration_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] locked: If true, user does not have login privileges.
        :param pulumi.Input[_builtins.str] password_expiration_time: Password expiration duration with one week grace period.
        """
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if password_expiration_time is not None:
            pulumi.set(__self__, "password_expiration_time", password_expiration_time)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, user does not have login privileges.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter(name="passwordExpirationTime")
    def password_expiration_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_time")

    @password_expiration_time.setter
    def password_expiration_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_expiration_time", value)


if not MYPY:
    class UserSqlServerUserDetailArgsDict(TypedDict):
        disabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If the user has been disabled.
        """
        server_roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The server roles for this user in the database.
        """
elif False:
    UserSqlServerUserDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserSqlServerUserDetailArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.bool] disabled: If the user has been disabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_roles: The server roles for this user in the database.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the user has been disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The server roles for this user in the database.
        """
        return pulumi.get(self, "server_roles")

    @server_roles.setter
    def server_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server_roles", value)


