# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransferJobArgs', 'TransferJob']

@pulumi.input_type
class TransferJobArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 event_stream: Optional[pulumi.Input['TransferJobEventStreamArgs']] = None,
                 logging_config: Optional[pulumi.Input['TransferJobLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input['TransferJobNotificationConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_spec: Optional[pulumi.Input['TransferJobReplicationSpecArgs']] = None,
                 schedule: Optional[pulumi.Input['TransferJobScheduleArgs']] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transfer_spec: Optional[pulumi.Input['TransferJobTransferSpecArgs']] = None):
        """
        The set of arguments for constructing a TransferJob resource.
        :param pulumi.Input[_builtins.str] description: Unique description to identify the Transfer Job.
        :param pulumi.Input['TransferJobEventStreamArgs'] event_stream: Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files. Structure documented below Either `event_stream` or `schedule` must be set.
        :param pulumi.Input['TransferJobLoggingConfigArgs'] logging_config: Logging configuration. Structure documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Transfer Job. This name must start with "transferJobs/" prefix and end with a letter or a number, and should be no more than 128 characters ( `transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For transfers involving PosixFilesystem, this name must start with transferJobs/OPI specifically ( `transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For all other transfer types, this name must not start with transferJobs/OPI. Default the provider will assign a random unique name with `transferJobs/{{name}}` format, where `name` is a numeric value.
        :param pulumi.Input['TransferJobNotificationConfigArgs'] notification_config: Notification configuration. This is not supported for transfers involving PosixFilesystem. Structure documented below.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['TransferJobReplicationSpecArgs'] replication_spec: Replication specification. Structure documented below. User should not configure `schedule`, `event_stream` with this argument. One of `transfer_spec`, or `replication_spec` must be specified.
               
               - - -
        :param pulumi.Input['TransferJobScheduleArgs'] schedule: Schedule specification defining when the Transfer Job should be scheduled to start, end and what time to run. Structure documented below. Either `schedule` or `event_stream` must be set.
        :param pulumi.Input[_builtins.str] service_account: The user-managed service account to run the job. If this field is specified, the given service account is granted the necessary permissions to all applicable resources (e.g. GCS buckets) required by the job.
        :param pulumi.Input[_builtins.str] status: Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        :param pulumi.Input['TransferJobTransferSpecArgs'] transfer_spec: Transfer specification. Structure documented below. One of `transfer_spec`, or `replication_spec` can be specified.
        """
        pulumi.set(__self__, "description", description)
        if event_stream is not None:
            pulumi.set(__self__, "event_stream", event_stream)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replication_spec is not None:
            pulumi.set(__self__, "replication_spec", replication_spec)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transfer_spec is not None:
            pulumi.set(__self__, "transfer_spec", transfer_spec)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Unique description to identify the Transfer Job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eventStream")
    def event_stream(self) -> Optional[pulumi.Input['TransferJobEventStreamArgs']]:
        """
        Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files. Structure documented below Either `event_stream` or `schedule` must be set.
        """
        return pulumi.get(self, "event_stream")

    @event_stream.setter
    def event_stream(self, value: Optional[pulumi.Input['TransferJobEventStreamArgs']]):
        pulumi.set(self, "event_stream", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['TransferJobLoggingConfigArgs']]:
        """
        Logging configuration. Structure documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['TransferJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Transfer Job. This name must start with "transferJobs/" prefix and end with a letter or a number, and should be no more than 128 characters ( `transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For transfers involving PosixFilesystem, this name must start with transferJobs/OPI specifically ( `transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For all other transfer types, this name must not start with transferJobs/OPI. Default the provider will assign a random unique name with `transferJobs/{{name}}` format, where `name` is a numeric value.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional[pulumi.Input['TransferJobNotificationConfigArgs']]:
        """
        Notification configuration. This is not supported for transfers involving PosixFilesystem. Structure documented below.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['TransferJobNotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="replicationSpec")
    def replication_spec(self) -> Optional[pulumi.Input['TransferJobReplicationSpecArgs']]:
        """
        Replication specification. Structure documented below. User should not configure `schedule`, `event_stream` with this argument. One of `transfer_spec`, or `replication_spec` must be specified.

        - - -
        """
        return pulumi.get(self, "replication_spec")

    @replication_spec.setter
    def replication_spec(self, value: Optional[pulumi.Input['TransferJobReplicationSpecArgs']]):
        pulumi.set(self, "replication_spec", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TransferJobScheduleArgs']]:
        """
        Schedule specification defining when the Transfer Job should be scheduled to start, end and what time to run. Structure documented below. Either `schedule` or `event_stream` must be set.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TransferJobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-managed service account to run the job. If this field is specified, the given service account is granted the necessary permissions to all applicable resources (e.g. GCS buckets) required by the job.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="transferSpec")
    def transfer_spec(self) -> Optional[pulumi.Input['TransferJobTransferSpecArgs']]:
        """
        Transfer specification. Structure documented below. One of `transfer_spec`, or `replication_spec` can be specified.
        """
        return pulumi.get(self, "transfer_spec")

    @transfer_spec.setter
    def transfer_spec(self, value: Optional[pulumi.Input['TransferJobTransferSpecArgs']]):
        pulumi.set(self, "transfer_spec", value)


@pulumi.input_type
class _TransferJobState:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 event_stream: Optional[pulumi.Input['TransferJobEventStreamArgs']] = None,
                 last_modification_time: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['TransferJobLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input['TransferJobNotificationConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_spec: Optional[pulumi.Input['TransferJobReplicationSpecArgs']] = None,
                 schedule: Optional[pulumi.Input['TransferJobScheduleArgs']] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transfer_spec: Optional[pulumi.Input['TransferJobTransferSpecArgs']] = None):
        """
        Input properties used for looking up and filtering TransferJob resources.
        :param pulumi.Input[_builtins.str] creation_time: When the Transfer Job was created.
        :param pulumi.Input[_builtins.str] deletion_time: When the Transfer Job was deleted.
        :param pulumi.Input[_builtins.str] description: Unique description to identify the Transfer Job.
        :param pulumi.Input['TransferJobEventStreamArgs'] event_stream: Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files. Structure documented below Either `event_stream` or `schedule` must be set.
        :param pulumi.Input[_builtins.str] last_modification_time: When the Transfer Job was last modified.
        :param pulumi.Input['TransferJobLoggingConfigArgs'] logging_config: Logging configuration. Structure documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Transfer Job. This name must start with "transferJobs/" prefix and end with a letter or a number, and should be no more than 128 characters ( `transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For transfers involving PosixFilesystem, this name must start with transferJobs/OPI specifically ( `transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For all other transfer types, this name must not start with transferJobs/OPI. Default the provider will assign a random unique name with `transferJobs/{{name}}` format, where `name` is a numeric value.
        :param pulumi.Input['TransferJobNotificationConfigArgs'] notification_config: Notification configuration. This is not supported for transfers involving PosixFilesystem. Structure documented below.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['TransferJobReplicationSpecArgs'] replication_spec: Replication specification. Structure documented below. User should not configure `schedule`, `event_stream` with this argument. One of `transfer_spec`, or `replication_spec` must be specified.
               
               - - -
        :param pulumi.Input['TransferJobScheduleArgs'] schedule: Schedule specification defining when the Transfer Job should be scheduled to start, end and what time to run. Structure documented below. Either `schedule` or `event_stream` must be set.
        :param pulumi.Input[_builtins.str] service_account: The user-managed service account to run the job. If this field is specified, the given service account is granted the necessary permissions to all applicable resources (e.g. GCS buckets) required by the job.
        :param pulumi.Input[_builtins.str] status: Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        :param pulumi.Input['TransferJobTransferSpecArgs'] transfer_spec: Transfer specification. Structure documented below. One of `transfer_spec`, or `replication_spec` can be specified.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deletion_time is not None:
            pulumi.set(__self__, "deletion_time", deletion_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_stream is not None:
            pulumi.set(__self__, "event_stream", event_stream)
        if last_modification_time is not None:
            pulumi.set(__self__, "last_modification_time", last_modification_time)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replication_spec is not None:
            pulumi.set(__self__, "replication_spec", replication_spec)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transfer_spec is not None:
            pulumi.set(__self__, "transfer_spec", transfer_spec)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Transfer Job was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Transfer Job was deleted.
        """
        return pulumi.get(self, "deletion_time")

    @deletion_time.setter
    def deletion_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique description to identify the Transfer Job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eventStream")
    def event_stream(self) -> Optional[pulumi.Input['TransferJobEventStreamArgs']]:
        """
        Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files. Structure documented below Either `event_stream` or `schedule` must be set.
        """
        return pulumi.get(self, "event_stream")

    @event_stream.setter
    def event_stream(self, value: Optional[pulumi.Input['TransferJobEventStreamArgs']]):
        pulumi.set(self, "event_stream", value)

    @_builtins.property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Transfer Job was last modified.
        """
        return pulumi.get(self, "last_modification_time")

    @last_modification_time.setter
    def last_modification_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modification_time", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['TransferJobLoggingConfigArgs']]:
        """
        Logging configuration. Structure documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['TransferJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Transfer Job. This name must start with "transferJobs/" prefix and end with a letter or a number, and should be no more than 128 characters ( `transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For transfers involving PosixFilesystem, this name must start with transferJobs/OPI specifically ( `transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For all other transfer types, this name must not start with transferJobs/OPI. Default the provider will assign a random unique name with `transferJobs/{{name}}` format, where `name` is a numeric value.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional[pulumi.Input['TransferJobNotificationConfigArgs']]:
        """
        Notification configuration. This is not supported for transfers involving PosixFilesystem. Structure documented below.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['TransferJobNotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="replicationSpec")
    def replication_spec(self) -> Optional[pulumi.Input['TransferJobReplicationSpecArgs']]:
        """
        Replication specification. Structure documented below. User should not configure `schedule`, `event_stream` with this argument. One of `transfer_spec`, or `replication_spec` must be specified.

        - - -
        """
        return pulumi.get(self, "replication_spec")

    @replication_spec.setter
    def replication_spec(self, value: Optional[pulumi.Input['TransferJobReplicationSpecArgs']]):
        pulumi.set(self, "replication_spec", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TransferJobScheduleArgs']]:
        """
        Schedule specification defining when the Transfer Job should be scheduled to start, end and what time to run. Structure documented below. Either `schedule` or `event_stream` must be set.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TransferJobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-managed service account to run the job. If this field is specified, the given service account is granted the necessary permissions to all applicable resources (e.g. GCS buckets) required by the job.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="transferSpec")
    def transfer_spec(self) -> Optional[pulumi.Input['TransferJobTransferSpecArgs']]:
        """
        Transfer specification. Structure documented below. One of `transfer_spec`, or `replication_spec` can be specified.
        """
        return pulumi.get(self, "transfer_spec")

    @transfer_spec.setter
    def transfer_spec(self, value: Optional[pulumi.Input['TransferJobTransferSpecArgs']]):
        pulumi.set(self, "transfer_spec", value)


@pulumi.type_token("gcp:storage/transferJob:TransferJob")
class TransferJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 event_stream: Optional[pulumi.Input[Union['TransferJobEventStreamArgs', 'TransferJobEventStreamArgsDict']]] = None,
                 logging_config: Optional[pulumi.Input[Union['TransferJobLoggingConfigArgs', 'TransferJobLoggingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input[Union['TransferJobNotificationConfigArgs', 'TransferJobNotificationConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_spec: Optional[pulumi.Input[Union['TransferJobReplicationSpecArgs', 'TransferJobReplicationSpecArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['TransferJobScheduleArgs', 'TransferJobScheduleArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transfer_spec: Optional[pulumi.Input[Union['TransferJobTransferSpecArgs', 'TransferJobTransferSpecArgsDict']]] = None,
                 __props__=None):
        """
        Creates a new Transfer Job in Google Cloud Storage Transfer.

        To get more information about Google Cloud Storage Transfer, see:

        * [Overview](https://cloud.google.com/storage-transfer/docs/overview)
        * [API documentation](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/transferJobs)
        * How-to Guides
            * [Configuring Access to Data Sources and Sinks](https://cloud.google.com/storage-transfer/docs/configure-access)

        ## Example Usage

        Example creating a nightly Transfer Job from an AWS S3 Bucket to a GCS bucket.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.get_transfer_project_service_account(project=project)
        s3_backup_bucket = gcp.storage.Bucket("s3-backup-bucket",
            name=f"{aws_s3_bucket}-backup",
            storage_class="NEARLINE",
            project=project,
            location="US")
        s3_backup_bucket_bucket_iam_member = gcp.storage.BucketIAMMember("s3-backup-bucket",
            bucket=s3_backup_bucket.name,
            role="roles/storage.admin",
            member=f"serviceAccount:{default.email}",
            opts = pulumi.ResourceOptions(depends_on=[s3_backup_bucket]))
        topic = gcp.pubsub.Topic("topic", name=pubsub_topic_name)
        notification_config = gcp.pubsub.TopicIAMMember("notification_config",
            topic=topic.id,
            role="roles/pubsub.publisher",
            member=f"serviceAccount:{default.email}")
        s3_bucket_nightly_backup = gcp.storage.TransferJob("s3-bucket-nightly-backup",
            description="Nightly backup of S3 bucket",
            project=project,
            transfer_spec={
                "object_conditions": {
                    "max_time_elapsed_since_last_modification": "600s",
                    "exclude_prefixes": ["requests.gz"],
                },
                "transfer_options": {
                    "delete_objects_unique_in_sink": False,
                },
                "aws_s3_data_source": {
                    "bucket_name": aws_s3_bucket,
                    "aws_access_key": {
                        "access_key_id": aws_access_key,
                        "secret_access_key": aws_secret_key,
                    },
                },
                "gcs_data_sink": {
                    "bucket_name": s3_backup_bucket.name,
                    "path": "foo/bar/",
                },
            },
            schedule={
                "schedule_start_date": {
                    "year": 2018,
                    "month": 10,
                    "day": 1,
                },
                "schedule_end_date": {
                    "year": 2019,
                    "month": 1,
                    "day": 15,
                },
                "start_time_of_day": {
                    "hours": 23,
                    "minutes": 30,
                    "seconds": 0,
                    "nanos": 0,
                },
                "repeat_interval": "604800s",
            },
            notification_config={
                "pubsub_topic": topic.id,
                "event_types": [
                    "TRANSFER_OPERATION_SUCCESS",
                    "TRANSFER_OPERATION_FAILED",
                ],
                "payload_format": "JSON",
            },
            logging_config={
                "log_actions": [
                    "COPY",
                    "DELETE",
                ],
                "log_action_states": [
                    "SUCCEEDED",
                    "FAILED",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    s3_backup_bucket_bucket_iam_member,
                    notification_config,
                ]))
        ```

        ## Import

        Storage Transfer Jobs can be imported using the Transfer Job's `project` and `name` (without the `transferJob/` prefix), e.g.

        * `{{project_id}}/{{name}}`, where `name` is a numeric value.

        When using the `pulumi import` command, Storage Transfer Jobs can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/transferJob:TransferJob default {{project_id}}/123456789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Unique description to identify the Transfer Job.
        :param pulumi.Input[Union['TransferJobEventStreamArgs', 'TransferJobEventStreamArgsDict']] event_stream: Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files. Structure documented below Either `event_stream` or `schedule` must be set.
        :param pulumi.Input[Union['TransferJobLoggingConfigArgs', 'TransferJobLoggingConfigArgsDict']] logging_config: Logging configuration. Structure documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Transfer Job. This name must start with "transferJobs/" prefix and end with a letter or a number, and should be no more than 128 characters ( `transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For transfers involving PosixFilesystem, this name must start with transferJobs/OPI specifically ( `transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For all other transfer types, this name must not start with transferJobs/OPI. Default the provider will assign a random unique name with `transferJobs/{{name}}` format, where `name` is a numeric value.
        :param pulumi.Input[Union['TransferJobNotificationConfigArgs', 'TransferJobNotificationConfigArgsDict']] notification_config: Notification configuration. This is not supported for transfers involving PosixFilesystem. Structure documented below.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['TransferJobReplicationSpecArgs', 'TransferJobReplicationSpecArgsDict']] replication_spec: Replication specification. Structure documented below. User should not configure `schedule`, `event_stream` with this argument. One of `transfer_spec`, or `replication_spec` must be specified.
               
               - - -
        :param pulumi.Input[Union['TransferJobScheduleArgs', 'TransferJobScheduleArgsDict']] schedule: Schedule specification defining when the Transfer Job should be scheduled to start, end and what time to run. Structure documented below. Either `schedule` or `event_stream` must be set.
        :param pulumi.Input[_builtins.str] service_account: The user-managed service account to run the job. If this field is specified, the given service account is granted the necessary permissions to all applicable resources (e.g. GCS buckets) required by the job.
        :param pulumi.Input[_builtins.str] status: Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        :param pulumi.Input[Union['TransferJobTransferSpecArgs', 'TransferJobTransferSpecArgsDict']] transfer_spec: Transfer specification. Structure documented below. One of `transfer_spec`, or `replication_spec` can be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransferJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Transfer Job in Google Cloud Storage Transfer.

        To get more information about Google Cloud Storage Transfer, see:

        * [Overview](https://cloud.google.com/storage-transfer/docs/overview)
        * [API documentation](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/transferJobs)
        * How-to Guides
            * [Configuring Access to Data Sources and Sinks](https://cloud.google.com/storage-transfer/docs/configure-access)

        ## Example Usage

        Example creating a nightly Transfer Job from an AWS S3 Bucket to a GCS bucket.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.storage.get_transfer_project_service_account(project=project)
        s3_backup_bucket = gcp.storage.Bucket("s3-backup-bucket",
            name=f"{aws_s3_bucket}-backup",
            storage_class="NEARLINE",
            project=project,
            location="US")
        s3_backup_bucket_bucket_iam_member = gcp.storage.BucketIAMMember("s3-backup-bucket",
            bucket=s3_backup_bucket.name,
            role="roles/storage.admin",
            member=f"serviceAccount:{default.email}",
            opts = pulumi.ResourceOptions(depends_on=[s3_backup_bucket]))
        topic = gcp.pubsub.Topic("topic", name=pubsub_topic_name)
        notification_config = gcp.pubsub.TopicIAMMember("notification_config",
            topic=topic.id,
            role="roles/pubsub.publisher",
            member=f"serviceAccount:{default.email}")
        s3_bucket_nightly_backup = gcp.storage.TransferJob("s3-bucket-nightly-backup",
            description="Nightly backup of S3 bucket",
            project=project,
            transfer_spec={
                "object_conditions": {
                    "max_time_elapsed_since_last_modification": "600s",
                    "exclude_prefixes": ["requests.gz"],
                },
                "transfer_options": {
                    "delete_objects_unique_in_sink": False,
                },
                "aws_s3_data_source": {
                    "bucket_name": aws_s3_bucket,
                    "aws_access_key": {
                        "access_key_id": aws_access_key,
                        "secret_access_key": aws_secret_key,
                    },
                },
                "gcs_data_sink": {
                    "bucket_name": s3_backup_bucket.name,
                    "path": "foo/bar/",
                },
            },
            schedule={
                "schedule_start_date": {
                    "year": 2018,
                    "month": 10,
                    "day": 1,
                },
                "schedule_end_date": {
                    "year": 2019,
                    "month": 1,
                    "day": 15,
                },
                "start_time_of_day": {
                    "hours": 23,
                    "minutes": 30,
                    "seconds": 0,
                    "nanos": 0,
                },
                "repeat_interval": "604800s",
            },
            notification_config={
                "pubsub_topic": topic.id,
                "event_types": [
                    "TRANSFER_OPERATION_SUCCESS",
                    "TRANSFER_OPERATION_FAILED",
                ],
                "payload_format": "JSON",
            },
            logging_config={
                "log_actions": [
                    "COPY",
                    "DELETE",
                ],
                "log_action_states": [
                    "SUCCEEDED",
                    "FAILED",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    s3_backup_bucket_bucket_iam_member,
                    notification_config,
                ]))
        ```

        ## Import

        Storage Transfer Jobs can be imported using the Transfer Job's `project` and `name` (without the `transferJob/` prefix), e.g.

        * `{{project_id}}/{{name}}`, where `name` is a numeric value.

        When using the `pulumi import` command, Storage Transfer Jobs can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/transferJob:TransferJob default {{project_id}}/123456789
        ```

        :param str resource_name: The name of the resource.
        :param TransferJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransferJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 event_stream: Optional[pulumi.Input[Union['TransferJobEventStreamArgs', 'TransferJobEventStreamArgsDict']]] = None,
                 logging_config: Optional[pulumi.Input[Union['TransferJobLoggingConfigArgs', 'TransferJobLoggingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_config: Optional[pulumi.Input[Union['TransferJobNotificationConfigArgs', 'TransferJobNotificationConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_spec: Optional[pulumi.Input[Union['TransferJobReplicationSpecArgs', 'TransferJobReplicationSpecArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['TransferJobScheduleArgs', 'TransferJobScheduleArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 transfer_spec: Optional[pulumi.Input[Union['TransferJobTransferSpecArgs', 'TransferJobTransferSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransferJobArgs.__new__(TransferJobArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["event_stream"] = event_stream
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_config"] = notification_config
            __props__.__dict__["project"] = project
            __props__.__dict__["replication_spec"] = replication_spec
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["status"] = status
            __props__.__dict__["transfer_spec"] = transfer_spec
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["deletion_time"] = None
            __props__.__dict__["last_modification_time"] = None
        super(TransferJob, __self__).__init__(
            'gcp:storage/transferJob:TransferJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            event_stream: Optional[pulumi.Input[Union['TransferJobEventStreamArgs', 'TransferJobEventStreamArgsDict']]] = None,
            last_modification_time: Optional[pulumi.Input[_builtins.str]] = None,
            logging_config: Optional[pulumi.Input[Union['TransferJobLoggingConfigArgs', 'TransferJobLoggingConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_config: Optional[pulumi.Input[Union['TransferJobNotificationConfigArgs', 'TransferJobNotificationConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            replication_spec: Optional[pulumi.Input[Union['TransferJobReplicationSpecArgs', 'TransferJobReplicationSpecArgsDict']]] = None,
            schedule: Optional[pulumi.Input[Union['TransferJobScheduleArgs', 'TransferJobScheduleArgsDict']]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            transfer_spec: Optional[pulumi.Input[Union['TransferJobTransferSpecArgs', 'TransferJobTransferSpecArgsDict']]] = None) -> 'TransferJob':
        """
        Get an existing TransferJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_time: When the Transfer Job was created.
        :param pulumi.Input[_builtins.str] deletion_time: When the Transfer Job was deleted.
        :param pulumi.Input[_builtins.str] description: Unique description to identify the Transfer Job.
        :param pulumi.Input[Union['TransferJobEventStreamArgs', 'TransferJobEventStreamArgsDict']] event_stream: Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files. Structure documented below Either `event_stream` or `schedule` must be set.
        :param pulumi.Input[_builtins.str] last_modification_time: When the Transfer Job was last modified.
        :param pulumi.Input[Union['TransferJobLoggingConfigArgs', 'TransferJobLoggingConfigArgsDict']] logging_config: Logging configuration. Structure documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Transfer Job. This name must start with "transferJobs/" prefix and end with a letter or a number, and should be no more than 128 characters ( `transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For transfers involving PosixFilesystem, this name must start with transferJobs/OPI specifically ( `transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For all other transfer types, this name must not start with transferJobs/OPI. Default the provider will assign a random unique name with `transferJobs/{{name}}` format, where `name` is a numeric value.
        :param pulumi.Input[Union['TransferJobNotificationConfigArgs', 'TransferJobNotificationConfigArgsDict']] notification_config: Notification configuration. This is not supported for transfers involving PosixFilesystem. Structure documented below.
        :param pulumi.Input[_builtins.str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['TransferJobReplicationSpecArgs', 'TransferJobReplicationSpecArgsDict']] replication_spec: Replication specification. Structure documented below. User should not configure `schedule`, `event_stream` with this argument. One of `transfer_spec`, or `replication_spec` must be specified.
               
               - - -
        :param pulumi.Input[Union['TransferJobScheduleArgs', 'TransferJobScheduleArgsDict']] schedule: Schedule specification defining when the Transfer Job should be scheduled to start, end and what time to run. Structure documented below. Either `schedule` or `event_stream` must be set.
        :param pulumi.Input[_builtins.str] service_account: The user-managed service account to run the job. If this field is specified, the given service account is granted the necessary permissions to all applicable resources (e.g. GCS buckets) required by the job.
        :param pulumi.Input[_builtins.str] status: Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        :param pulumi.Input[Union['TransferJobTransferSpecArgs', 'TransferJobTransferSpecArgsDict']] transfer_spec: Transfer specification. Structure documented below. One of `transfer_spec`, or `replication_spec` can be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransferJobState.__new__(_TransferJobState)

        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["deletion_time"] = deletion_time
        __props__.__dict__["description"] = description
        __props__.__dict__["event_stream"] = event_stream
        __props__.__dict__["last_modification_time"] = last_modification_time
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_config"] = notification_config
        __props__.__dict__["project"] = project
        __props__.__dict__["replication_spec"] = replication_spec
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["status"] = status
        __props__.__dict__["transfer_spec"] = transfer_spec
        return TransferJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        When the Transfer Job was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> pulumi.Output[_builtins.str]:
        """
        When the Transfer Job was deleted.
        """
        return pulumi.get(self, "deletion_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Unique description to identify the Transfer Job.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eventStream")
    def event_stream(self) -> pulumi.Output[Optional['outputs.TransferJobEventStream']]:
        """
        Specifies the Event-driven transfer options. Event-driven transfers listen to an event stream to transfer updated files. Structure documented below Either `event_stream` or `schedule` must be set.
        """
        return pulumi.get(self, "event_stream")

    @_builtins.property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> pulumi.Output[_builtins.str]:
        """
        When the Transfer Job was last modified.
        """
        return pulumi.get(self, "last_modification_time")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.TransferJobLoggingConfig']]:
        """
        Logging configuration. Structure documented below.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Transfer Job. This name must start with "transferJobs/" prefix and end with a letter or a number, and should be no more than 128 characters ( `transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For transfers involving PosixFilesystem, this name must start with transferJobs/OPI specifically ( `transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$` ). For all other transfer types, this name must not start with transferJobs/OPI. Default the provider will assign a random unique name with `transferJobs/{{name}}` format, where `name` is a numeric value.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> pulumi.Output[Optional['outputs.TransferJobNotificationConfig']]:
        """
        Notification configuration. This is not supported for transfers involving PosixFilesystem. Structure documented below.
        """
        return pulumi.get(self, "notification_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="replicationSpec")
    def replication_spec(self) -> pulumi.Output[Optional['outputs.TransferJobReplicationSpec']]:
        """
        Replication specification. Structure documented below. User should not configure `schedule`, `event_stream` with this argument. One of `transfer_spec`, or `replication_spec` must be specified.

        - - -
        """
        return pulumi.get(self, "replication_spec")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.TransferJobSchedule']]:
        """
        Schedule specification defining when the Transfer Job should be scheduled to start, end and what time to run. Structure documented below. Either `schedule` or `event_stream` must be set.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user-managed service account to run the job. If this field is specified, the given service account is granted the necessary permissions to all applicable resources (e.g. GCS buckets) required by the job.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transferSpec")
    def transfer_spec(self) -> pulumi.Output[Optional['outputs.TransferJobTransferSpec']]:
        """
        Transfer specification. Structure documented below. One of `transfer_spec`, or `replication_spec` can be specified.
        """
        return pulumi.get(self, "transfer_spec")

