# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AiCacheConfigArgs', 'AiCacheConfig']

@pulumi.input_type
class AiCacheConfigArgs:
    def __init__(__self__, *,
                 disable_cache: pulumi.Input[_builtins.bool],
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AiCacheConfig resource.
        :param pulumi.Input[_builtins.bool] disable_cache: If set to true, disables GenAI caching. Otherwise caching is enabled.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "disable_cache", disable_cache)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="disableCache")
    def disable_cache(self) -> pulumi.Input[_builtins.bool]:
        """
        If set to true, disables GenAI caching. Otherwise caching is enabled.
        """
        return pulumi.get(self, "disable_cache")

    @disable_cache.setter
    def disable_cache(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "disable_cache", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AiCacheConfigState:
    def __init__(__self__, *,
                 disable_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiCacheConfig resources.
        :param pulumi.Input[_builtins.bool] disable_cache: If set to true, disables GenAI caching. Otherwise caching is enabled.
        :param pulumi.Input[_builtins.str] name: Identifier. name of the cache config. Format: - `projects/{project}/cacheConfig`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if disable_cache is not None:
            pulumi.set(__self__, "disable_cache", disable_cache)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="disableCache")
    def disable_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, disables GenAI caching. Otherwise caching is enabled.
        """
        return pulumi.get(self, "disable_cache")

    @disable_cache.setter
    def disable_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_cache", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. name of the cache config. Format: - `projects/{project}/cacheConfig`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:vertex/aiCacheConfig:AiCacheConfig")
class AiCacheConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Config of GenAI caching features. This is a singleton resource.

        To get more information about CacheConfig, see:

        * [API documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/reference/rest/v1/projects/updateCacheConfig)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/reference/rest/Shared.Types/CacheConfig)

        ## Example Usage

        ### Vertex Ai Cache Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache_config = gcp.vertex.AiCacheConfig("cache_config",
            project="my-project-name",
            disable_cache=True)
        ```

        ## Import

        CacheConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/cacheConfig`

        * `{{project}}`

        When using the `pulumi import` command, CacheConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiCacheConfig:AiCacheConfig default projects/{{project}}/cacheConfig
        ```

        ```sh
        $ pulumi import gcp:vertex/aiCacheConfig:AiCacheConfig default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disable_cache: If set to true, disables GenAI caching. Otherwise caching is enabled.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiCacheConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Config of GenAI caching features. This is a singleton resource.

        To get more information about CacheConfig, see:

        * [API documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/reference/rest/v1/projects/updateCacheConfig)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/generative-ai/docs/reference/rest/Shared.Types/CacheConfig)

        ## Example Usage

        ### Vertex Ai Cache Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache_config = gcp.vertex.AiCacheConfig("cache_config",
            project="my-project-name",
            disable_cache=True)
        ```

        ## Import

        CacheConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/cacheConfig`

        * `{{project}}`

        When using the `pulumi import` command, CacheConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiCacheConfig:AiCacheConfig default projects/{{project}}/cacheConfig
        ```

        ```sh
        $ pulumi import gcp:vertex/aiCacheConfig:AiCacheConfig default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param AiCacheConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiCacheConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiCacheConfigArgs.__new__(AiCacheConfigArgs)

            if disable_cache is None and not opts.urn:
                raise TypeError("Missing required property 'disable_cache'")
            __props__.__dict__["disable_cache"] = disable_cache
            __props__.__dict__["project"] = project
            __props__.__dict__["name"] = None
        super(AiCacheConfig, __self__).__init__(
            'gcp:vertex/aiCacheConfig:AiCacheConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disable_cache: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None) -> 'AiCacheConfig':
        """
        Get an existing AiCacheConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disable_cache: If set to true, disables GenAI caching. Otherwise caching is enabled.
        :param pulumi.Input[_builtins.str] name: Identifier. name of the cache config. Format: - `projects/{project}/cacheConfig`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiCacheConfigState.__new__(_AiCacheConfigState)

        __props__.__dict__["disable_cache"] = disable_cache
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return AiCacheConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="disableCache")
    def disable_cache(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, disables GenAI caching. Otherwise caching is enabled.
        """
        return pulumi.get(self, "disable_cache")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. name of the cache config. Format: - `projects/{project}/cacheConfig`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

