# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiEndpointWithModelGardenDeploymentArgs', 'AiEndpointWithModelGardenDeployment']

@pulumi.input_type
class AiEndpointWithModelGardenDeploymentArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 deploy_config: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs']] = None,
                 endpoint_config: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs']] = None,
                 hugging_face_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 model_config: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_model_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AiEndpointWithModelGardenDeployment resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `location`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs'] deploy_config: The deploy config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs'] endpoint_config: The endpoint config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] hugging_face_model_id: The Hugging Face model to deploy.
               Format: Hugging Face model ID like `google/gemma-2-2b-it`.
        :param pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs'] model_config: The model config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] publisher_model_name: The Model Garden model to deploy.
               Format:
               `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
               `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
        """
        pulumi.set(__self__, "location", location)
        if deploy_config is not None:
            pulumi.set(__self__, "deploy_config", deploy_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if hugging_face_model_id is not None:
            pulumi.set(__self__, "hugging_face_model_id", hugging_face_model_id)
        if model_config is not None:
            pulumi.set(__self__, "model_config", model_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publisher_model_name is not None:
            pulumi.set(__self__, "publisher_model_name", publisher_model_name)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `location`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="deployConfig")
    def deploy_config(self) -> Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs']]:
        """
        The deploy config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "deploy_config")

    @deploy_config.setter
    def deploy_config(self, value: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs']]):
        pulumi.set(self, "deploy_config", value)

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs']]:
        """
        The endpoint config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @_builtins.property
    @pulumi.getter(name="huggingFaceModelId")
    def hugging_face_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Hugging Face model to deploy.
        Format: Hugging Face model ID like `google/gemma-2-2b-it`.
        """
        return pulumi.get(self, "hugging_face_model_id")

    @hugging_face_model_id.setter
    def hugging_face_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hugging_face_model_id", value)

    @_builtins.property
    @pulumi.getter(name="modelConfig")
    def model_config(self) -> Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs']]:
        """
        The model config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "model_config")

    @model_config.setter
    def model_config(self, value: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs']]):
        pulumi.set(self, "model_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="publisherModelName")
    def publisher_model_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Model Garden model to deploy.
        Format:
        `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
        `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
        """
        return pulumi.get(self, "publisher_model_name")

    @publisher_model_name.setter
    def publisher_model_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publisher_model_name", value)


@pulumi.input_type
class _AiEndpointWithModelGardenDeploymentState:
    def __init__(__self__, *,
                 deploy_config: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs']] = None,
                 deployed_model_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 deployed_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_config: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs']] = None,
                 hugging_face_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 model_config: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_model_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiEndpointWithModelGardenDeployment resources.
        :param pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs'] deploy_config: The deploy config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] deployed_model_display_name: Output only. The display name assigned to the model deployed to the endpoint.
               This is not required to delete the resource but is used for debug logging.
        :param pulumi.Input[_builtins.str] deployed_model_id: Output only. The unique numeric ID that Vertex AI assigns to the model at the time it is deployed to the endpoint.
               It is required to undeploy the model from the endpoint during resource deletion as described in
               https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.endpoints/undeployModel.
        :param pulumi.Input[_builtins.str] endpoint: Resource ID segment making up resource `endpoint`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs'] endpoint_config: The endpoint config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] hugging_face_model_id: The Hugging Face model to deploy.
               Format: Hugging Face model ID like `google/gemma-2-2b-it`.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `location`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs'] model_config: The model config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] publisher_model_name: The Model Garden model to deploy.
               Format:
               `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
               `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
        """
        if deploy_config is not None:
            pulumi.set(__self__, "deploy_config", deploy_config)
        if deployed_model_display_name is not None:
            pulumi.set(__self__, "deployed_model_display_name", deployed_model_display_name)
        if deployed_model_id is not None:
            pulumi.set(__self__, "deployed_model_id", deployed_model_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if hugging_face_model_id is not None:
            pulumi.set(__self__, "hugging_face_model_id", hugging_face_model_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if model_config is not None:
            pulumi.set(__self__, "model_config", model_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publisher_model_name is not None:
            pulumi.set(__self__, "publisher_model_name", publisher_model_name)

    @_builtins.property
    @pulumi.getter(name="deployConfig")
    def deploy_config(self) -> Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs']]:
        """
        The deploy config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "deploy_config")

    @deploy_config.setter
    def deploy_config(self, value: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentDeployConfigArgs']]):
        pulumi.set(self, "deploy_config", value)

    @_builtins.property
    @pulumi.getter(name="deployedModelDisplayName")
    def deployed_model_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The display name assigned to the model deployed to the endpoint.
        This is not required to delete the resource but is used for debug logging.
        """
        return pulumi.get(self, "deployed_model_display_name")

    @deployed_model_display_name.setter
    def deployed_model_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployed_model_display_name", value)

    @_builtins.property
    @pulumi.getter(name="deployedModelId")
    def deployed_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The unique numeric ID that Vertex AI assigns to the model at the time it is deployed to the endpoint.
        It is required to undeploy the model from the endpoint during resource deletion as described in
        https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.endpoints/undeployModel.
        """
        return pulumi.get(self, "deployed_model_id")

    @deployed_model_id.setter
    def deployed_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployed_model_id", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `endpoint`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs']]:
        """
        The endpoint config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentEndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @_builtins.property
    @pulumi.getter(name="huggingFaceModelId")
    def hugging_face_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Hugging Face model to deploy.
        Format: Hugging Face model ID like `google/gemma-2-2b-it`.
        """
        return pulumi.get(self, "hugging_face_model_id")

    @hugging_face_model_id.setter
    def hugging_face_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hugging_face_model_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `location`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="modelConfig")
    def model_config(self) -> Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs']]:
        """
        The model config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "model_config")

    @model_config.setter
    def model_config(self, value: Optional[pulumi.Input['AiEndpointWithModelGardenDeploymentModelConfigArgs']]):
        pulumi.set(self, "model_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="publisherModelName")
    def publisher_model_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Model Garden model to deploy.
        Format:
        `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
        `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
        """
        return pulumi.get(self, "publisher_model_name")

    @publisher_model_name.setter
    def publisher_model_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publisher_model_name", value)


@pulumi.type_token("gcp:vertex/aiEndpointWithModelGardenDeployment:AiEndpointWithModelGardenDeployment")
class AiEndpointWithModelGardenDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentDeployConfigArgs', 'AiEndpointWithModelGardenDeploymentDeployConfigArgsDict']]] = None,
                 endpoint_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentEndpointConfigArgs', 'AiEndpointWithModelGardenDeploymentEndpointConfigArgsDict']]] = None,
                 hugging_face_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 model_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentModelConfigArgs', 'AiEndpointWithModelGardenDeploymentModelConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_model_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create an Endpoint and deploy a Model Garden model to it.

        To get more information about EndpointWithModelGardenDeployment, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations/deploy)
        * How-to Guides
            * [Overview of Model Garden](https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/explore-models)
            * [Overview of self-deployed models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/self-deployed-models)
            * [Use models in Model Garden](https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/use-models)

        ## Example Usage

        ### Vertex Ai Deploy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            })
        ```
        ### Vertex Ai Deploy Huggingface Model

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            hugging_face_model_id="Qwen/Qwen3-0.6B",
            location="us-central1",
            model_config={
                "accept_eula": True,
            })
        ```
        ### Vertex Ai Deploy With Configs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-16",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        ```
        ### Vertex Ai Deploy Multiple Models In Parallel

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy_gemma_11_2b_it = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-gemma-1_1-2b-it",
            publisher_model_name="publishers/google/models/gemma@gemma-1.1-2b-it",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "us-central1",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        deploy_qwen3_06b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-qwen3-0_6b",
            hugging_face_model_id="Qwen/Qwen3-0.6B",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        deploy_llama_32_1b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-llama-3_2-1b",
            publisher_model_name="publishers/meta/models/llama3-2@llama-3.2-1b",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        ```
        ### Vertex Ai Deploy Multiple Models In Sequence

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy_gemma_11_2b_it = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-gemma-1_1-2b-it",
            publisher_model_name="publishers/google/models/gemma@gemma-1.1-2b-it",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        deploy_qwen3_06b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-qwen3-0_6b",
            hugging_face_model_id="Qwen/Qwen3-0.6B",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[deploy_gemma_11_2b_it]))
        deploy_llama_32_1b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-llama-3_2-1b",
            publisher_model_name="publishers/meta/models/llama3-2@llama-3.2-1b",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[deploy_qwen3_06b]))
        ```
        ### Vertex Ai Deploy Psc Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            endpoint_config={
                "private_service_connect_config": {
                    "enable_private_service_connect": True,
                    "project_allowlists": ["my-project-id"],
                },
            })
        ```
        ### Vertex Ai Deploy Psc Endpoint Automated

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        project = gcp.organizations.get_project()
        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            endpoint_config={
                "private_service_connect_config": {
                    "enable_private_service_connect": True,
                    "project_allowlists": [project.id],
                    "psc_automation_configs": {
                        "project_id": project.id,
                        "network": network.id,
                    },
                },
            })
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="subnetwork",
            ip_cidr_range="192.168.0.0/24",
            region="us-central1",
            network=network.id)
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiEndpointWithModelGardenDeploymentDeployConfigArgs', 'AiEndpointWithModelGardenDeploymentDeployConfigArgsDict']] deploy_config: The deploy config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[Union['AiEndpointWithModelGardenDeploymentEndpointConfigArgs', 'AiEndpointWithModelGardenDeploymentEndpointConfigArgsDict']] endpoint_config: The endpoint config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] hugging_face_model_id: The Hugging Face model to deploy.
               Format: Hugging Face model ID like `google/gemma-2-2b-it`.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `location`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['AiEndpointWithModelGardenDeploymentModelConfigArgs', 'AiEndpointWithModelGardenDeploymentModelConfigArgsDict']] model_config: The model config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] publisher_model_name: The Model Garden model to deploy.
               Format:
               `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
               `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiEndpointWithModelGardenDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an Endpoint and deploy a Model Garden model to it.

        To get more information about EndpointWithModelGardenDeployment, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations/deploy)
        * How-to Guides
            * [Overview of Model Garden](https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/explore-models)
            * [Overview of self-deployed models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/self-deployed-models)
            * [Use models in Model Garden](https://cloud.google.com/vertex-ai/generative-ai/docs/model-garden/use-models)

        ## Example Usage

        ### Vertex Ai Deploy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            })
        ```
        ### Vertex Ai Deploy Huggingface Model

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            hugging_face_model_id="Qwen/Qwen3-0.6B",
            location="us-central1",
            model_config={
                "accept_eula": True,
            })
        ```
        ### Vertex Ai Deploy With Configs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-16",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        ```
        ### Vertex Ai Deploy Multiple Models In Parallel

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy_gemma_11_2b_it = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-gemma-1_1-2b-it",
            publisher_model_name="publishers/google/models/gemma@gemma-1.1-2b-it",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "us-central1",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        deploy_qwen3_06b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-qwen3-0_6b",
            hugging_face_model_id="Qwen/Qwen3-0.6B",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        deploy_llama_32_1b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-llama-3_2-1b",
            publisher_model_name="publishers/meta/models/llama3-2@llama-3.2-1b",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        ```
        ### Vertex Ai Deploy Multiple Models In Sequence

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy_gemma_11_2b_it = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-gemma-1_1-2b-it",
            publisher_model_name="publishers/google/models/gemma@gemma-1.1-2b-it",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            })
        deploy_qwen3_06b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-qwen3-0_6b",
            hugging_face_model_id="Qwen/Qwen3-0.6B",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[deploy_gemma_11_2b_it]))
        deploy_llama_32_1b = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy-llama-3_2-1b",
            publisher_model_name="publishers/meta/models/llama3-2@llama-3.2-1b",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            deploy_config={
                "dedicated_resources": {
                    "machine_spec": {
                        "machine_type": "g2-standard-12",
                        "accelerator_type": "NVIDIA_L4",
                        "accelerator_count": 1,
                    },
                    "min_replica_count": 1,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[deploy_qwen3_06b]))
        ```
        ### Vertex Ai Deploy Psc Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            endpoint_config={
                "private_service_connect_config": {
                    "enable_private_service_connect": True,
                    "project_allowlists": ["my-project-id"],
                },
            })
        ```
        ### Vertex Ai Deploy Psc Endpoint Automated

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        project = gcp.organizations.get_project()
        deploy = gcp.vertex.AiEndpointWithModelGardenDeployment("deploy",
            publisher_model_name="publishers/google/models/paligemma@paligemma-224-float32",
            location="us-central1",
            model_config={
                "accept_eula": True,
            },
            endpoint_config={
                "private_service_connect_config": {
                    "enable_private_service_connect": True,
                    "project_allowlists": [project.id],
                    "psc_automation_configs": {
                        "project_id": project.id,
                        "network": network.id,
                    },
                },
            })
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            name="subnetwork",
            ip_cidr_range="192.168.0.0/24",
            region="us-central1",
            network=network.id)
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param AiEndpointWithModelGardenDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiEndpointWithModelGardenDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentDeployConfigArgs', 'AiEndpointWithModelGardenDeploymentDeployConfigArgsDict']]] = None,
                 endpoint_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentEndpointConfigArgs', 'AiEndpointWithModelGardenDeploymentEndpointConfigArgsDict']]] = None,
                 hugging_face_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 model_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentModelConfigArgs', 'AiEndpointWithModelGardenDeploymentModelConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_model_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiEndpointWithModelGardenDeploymentArgs.__new__(AiEndpointWithModelGardenDeploymentArgs)

            __props__.__dict__["deploy_config"] = deploy_config
            __props__.__dict__["endpoint_config"] = endpoint_config
            __props__.__dict__["hugging_face_model_id"] = hugging_face_model_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["model_config"] = model_config
            __props__.__dict__["project"] = project
            __props__.__dict__["publisher_model_name"] = publisher_model_name
            __props__.__dict__["deployed_model_display_name"] = None
            __props__.__dict__["deployed_model_id"] = None
            __props__.__dict__["endpoint"] = None
        super(AiEndpointWithModelGardenDeployment, __self__).__init__(
            'gcp:vertex/aiEndpointWithModelGardenDeployment:AiEndpointWithModelGardenDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deploy_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentDeployConfigArgs', 'AiEndpointWithModelGardenDeploymentDeployConfigArgsDict']]] = None,
            deployed_model_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            deployed_model_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentEndpointConfigArgs', 'AiEndpointWithModelGardenDeploymentEndpointConfigArgsDict']]] = None,
            hugging_face_model_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            model_config: Optional[pulumi.Input[Union['AiEndpointWithModelGardenDeploymentModelConfigArgs', 'AiEndpointWithModelGardenDeploymentModelConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            publisher_model_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AiEndpointWithModelGardenDeployment':
        """
        Get an existing AiEndpointWithModelGardenDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiEndpointWithModelGardenDeploymentDeployConfigArgs', 'AiEndpointWithModelGardenDeploymentDeployConfigArgsDict']] deploy_config: The deploy config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] deployed_model_display_name: Output only. The display name assigned to the model deployed to the endpoint.
               This is not required to delete the resource but is used for debug logging.
        :param pulumi.Input[_builtins.str] deployed_model_id: Output only. The unique numeric ID that Vertex AI assigns to the model at the time it is deployed to the endpoint.
               It is required to undeploy the model from the endpoint during resource deletion as described in
               https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.endpoints/undeployModel.
        :param pulumi.Input[_builtins.str] endpoint: Resource ID segment making up resource `endpoint`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['AiEndpointWithModelGardenDeploymentEndpointConfigArgs', 'AiEndpointWithModelGardenDeploymentEndpointConfigArgsDict']] endpoint_config: The endpoint config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] hugging_face_model_id: The Hugging Face model to deploy.
               Format: Hugging Face model ID like `google/gemma-2-2b-it`.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `location`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['AiEndpointWithModelGardenDeploymentModelConfigArgs', 'AiEndpointWithModelGardenDeploymentModelConfigArgsDict']] model_config: The model config to use for the deployment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] publisher_model_name: The Model Garden model to deploy.
               Format:
               `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
               `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiEndpointWithModelGardenDeploymentState.__new__(_AiEndpointWithModelGardenDeploymentState)

        __props__.__dict__["deploy_config"] = deploy_config
        __props__.__dict__["deployed_model_display_name"] = deployed_model_display_name
        __props__.__dict__["deployed_model_id"] = deployed_model_id
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["endpoint_config"] = endpoint_config
        __props__.__dict__["hugging_face_model_id"] = hugging_face_model_id
        __props__.__dict__["location"] = location
        __props__.__dict__["model_config"] = model_config
        __props__.__dict__["project"] = project
        __props__.__dict__["publisher_model_name"] = publisher_model_name
        return AiEndpointWithModelGardenDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deployConfig")
    def deploy_config(self) -> pulumi.Output[Optional['outputs.AiEndpointWithModelGardenDeploymentDeployConfig']]:
        """
        The deploy config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "deploy_config")

    @_builtins.property
    @pulumi.getter(name="deployedModelDisplayName")
    def deployed_model_display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The display name assigned to the model deployed to the endpoint.
        This is not required to delete the resource but is used for debug logging.
        """
        return pulumi.get(self, "deployed_model_display_name")

    @_builtins.property
    @pulumi.getter(name="deployedModelId")
    def deployed_model_id(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The unique numeric ID that Vertex AI assigns to the model at the time it is deployed to the endpoint.
        It is required to undeploy the model from the endpoint during resource deletion as described in
        https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.endpoints/undeployModel.
        """
        return pulumi.get(self, "deployed_model_id")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `endpoint`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> pulumi.Output[Optional['outputs.AiEndpointWithModelGardenDeploymentEndpointConfig']]:
        """
        The endpoint config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_config")

    @_builtins.property
    @pulumi.getter(name="huggingFaceModelId")
    def hugging_face_model_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Hugging Face model to deploy.
        Format: Hugging Face model ID like `google/gemma-2-2b-it`.
        """
        return pulumi.get(self, "hugging_face_model_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `location`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="modelConfig")
    def model_config(self) -> pulumi.Output[Optional['outputs.AiEndpointWithModelGardenDeploymentModelConfig']]:
        """
        The model config to use for the deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "model_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="publisherModelName")
    def publisher_model_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Model Garden model to deploy.
        Format:
        `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
        `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
        """
        return pulumi.get(self, "publisher_model_name")

