# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AiFeatureGroupFeatureArgs', 'AiFeatureGroupFeature']

@pulumi.input_type
class AiFeatureGroupFeatureArgs:
    def __init__(__self__, *,
                 feature_group: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 version_column_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AiFeatureGroupFeature resource.
        :param pulumi.Input[_builtins.str] feature_group: The name of the Feature Group.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the feature group's region.
        :param pulumi.Input[_builtins.str] description: The description of the FeatureGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your FeatureGroup.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the Feature Group Feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] version_column_name: The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use featureId.
        """
        pulumi.set(__self__, "feature_group", feature_group)
        pulumi.set(__self__, "region", region)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if version_column_name is not None:
            pulumi.set(__self__, "version_column_name", version_column_name)

    @_builtins.property
    @pulumi.getter(name="featureGroup")
    def feature_group(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Feature Group.
        """
        return pulumi.get(self, "feature_group")

    @feature_group.setter
    def feature_group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_group", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region for the resource. It should be the same as the feature group's region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the FeatureGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels with user-defined metadata to organize your FeatureGroup.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Feature Group Feature.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="versionColumnName")
    def version_column_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use featureId.
        """
        return pulumi.get(self, "version_column_name")

    @version_column_name.setter
    def version_column_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_column_name", value)


@pulumi.input_type
class _AiFeatureGroupFeatureState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 feature_group: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 version_column_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiFeatureGroupFeature resources.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the FeatureGroup was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[_builtins.str] description: The description of the FeatureGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] feature_group: The name of the Feature Group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your FeatureGroup.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the Feature Group Feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the feature group's region.
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the FeatureGroup was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[_builtins.str] version_column_name: The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use featureId.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if feature_group is not None:
            pulumi.set(__self__, "feature_group", feature_group)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version_column_name is not None:
            pulumi.set(__self__, "version_column_name", version_column_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the FeatureGroup was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the FeatureGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="featureGroup")
    def feature_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature Group.
        """
        return pulumi.get(self, "feature_group")

    @feature_group.setter
    def feature_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_group", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels with user-defined metadata to organize your FeatureGroup.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Feature Group Feature.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region for the resource. It should be the same as the feature group's region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the FeatureGroup was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="versionColumnName")
    def version_column_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use featureId.
        """
        return pulumi.get(self, "version_column_name")

    @version_column_name.setter
    def version_column_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_column_name", value)


@pulumi.type_token("gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature")
class AiFeatureGroupFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_group: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 version_column_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Vertex AI Feature Group Feature is feature metadata information.

        To get more information about FeatureGroupFeature, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.featureGroups.features)
        * How-to Guides
            * [Creating a Feature](https://cloud.google.com/vertex-ai/docs/featurestore/latest/create-feature)

        ## Example Usage

        ### Vertex Ai Feature Group Feature

        ```python
        import pulumi
        import pulumi_gcp as gcp

        sample_dataset = gcp.bigquery.Dataset("sample_dataset",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        sample_table = gcp.bigquery.Table("sample_table",
            deletion_protection=False,
            dataset_id=sample_dataset.dataset_id,
            table_id="job_load_table",
            schema=\"\"\"[
            {
                \\"name\\": \\"feature_id\\",
                \\"type\\": \\"STRING\\",
                \\"mode\\": \\"NULLABLE\\"
            },
            {
                \\"name\\": \\"example_feature\\",
                \\"type\\": \\"STRING\\",
                \\"mode\\": \\"NULLABLE\\"
            },
            {
                \\"name\\": \\"feature_timestamp\\",
                \\"type\\": \\"TIMESTAMP\\",
                \\"mode\\": \\"NULLABLE\\"
            }
        ]
        \"\"\")
        sample_feature_group = gcp.vertex.AiFeatureGroup("sample_feature_group",
            name="example_feature_group",
            description="A sample feature group",
            region="us-central1",
            labels={
                "label-one": "value-one",
            },
            big_query={
                "big_query_source": {
                    "input_uri": pulumi.Output.all(
                        project=sample_table.project,
                        dataset_id=sample_table.dataset_id,
                        table_id=sample_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                },
                "entity_id_columns": ["feature_id"],
            })
        feature_group_feature = gcp.vertex.AiFeatureGroupFeature("feature_group_feature",
            name="example_feature",
            region="us-central1",
            feature_group=sample_feature_group.name,
            description="A sample feature",
            labels={
                "label-one": "value-one",
            })
        ```

        ## Import

        FeatureGroupFeature can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/featureGroups/{{feature_group}}/features/{{name}}`

        * `{{project}}/{{region}}/{{feature_group}}/{{name}}`

        * `{{region}}/{{feature_group}}/{{name}}`

        * `{{feature_group}}/{{name}}`

        When using the `pulumi import` command, FeatureGroupFeature can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default projects/{{project}}/locations/{{region}}/featureGroups/{{feature_group}}/features/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default {{project}}/{{region}}/{{feature_group}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default {{region}}/{{feature_group}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default {{feature_group}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the FeatureGroup.
        :param pulumi.Input[_builtins.str] feature_group: The name of the Feature Group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your FeatureGroup.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the Feature Group Feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the feature group's region.
        :param pulumi.Input[_builtins.str] version_column_name: The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use featureId.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiFeatureGroupFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Vertex AI Feature Group Feature is feature metadata information.

        To get more information about FeatureGroupFeature, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.featureGroups.features)
        * How-to Guides
            * [Creating a Feature](https://cloud.google.com/vertex-ai/docs/featurestore/latest/create-feature)

        ## Example Usage

        ### Vertex Ai Feature Group Feature

        ```python
        import pulumi
        import pulumi_gcp as gcp

        sample_dataset = gcp.bigquery.Dataset("sample_dataset",
            dataset_id="job_load_dataset",
            friendly_name="test",
            description="This is a test description",
            location="US")
        sample_table = gcp.bigquery.Table("sample_table",
            deletion_protection=False,
            dataset_id=sample_dataset.dataset_id,
            table_id="job_load_table",
            schema=\"\"\"[
            {
                \\"name\\": \\"feature_id\\",
                \\"type\\": \\"STRING\\",
                \\"mode\\": \\"NULLABLE\\"
            },
            {
                \\"name\\": \\"example_feature\\",
                \\"type\\": \\"STRING\\",
                \\"mode\\": \\"NULLABLE\\"
            },
            {
                \\"name\\": \\"feature_timestamp\\",
                \\"type\\": \\"TIMESTAMP\\",
                \\"mode\\": \\"NULLABLE\\"
            }
        ]
        \"\"\")
        sample_feature_group = gcp.vertex.AiFeatureGroup("sample_feature_group",
            name="example_feature_group",
            description="A sample feature group",
            region="us-central1",
            labels={
                "label-one": "value-one",
            },
            big_query={
                "big_query_source": {
                    "input_uri": pulumi.Output.all(
                        project=sample_table.project,
                        dataset_id=sample_table.dataset_id,
                        table_id=sample_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                },
                "entity_id_columns": ["feature_id"],
            })
        feature_group_feature = gcp.vertex.AiFeatureGroupFeature("feature_group_feature",
            name="example_feature",
            region="us-central1",
            feature_group=sample_feature_group.name,
            description="A sample feature",
            labels={
                "label-one": "value-one",
            })
        ```

        ## Import

        FeatureGroupFeature can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/featureGroups/{{feature_group}}/features/{{name}}`

        * `{{project}}/{{region}}/{{feature_group}}/{{name}}`

        * `{{region}}/{{feature_group}}/{{name}}`

        * `{{feature_group}}/{{name}}`

        When using the `pulumi import` command, FeatureGroupFeature can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default projects/{{project}}/locations/{{region}}/featureGroups/{{feature_group}}/features/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default {{project}}/{{region}}/{{feature_group}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default {{region}}/{{feature_group}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature default {{feature_group}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AiFeatureGroupFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiFeatureGroupFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_group: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 version_column_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiFeatureGroupFeatureArgs.__new__(AiFeatureGroupFeatureArgs)

            __props__.__dict__["description"] = description
            if feature_group is None and not opts.urn:
                raise TypeError("Missing required property 'feature_group'")
            __props__.__dict__["feature_group"] = feature_group
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["version_column_name"] = version_column_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AiFeatureGroupFeature, __self__).__init__(
            'gcp:vertex/aiFeatureGroupFeature:AiFeatureGroupFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            feature_group: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            version_column_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AiFeatureGroupFeature':
        """
        Get an existing AiFeatureGroupFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the FeatureGroup was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[_builtins.str] description: The description of the FeatureGroup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] feature_group: The name of the Feature Group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your FeatureGroup.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the Feature Group Feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the feature group's region.
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the FeatureGroup was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[_builtins.str] version_column_name: The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use featureId.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiFeatureGroupFeatureState.__new__(_AiFeatureGroupFeatureState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["feature_group"] = feature_group
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["version_column_name"] = version_column_name
        return AiFeatureGroupFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the FeatureGroup was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the FeatureGroup.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="featureGroup")
    def feature_group(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Feature Group.
        """
        return pulumi.get(self, "feature_group")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels with user-defined metadata to organize your FeatureGroup.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the Feature Group Feature.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region for the resource. It should be the same as the feature group's region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the FeatureGroup was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="versionColumnName")
    def version_column_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use featureId.
        """
        return pulumi.get(self, "version_column_name")

