# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiIndexEndpointDeployedIndexArgs', 'AiIndexEndpointDeployedIndex']

@pulumi.input_type
class AiIndexEndpointDeployedIndexArgs:
    def __init__(__self__, *,
                 deployed_index_id: pulumi.Input[_builtins.str],
                 index: pulumi.Input[_builtins.str],
                 index_endpoint: pulumi.Input[_builtins.str],
                 automatic_resources: Optional[pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs']] = None,
                 dedicated_resources: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs']] = None,
                 deployed_index_auth_config: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs']] = None,
                 deployment_group: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_access_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AiIndexEndpointDeployedIndex resource.
        :param pulumi.Input[_builtins.str] deployed_index_id: The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
        :param pulumi.Input[_builtins.str] index: The name of the Index this is the deployment of.
        :param pulumi.Input[_builtins.str] index_endpoint: Identifies the index endpoint. Must be in the format
               'projects/{{project}}/locations/{{region}}/indexEndpoints/{{indexEndpoint}}'
        :param pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs'] automatic_resources: A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration.
               Structure is documented below.
        :param pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs'] dedicated_resources: A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field minReplicaCount must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when minReplicaCount=1. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
               Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
               Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard.
               Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
               n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
               Structure is documented below.
        :param pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs'] deployed_index_auth_config: If set, the authentication is enabled for the private endpoint.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] deployment_group: The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group.
               Creating deployment_groups with reserved_ip_ranges is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. [See the official documentation here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex.FIELDS.deployment_group).
               Note: we only support up to 5 deployment groups (not including 'default').
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[_builtins.bool] enable_access_logging: If true, private endpoint's access logs are sent to Cloud Logging.
        :param pulumi.Input[_builtins.str] region: The region of the index endpoint deployment. eg us-central1
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ip_ranges: A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex.
               If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network.
               The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range'].
               For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
        """
        pulumi.set(__self__, "deployed_index_id", deployed_index_id)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "index_endpoint", index_endpoint)
        if automatic_resources is not None:
            pulumi.set(__self__, "automatic_resources", automatic_resources)
        if dedicated_resources is not None:
            pulumi.set(__self__, "dedicated_resources", dedicated_resources)
        if deployed_index_auth_config is not None:
            pulumi.set(__self__, "deployed_index_auth_config", deployed_index_auth_config)
        if deployment_group is not None:
            pulumi.set(__self__, "deployment_group", deployment_group)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_access_logging is not None:
            pulumi.set(__self__, "enable_access_logging", enable_access_logging)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)

    @_builtins.property
    @pulumi.getter(name="deployedIndexId")
    def deployed_index_id(self) -> pulumi.Input[_builtins.str]:
        """
        The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
        """
        return pulumi.get(self, "deployed_index_id")

    @deployed_index_id.setter
    def deployed_index_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "deployed_index_id", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Index this is the deployment of.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter(name="indexEndpoint")
    def index_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the index endpoint. Must be in the format
        'projects/{{project}}/locations/{{region}}/indexEndpoints/{{indexEndpoint}}'
        """
        return pulumi.get(self, "index_endpoint")

    @index_endpoint.setter
    def index_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "index_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="automaticResources")
    def automatic_resources(self) -> Optional[pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs']]:
        """
        A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_resources")

    @automatic_resources.setter
    def automatic_resources(self, value: Optional[pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs']]):
        pulumi.set(self, "automatic_resources", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> Optional[pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs']]:
        """
        A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field minReplicaCount must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when minReplicaCount=1. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
        Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
        Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard.
        Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
        n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @dedicated_resources.setter
    def dedicated_resources(self, value: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs']]):
        pulumi.set(self, "dedicated_resources", value)

    @_builtins.property
    @pulumi.getter(name="deployedIndexAuthConfig")
    def deployed_index_auth_config(self) -> Optional[pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs']]:
        """
        If set, the authentication is enabled for the private endpoint.
        Structure is documented below.
        """
        return pulumi.get(self, "deployed_index_auth_config")

    @deployed_index_auth_config.setter
    def deployed_index_auth_config(self, value: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs']]):
        pulumi.set(self, "deployed_index_auth_config", value)

    @_builtins.property
    @pulumi.getter(name="deploymentGroup")
    def deployment_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group.
        Creating deployment_groups with reserved_ip_ranges is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. [See the official documentation here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex.FIELDS.deployment_group).
        Note: we only support up to 5 deployment groups (not including 'default').
        """
        return pulumi.get(self, "deployment_group")

    @deployment_group.setter
    def deployment_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_group", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enableAccessLogging")
    def enable_access_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, private endpoint's access logs are sent to Cloud Logging.
        """
        return pulumi.get(self, "enable_access_logging")

    @enable_access_logging.setter
    def enable_access_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_access_logging", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the index endpoint deployment. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex.
        If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network.
        The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range'].
        For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "reserved_ip_ranges", value)


@pulumi.input_type
class _AiIndexEndpointDeployedIndexState:
    def __init__(__self__, *,
                 automatic_resources: Optional[pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_resources: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs']] = None,
                 deployed_index_auth_config: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs']] = None,
                 deployed_index_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_group: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_access_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 index_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 index_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexEndpointDeployedIndexPrivateEndpointArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AiIndexEndpointDeployedIndex resources.
        :param pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs'] automatic_resources: A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs'] dedicated_resources: A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field minReplicaCount must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when minReplicaCount=1. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
               Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
               Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard.
               Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
               n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
               Structure is documented below.
        :param pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs'] deployed_index_auth_config: If set, the authentication is enabled for the private endpoint.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] deployed_index_id: The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
        :param pulumi.Input[_builtins.str] deployment_group: The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group.
               Creating deployment_groups with reserved_ip_ranges is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. [See the official documentation here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex.FIELDS.deployment_group).
               Note: we only support up to 5 deployment groups (not including 'default').
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[_builtins.bool] enable_access_logging: If true, private endpoint's access logs are sent to Cloud Logging.
        :param pulumi.Input[_builtins.str] index: The name of the Index this is the deployment of.
        :param pulumi.Input[_builtins.str] index_endpoint: Identifies the index endpoint. Must be in the format
               'projects/{{project}}/locations/{{region}}/indexEndpoints/{{indexEndpoint}}'
        :param pulumi.Input[_builtins.str] index_sync_time: The DeployedIndex may depend on various data on its original Index. Additionally when certain changes to the original Index are being done (e.g. when what the Index contains is being changed) the DeployedIndex may be asynchronously updated in the background to reflect these changes. If this timestamp's value is at least the [Index.update_time](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes#Index.FIELDS.update_time) of the original Index, it means that this DeployedIndex and the original Index are in sync. If this timestamp is older, then to see which updates this DeployedIndex already contains (and which it does not), one must [list](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.operations/list#google.longrunning.Operations.ListOperations) the operations that are running on the original Index. Only the successfully completed Operations with updateTime equal or before this sync time are contained in this DeployedIndex.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] name: The name of the DeployedIndex resource.
        :param pulumi.Input[Sequence[pulumi.Input['AiIndexEndpointDeployedIndexPrivateEndpointArgs']]] private_endpoints: Provides paths for users to send requests directly to the deployed index services running on Cloud via private services access. This field is populated if [network](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#IndexEndpoint.FIELDS.network) is configured.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The region of the index endpoint deployment. eg us-central1
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ip_ranges: A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex.
               If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network.
               The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range'].
               For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
        """
        if automatic_resources is not None:
            pulumi.set(__self__, "automatic_resources", automatic_resources)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dedicated_resources is not None:
            pulumi.set(__self__, "dedicated_resources", dedicated_resources)
        if deployed_index_auth_config is not None:
            pulumi.set(__self__, "deployed_index_auth_config", deployed_index_auth_config)
        if deployed_index_id is not None:
            pulumi.set(__self__, "deployed_index_id", deployed_index_id)
        if deployment_group is not None:
            pulumi.set(__self__, "deployment_group", deployment_group)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_access_logging is not None:
            pulumi.set(__self__, "enable_access_logging", enable_access_logging)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if index_endpoint is not None:
            pulumi.set(__self__, "index_endpoint", index_endpoint)
        if index_sync_time is not None:
            pulumi.set(__self__, "index_sync_time", index_sync_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)

    @_builtins.property
    @pulumi.getter(name="automaticResources")
    def automatic_resources(self) -> Optional[pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs']]:
        """
        A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_resources")

    @automatic_resources.setter
    def automatic_resources(self, value: Optional[pulumi.Input['AiIndexEndpointDeployedIndexAutomaticResourcesArgs']]):
        pulumi.set(self, "automatic_resources", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> Optional[pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs']]:
        """
        A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field minReplicaCount must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when minReplicaCount=1. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
        Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
        Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard.
        Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
        n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @dedicated_resources.setter
    def dedicated_resources(self, value: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDedicatedResourcesArgs']]):
        pulumi.set(self, "dedicated_resources", value)

    @_builtins.property
    @pulumi.getter(name="deployedIndexAuthConfig")
    def deployed_index_auth_config(self) -> Optional[pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs']]:
        """
        If set, the authentication is enabled for the private endpoint.
        Structure is documented below.
        """
        return pulumi.get(self, "deployed_index_auth_config")

    @deployed_index_auth_config.setter
    def deployed_index_auth_config(self, value: Optional[pulumi.Input['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs']]):
        pulumi.set(self, "deployed_index_auth_config", value)

    @_builtins.property
    @pulumi.getter(name="deployedIndexId")
    def deployed_index_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
        """
        return pulumi.get(self, "deployed_index_id")

    @deployed_index_id.setter
    def deployed_index_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployed_index_id", value)

    @_builtins.property
    @pulumi.getter(name="deploymentGroup")
    def deployment_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group.
        Creating deployment_groups with reserved_ip_ranges is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. [See the official documentation here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex.FIELDS.deployment_group).
        Note: we only support up to 5 deployment groups (not including 'default').
        """
        return pulumi.get(self, "deployment_group")

    @deployment_group.setter
    def deployment_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_group", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enableAccessLogging")
    def enable_access_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, private endpoint's access logs are sent to Cloud Logging.
        """
        return pulumi.get(self, "enable_access_logging")

    @enable_access_logging.setter
    def enable_access_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_access_logging", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Index this is the deployment of.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter(name="indexEndpoint")
    def index_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the index endpoint. Must be in the format
        'projects/{{project}}/locations/{{region}}/indexEndpoints/{{indexEndpoint}}'
        """
        return pulumi.get(self, "index_endpoint")

    @index_endpoint.setter
    def index_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="indexSyncTime")
    def index_sync_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DeployedIndex may depend on various data on its original Index. Additionally when certain changes to the original Index are being done (e.g. when what the Index contains is being changed) the DeployedIndex may be asynchronously updated in the background to reflect these changes. If this timestamp's value is at least the [Index.update_time](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes#Index.FIELDS.update_time) of the original Index, it means that this DeployedIndex and the original Index are in sync. If this timestamp is older, then to see which updates this DeployedIndex already contains (and which it does not), one must [list](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.operations/list#google.longrunning.Operations.ListOperations) the operations that are running on the original Index. Only the successfully completed Operations with updateTime equal or before this sync time are contained in this DeployedIndex.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "index_sync_time")

    @index_sync_time.setter
    def index_sync_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index_sync_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the DeployedIndex resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexEndpointDeployedIndexPrivateEndpointArgs']]]]:
        """
        Provides paths for users to send requests directly to the deployed index services running on Cloud via private services access. This field is populated if [network](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#IndexEndpoint.FIELDS.network) is configured.
        Structure is documented below.
        """
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexEndpointDeployedIndexPrivateEndpointArgs']]]]):
        pulumi.set(self, "private_endpoints", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the index endpoint deployment. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex.
        If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network.
        The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range'].
        For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "reserved_ip_ranges", value)


@pulumi.type_token("gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex")
class AiIndexEndpointDeployedIndex(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_resources: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexAutomaticResourcesArgs', 'AiIndexEndpointDeployedIndexAutomaticResourcesArgsDict']]] = None,
                 dedicated_resources: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexDedicatedResourcesArgs', 'AiIndexEndpointDeployedIndexDedicatedResourcesArgsDict']]] = None,
                 deployed_index_auth_config: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs', 'AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgsDict']]] = None,
                 deployed_index_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_group: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_access_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 index_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        An endpoint indexes are deployed into. An index endpoint can have multiple deployed indexes.

        To get more information about IndexEndpointDeployedIndex, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex)

        ## Example Usage

        ### Vertex Ai Index Endpoint Deployed Index Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="bucket-name",
            location="us-central1",
            uniform_bucket_level_access=True)
        index = gcp.vertex.AiIndex("index",
            region="us-central1",
            display_name="test-index",
            description="index for test",
            index_update_method="BATCH_UPDATE",
            labels={
                "foo": "bar",
            },
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "approximate_neighbors_count": 150,
                    "shard_size": "SHARD_SIZE_SMALL",
                    "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                    "algorithm_config": {
                        "tree_ah_config": {
                            "leaf_node_embedding_count": 500,
                            "leaf_nodes_to_search_percent": 7,
                        },
                    },
                },
            })
        vertex_network = gcp.compute.get_network(name="network-name")
        project = gcp.organizations.get_project()
        vertex_index_endpoint_deployed = gcp.vertex.AiIndexEndpoint("vertex_index_endpoint_deployed",
            display_name="sample-endpoint",
            description="A sample vertex endpoint",
            region="us-central1",
            network=f"projects/{project.number}/global/networks/{vertex_network.name}",
            labels={
                "label-one": "value-one",
            })
        sa = gcp.serviceaccount.Account("sa", account_id="vertex-sa")
        basic_deployed_index = gcp.vertex.AiIndexEndpointDeployedIndex("basic_deployed_index",
            deployed_index_id="deployed_index_id",
            display_name="vertex-deployed-index",
            region="us-central1",
            index=index.id,
            index_endpoint=vertex_index_endpoint_deployed.id,
            enable_access_logging=False,
            reserved_ip_ranges=["vertex-ai-range"],
            deployed_index_auth_config={
                "auth_provider": {
                    "audiences": ["123456-my-app"],
                    "allowed_issuers": [sa.email],
                },
            })
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{\\"id\\": \\"42\\", \\"embedding\\": [0.5, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"cat\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"feline\\"]}]}
        {\\"id\\": \\"43\\", \\"embedding\\": [0.6, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"dog\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"canine\\"]}]}
        \"\"\")
        ```
        ### Vertex Ai Index Endpoint Deployed Index Basic Two

        ```python
        import pulumi
        import pulumi_gcp as gcp

        sa = gcp.serviceaccount.Account("sa", account_id="vertex-sa")
        bucket = gcp.storage.Bucket("bucket",
            name="bucket-name",
            location="us-central1",
            uniform_bucket_level_access=True)
        index = gcp.vertex.AiIndex("index",
            region="us-central1",
            display_name="test-index",
            description="index for test",
            index_update_method="BATCH_UPDATE",
            labels={
                "foo": "bar",
            },
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "approximate_neighbors_count": 150,
                    "shard_size": "SHARD_SIZE_SMALL",
                    "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                    "algorithm_config": {
                        "tree_ah_config": {
                            "leaf_node_embedding_count": 500,
                            "leaf_nodes_to_search_percent": 7,
                        },
                    },
                },
            })
        vertex_network = gcp.compute.get_network(name="network-name")
        project = gcp.organizations.get_project()
        vertex_index_endpoint_deployed = gcp.vertex.AiIndexEndpoint("vertex_index_endpoint_deployed",
            display_name="sample-endpoint",
            description="A sample vertex endpoint",
            region="us-central1",
            network=f"projects/{project.number}/global/networks/{vertex_network.name}",
            labels={
                "label-one": "value-one",
            })
        basic_deployed_index = gcp.vertex.AiIndexEndpointDeployedIndex("basic_deployed_index",
            deployed_index_id="deployed_index_id",
            display_name="vertex-deployed-index",
            region="us-central1",
            index=index.id,
            index_endpoint=vertex_index_endpoint_deployed.id,
            reserved_ip_ranges=["vertex-ai-range"],
            enable_access_logging=False,
            deployed_index_auth_config={
                "auth_provider": {
                    "audiences": ["123456-my-app"],
                    "allowed_issuers": [sa.email],
                },
            },
            automatic_resources={
                "max_replica_count": 4,
            })
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{\\"id\\": \\"42\\", \\"embedding\\": [0.5, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"cat\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"feline\\"]}]}
        {\\"id\\": \\"43\\", \\"embedding\\": [0.6, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"dog\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"canine\\"]}]}
        \"\"\")
        ```

        ## Import

        IndexEndpointDeployedIndex can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/indexEndpoints/{{index_endpoint}}/deployedIndex/{{deployed_index_id}}`

        * `{{project}}/{{region}}/{{index_endpoint}}/{{deployed_index_id}}`

        * `{{region}}/{{index_endpoint}}/{{deployed_index_id}}`

        * `{{index_endpoint}}/{{deployed_index_id}}`

        When using the `pulumi import` command, IndexEndpointDeployedIndex can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default projects/{{project}}/locations/{{region}}/indexEndpoints/{{index_endpoint}}/deployedIndex/{{deployed_index_id}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default {{project}}/{{region}}/{{index_endpoint}}/{{deployed_index_id}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default {{region}}/{{index_endpoint}}/{{deployed_index_id}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default {{index_endpoint}}/{{deployed_index_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiIndexEndpointDeployedIndexAutomaticResourcesArgs', 'AiIndexEndpointDeployedIndexAutomaticResourcesArgsDict']] automatic_resources: A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration.
               Structure is documented below.
        :param pulumi.Input[Union['AiIndexEndpointDeployedIndexDedicatedResourcesArgs', 'AiIndexEndpointDeployedIndexDedicatedResourcesArgsDict']] dedicated_resources: A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field minReplicaCount must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when minReplicaCount=1. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
               Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
               Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard.
               Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
               n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
               Structure is documented below.
        :param pulumi.Input[Union['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs', 'AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgsDict']] deployed_index_auth_config: If set, the authentication is enabled for the private endpoint.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] deployed_index_id: The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
        :param pulumi.Input[_builtins.str] deployment_group: The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group.
               Creating deployment_groups with reserved_ip_ranges is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. [See the official documentation here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex.FIELDS.deployment_group).
               Note: we only support up to 5 deployment groups (not including 'default').
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[_builtins.bool] enable_access_logging: If true, private endpoint's access logs are sent to Cloud Logging.
        :param pulumi.Input[_builtins.str] index: The name of the Index this is the deployment of.
        :param pulumi.Input[_builtins.str] index_endpoint: Identifies the index endpoint. Must be in the format
               'projects/{{project}}/locations/{{region}}/indexEndpoints/{{indexEndpoint}}'
        :param pulumi.Input[_builtins.str] region: The region of the index endpoint deployment. eg us-central1
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ip_ranges: A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex.
               If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network.
               The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range'].
               For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiIndexEndpointDeployedIndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An endpoint indexes are deployed into. An index endpoint can have multiple deployed indexes.

        To get more information about IndexEndpointDeployedIndex, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex)

        ## Example Usage

        ### Vertex Ai Index Endpoint Deployed Index Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="bucket-name",
            location="us-central1",
            uniform_bucket_level_access=True)
        index = gcp.vertex.AiIndex("index",
            region="us-central1",
            display_name="test-index",
            description="index for test",
            index_update_method="BATCH_UPDATE",
            labels={
                "foo": "bar",
            },
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "approximate_neighbors_count": 150,
                    "shard_size": "SHARD_SIZE_SMALL",
                    "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                    "algorithm_config": {
                        "tree_ah_config": {
                            "leaf_node_embedding_count": 500,
                            "leaf_nodes_to_search_percent": 7,
                        },
                    },
                },
            })
        vertex_network = gcp.compute.get_network(name="network-name")
        project = gcp.organizations.get_project()
        vertex_index_endpoint_deployed = gcp.vertex.AiIndexEndpoint("vertex_index_endpoint_deployed",
            display_name="sample-endpoint",
            description="A sample vertex endpoint",
            region="us-central1",
            network=f"projects/{project.number}/global/networks/{vertex_network.name}",
            labels={
                "label-one": "value-one",
            })
        sa = gcp.serviceaccount.Account("sa", account_id="vertex-sa")
        basic_deployed_index = gcp.vertex.AiIndexEndpointDeployedIndex("basic_deployed_index",
            deployed_index_id="deployed_index_id",
            display_name="vertex-deployed-index",
            region="us-central1",
            index=index.id,
            index_endpoint=vertex_index_endpoint_deployed.id,
            enable_access_logging=False,
            reserved_ip_ranges=["vertex-ai-range"],
            deployed_index_auth_config={
                "auth_provider": {
                    "audiences": ["123456-my-app"],
                    "allowed_issuers": [sa.email],
                },
            })
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{\\"id\\": \\"42\\", \\"embedding\\": [0.5, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"cat\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"feline\\"]}]}
        {\\"id\\": \\"43\\", \\"embedding\\": [0.6, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"dog\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"canine\\"]}]}
        \"\"\")
        ```
        ### Vertex Ai Index Endpoint Deployed Index Basic Two

        ```python
        import pulumi
        import pulumi_gcp as gcp

        sa = gcp.serviceaccount.Account("sa", account_id="vertex-sa")
        bucket = gcp.storage.Bucket("bucket",
            name="bucket-name",
            location="us-central1",
            uniform_bucket_level_access=True)
        index = gcp.vertex.AiIndex("index",
            region="us-central1",
            display_name="test-index",
            description="index for test",
            index_update_method="BATCH_UPDATE",
            labels={
                "foo": "bar",
            },
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "approximate_neighbors_count": 150,
                    "shard_size": "SHARD_SIZE_SMALL",
                    "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                    "algorithm_config": {
                        "tree_ah_config": {
                            "leaf_node_embedding_count": 500,
                            "leaf_nodes_to_search_percent": 7,
                        },
                    },
                },
            })
        vertex_network = gcp.compute.get_network(name="network-name")
        project = gcp.organizations.get_project()
        vertex_index_endpoint_deployed = gcp.vertex.AiIndexEndpoint("vertex_index_endpoint_deployed",
            display_name="sample-endpoint",
            description="A sample vertex endpoint",
            region="us-central1",
            network=f"projects/{project.number}/global/networks/{vertex_network.name}",
            labels={
                "label-one": "value-one",
            })
        basic_deployed_index = gcp.vertex.AiIndexEndpointDeployedIndex("basic_deployed_index",
            deployed_index_id="deployed_index_id",
            display_name="vertex-deployed-index",
            region="us-central1",
            index=index.id,
            index_endpoint=vertex_index_endpoint_deployed.id,
            reserved_ip_ranges=["vertex-ai-range"],
            enable_access_logging=False,
            deployed_index_auth_config={
                "auth_provider": {
                    "audiences": ["123456-my-app"],
                    "allowed_issuers": [sa.email],
                },
            },
            automatic_resources={
                "max_replica_count": 4,
            })
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{\\"id\\": \\"42\\", \\"embedding\\": [0.5, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"cat\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"feline\\"]}]}
        {\\"id\\": \\"43\\", \\"embedding\\": [0.6, 1.0], \\"restricts\\": [{\\"namespace\\": \\"class\\", \\"allow\\": [\\"dog\\", \\"pet\\"]},{\\"namespace\\": \\"category\\", \\"allow\\": [\\"canine\\"]}]}
        \"\"\")
        ```

        ## Import

        IndexEndpointDeployedIndex can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/indexEndpoints/{{index_endpoint}}/deployedIndex/{{deployed_index_id}}`

        * `{{project}}/{{region}}/{{index_endpoint}}/{{deployed_index_id}}`

        * `{{region}}/{{index_endpoint}}/{{deployed_index_id}}`

        * `{{index_endpoint}}/{{deployed_index_id}}`

        When using the `pulumi import` command, IndexEndpointDeployedIndex can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default projects/{{project}}/locations/{{region}}/indexEndpoints/{{index_endpoint}}/deployedIndex/{{deployed_index_id}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default {{project}}/{{region}}/{{index_endpoint}}/{{deployed_index_id}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default {{region}}/{{index_endpoint}}/{{deployed_index_id}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex default {{index_endpoint}}/{{deployed_index_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AiIndexEndpointDeployedIndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiIndexEndpointDeployedIndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_resources: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexAutomaticResourcesArgs', 'AiIndexEndpointDeployedIndexAutomaticResourcesArgsDict']]] = None,
                 dedicated_resources: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexDedicatedResourcesArgs', 'AiIndexEndpointDeployedIndexDedicatedResourcesArgsDict']]] = None,
                 deployed_index_auth_config: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs', 'AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgsDict']]] = None,
                 deployed_index_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_group: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_access_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 index_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiIndexEndpointDeployedIndexArgs.__new__(AiIndexEndpointDeployedIndexArgs)

            __props__.__dict__["automatic_resources"] = automatic_resources
            __props__.__dict__["dedicated_resources"] = dedicated_resources
            __props__.__dict__["deployed_index_auth_config"] = deployed_index_auth_config
            if deployed_index_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployed_index_id'")
            __props__.__dict__["deployed_index_id"] = deployed_index_id
            __props__.__dict__["deployment_group"] = deployment_group
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_access_logging"] = enable_access_logging
            if index is None and not opts.urn:
                raise TypeError("Missing required property 'index'")
            __props__.__dict__["index"] = index
            if index_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'index_endpoint'")
            __props__.__dict__["index_endpoint"] = index_endpoint
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
            __props__.__dict__["create_time"] = None
            __props__.__dict__["index_sync_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["private_endpoints"] = None
        super(AiIndexEndpointDeployedIndex, __self__).__init__(
            'gcp:vertex/aiIndexEndpointDeployedIndex:AiIndexEndpointDeployedIndex',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatic_resources: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexAutomaticResourcesArgs', 'AiIndexEndpointDeployedIndexAutomaticResourcesArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_resources: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexDedicatedResourcesArgs', 'AiIndexEndpointDeployedIndexDedicatedResourcesArgsDict']]] = None,
            deployed_index_auth_config: Optional[pulumi.Input[Union['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs', 'AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgsDict']]] = None,
            deployed_index_id: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_group: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_access_logging: Optional[pulumi.Input[_builtins.bool]] = None,
            index: Optional[pulumi.Input[_builtins.str]] = None,
            index_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            index_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AiIndexEndpointDeployedIndexPrivateEndpointArgs', 'AiIndexEndpointDeployedIndexPrivateEndpointArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AiIndexEndpointDeployedIndex':
        """
        Get an existing AiIndexEndpointDeployedIndex resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiIndexEndpointDeployedIndexAutomaticResourcesArgs', 'AiIndexEndpointDeployedIndexAutomaticResourcesArgsDict']] automatic_resources: A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Union['AiIndexEndpointDeployedIndexDedicatedResourcesArgs', 'AiIndexEndpointDeployedIndexDedicatedResourcesArgsDict']] dedicated_resources: A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field minReplicaCount must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when minReplicaCount=1. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
               Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
               Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard.
               Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
               n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
               Structure is documented below.
        :param pulumi.Input[Union['AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgs', 'AiIndexEndpointDeployedIndexDeployedIndexAuthConfigArgsDict']] deployed_index_auth_config: If set, the authentication is enabled for the private endpoint.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] deployed_index_id: The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
        :param pulumi.Input[_builtins.str] deployment_group: The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group.
               Creating deployment_groups with reserved_ip_ranges is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. [See the official documentation here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex.FIELDS.deployment_group).
               Note: we only support up to 5 deployment groups (not including 'default').
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[_builtins.bool] enable_access_logging: If true, private endpoint's access logs are sent to Cloud Logging.
        :param pulumi.Input[_builtins.str] index: The name of the Index this is the deployment of.
        :param pulumi.Input[_builtins.str] index_endpoint: Identifies the index endpoint. Must be in the format
               'projects/{{project}}/locations/{{region}}/indexEndpoints/{{indexEndpoint}}'
        :param pulumi.Input[_builtins.str] index_sync_time: The DeployedIndex may depend on various data on its original Index. Additionally when certain changes to the original Index are being done (e.g. when what the Index contains is being changed) the DeployedIndex may be asynchronously updated in the background to reflect these changes. If this timestamp's value is at least the [Index.update_time](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes#Index.FIELDS.update_time) of the original Index, it means that this DeployedIndex and the original Index are in sync. If this timestamp is older, then to see which updates this DeployedIndex already contains (and which it does not), one must [list](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.operations/list#google.longrunning.Operations.ListOperations) the operations that are running on the original Index. Only the successfully completed Operations with updateTime equal or before this sync time are contained in this DeployedIndex.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] name: The name of the DeployedIndex resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AiIndexEndpointDeployedIndexPrivateEndpointArgs', 'AiIndexEndpointDeployedIndexPrivateEndpointArgsDict']]]] private_endpoints: Provides paths for users to send requests directly to the deployed index services running on Cloud via private services access. This field is populated if [network](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#IndexEndpoint.FIELDS.network) is configured.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The region of the index endpoint deployment. eg us-central1
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ip_ranges: A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex.
               If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network.
               The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range'].
               For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiIndexEndpointDeployedIndexState.__new__(_AiIndexEndpointDeployedIndexState)

        __props__.__dict__["automatic_resources"] = automatic_resources
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dedicated_resources"] = dedicated_resources
        __props__.__dict__["deployed_index_auth_config"] = deployed_index_auth_config
        __props__.__dict__["deployed_index_id"] = deployed_index_id
        __props__.__dict__["deployment_group"] = deployment_group
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_access_logging"] = enable_access_logging
        __props__.__dict__["index"] = index
        __props__.__dict__["index_endpoint"] = index_endpoint
        __props__.__dict__["index_sync_time"] = index_sync_time
        __props__.__dict__["name"] = name
        __props__.__dict__["private_endpoints"] = private_endpoints
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
        return AiIndexEndpointDeployedIndex(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automaticResources")
    def automatic_resources(self) -> pulumi.Output['outputs.AiIndexEndpointDeployedIndexAutomaticResources']:
        """
        A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_resources")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> pulumi.Output[Optional['outputs.AiIndexEndpointDeployedIndexDedicatedResources']]:
        """
        A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field minReplicaCount must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when minReplicaCount=1. If maxReplicaCount is not set, the default value is minReplicaCount. The max allowed replica count is 1000.
        Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
        Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard.
        Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
        n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @_builtins.property
    @pulumi.getter(name="deployedIndexAuthConfig")
    def deployed_index_auth_config(self) -> pulumi.Output[Optional['outputs.AiIndexEndpointDeployedIndexDeployedIndexAuthConfig']]:
        """
        If set, the authentication is enabled for the private endpoint.
        Structure is documented below.
        """
        return pulumi.get(self, "deployed_index_auth_config")

    @_builtins.property
    @pulumi.getter(name="deployedIndexId")
    def deployed_index_id(self) -> pulumi.Output[_builtins.str]:
        """
        The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
        """
        return pulumi.get(self, "deployed_index_id")

    @_builtins.property
    @pulumi.getter(name="deploymentGroup")
    def deployment_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group.
        Creating deployment_groups with reserved_ip_ranges is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. [See the official documentation here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#DeployedIndex.FIELDS.deployment_group).
        Note: we only support up to 5 deployment groups (not including 'default').
        """
        return pulumi.get(self, "deployment_group")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enableAccessLogging")
    def enable_access_logging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, private endpoint's access logs are sent to Cloud Logging.
        """
        return pulumi.get(self, "enable_access_logging")

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Index this is the deployment of.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter(name="indexEndpoint")
    def index_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the index endpoint. Must be in the format
        'projects/{{project}}/locations/{{region}}/indexEndpoints/{{indexEndpoint}}'
        """
        return pulumi.get(self, "index_endpoint")

    @_builtins.property
    @pulumi.getter(name="indexSyncTime")
    def index_sync_time(self) -> pulumi.Output[_builtins.str]:
        """
        The DeployedIndex may depend on various data on its original Index. Additionally when certain changes to the original Index are being done (e.g. when what the Index contains is being changed) the DeployedIndex may be asynchronously updated in the background to reflect these changes. If this timestamp's value is at least the [Index.update_time](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes#Index.FIELDS.update_time) of the original Index, it means that this DeployedIndex and the original Index are in sync. If this timestamp is older, then to see which updates this DeployedIndex already contains (and which it does not), one must [list](https://cloud.google.com/vertex-ai/docs/reference/rest/v1beta1/projects.locations.operations/list#google.longrunning.Operations.ListOperations) the operations that are running on the original Index. Only the successfully completed Operations with updateTime equal or before this sync time are contained in this DeployedIndex.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "index_sync_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the DeployedIndex resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> pulumi.Output[Sequence['outputs.AiIndexEndpointDeployedIndexPrivateEndpoint']]:
        """
        Provides paths for users to send requests directly to the deployed index services running on Cloud via private services access. This field is populated if [network](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexEndpoints#IndexEndpoint.FIELDS.network) is configured.
        Structure is documented below.
        """
        return pulumi.get(self, "private_endpoints")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region of the index endpoint deployment. eg us-central1
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex.
        If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network.
        The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range'].
        For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
        """
        return pulumi.get(self, "reserved_ip_ranges")

