# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiReasoningEngineArgs', 'AiReasoningEngine']

@pulumi.input_type
class AiReasoningEngineArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_spec: Optional[pulumi.Input['AiReasoningEngineEncryptionSpecArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input['AiReasoningEngineSpecArgs']] = None):
        """
        The set of arguments for constructing a AiReasoningEngine resource.
        :param pulumi.Input[_builtins.str] display_name: The display name of the ReasoningEngine.
        :param pulumi.Input[_builtins.str] description: The description of the ReasoningEngine.
        :param pulumi.Input['AiReasoningEngineEncryptionSpecArgs'] encryption_spec: Optional. Customer-managed encryption key spec for a ReasoningEngine.
               If set, this ReasoningEngine and all sub-resources of this ReasoningEngine will be secured by this key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the reasoning engine. eg us-central1
        :param pulumi.Input['AiReasoningEngineSpecArgs'] spec: Optional. Configurations of the ReasoningEngine.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_spec is not None:
            pulumi.set(__self__, "encryption_spec", encryption_spec)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the ReasoningEngine.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ReasoningEngine.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> Optional[pulumi.Input['AiReasoningEngineEncryptionSpecArgs']]:
        """
        Optional. Customer-managed encryption key spec for a ReasoningEngine.
        If set, this ReasoningEngine and all sub-resources of this ReasoningEngine will be secured by this key.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @encryption_spec.setter
    def encryption_spec(self, value: Optional[pulumi.Input['AiReasoningEngineEncryptionSpecArgs']]):
        pulumi.set(self, "encryption_spec", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the reasoning engine. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['AiReasoningEngineSpecArgs']]:
        """
        Optional. Configurations of the ReasoningEngine.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['AiReasoningEngineSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class _AiReasoningEngineState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_spec: Optional[pulumi.Input['AiReasoningEngineEncryptionSpecArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input['AiReasoningEngineSpecArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiReasoningEngine resources.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[_builtins.str] description: The description of the ReasoningEngine.
        :param pulumi.Input[_builtins.str] display_name: The display name of the ReasoningEngine.
        :param pulumi.Input['AiReasoningEngineEncryptionSpecArgs'] encryption_spec: Optional. Customer-managed encryption key spec for a ReasoningEngine.
               If set, this ReasoningEngine and all sub-resources of this ReasoningEngine will be secured by this key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The generated name of the ReasoningEngine, in the format
               'projects/{project}/locations/{location}/reasoningEngines/{reasoningEngine}'
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the reasoning engine. eg us-central1
        :param pulumi.Input['AiReasoningEngineSpecArgs'] spec: Optional. Configurations of the ReasoningEngine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_spec is not None:
            pulumi.set(__self__, "encryption_spec", encryption_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ReasoningEngine.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the ReasoningEngine.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> Optional[pulumi.Input['AiReasoningEngineEncryptionSpecArgs']]:
        """
        Optional. Customer-managed encryption key spec for a ReasoningEngine.
        If set, this ReasoningEngine and all sub-resources of this ReasoningEngine will be secured by this key.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @encryption_spec.setter
    def encryption_spec(self, value: Optional[pulumi.Input['AiReasoningEngineEncryptionSpecArgs']]):
        pulumi.set(self, "encryption_spec", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated name of the ReasoningEngine, in the format
        'projects/{project}/locations/{location}/reasoningEngines/{reasoningEngine}'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the reasoning engine. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['AiReasoningEngineSpecArgs']]:
        """
        Optional. Configurations of the ReasoningEngine.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['AiReasoningEngineSpecArgs']]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:vertex/aiReasoningEngine:AiReasoningEngine")
class AiReasoningEngine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_spec: Optional[pulumi.Input[Union['AiReasoningEngineEncryptionSpecArgs', 'AiReasoningEngineEncryptionSpecArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['AiReasoningEngineSpecArgs', 'AiReasoningEngineSpecArgsDict']]] = None,
                 __props__=None):
        """
        ReasoningEngine provides a customizable runtime for models to determine which actions to take and in which order.

        To get more information about ReasoningEngine, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.reasoningEngines/)
        * How-to Guides
            * [Develop and deploy agents on Vertex AI Agent Engine](https://cloud.google.com/vertex-ai/generative-ai/docs/agent-engine/quickstart)

        ## Example Usage

        ### Vertex Ai Reasoning Engine Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        class_methods = [{
            "apiMode": "async",
            "description": None,
            "name": "async_query",
            "parameters": {
                "type": "object",
                "required": [],
                "properties": {},
            },
        }]
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version = gcp.secretmanager.SecretVersion("secret_version",
            secret=secret.id,
            secret_data="test")
        service_account = gcp.serviceaccount.Account("service_account", account_id="sa")
        secret_access = gcp.secretmanager.SecretIamMember("secret_access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=service_account.member)
        project = gcp.organizations.get_project()
        sa_iam_object_viewer = gcp.projects.IAMMember("sa_iam_object_viewer",
            role="roles/storage.objectViewer",
            project=project.id,
            member=service_account.member)
        sa_iam_ai_platform_user = gcp.projects.IAMMember("sa_iam_ai_platform_user",
            role="roles/aiplatform.user",
            project=project.id,
            member=service_account.member)
        sa_iam_viewer = gcp.projects.IAMMember("sa_iam_viewer",
            role="roles/viewer",
            project=project.id,
            member=service_account.member)
        # Ensure we wait enough time for IAM permissions to be propagated
        wait5_minutes = time.Sleep("wait_5_minutes", create_duration="5m",
        opts = pulumi.ResourceOptions(depends_on=[
                sa_iam_ai_platform_user,
                sa_iam_object_viewer,
                sa_iam_viewer,
                secret_access,
                secret_version,
            ]))
        bucket = gcp.storage.Bucket("bucket",
            name="reasoning-engine",
            location="us-central1",
            uniform_bucket_level_access=True,
            force_destroy=True)
        bucket_obj_requirements_txt = gcp.storage.BucketObject("bucket_obj_requirements_txt",
            name="requirements.txt",
            bucket=bucket.id,
            source=pulumi.FileAsset("./test-fixtures/requirements_adk.txt"))
        bucket_obj_pickle = gcp.storage.BucketObject("bucket_obj_pickle",
            name="code.pkl",
            bucket=bucket.id,
            source=pulumi.FileAsset("./test-fixtures/pickle_adk.pkl"))
        bucket_obj_dependencies_tar_gz = gcp.storage.BucketObject("bucket_obj_dependencies_tar_gz",
            name="dependencies.tar.gz",
            bucket=bucket.id,
            source=pulumi.FileAsset("./test-fixtures/dependencies_adk.tar.gz"))
        reasoning_engine = gcp.vertex.AiReasoningEngine("reasoning_engine",
            display_name="reasoning-engine",
            description="A basic reasoning engine",
            region="us-central1",
            encryption_spec={
                "kms_key_name": "example-key",
            },
            spec={
                "agent_framework": "google-adk",
                "class_methods": json.dumps(class_methods),
                "service_account": service_account.email,
                "deployment_spec": {
                    "envs": [
                        {
                            "name": "var_1",
                            "value": "value_2",
                        },
                        {
                            "name": "var_2",
                            "value": "value_2",
                        },
                    ],
                    "secret_envs": [
                        {
                            "name": "secret_var_1",
                            "secret_ref": {
                                "secret": secret.secret_id,
                                "version": "latest",
                            },
                        },
                        {
                            "name": "secret_var_2",
                            "secret_ref": {
                                "secret": secret.secret_id,
                                "version": "latest",
                            },
                        },
                    ],
                },
                "package_spec": {
                    "dependency_files_gcs_uri": pulumi.Output.all(
                        url=bucket.url,
                        name=bucket_obj_dependencies_tar_gz.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['url']}/{resolved_outputs['name']}")
        ,
                    "pickle_object_gcs_uri": pulumi.Output.all(
                        url=bucket.url,
                        name=bucket_obj_pickle.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['url']}/{resolved_outputs['name']}")
        ,
                    "python_version": "3.11",
                    "requirements_gcs_uri": pulumi.Output.all(
                        url=bucket.url,
                        name=bucket_obj_requirements_txt.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['url']}/{resolved_outputs['name']}")
        ,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[wait5_minutes]))
        ```

        ## Import

        ReasoningEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/reasoningEngines/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ReasoningEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default projects/{{project}}/locations/{{region}}/reasoningEngines/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the ReasoningEngine.
        :param pulumi.Input[_builtins.str] display_name: The display name of the ReasoningEngine.
        :param pulumi.Input[Union['AiReasoningEngineEncryptionSpecArgs', 'AiReasoningEngineEncryptionSpecArgsDict']] encryption_spec: Optional. Customer-managed encryption key spec for a ReasoningEngine.
               If set, this ReasoningEngine and all sub-resources of this ReasoningEngine will be secured by this key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the reasoning engine. eg us-central1
        :param pulumi.Input[Union['AiReasoningEngineSpecArgs', 'AiReasoningEngineSpecArgsDict']] spec: Optional. Configurations of the ReasoningEngine.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiReasoningEngineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ReasoningEngine provides a customizable runtime for models to determine which actions to take and in which order.

        To get more information about ReasoningEngine, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.reasoningEngines/)
        * How-to Guides
            * [Develop and deploy agents on Vertex AI Agent Engine](https://cloud.google.com/vertex-ai/generative-ai/docs/agent-engine/quickstart)

        ## Example Usage

        ### Vertex Ai Reasoning Engine Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        class_methods = [{
            "apiMode": "async",
            "description": None,
            "name": "async_query",
            "parameters": {
                "type": "object",
                "required": [],
                "properties": {},
            },
        }]
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version = gcp.secretmanager.SecretVersion("secret_version",
            secret=secret.id,
            secret_data="test")
        service_account = gcp.serviceaccount.Account("service_account", account_id="sa")
        secret_access = gcp.secretmanager.SecretIamMember("secret_access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=service_account.member)
        project = gcp.organizations.get_project()
        sa_iam_object_viewer = gcp.projects.IAMMember("sa_iam_object_viewer",
            role="roles/storage.objectViewer",
            project=project.id,
            member=service_account.member)
        sa_iam_ai_platform_user = gcp.projects.IAMMember("sa_iam_ai_platform_user",
            role="roles/aiplatform.user",
            project=project.id,
            member=service_account.member)
        sa_iam_viewer = gcp.projects.IAMMember("sa_iam_viewer",
            role="roles/viewer",
            project=project.id,
            member=service_account.member)
        # Ensure we wait enough time for IAM permissions to be propagated
        wait5_minutes = time.Sleep("wait_5_minutes", create_duration="5m",
        opts = pulumi.ResourceOptions(depends_on=[
                sa_iam_ai_platform_user,
                sa_iam_object_viewer,
                sa_iam_viewer,
                secret_access,
                secret_version,
            ]))
        bucket = gcp.storage.Bucket("bucket",
            name="reasoning-engine",
            location="us-central1",
            uniform_bucket_level_access=True,
            force_destroy=True)
        bucket_obj_requirements_txt = gcp.storage.BucketObject("bucket_obj_requirements_txt",
            name="requirements.txt",
            bucket=bucket.id,
            source=pulumi.FileAsset("./test-fixtures/requirements_adk.txt"))
        bucket_obj_pickle = gcp.storage.BucketObject("bucket_obj_pickle",
            name="code.pkl",
            bucket=bucket.id,
            source=pulumi.FileAsset("./test-fixtures/pickle_adk.pkl"))
        bucket_obj_dependencies_tar_gz = gcp.storage.BucketObject("bucket_obj_dependencies_tar_gz",
            name="dependencies.tar.gz",
            bucket=bucket.id,
            source=pulumi.FileAsset("./test-fixtures/dependencies_adk.tar.gz"))
        reasoning_engine = gcp.vertex.AiReasoningEngine("reasoning_engine",
            display_name="reasoning-engine",
            description="A basic reasoning engine",
            region="us-central1",
            encryption_spec={
                "kms_key_name": "example-key",
            },
            spec={
                "agent_framework": "google-adk",
                "class_methods": json.dumps(class_methods),
                "service_account": service_account.email,
                "deployment_spec": {
                    "envs": [
                        {
                            "name": "var_1",
                            "value": "value_2",
                        },
                        {
                            "name": "var_2",
                            "value": "value_2",
                        },
                    ],
                    "secret_envs": [
                        {
                            "name": "secret_var_1",
                            "secret_ref": {
                                "secret": secret.secret_id,
                                "version": "latest",
                            },
                        },
                        {
                            "name": "secret_var_2",
                            "secret_ref": {
                                "secret": secret.secret_id,
                                "version": "latest",
                            },
                        },
                    ],
                },
                "package_spec": {
                    "dependency_files_gcs_uri": pulumi.Output.all(
                        url=bucket.url,
                        name=bucket_obj_dependencies_tar_gz.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['url']}/{resolved_outputs['name']}")
        ,
                    "pickle_object_gcs_uri": pulumi.Output.all(
                        url=bucket.url,
                        name=bucket_obj_pickle.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['url']}/{resolved_outputs['name']}")
        ,
                    "python_version": "3.11",
                    "requirements_gcs_uri": pulumi.Output.all(
                        url=bucket.url,
                        name=bucket_obj_requirements_txt.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['url']}/{resolved_outputs['name']}")
        ,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[wait5_minutes]))
        ```

        ## Import

        ReasoningEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/reasoningEngines/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ReasoningEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default projects/{{project}}/locations/{{region}}/reasoningEngines/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiReasoningEngine:AiReasoningEngine default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AiReasoningEngineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiReasoningEngineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_spec: Optional[pulumi.Input[Union['AiReasoningEngineEncryptionSpecArgs', 'AiReasoningEngineEncryptionSpecArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['AiReasoningEngineSpecArgs', 'AiReasoningEngineSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiReasoningEngineArgs.__new__(AiReasoningEngineArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_spec"] = encryption_spec
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["spec"] = spec
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(AiReasoningEngine, __self__).__init__(
            'gcp:vertex/aiReasoningEngine:AiReasoningEngine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_spec: Optional[pulumi.Input[Union['AiReasoningEngineEncryptionSpecArgs', 'AiReasoningEngineEncryptionSpecArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[Union['AiReasoningEngineSpecArgs', 'AiReasoningEngineSpecArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'AiReasoningEngine':
        """
        Get an existing AiReasoningEngine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[_builtins.str] description: The description of the ReasoningEngine.
        :param pulumi.Input[_builtins.str] display_name: The display name of the ReasoningEngine.
        :param pulumi.Input[Union['AiReasoningEngineEncryptionSpecArgs', 'AiReasoningEngineEncryptionSpecArgsDict']] encryption_spec: Optional. Customer-managed encryption key spec for a ReasoningEngine.
               If set, this ReasoningEngine and all sub-resources of this ReasoningEngine will be secured by this key.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The generated name of the ReasoningEngine, in the format
               'projects/{project}/locations/{location}/reasoningEngines/{reasoningEngine}'
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the reasoning engine. eg us-central1
        :param pulumi.Input[Union['AiReasoningEngineSpecArgs', 'AiReasoningEngineSpecArgsDict']] spec: Optional. Configurations of the ReasoningEngine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiReasoningEngineState.__new__(_AiReasoningEngineState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encryption_spec"] = encryption_spec
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["spec"] = spec
        __props__.__dict__["update_time"] = update_time
        return AiReasoningEngine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the ReasoningEngine.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the ReasoningEngine.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptionSpec")
    def encryption_spec(self) -> pulumi.Output[Optional['outputs.AiReasoningEngineEncryptionSpec']]:
        """
        Optional. Customer-managed encryption key spec for a ReasoningEngine.
        If set, this ReasoningEngine and all sub-resources of this ReasoningEngine will be secured by this key.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_spec")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The generated name of the ReasoningEngine, in the format
        'projects/{project}/locations/{location}/reasoningEngines/{reasoningEngine}'
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region of the reasoning engine. eg us-central1
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional['outputs.AiReasoningEngineSpec']]:
        """
        Optional. Configurations of the ReasoningEngine.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

