# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceGceSetupArgs',
    'InstanceGceSetupArgsDict',
    'InstanceGceSetupAcceleratorConfigArgs',
    'InstanceGceSetupAcceleratorConfigArgsDict',
    'InstanceGceSetupBootDiskArgs',
    'InstanceGceSetupBootDiskArgsDict',
    'InstanceGceSetupConfidentialInstanceConfigArgs',
    'InstanceGceSetupConfidentialInstanceConfigArgsDict',
    'InstanceGceSetupContainerImageArgs',
    'InstanceGceSetupContainerImageArgsDict',
    'InstanceGceSetupDataDisksArgs',
    'InstanceGceSetupDataDisksArgsDict',
    'InstanceGceSetupNetworkInterfaceArgs',
    'InstanceGceSetupNetworkInterfaceArgsDict',
    'InstanceGceSetupNetworkInterfaceAccessConfigArgs',
    'InstanceGceSetupNetworkInterfaceAccessConfigArgsDict',
    'InstanceGceSetupReservationAffinityArgs',
    'InstanceGceSetupReservationAffinityArgsDict',
    'InstanceGceSetupServiceAccountArgs',
    'InstanceGceSetupServiceAccountArgsDict',
    'InstanceGceSetupShieldedInstanceConfigArgs',
    'InstanceGceSetupShieldedInstanceConfigArgsDict',
    'InstanceGceSetupVmImageArgs',
    'InstanceGceSetupVmImageArgsDict',
    'InstanceHealthInfoArgs',
    'InstanceHealthInfoArgsDict',
    'InstanceIamBindingConditionArgs',
    'InstanceIamBindingConditionArgsDict',
    'InstanceIamMemberConditionArgs',
    'InstanceIamMemberConditionArgsDict',
    'InstanceUpgradeHistoryArgs',
    'InstanceUpgradeHistoryArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceGceSetupArgsDict(TypedDict):
        accelerator_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupAcceleratorConfigArgsDict']]]]
        """
        The hardware accelerators used on this instance. If you use accelerators, make sure that your configuration has
        [enough vCPUs and memory to support the `machine_type` you have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
        Currently supports only one accelerator configuration.
        Structure is documented below.
        """
        boot_disk: NotRequired[pulumi.Input['InstanceGceSetupBootDiskArgsDict']]
        """
        The definition of a boot disk.
        Structure is documented below.
        """
        confidential_instance_config: NotRequired[pulumi.Input['InstanceGceSetupConfidentialInstanceConfigArgsDict']]
        """
        Confidential instance configuration.
        Structure is documented below.
        """
        container_image: NotRequired[pulumi.Input['InstanceGceSetupContainerImageArgsDict']]
        """
        Use a container image to start the workbench instance.
        Structure is documented below.
        """
        data_disks: NotRequired[pulumi.Input['InstanceGceSetupDataDisksArgsDict']]
        """
        Data disks attached to the VM instance. Currently supports only one data disk.
        Structure is documented below.
        """
        disable_public_ip: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. If true, no external IP will be assigned to this VM instance.
        """
        enable_ip_forwarding: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. Flag to enable ip forwarding or not, default false/off.
        https://cloud.google.com/vpc/docs/using-routes#canipforward
        """
        machine_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The machine type of the VM instance. https://cloud.google.com/compute/docs/machine-resource
        """
        metadata: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Optional. Custom metadata to apply to this instance.
        """
        network_interfaces: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceArgsDict']]]]
        """
        The network interfaces for the VM. Supports only one interface.
        Structure is documented below.
        """
        reservation_affinity: NotRequired[pulumi.Input['InstanceGceSetupReservationAffinityArgsDict']]
        """
        Reservations that this instance can consume from.
        Structure is documented below.
        """
        service_accounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupServiceAccountArgsDict']]]]
        """
        The service account that serves as an identity for the VM instance. Currently supports only one service account.
        Structure is documented below.
        """
        shielded_instance_config: NotRequired[pulumi.Input['InstanceGceSetupShieldedInstanceConfigArgsDict']]
        """
        A set of Shielded Instance options. See [Images using supported Shielded
        VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
        Not all combinations are valid.
        Structure is documented below.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Optional. The Compute Engine tags to add to instance (see [Tagging
        instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        vm_image: NotRequired[pulumi.Input['InstanceGceSetupVmImageArgsDict']]
        """
        Definition of a custom Compute Engine virtual machine image for starting
        a workbench instance with the environment installed directly on the VM.
        Structure is documented below.
        """
elif False:
    InstanceGceSetupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupArgs:
    def __init__(__self__, *,
                 accelerator_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupAcceleratorConfigArgs']]]] = None,
                 boot_disk: Optional[pulumi.Input['InstanceGceSetupBootDiskArgs']] = None,
                 confidential_instance_config: Optional[pulumi.Input['InstanceGceSetupConfidentialInstanceConfigArgs']] = None,
                 container_image: Optional[pulumi.Input['InstanceGceSetupContainerImageArgs']] = None,
                 data_disks: Optional[pulumi.Input['InstanceGceSetupDataDisksArgs']] = None,
                 disable_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ip_forwarding: Optional[pulumi.Input[_builtins.bool]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceArgs']]]] = None,
                 reservation_affinity: Optional[pulumi.Input['InstanceGceSetupReservationAffinityArgs']] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupServiceAccountArgs']]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceGceSetupShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vm_image: Optional[pulumi.Input['InstanceGceSetupVmImageArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupAcceleratorConfigArgs']]] accelerator_configs: The hardware accelerators used on this instance. If you use accelerators, make sure that your configuration has
               [enough vCPUs and memory to support the `machine_type` you have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
               Currently supports only one accelerator configuration.
               Structure is documented below.
        :param pulumi.Input['InstanceGceSetupBootDiskArgs'] boot_disk: The definition of a boot disk.
               Structure is documented below.
        :param pulumi.Input['InstanceGceSetupConfidentialInstanceConfigArgs'] confidential_instance_config: Confidential instance configuration.
               Structure is documented below.
        :param pulumi.Input['InstanceGceSetupContainerImageArgs'] container_image: Use a container image to start the workbench instance.
               Structure is documented below.
        :param pulumi.Input['InstanceGceSetupDataDisksArgs'] data_disks: Data disks attached to the VM instance. Currently supports only one data disk.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] disable_public_ip: Optional. If true, no external IP will be assigned to this VM instance.
        :param pulumi.Input[_builtins.bool] enable_ip_forwarding: Optional. Flag to enable ip forwarding or not, default false/off.
               https://cloud.google.com/vpc/docs/using-routes#canipforward
        :param pulumi.Input[_builtins.str] machine_type: Optional. The machine type of the VM instance. https://cloud.google.com/compute/docs/machine-resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Optional. Custom metadata to apply to this instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceArgs']]] network_interfaces: The network interfaces for the VM. Supports only one interface.
               Structure is documented below.
        :param pulumi.Input['InstanceGceSetupReservationAffinityArgs'] reservation_affinity: Reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupServiceAccountArgs']]] service_accounts: The service account that serves as an identity for the VM instance. Currently supports only one service account.
               Structure is documented below.
        :param pulumi.Input['InstanceGceSetupShieldedInstanceConfigArgs'] shielded_instance_config: A set of Shielded Instance options. See [Images using supported Shielded
               VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
               Not all combinations are valid.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Optional. The Compute Engine tags to add to instance (see [Tagging
               instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param pulumi.Input['InstanceGceSetupVmImageArgs'] vm_image: Definition of a custom Compute Engine virtual machine image for starting
               a workbench instance with the environment installed directly on the VM.
               Structure is documented below.
        """
        if accelerator_configs is not None:
            pulumi.set(__self__, "accelerator_configs", accelerator_configs)
        if boot_disk is not None:
            pulumi.set(__self__, "boot_disk", boot_disk)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disable_public_ip is not None:
            pulumi.set(__self__, "disable_public_ip", disable_public_ip)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vm_image is not None:
            pulumi.set(__self__, "vm_image", vm_image)

    @_builtins.property
    @pulumi.getter(name="acceleratorConfigs")
    def accelerator_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupAcceleratorConfigArgs']]]]:
        """
        The hardware accelerators used on this instance. If you use accelerators, make sure that your configuration has
        [enough vCPUs and memory to support the `machine_type` you have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
        Currently supports only one accelerator configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_configs")

    @accelerator_configs.setter
    def accelerator_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupAcceleratorConfigArgs']]]]):
        pulumi.set(self, "accelerator_configs", value)

    @_builtins.property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> Optional[pulumi.Input['InstanceGceSetupBootDiskArgs']]:
        """
        The definition of a boot disk.
        Structure is documented below.
        """
        return pulumi.get(self, "boot_disk")

    @boot_disk.setter
    def boot_disk(self, value: Optional[pulumi.Input['InstanceGceSetupBootDiskArgs']]):
        pulumi.set(self, "boot_disk", value)

    @_builtins.property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['InstanceGceSetupConfidentialInstanceConfigArgs']]:
        """
        Confidential instance configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['InstanceGceSetupConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input['InstanceGceSetupContainerImageArgs']]:
        """
        Use a container image to start the workbench instance.
        Structure is documented below.
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input['InstanceGceSetupContainerImageArgs']]):
        pulumi.set(self, "container_image", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input['InstanceGceSetupDataDisksArgs']]:
        """
        Data disks attached to the VM instance. Currently supports only one data disk.
        Structure is documented below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input['InstanceGceSetupDataDisksArgs']]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="disablePublicIp")
    def disable_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. If true, no external IP will be assigned to this VM instance.
        """
        return pulumi.get(self, "disable_public_ip")

    @disable_public_ip.setter
    def disable_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="enableIpForwarding")
    def enable_ip_forwarding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Flag to enable ip forwarding or not, default false/off.
        https://cloud.google.com/vpc/docs/using-routes#canipforward
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @enable_ip_forwarding.setter
    def enable_ip_forwarding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ip_forwarding", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The machine type of the VM instance. https://cloud.google.com/compute/docs/machine-resource
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Custom metadata to apply to this instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceArgs']]]]:
        """
        The network interfaces for the VM. Supports only one interface.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['InstanceGceSetupReservationAffinityArgs']]:
        """
        Reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['InstanceGceSetupReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupServiceAccountArgs']]]]:
        """
        The service account that serves as an identity for the VM instance. Currently supports only one service account.
        Structure is documented below.
        """
        return pulumi.get(self, "service_accounts")

    @service_accounts.setter
    def service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupServiceAccountArgs']]]]):
        pulumi.set(self, "service_accounts", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceGceSetupShieldedInstanceConfigArgs']]:
        """
        A set of Shielded Instance options. See [Images using supported Shielded
        VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
        Not all combinations are valid.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceGceSetupShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. The Compute Engine tags to add to instance (see [Tagging
        instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> Optional[pulumi.Input['InstanceGceSetupVmImageArgs']]:
        """
        Definition of a custom Compute Engine virtual machine image for starting
        a workbench instance with the environment installed directly on the VM.
        Structure is documented below.
        """
        return pulumi.get(self, "vm_image")

    @vm_image.setter
    def vm_image(self, value: Optional[pulumi.Input['InstanceGceSetupVmImageArgs']]):
        pulumi.set(self, "vm_image", value)


if not MYPY:
    class InstanceGceSetupAcceleratorConfigArgsDict(TypedDict):
        core_count: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Count of cores of this accelerator.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Type of this accelerator.
        Possible values are: `NVIDIA_TESLA_P100`, `NVIDIA_TESLA_V100`, `NVIDIA_TESLA_P4`, `NVIDIA_TESLA_T4`, `NVIDIA_TESLA_A100`, `NVIDIA_A100_80GB`, `NVIDIA_L4`, `NVIDIA_TESLA_T4_VWS`, `NVIDIA_TESLA_P100_VWS`, `NVIDIA_TESLA_P4_VWS`.
        """
elif False:
    InstanceGceSetupAcceleratorConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupAcceleratorConfigArgs:
    def __init__(__self__, *,
                 core_count: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] core_count: Optional. Count of cores of this accelerator.
        :param pulumi.Input[_builtins.str] type: Optional. Type of this accelerator.
               Possible values are: `NVIDIA_TESLA_P100`, `NVIDIA_TESLA_V100`, `NVIDIA_TESLA_P4`, `NVIDIA_TESLA_T4`, `NVIDIA_TESLA_A100`, `NVIDIA_A100_80GB`, `NVIDIA_L4`, `NVIDIA_TESLA_T4_VWS`, `NVIDIA_TESLA_P100_VWS`, `NVIDIA_TESLA_P4_VWS`.
        """
        if core_count is not None:
            pulumi.set(__self__, "core_count", core_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Count of cores of this accelerator.
        """
        return pulumi.get(self, "core_count")

    @core_count.setter
    def core_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_count", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Type of this accelerator.
        Possible values are: `NVIDIA_TESLA_P100`, `NVIDIA_TESLA_V100`, `NVIDIA_TESLA_P4`, `NVIDIA_TESLA_T4`, `NVIDIA_TESLA_A100`, `NVIDIA_A100_80GB`, `NVIDIA_L4`, `NVIDIA_TESLA_T4_VWS`, `NVIDIA_TESLA_P100_VWS`, `NVIDIA_TESLA_P4_VWS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class InstanceGceSetupBootDiskArgsDict(TypedDict):
        disk_encryption: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Input only. Disk encryption method used on the boot and
        data disks, defaults to GMEK.
        Possible values are: `GMEK`, `CMEK`.
        """
        disk_size_gb: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The size of the boot disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB). If not specified, this defaults to the
        recommended value of 150GB.
        """
        disk_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Indicates the type of the disk.
        Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        """
        kms_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        'Optional. The KMS key used to encrypt the disks, only
        applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
        Learn more about using your own encryption keys.'
        """
elif False:
    InstanceGceSetupBootDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupBootDiskArgs:
    def __init__(__self__, *,
                 disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] disk_encryption: Optional. Input only. Disk encryption method used on the boot and
               data disks, defaults to GMEK.
               Possible values are: `GMEK`, `CMEK`.
        :param pulumi.Input[_builtins.str] disk_size_gb: Optional. The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). If not specified, this defaults to the
               recommended value of 150GB.
        :param pulumi.Input[_builtins.str] disk_type: Optional. Indicates the type of the disk.
               Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        :param pulumi.Input[_builtins.str] kms_key: 'Optional. The KMS key used to encrypt the disks, only
               applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
               Learn more about using your own encryption keys.'
        """
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Input only. Disk encryption method used on the boot and
        data disks, defaults to GMEK.
        Possible values are: `GMEK`, `CMEK`.
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The size of the boot disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB). If not specified, this defaults to the
        recommended value of 150GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Indicates the type of the disk.
        Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        'Optional. The KMS key used to encrypt the disks, only
        applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
        Learn more about using your own encryption keys.'
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class InstanceGceSetupConfidentialInstanceConfigArgsDict(TypedDict):
        confidential_instance_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Defines the type of technology used by the confidential instance.
        Possible values are: `SEV`.
        """
elif False:
    InstanceGceSetupConfidentialInstanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupConfidentialInstanceConfigArgs:
    def __init__(__self__, *,
                 confidential_instance_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] confidential_instance_type: Defines the type of technology used by the confidential instance.
               Possible values are: `SEV`.
        """
        if confidential_instance_type is not None:
            pulumi.set(__self__, "confidential_instance_type", confidential_instance_type)

    @_builtins.property
    @pulumi.getter(name="confidentialInstanceType")
    def confidential_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the type of technology used by the confidential instance.
        Possible values are: `SEV`.
        """
        return pulumi.get(self, "confidential_instance_type")

    @confidential_instance_type.setter
    def confidential_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "confidential_instance_type", value)


if not MYPY:
    class InstanceGceSetupContainerImageArgsDict(TypedDict):
        repository: pulumi.Input[_builtins.str]
        """
        The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
        """
        tag: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
elif False:
    InstanceGceSetupContainerImageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupContainerImageArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[_builtins.str],
                 tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] repository: The path to the container image repository.
               For example: gcr.io/{project_id}/{imageName}
        :param pulumi.Input[_builtins.str] tag: The tag of the container image. If not specified, this defaults to the latest tag.
        """
        pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)


if not MYPY:
    class InstanceGceSetupDataDisksArgsDict(TypedDict):
        disk_encryption: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Input only. Disk encryption method used on the boot
        and data disks, defaults to GMEK.
        Possible values are: `GMEK`, `CMEK`.
        """
        disk_size_gb: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The size of the disk in GB attached to this VM instance,
        up to a maximum of 64000 GB (64 TB). If not specified, this defaults to
        100.
        """
        disk_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Input only. Indicates the type of the disk.
        Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        """
        kms_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        'Optional. The KMS key used to encrypt the disks,
        only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
        Learn more about using your own encryption keys.'
        """
elif False:
    InstanceGceSetupDataDisksArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupDataDisksArgs:
    def __init__(__self__, *,
                 disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] disk_encryption: Optional. Input only. Disk encryption method used on the boot
               and data disks, defaults to GMEK.
               Possible values are: `GMEK`, `CMEK`.
        :param pulumi.Input[_builtins.str] disk_size_gb: Optional. The size of the disk in GB attached to this VM instance,
               up to a maximum of 64000 GB (64 TB). If not specified, this defaults to
               100.
        :param pulumi.Input[_builtins.str] disk_type: Optional. Input only. Indicates the type of the disk.
               Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        :param pulumi.Input[_builtins.str] kms_key: 'Optional. The KMS key used to encrypt the disks,
               only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
               Learn more about using your own encryption keys.'
        """
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Input only. Disk encryption method used on the boot
        and data disks, defaults to GMEK.
        Possible values are: `GMEK`, `CMEK`.
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The size of the disk in GB attached to this VM instance,
        up to a maximum of 64000 GB (64 TB). If not specified, this defaults to
        100.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Input only. Indicates the type of the disk.
        Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        'Optional. The KMS key used to encrypt the disks,
        only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
        Learn more about using your own encryption keys.'
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class InstanceGceSetupNetworkInterfaceArgsDict(TypedDict):
        access_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceAccessConfigArgsDict']]]]
        """
        Optional. An array of configurations for this interface. Currently, only one access
        config, ONE_TO_ONE_NAT, is supported. If no accessConfigs specified, the
        instance will have an external internet access through an ephemeral
        external IP address.
        Structure is documented below.
        """
        network: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The name of the VPC that this VM instance is in.
        """
        nic_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The type of vNIC to be used on this interface. This
        may be gVNIC or VirtioNet.
        Possible values are: `VIRTIO_NET`, `GVNIC`.
        """
        subnet: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The name of the subnet that this VM instance is in.
        """
elif False:
    InstanceGceSetupNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupNetworkInterfaceArgs:
    def __init__(__self__, *,
                 access_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceAccessConfigArgs']]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 nic_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceAccessConfigArgs']]] access_configs: Optional. An array of configurations for this interface. Currently, only one access
               config, ONE_TO_ONE_NAT, is supported. If no accessConfigs specified, the
               instance will have an external internet access through an ephemeral
               external IP address.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] network: Optional. The name of the VPC that this VM instance is in.
        :param pulumi.Input[_builtins.str] nic_type: Optional. The type of vNIC to be used on this interface. This
               may be gVNIC or VirtioNet.
               Possible values are: `VIRTIO_NET`, `GVNIC`.
        :param pulumi.Input[_builtins.str] subnet: Optional. The name of the subnet that this VM instance is in.
        """
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if nic_type is not None:
            pulumi.set(__self__, "nic_type", nic_type)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceAccessConfigArgs']]]]:
        """
        Optional. An array of configurations for this interface. Currently, only one access
        config, ONE_TO_ONE_NAT, is supported. If no accessConfigs specified, the
        instance will have an external internet access through an ephemeral
        external IP address.
        Structure is documented below.
        """
        return pulumi.get(self, "access_configs")

    @access_configs.setter
    def access_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGceSetupNetworkInterfaceAccessConfigArgs']]]]):
        pulumi.set(self, "access_configs", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The name of the VPC that this VM instance is in.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The type of vNIC to be used on this interface. This
        may be gVNIC or VirtioNet.
        Possible values are: `VIRTIO_NET`, `GVNIC`.
        """
        return pulumi.get(self, "nic_type")

    @nic_type.setter
    def nic_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nic_type", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The name of the subnet that this VM instance is in.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)


if not MYPY:
    class InstanceGceSetupNetworkInterfaceAccessConfigArgsDict(TypedDict):
        external_ip: pulumi.Input[_builtins.str]
        """
        An external IP address associated with this instance. Specify an unused
        static external IP address available to the project or leave this field
        undefined to use an IP from a shared ephemeral IP address pool. If you
        specify a static external IP address, it must live in the same region as
        the zone of the instance.
        """
elif False:
    InstanceGceSetupNetworkInterfaceAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupNetworkInterfaceAccessConfigArgs:
    def __init__(__self__, *,
                 external_ip: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] external_ip: An external IP address associated with this instance. Specify an unused
               static external IP address available to the project or leave this field
               undefined to use an IP from a shared ephemeral IP address pool. If you
               specify a static external IP address, it must live in the same region as
               the zone of the instance.
        """
        pulumi.set(__self__, "external_ip", external_ip)

    @_builtins.property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> pulumi.Input[_builtins.str]:
        """
        An external IP address associated with this instance. Specify an unused
        static external IP address available to the project or leave this field
        undefined to use an IP from a shared ephemeral IP address pool. If you
        specify a static external IP address, it must live in the same region as
        the zone of the instance.
        """
        return pulumi.get(self, "external_ip")

    @external_ip.setter
    def external_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_ip", value)


if not MYPY:
    class InstanceGceSetupReservationAffinityArgsDict(TypedDict):
        consume_reservation_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the type of reservation from which this instance can consume resources:
        RESERVATION_ANY (default), RESERVATION_SPECIFIC, or RESERVATION_NONE.
        Possible values are: `RESERVATION_NONE`, `RESERVATION_ANY`, `RESERVATION_SPECIFIC`.
        """
        key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Corresponds to the label key of a reservation resource. To target a
        RESERVATION_SPECIFIC by name, use compute.googleapis.com/reservation-name
        as the key and specify the name of your reservation as its value.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Corresponds to the label values of a reservation resource. This can be
        either a name to a reservation in the same project or
        "projects/different-project/reservations/some-reservation-name"
        to target a shared reservation in the same zone but in a different project.
        """
elif False:
    InstanceGceSetupReservationAffinityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupReservationAffinityArgs:
    def __init__(__self__, *,
                 consume_reservation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] consume_reservation_type: Specifies the type of reservation from which this instance can consume resources:
               RESERVATION_ANY (default), RESERVATION_SPECIFIC, or RESERVATION_NONE.
               Possible values are: `RESERVATION_NONE`, `RESERVATION_ANY`, `RESERVATION_SPECIFIC`.
        :param pulumi.Input[_builtins.str] key: Corresponds to the label key of a reservation resource. To target a
               RESERVATION_SPECIFIC by name, use compute.googleapis.com/reservation-name
               as the key and specify the name of your reservation as its value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: Corresponds to the label values of a reservation resource. This can be
               either a name to a reservation in the same project or
               "projects/different-project/reservations/some-reservation-name"
               to target a shared reservation in the same zone but in a different project.
        """
        if consume_reservation_type is not None:
            pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of reservation from which this instance can consume resources:
        RESERVATION_ANY (default), RESERVATION_SPECIFIC, or RESERVATION_NONE.
        Possible values are: `RESERVATION_NONE`, `RESERVATION_ANY`, `RESERVATION_SPECIFIC`.
        """
        return pulumi.get(self, "consume_reservation_type")

    @consume_reservation_type.setter
    def consume_reservation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consume_reservation_type", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Corresponds to the label key of a reservation resource. To target a
        RESERVATION_SPECIFIC by name, use compute.googleapis.com/reservation-name
        as the key and specify the name of your reservation as its value.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Corresponds to the label values of a reservation resource. This can be
        either a name to a reservation in the same project or
        "projects/different-project/reservations/some-reservation-name"
        to target a shared reservation in the same zone but in a different project.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class InstanceGceSetupServiceAccountArgsDict(TypedDict):
        email: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Email address of the service account.
        """
        scopes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        (Output)
        Output only. The list of scopes to be made available for this
        service account. Set by the CLH to https://www.googleapis.com/auth/cloud-platform
        """
elif False:
    InstanceGceSetupServiceAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupServiceAccountArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] email: Optional. Email address of the service account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: (Output)
               Output only. The list of scopes to be made available for this
               service account. Set by the CLH to https://www.googleapis.com/auth/cloud-platform
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Email address of the service account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Output)
        Output only. The list of scopes to be made available for this
        service account. Set by the CLH to https://www.googleapis.com/auth/cloud-platform
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)


if not MYPY:
    class InstanceGceSetupShieldedInstanceConfigArgsDict(TypedDict):
        enable_integrity_monitoring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. Defines whether the VM instance has integrity monitoring
        enabled. Enables monitoring and attestation of the boot integrity of the VM
        instance. The attestation is performed against the integrity policy baseline.
        This baseline is initially derived from the implicitly trusted boot image
        when the VM instance is created. Enabled by default.
        """
        enable_secure_boot: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. Defines whether the VM instance has Secure Boot enabled.
        Secure Boot helps ensure that the system only runs authentic software by verifying
        the digital signature of all boot components, and halting the boot process
        if signature verification fails. Disabled by default.
        """
        enable_vtpm: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. Defines whether the VM instance has the vTPM enabled.
        Enabled by default.
        """
elif False:
    InstanceGceSetupShieldedInstanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_integrity_monitoring: Optional. Defines whether the VM instance has integrity monitoring
               enabled. Enables monitoring and attestation of the boot integrity of the VM
               instance. The attestation is performed against the integrity policy baseline.
               This baseline is initially derived from the implicitly trusted boot image
               when the VM instance is created. Enabled by default.
        :param pulumi.Input[_builtins.bool] enable_secure_boot: Optional. Defines whether the VM instance has Secure Boot enabled.
               Secure Boot helps ensure that the system only runs authentic software by verifying
               the digital signature of all boot components, and halting the boot process
               if signature verification fails. Disabled by default.
        :param pulumi.Input[_builtins.bool] enable_vtpm: Optional. Defines whether the VM instance has the vTPM enabled.
               Enabled by default.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @_builtins.property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Defines whether the VM instance has integrity monitoring
        enabled. Enables monitoring and attestation of the boot integrity of the VM
        instance. The attestation is performed against the integrity policy baseline.
        This baseline is initially derived from the implicitly trusted boot image
        when the VM instance is created. Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @_builtins.property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Defines whether the VM instance has Secure Boot enabled.
        Secure Boot helps ensure that the system only runs authentic software by verifying
        the digital signature of all boot components, and halting the boot process
        if signature verification fails. Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_secure_boot", value)

    @_builtins.property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Defines whether the VM instance has the vTPM enabled.
        Enabled by default.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_vtpm", value)


if not MYPY:
    class InstanceGceSetupVmImageArgsDict(TypedDict):
        family: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Use this VM image family to find the image; the newest
        image in this family will be used.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Use VM image name to find the image.
        """
        project: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: {project_id}
        """
elif False:
    InstanceGceSetupVmImageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGceSetupVmImageArgs:
    def __init__(__self__, *,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] family: Optional. Use this VM image family to find the image; the newest
               image in this family will be used.
        :param pulumi.Input[_builtins.str] name: Optional. Use VM image name to find the image.
        :param pulumi.Input[_builtins.str] project: The name of the Google Cloud project that this VM image belongs to.
               Format: {project_id}
        """
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Use this VM image family to find the image; the newest
        image in this family will be used.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Use VM image name to find the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: {project_id}
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


if not MYPY:
    class InstanceHealthInfoArgsDict(TypedDict):
        pass
elif False:
    InstanceHealthInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceHealthInfoArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class InstanceIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        title: pulumi.Input[_builtins.str]
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    InstanceIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class InstanceIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        title: pulumi.Input[_builtins.str]
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    InstanceIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class InstanceUpgradeHistoryArgsDict(TypedDict):
        action: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Action. Rolloback or Upgrade.
        """
        container_image: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The container image before this instance upgrade.
        """
        create_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        The milliseconds portion (".SSS") is optional.
        """
        framework: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The framework of this workbench instance.
        """
        snapshot: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The snapshot of the boot disk of this workbench instance before upgrade.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Output only. The state of this instance upgrade history entry.
        """
        target_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Target VM Version, like m63.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The version of the workbench instance before this upgrade.
        """
        vm_image: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The VM image before this instance upgrade.
        """
elif False:
    InstanceUpgradeHistoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceUpgradeHistoryArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 container_image: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 framework: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 target_version: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_image: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: Optional. Action. Rolloback or Upgrade.
        :param pulumi.Input[_builtins.str] container_image: Optional. The container image before this instance upgrade.
        :param pulumi.Input[_builtins.str] create_time: An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
               The milliseconds portion (".SSS") is optional.
        :param pulumi.Input[_builtins.str] framework: Optional. The framework of this workbench instance.
        :param pulumi.Input[_builtins.str] snapshot: Optional. The snapshot of the boot disk of this workbench instance before upgrade.
        :param pulumi.Input[_builtins.str] state: (Output)
               Output only. The state of this instance upgrade history entry.
        :param pulumi.Input[_builtins.str] target_version: Optional. Target VM Version, like m63.
        :param pulumi.Input[_builtins.str] version: Optional. The version of the workbench instance before this upgrade.
        :param pulumi.Input[_builtins.str] vm_image: Optional. The VM image before this instance upgrade.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vm_image is not None:
            pulumi.set(__self__, "vm_image", vm_image)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Action. Rolloback or Upgrade.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The container image before this instance upgrade.
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_image", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        The milliseconds portion (".SSS") is optional.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def framework(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The framework of this workbench instance.
        """
        return pulumi.get(self, "framework")

    @framework.setter
    def framework(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "framework", value)

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The snapshot of the boot disk of this workbench instance before upgrade.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Output only. The state of this instance upgrade history entry.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Target VM Version, like m63.
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_version", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The version of the workbench instance before this upgrade.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The VM image before this instance upgrade.
        """
        return pulumi.get(self, "vm_image")

    @vm_image.setter
    def vm_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_image", value)


