# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['parserkiosk', 'parserkiosk.schemas', 'parserkiosk.templates']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.0.3,<4.0.0',
 'PyYAML>=6.0,<7.0',
 'python-box>=5.4.1,<6.0.0',
 'yamale>=4.0.4,<5.0.0']

entry_points = \
{'console_scripts': ['parserkiosk = parserkiosk:main']}

setup_kwargs = {
    'name': 'parserkiosk',
    'version': '0.2.2',
    'description': 'A Proof of Concept multi-lingual test generation suite intended for parsers.',
    'long_description': '## ParserKiosk: A Proof of Concept multi-lingual test generation suite intended for parsers\n\n![](https://img.shields.io/github/commit-activity/w/R9295/parserkiosk?style=flat-square)\n![](https://img.shields.io/github/issues/R9295/parserkiosk?style=flat-square)\n![](https://img.shields.io/pypi/v/parserkiosk?style=flat-square)\n![](https://pepy.tech/badge/parserkiosk)\n![](https://img.shields.io/pypi/format/parserkiosk?style=flat-square)\n![](https://img.shields.io/badge/code%20style-black-000000.svg)\n\n### Motivation\nAfter reading this [article](https://seriot.ch/projects/parsing_json.html) and [this one](https://bishopfox.com/blog/json-interoperability-vulnerabilities), I am now paranoid and under the assumption that implementations of data serialization and deserialization have a lot of quirks that differ from language to language, and implementation to implementation.\n\nThis _could_ lead to serious security issues as applications, especially web applicatons _usually_ utilize multiple services, written in multiple languages that use the same format to communicate. \n\nReference implementations usually provide tests, but translating them from language to language is tiresome and tedious. I wanted to compose a library to generate **simple**, functional tests for multiple languages with minimal repitition. \n\n### Usage\n1. Install \n``` bash\n$ pip install parserkiosk\n```\n2. Define a ``config.yaml``\n``` yaml\n# config.yaml\n---\nimport_string: "from my_parser import serialize, deserialize"\nserialize_function: "serialize"\nde_serialize_function: "deserialize"\nassert_functions:\n  - my_assert_function\n```\n3. Define a yaml file prefixed with ``test_`` in the same directory as ``config.yaml``\n``` yaml\n# test_serialize.yaml\ntype: "SERIALIZE"\ntests:\n  test_something:\n      info: "Example Test"\n      input:\n        type: "str"\n        arg: "hello, world"\n      assert:\n        func: "my_assert_function"\n        arg: "[\\"hello\\", \\" world\\"]"\n```\n4. Run parserkiosk in the same directory as ```config.yaml``` and ``test_serialize.yaml``\n``` bash\n$ parserkiosk . --builtin python\n```\n5. See output directory ```tests/```\n``` bash\n$ ls tests/\ntest_serialize.py\n```\n\n\n#### See [HOWTO](HOWTO.md) for a complete guide.\n\n### How does it work?\nParserkiosk uses ``jinja2`` templates to generate test cases from ``yaml`` file(s). You can either expect something to fail(raise an "exception" or "error") or use a function that you define in a special file called ```commons``` to assert if the parsed data matches the expected internal representation. \n\nLet\'s say you\'ve written a reference implementation of your data de/serialization format in ``Go`` and I wanted to implement it in ``Python``.  \nAll I would need to do to implement your test-suite is:\n1. Write a ```commons.py``` file implementing the same assertion functions that you\'ve written in your ``commons.go`` file\n2. Adapt your parserkiosk config to use my implementation\n3. Run ```$ parserkiosk folder_with_yaml_test_files/ --builtin python``` and _voila_ I have your entire test suite implemented!\n\nFor more on this, see ```examples/json/```\n\n### Languages supported\n- [x] Python / pytest / ``python``\n- [x] NodeJS / jest (sync) / ``node_js``\n- [ ] NodeJS / jest (async)\n- [ ] Lua \n- [ ] Go\n- [ ] Java\n- [ ] PHP\n- [ ] Perl\n- [ ] Ruby\n- [ ] ...\n\n### License\nAll work is licensed under ```GPL-3.0``` excluding the example JSON test-suite which is licensed under ```MIT```\n\n### Contributing\nIssues, feedback and pull requests are welcome. I have tried _my best_ to keep the code simple. Please keep in mind that I wish to limit features that we accomodate to keep it simple. Tests should be simple and readable.\n### Installing for development:\n``` bash\n$ git clone https://github.com/you/your-fork-of-parserkiosk.git\n$ cd your-fork-of-parserkiosk\n$ poetry install\n$ poetry run pre-commit install\n# do some changes\n$ ./runtests.sh\n# you are ready!\n```\n### Thanks\nSpecial thanks to [nst](https://github.com/nst/) for inspiring Parserkiosk. All test cases in ``examples/json`` come from his [incredible work](https://github.com/nst/JSONTestSuite)\n',
    'author': 'aarnav',
    'author_email': 'aarnavbos@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/R9295/parser-kiosk',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
