# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GitRepositoryBranchArgs', 'GitRepositoryBranch']

@pulumi.input_type
class GitRepositoryBranchArgs:
    def __init__(__self__, *,
                 repository_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GitRepositoryBranch resource.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository the branch is created against.
        :param pulumi.Input[_builtins.str] name: The name of the branch in short format not prefixed with `refs/heads/`.
        :param pulumi.Input[_builtins.str] ref_branch: The reference to the source branch to create the branch from, in `<name>` or `refs/heads/<name>` format. Conflict with `ref_tag`, `ref_commit_id`.
        :param pulumi.Input[_builtins.str] ref_commit_id: The commit object ID to create the branch from. Conflict with `ref_branch`, `ref_tag`.
        :param pulumi.Input[_builtins.str] ref_tag: The reference to the tag to create the branch from, in `<name>` or `refs/tags/<name>` format. Conflict with `ref_branch`, `ref_commit_id`.
        """
        pulumi.set(__self__, "repository_id", repository_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ref_branch is not None:
            pulumi.set(__self__, "ref_branch", ref_branch)
        if ref_commit_id is not None:
            pulumi.set(__self__, "ref_commit_id", ref_commit_id)
        if ref_tag is not None:
            pulumi.set(__self__, "ref_tag", ref_tag)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the repository the branch is created against.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the branch in short format not prefixed with `refs/heads/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="refBranch")
    def ref_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to the source branch to create the branch from, in `<name>` or `refs/heads/<name>` format. Conflict with `ref_tag`, `ref_commit_id`.
        """
        return pulumi.get(self, "ref_branch")

    @ref_branch.setter
    def ref_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_branch", value)

    @_builtins.property
    @pulumi.getter(name="refCommitId")
    def ref_commit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit object ID to create the branch from. Conflict with `ref_branch`, `ref_tag`.
        """
        return pulumi.get(self, "ref_commit_id")

    @ref_commit_id.setter
    def ref_commit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_commit_id", value)

    @_builtins.property
    @pulumi.getter(name="refTag")
    def ref_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to the tag to create the branch from, in `<name>` or `refs/tags/<name>` format. Conflict with `ref_branch`, `ref_commit_id`.
        """
        return pulumi.get(self, "ref_tag")

    @ref_tag.setter
    def ref_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_tag", value)


@pulumi.input_type
class _GitRepositoryBranchState:
    def __init__(__self__, *,
                 last_commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitRepositoryBranch resources.
        :param pulumi.Input[_builtins.str] last_commit_id: The commit object ID of last commit on the branch.
        :param pulumi.Input[_builtins.str] name: The name of the branch in short format not prefixed with `refs/heads/`.
        :param pulumi.Input[_builtins.str] ref_branch: The reference to the source branch to create the branch from, in `<name>` or `refs/heads/<name>` format. Conflict with `ref_tag`, `ref_commit_id`.
        :param pulumi.Input[_builtins.str] ref_commit_id: The commit object ID to create the branch from. Conflict with `ref_branch`, `ref_tag`.
        :param pulumi.Input[_builtins.str] ref_tag: The reference to the tag to create the branch from, in `<name>` or `refs/tags/<name>` format. Conflict with `ref_branch`, `ref_commit_id`.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository the branch is created against.
        """
        if last_commit_id is not None:
            pulumi.set(__self__, "last_commit_id", last_commit_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ref_branch is not None:
            pulumi.set(__self__, "ref_branch", ref_branch)
        if ref_commit_id is not None:
            pulumi.set(__self__, "ref_commit_id", ref_commit_id)
        if ref_tag is not None:
            pulumi.set(__self__, "ref_tag", ref_tag)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit object ID of last commit on the branch.
        """
        return pulumi.get(self, "last_commit_id")

    @last_commit_id.setter
    def last_commit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_commit_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the branch in short format not prefixed with `refs/heads/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="refBranch")
    def ref_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to the source branch to create the branch from, in `<name>` or `refs/heads/<name>` format. Conflict with `ref_tag`, `ref_commit_id`.
        """
        return pulumi.get(self, "ref_branch")

    @ref_branch.setter
    def ref_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_branch", value)

    @_builtins.property
    @pulumi.getter(name="refCommitId")
    def ref_commit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit object ID to create the branch from. Conflict with `ref_branch`, `ref_tag`.
        """
        return pulumi.get(self, "ref_commit_id")

    @ref_commit_id.setter
    def ref_commit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_commit_id", value)

    @_builtins.property
    @pulumi.getter(name="refTag")
    def ref_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to the tag to create the branch from, in `<name>` or `refs/tags/<name>` format. Conflict with `ref_branch`, `ref_commit_id`.
        """
        return pulumi.get(self, "ref_tag")

    @ref_tag.setter
    def ref_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_tag", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the repository the branch is created against.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)


@pulumi.type_token("azuredevops:index/gitRepositoryBranch:GitRepositoryBranch")
class GitRepositoryBranch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Git Repository Branch.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_git_repository_branch = azuredevops.GitRepositoryBranch("example",
            repository_id=example_git.id,
            name="example-branch-name",
            ref_branch=example_git.default_branch)
        example_from_commit_id = azuredevops.GitRepositoryBranch("example_from_commit_id",
            repository_id=example_git.id,
            name="example-from-commit-id",
            ref_commit_id=example_git_repository_branch.last_commit_id)
        ```

        ## Import

        Azure DevOps Git Repository Branch can be imported using the `repository ID:branchName`.

        ```sh
        $ pulumi import azuredevops:index/gitRepositoryBranch:GitRepositoryBranch example "00000000-0000-0000-0000-000000000000:main"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the branch in short format not prefixed with `refs/heads/`.
        :param pulumi.Input[_builtins.str] ref_branch: The reference to the source branch to create the branch from, in `<name>` or `refs/heads/<name>` format. Conflict with `ref_tag`, `ref_commit_id`.
        :param pulumi.Input[_builtins.str] ref_commit_id: The commit object ID to create the branch from. Conflict with `ref_branch`, `ref_tag`.
        :param pulumi.Input[_builtins.str] ref_tag: The reference to the tag to create the branch from, in `<name>` or `refs/tags/<name>` format. Conflict with `ref_branch`, `ref_commit_id`.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository the branch is created against.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitRepositoryBranchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Git Repository Branch.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_git_repository_branch = azuredevops.GitRepositoryBranch("example",
            repository_id=example_git.id,
            name="example-branch-name",
            ref_branch=example_git.default_branch)
        example_from_commit_id = azuredevops.GitRepositoryBranch("example_from_commit_id",
            repository_id=example_git.id,
            name="example-from-commit-id",
            ref_commit_id=example_git_repository_branch.last_commit_id)
        ```

        ## Import

        Azure DevOps Git Repository Branch can be imported using the `repository ID:branchName`.

        ```sh
        $ pulumi import azuredevops:index/gitRepositoryBranch:GitRepositoryBranch example "00000000-0000-0000-0000-000000000000:main"
        ```

        :param str resource_name: The name of the resource.
        :param GitRepositoryBranchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitRepositoryBranchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitRepositoryBranchArgs.__new__(GitRepositoryBranchArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["ref_branch"] = ref_branch
            __props__.__dict__["ref_commit_id"] = ref_commit_id
            __props__.__dict__["ref_tag"] = ref_tag
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["last_commit_id"] = None
        super(GitRepositoryBranch, __self__).__init__(
            'azuredevops:index/gitRepositoryBranch:GitRepositoryBranch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            last_commit_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ref_branch: Optional[pulumi.Input[_builtins.str]] = None,
            ref_commit_id: Optional[pulumi.Input[_builtins.str]] = None,
            ref_tag: Optional[pulumi.Input[_builtins.str]] = None,
            repository_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GitRepositoryBranch':
        """
        Get an existing GitRepositoryBranch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] last_commit_id: The commit object ID of last commit on the branch.
        :param pulumi.Input[_builtins.str] name: The name of the branch in short format not prefixed with `refs/heads/`.
        :param pulumi.Input[_builtins.str] ref_branch: The reference to the source branch to create the branch from, in `<name>` or `refs/heads/<name>` format. Conflict with `ref_tag`, `ref_commit_id`.
        :param pulumi.Input[_builtins.str] ref_commit_id: The commit object ID to create the branch from. Conflict with `ref_branch`, `ref_tag`.
        :param pulumi.Input[_builtins.str] ref_tag: The reference to the tag to create the branch from, in `<name>` or `refs/tags/<name>` format. Conflict with `ref_branch`, `ref_commit_id`.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the repository the branch is created against.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitRepositoryBranchState.__new__(_GitRepositoryBranchState)

        __props__.__dict__["last_commit_id"] = last_commit_id
        __props__.__dict__["name"] = name
        __props__.__dict__["ref_branch"] = ref_branch
        __props__.__dict__["ref_commit_id"] = ref_commit_id
        __props__.__dict__["ref_tag"] = ref_tag
        __props__.__dict__["repository_id"] = repository_id
        return GitRepositoryBranch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> pulumi.Output[_builtins.str]:
        """
        The commit object ID of last commit on the branch.
        """
        return pulumi.get(self, "last_commit_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the branch in short format not prefixed with `refs/heads/`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="refBranch")
    def ref_branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The reference to the source branch to create the branch from, in `<name>` or `refs/heads/<name>` format. Conflict with `ref_tag`, `ref_commit_id`.
        """
        return pulumi.get(self, "ref_branch")

    @_builtins.property
    @pulumi.getter(name="refCommitId")
    def ref_commit_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The commit object ID to create the branch from. Conflict with `ref_branch`, `ref_tag`.
        """
        return pulumi.get(self, "ref_commit_id")

    @_builtins.property
    @pulumi.getter(name="refTag")
    def ref_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The reference to the tag to create the branch from, in `<name>` or `refs/tags/<name>` format. Conflict with `ref_branch`, `ref_commit_id`.
        """
        return pulumi.get(self, "ref_tag")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the repository the branch is created against.
        """
        return pulumi.get(self, "repository_id")

