# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AuthConfigAzureAdArgs', 'AuthConfigAzureAd']

@pulumi.input_type
class AuthConfigAzureAdArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 application_secret: pulumi.Input[_builtins.str],
                 auth_endpoint: pulumi.Input[_builtins.str],
                 graph_endpoint: pulumi.Input[_builtins.str],
                 rancher_url: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 token_endpoint: pulumi.Input[_builtins.str],
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 group_membership_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AuthConfigAzureAd resource.
        :param pulumi.Input[_builtins.str] application_id: AzureAD auth application ID (string)
        :param pulumi.Input[_builtins.str] application_secret: AzureAD auth application secret (string)
        :param pulumi.Input[_builtins.str] auth_endpoint: AzureAD auth endpoint (string)
        :param pulumi.Input[_builtins.str] graph_endpoint: AzureAD graph endpoint (string)
        :param pulumi.Input[_builtins.str] rancher_url: Rancher URL (string). "<rancher_url>/verify-auth-azure"
        :param pulumi.Input[_builtins.str] tenant_id: AzureAD tenant ID (string)
        :param pulumi.Input[_builtins.str] token_endpoint: AzureAD token endpoint (string)
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `azuread_user://<USER_ID>`  `azuread_group://<GROUP_ID>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] endpoint: AzureAD endpoint. Default `https://login.microsoftonline.com/` (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_secret", application_secret)
        pulumi.set(__self__, "auth_endpoint", auth_endpoint)
        pulumi.set(__self__, "graph_endpoint", graph_endpoint)
        pulumi.set(__self__, "rancher_url", rancher_url)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if allowed_principal_ids is not None:
            pulumi.set(__self__, "allowed_principal_ids", allowed_principal_ids)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if group_membership_filter is not None:
            pulumi.set(__self__, "group_membership_filter", group_membership_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        AzureAD auth application ID (string)
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> pulumi.Input[_builtins.str]:
        """
        AzureAD auth application secret (string)
        """
        return pulumi.get(self, "application_secret")

    @application_secret.setter
    def application_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_secret", value)

    @_builtins.property
    @pulumi.getter(name="authEndpoint")
    def auth_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        AzureAD auth endpoint (string)
        """
        return pulumi.get(self, "auth_endpoint")

    @auth_endpoint.setter
    def auth_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="graphEndpoint")
    def graph_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        AzureAD graph endpoint (string)
        """
        return pulumi.get(self, "graph_endpoint")

    @graph_endpoint.setter
    def graph_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "graph_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="rancherUrl")
    def rancher_url(self) -> pulumi.Input[_builtins.str]:
        """
        Rancher URL (string). "<rancher_url>/verify-auth-azure"
        """
        return pulumi.get(self, "rancher_url")

    @rancher_url.setter
    def rancher_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rancher_url", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        AzureAD tenant ID (string)
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        AzureAD token endpoint (string)
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "token_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrincipalIds")
    def allowed_principal_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `azuread_user://<USER_ID>`  `azuread_group://<GROUP_ID>` (list)
        """
        return pulumi.get(self, "allowed_principal_ids")

    @allowed_principal_ids.setter
    def allowed_principal_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_principal_ids", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable auth config provider. Default `true` (bool)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD endpoint. Default `https://login.microsoftonline.com/` (string)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="groupMembershipFilter")
    def group_membership_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "group_membership_filter")

    @group_membership_filter.setter
    def group_membership_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_membership_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class _AuthConfigAzureAdState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 graph_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 group_membership_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rancher_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthConfigAzureAd resources.
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `azuread_user://<USER_ID>`  `azuread_group://<GROUP_ID>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] application_id: AzureAD auth application ID (string)
        :param pulumi.Input[_builtins.str] application_secret: AzureAD auth application secret (string)
        :param pulumi.Input[_builtins.str] auth_endpoint: AzureAD auth endpoint (string)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] endpoint: AzureAD endpoint. Default `https://login.microsoftonline.com/` (string)
        :param pulumi.Input[_builtins.str] graph_endpoint: AzureAD graph endpoint (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: (Computed) The name of the resource (string)
        :param pulumi.Input[_builtins.str] rancher_url: Rancher URL (string). "<rancher_url>/verify-auth-azure"
        :param pulumi.Input[_builtins.str] tenant_id: AzureAD tenant ID (string)
        :param pulumi.Input[_builtins.str] token_endpoint: AzureAD token endpoint (string)
        :param pulumi.Input[_builtins.str] type: (Computed) The type of the resource (string)
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if allowed_principal_ids is not None:
            pulumi.set(__self__, "allowed_principal_ids", allowed_principal_ids)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_secret is not None:
            pulumi.set(__self__, "application_secret", application_secret)
        if auth_endpoint is not None:
            pulumi.set(__self__, "auth_endpoint", auth_endpoint)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if graph_endpoint is not None:
            pulumi.set(__self__, "graph_endpoint", graph_endpoint)
        if group_membership_filter is not None:
            pulumi.set(__self__, "group_membership_filter", group_membership_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rancher_url is not None:
            pulumi.set(__self__, "rancher_url", rancher_url)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="allowedPrincipalIds")
    def allowed_principal_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `azuread_user://<USER_ID>`  `azuread_group://<GROUP_ID>` (list)
        """
        return pulumi.get(self, "allowed_principal_ids")

    @allowed_principal_ids.setter
    def allowed_principal_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_principal_ids", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD auth application ID (string)
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD auth application secret (string)
        """
        return pulumi.get(self, "application_secret")

    @application_secret.setter
    def application_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_secret", value)

    @_builtins.property
    @pulumi.getter(name="authEndpoint")
    def auth_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD auth endpoint (string)
        """
        return pulumi.get(self, "auth_endpoint")

    @auth_endpoint.setter
    def auth_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable auth config provider. Default `true` (bool)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD endpoint. Default `https://login.microsoftonline.com/` (string)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="graphEndpoint")
    def graph_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD graph endpoint (string)
        """
        return pulumi.get(self, "graph_endpoint")

    @graph_endpoint.setter
    def graph_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graph_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="groupMembershipFilter")
    def group_membership_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "group_membership_filter")

    @group_membership_filter.setter
    def group_membership_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_membership_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The name of the resource (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rancherUrl")
    def rancher_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rancher URL (string). "<rancher_url>/verify-auth-azure"
        """
        return pulumi.get(self, "rancher_url")

    @rancher_url.setter
    def rancher_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rancher_url", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD tenant ID (string)
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AzureAD token endpoint (string)
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The type of the resource (string)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("rancher2:index/authConfigAzureAd:AuthConfigAzureAd")
class AuthConfigAzureAd(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 graph_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 group_membership_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rancher_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Auth Config AzureAD
        azuread = rancher2.AuthConfigAzureAd("azuread",
            application_id="<AZUREAD_APP_ID>",
            application_secret="<AZUREAD_APP_SECRET>",
            auth_endpoint="<AZUREAD_AUTH_ENDPOINT>",
            graph_endpoint="<AZUREAD_GRAPH_ENDPOINT>",
            rancher_url="<RANCHER_URL>",
            tenant_id="<AZUREAD_TENANT_ID>",
            token_endpoint="<AZUREAD_TOKEN_ENDPOINT>")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `azuread_user://<USER_ID>`  `azuread_group://<GROUP_ID>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] application_id: AzureAD auth application ID (string)
        :param pulumi.Input[_builtins.str] application_secret: AzureAD auth application secret (string)
        :param pulumi.Input[_builtins.str] auth_endpoint: AzureAD auth endpoint (string)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] endpoint: AzureAD endpoint. Default `https://login.microsoftonline.com/` (string)
        :param pulumi.Input[_builtins.str] graph_endpoint: AzureAD graph endpoint (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] rancher_url: Rancher URL (string). "<rancher_url>/verify-auth-azure"
        :param pulumi.Input[_builtins.str] tenant_id: AzureAD tenant ID (string)
        :param pulumi.Input[_builtins.str] token_endpoint: AzureAD token endpoint (string)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthConfigAzureAdArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Auth Config AzureAD
        azuread = rancher2.AuthConfigAzureAd("azuread",
            application_id="<AZUREAD_APP_ID>",
            application_secret="<AZUREAD_APP_SECRET>",
            auth_endpoint="<AZUREAD_AUTH_ENDPOINT>",
            graph_endpoint="<AZUREAD_GRAPH_ENDPOINT>",
            rancher_url="<RANCHER_URL>",
            tenant_id="<AZUREAD_TENANT_ID>",
            token_endpoint="<AZUREAD_TOKEN_ENDPOINT>")
        ```

        :param str resource_name: The name of the resource.
        :param AuthConfigAzureAdArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthConfigAzureAdArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 graph_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 group_membership_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rancher_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthConfigAzureAdArgs.__new__(AuthConfigAzureAdArgs)

            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["allowed_principal_ids"] = allowed_principal_ids
            __props__.__dict__["annotations"] = annotations
            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = None if application_id is None else pulumi.Output.secret(application_id)
            if application_secret is None and not opts.urn:
                raise TypeError("Missing required property 'application_secret'")
            __props__.__dict__["application_secret"] = None if application_secret is None else pulumi.Output.secret(application_secret)
            if auth_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'auth_endpoint'")
            __props__.__dict__["auth_endpoint"] = auth_endpoint
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["endpoint"] = endpoint
            if graph_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'graph_endpoint'")
            __props__.__dict__["graph_endpoint"] = graph_endpoint
            __props__.__dict__["group_membership_filter"] = group_membership_filter
            __props__.__dict__["labels"] = labels
            if rancher_url is None and not opts.urn:
                raise TypeError("Missing required property 'rancher_url'")
            __props__.__dict__["rancher_url"] = rancher_url
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if token_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'token_endpoint'")
            __props__.__dict__["token_endpoint"] = token_endpoint
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["applicationId", "applicationSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthConfigAzureAd, __self__).__init__(
            'rancher2:index/authConfigAzureAd:AuthConfigAzureAd',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_principal_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            application_secret: Optional[pulumi.Input[_builtins.str]] = None,
            auth_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            graph_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            group_membership_filter: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rancher_url: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            token_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthConfigAzureAd':
        """
        Get an existing AuthConfigAzureAd resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_mode: Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_principal_ids: Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `azuread_user://<USER_ID>`  `azuread_group://<GROUP_ID>` (list)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] application_id: AzureAD auth application ID (string)
        :param pulumi.Input[_builtins.str] application_secret: AzureAD auth application secret (string)
        :param pulumi.Input[_builtins.str] auth_endpoint: AzureAD auth endpoint (string)
        :param pulumi.Input[_builtins.bool] enabled: Enable auth config provider. Default `true` (bool)
        :param pulumi.Input[_builtins.str] endpoint: AzureAD endpoint. Default `https://login.microsoftonline.com/` (string)
        :param pulumi.Input[_builtins.str] graph_endpoint: AzureAD graph endpoint (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: (Computed) The name of the resource (string)
        :param pulumi.Input[_builtins.str] rancher_url: Rancher URL (string). "<rancher_url>/verify-auth-azure"
        :param pulumi.Input[_builtins.str] tenant_id: AzureAD tenant ID (string)
        :param pulumi.Input[_builtins.str] token_endpoint: AzureAD token endpoint (string)
        :param pulumi.Input[_builtins.str] type: (Computed) The type of the resource (string)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthConfigAzureAdState.__new__(_AuthConfigAzureAdState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["allowed_principal_ids"] = allowed_principal_ids
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["application_secret"] = application_secret
        __props__.__dict__["auth_endpoint"] = auth_endpoint
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["graph_endpoint"] = graph_endpoint
        __props__.__dict__["group_membership_filter"] = group_membership_filter
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["rancher_url"] = rancher_url
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["token_endpoint"] = token_endpoint
        __props__.__dict__["type"] = type
        return AuthConfigAzureAd(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access mode for auth. `required`, `restricted`, `unrestricted` are supported. Default `unrestricted` (string)
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="allowedPrincipalIds")
    def allowed_principal_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Allowed principal ids for auth. Required if `access_mode` is `required` or `restricted`. Ex: `azuread_user://<USER_ID>`  `azuread_group://<GROUP_ID>` (list)
        """
        return pulumi.get(self, "allowed_principal_ids")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        AzureAD auth application ID (string)
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationSecret")
    def application_secret(self) -> pulumi.Output[_builtins.str]:
        """
        AzureAD auth application secret (string)
        """
        return pulumi.get(self, "application_secret")

    @_builtins.property
    @pulumi.getter(name="authEndpoint")
    def auth_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        AzureAD auth endpoint (string)
        """
        return pulumi.get(self, "auth_endpoint")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable auth config provider. Default `true` (bool)
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AzureAD endpoint. Default `https://login.microsoftonline.com/` (string)
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="graphEndpoint")
    def graph_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        AzureAD graph endpoint (string)
        """
        return pulumi.get(self, "graph_endpoint")

    @_builtins.property
    @pulumi.getter(name="groupMembershipFilter")
    def group_membership_filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "group_membership_filter")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The name of the resource (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rancherUrl")
    def rancher_url(self) -> pulumi.Output[_builtins.str]:
        """
        Rancher URL (string). "<rancher_url>/verify-auth-azure"
        """
        return pulumi.get(self, "rancher_url")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        AzureAD tenant ID (string)
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        AzureAD token endpoint (string)
        """
        return pulumi.get(self, "token_endpoint")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The type of the resource (string)
        """
        return pulumi.get(self, "type")

