# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ClusterDriverArgs', 'ClusterDriver']

@pulumi.input_type
class ClusterDriverArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[_builtins.bool],
                 builtin: pulumi.Input[_builtins.bool],
                 url: pulumi.Input[_builtins.str],
                 actual_url: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ui_url: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ClusterDriver resource.
        :param pulumi.Input[_builtins.bool] active: Specify the cluster driver state (bool)
        :param pulumi.Input[_builtins.bool] builtin: Specify whether the cluster driver is an internal cluster driver or not (bool)
        :param pulumi.Input[_builtins.str] url: The URL to download the machine driver binary for 64-bit Linux (string)
        :param pulumi.Input[_builtins.str] actual_url: Actual url of the cluster driver (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.str] checksum: Verify that the downloaded driver matches the expected checksum (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: Name of the cluster driver (string)
        :param pulumi.Input[_builtins.str] ui_url: The URL to load for customized Add Clusters screen for this driver (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelist_domains: Domains to whitelist for the ui (list)
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "builtin", builtin)
        pulumi.set(__self__, "url", url)
        if actual_url is not None:
            pulumi.set(__self__, "actual_url", actual_url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ui_url is not None:
            pulumi.set(__self__, "ui_url", ui_url)
        if whitelist_domains is not None:
            pulumi.set(__self__, "whitelist_domains", whitelist_domains)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Input[_builtins.bool]:
        """
        Specify the cluster driver state (bool)
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter
    def builtin(self) -> pulumi.Input[_builtins.bool]:
        """
        Specify whether the cluster driver is an internal cluster driver or not (bool)
        """
        return pulumi.get(self, "builtin")

    @builtin.setter
    def builtin(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "builtin", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL to download the machine driver binary for 64-bit Linux (string)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="actualUrl")
    def actual_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Actual url of the cluster driver (string)
        """
        return pulumi.get(self, "actual_url")

    @actual_url.setter
    def actual_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "actual_url", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Verify that the downloaded driver matches the expected checksum (string)
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster driver (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="uiUrl")
    def ui_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to load for customized Add Clusters screen for this driver (string)
        """
        return pulumi.get(self, "ui_url")

    @ui_url.setter
    def ui_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ui_url", value)

    @_builtins.property
    @pulumi.getter(name="whitelistDomains")
    def whitelist_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domains to whitelist for the ui (list)
        """
        return pulumi.get(self, "whitelist_domains")

    @whitelist_domains.setter
    def whitelist_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelist_domains", value)


@pulumi.input_type
class _ClusterDriverState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 actual_url: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 builtin: Optional[pulumi.Input[_builtins.bool]] = None,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ui_url: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ClusterDriver resources.
        :param pulumi.Input[_builtins.bool] active: Specify the cluster driver state (bool)
        :param pulumi.Input[_builtins.str] actual_url: Actual url of the cluster driver (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.bool] builtin: Specify whether the cluster driver is an internal cluster driver or not (bool)
        :param pulumi.Input[_builtins.str] checksum: Verify that the downloaded driver matches the expected checksum (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: Name of the cluster driver (string)
        :param pulumi.Input[_builtins.str] ui_url: The URL to load for customized Add Clusters screen for this driver (string)
        :param pulumi.Input[_builtins.str] url: The URL to download the machine driver binary for 64-bit Linux (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelist_domains: Domains to whitelist for the ui (list)
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if actual_url is not None:
            pulumi.set(__self__, "actual_url", actual_url)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if builtin is not None:
            pulumi.set(__self__, "builtin", builtin)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ui_url is not None:
            pulumi.set(__self__, "ui_url", ui_url)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if whitelist_domains is not None:
            pulumi.set(__self__, "whitelist_domains", whitelist_domains)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify the cluster driver state (bool)
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="actualUrl")
    def actual_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Actual url of the cluster driver (string)
        """
        return pulumi.get(self, "actual_url")

    @actual_url.setter
    def actual_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "actual_url", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def builtin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether the cluster driver is an internal cluster driver or not (bool)
        """
        return pulumi.get(self, "builtin")

    @builtin.setter
    def builtin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "builtin", value)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Verify that the downloaded driver matches the expected checksum (string)
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cluster driver (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="uiUrl")
    def ui_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to load for customized Add Clusters screen for this driver (string)
        """
        return pulumi.get(self, "ui_url")

    @ui_url.setter
    def ui_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ui_url", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to download the machine driver binary for 64-bit Linux (string)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="whitelistDomains")
    def whitelist_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domains to whitelist for the ui (list)
        """
        return pulumi.get(self, "whitelist_domains")

    @whitelist_domains.setter
    def whitelist_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelist_domains", value)


@pulumi.type_token("rancher2:index/clusterDriver:ClusterDriver")
class ClusterDriver(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 actual_url: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 builtin: Optional[pulumi.Input[_builtins.bool]] = None,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ui_url: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Cluster Driver resource. This can be used to create Cluster Driver for Rancher v2.2.x Kontainer Engine clusters and retrieve their information.

        ## Example Usage

        ## Import

        Cluster Driver can be imported using the Rancher Cluster Driver ID

        ```sh
        $ pulumi import rancher2:index/clusterDriver:ClusterDriver foo &lt;CLUSTER_DRIVER_ID&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Specify the cluster driver state (bool)
        :param pulumi.Input[_builtins.str] actual_url: Actual url of the cluster driver (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.bool] builtin: Specify whether the cluster driver is an internal cluster driver or not (bool)
        :param pulumi.Input[_builtins.str] checksum: Verify that the downloaded driver matches the expected checksum (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: Name of the cluster driver (string)
        :param pulumi.Input[_builtins.str] ui_url: The URL to load for customized Add Clusters screen for this driver (string)
        :param pulumi.Input[_builtins.str] url: The URL to download the machine driver binary for 64-bit Linux (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelist_domains: Domains to whitelist for the ui (list)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterDriverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Cluster Driver resource. This can be used to create Cluster Driver for Rancher v2.2.x Kontainer Engine clusters and retrieve their information.

        ## Example Usage

        ## Import

        Cluster Driver can be imported using the Rancher Cluster Driver ID

        ```sh
        $ pulumi import rancher2:index/clusterDriver:ClusterDriver foo &lt;CLUSTER_DRIVER_ID&gt;
        ```

        :param str resource_name: The name of the resource.
        :param ClusterDriverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterDriverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 actual_url: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 builtin: Optional[pulumi.Input[_builtins.bool]] = None,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ui_url: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterDriverArgs.__new__(ClusterDriverArgs)

            if active is None and not opts.urn:
                raise TypeError("Missing required property 'active'")
            __props__.__dict__["active"] = active
            __props__.__dict__["actual_url"] = actual_url
            __props__.__dict__["annotations"] = annotations
            if builtin is None and not opts.urn:
                raise TypeError("Missing required property 'builtin'")
            __props__.__dict__["builtin"] = builtin
            __props__.__dict__["checksum"] = checksum
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["ui_url"] = ui_url
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["whitelist_domains"] = whitelist_domains
        super(ClusterDriver, __self__).__init__(
            'rancher2:index/clusterDriver:ClusterDriver',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            actual_url: Optional[pulumi.Input[_builtins.str]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            builtin: Optional[pulumi.Input[_builtins.bool]] = None,
            checksum: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ui_url: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            whitelist_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ClusterDriver':
        """
        Get an existing ClusterDriver resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Specify the cluster driver state (bool)
        :param pulumi.Input[_builtins.str] actual_url: Actual url of the cluster driver (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations of the resource (map)
        :param pulumi.Input[_builtins.bool] builtin: Specify whether the cluster driver is an internal cluster driver or not (bool)
        :param pulumi.Input[_builtins.str] checksum: Verify that the downloaded driver matches the expected checksum (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels of the resource (map)
        :param pulumi.Input[_builtins.str] name: Name of the cluster driver (string)
        :param pulumi.Input[_builtins.str] ui_url: The URL to load for customized Add Clusters screen for this driver (string)
        :param pulumi.Input[_builtins.str] url: The URL to download the machine driver binary for 64-bit Linux (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelist_domains: Domains to whitelist for the ui (list)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterDriverState.__new__(_ClusterDriverState)

        __props__.__dict__["active"] = active
        __props__.__dict__["actual_url"] = actual_url
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["builtin"] = builtin
        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["ui_url"] = ui_url
        __props__.__dict__["url"] = url
        __props__.__dict__["whitelist_domains"] = whitelist_domains
        return ClusterDriver(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[_builtins.bool]:
        """
        Specify the cluster driver state (bool)
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="actualUrl")
    def actual_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Actual url of the cluster driver (string)
        """
        return pulumi.get(self, "actual_url")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def builtin(self) -> pulumi.Output[_builtins.bool]:
        """
        Specify whether the cluster driver is an internal cluster driver or not (bool)
        """
        return pulumi.get(self, "builtin")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Verify that the downloaded driver matches the expected checksum (string)
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cluster driver (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="uiUrl")
    def ui_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL to load for customized Add Clusters screen for this driver (string)
        """
        return pulumi.get(self, "ui_url")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL to download the machine driver binary for 64-bit Linux (string)
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="whitelistDomains")
    def whitelist_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Domains to whitelist for the ui (list)
        """
        return pulumi.get(self, "whitelist_domains")

