# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterSyncArgs', 'ClusterSync']

@pulumi.input_type
class ClusterSyncArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 node_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state_confirm: Optional[pulumi.Input[_builtins.int]] = None,
                 synced: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_catalogs: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ClusterSync resource.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID that is syncing (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_pool_ids: The node pool IDs used by the cluster id (list)
        :param pulumi.Input[_builtins.int] state_confirm: Wait until active status is confirmed a number of times (wait interval of 5s). Default: `1` means no confirmation (int)
               
               **Note:** `state_confirm` would be useful, if you have troubles for creating/updating custom clusters that eventually are reaching `active` state before they are fully installed. For example: setting `state_confirm = 2` will assure that the cluster has been in `active` state for at least 5 seconds, `state_confirm = 3` assure at least 10 seconds, etc
        :param pulumi.Input[_builtins.bool] wait_catalogs: Wait until all catalogs are downloaded and active. Default: `false` (bool)
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if node_pool_ids is not None:
            pulumi.set(__self__, "node_pool_ids", node_pool_ids)
        if state_confirm is not None:
            pulumi.set(__self__, "state_confirm", state_confirm)
        if synced is not None:
            pulumi.set(__self__, "synced", synced)
        if wait_catalogs is not None:
            pulumi.set(__self__, "wait_catalogs", wait_catalogs)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster ID that is syncing (string)
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolIds")
    def node_pool_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The node pool IDs used by the cluster id (list)
        """
        return pulumi.get(self, "node_pool_ids")

    @node_pool_ids.setter
    def node_pool_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_pool_ids", value)

    @_builtins.property
    @pulumi.getter(name="stateConfirm")
    def state_confirm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Wait until active status is confirmed a number of times (wait interval of 5s). Default: `1` means no confirmation (int)

        **Note:** `state_confirm` would be useful, if you have troubles for creating/updating custom clusters that eventually are reaching `active` state before they are fully installed. For example: setting `state_confirm = 2` will assure that the cluster has been in `active` state for at least 5 seconds, `state_confirm = 3` assure at least 10 seconds, etc
        """
        return pulumi.get(self, "state_confirm")

    @state_confirm.setter
    def state_confirm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "state_confirm", value)

    @_builtins.property
    @pulumi.getter
    def synced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "synced")

    @synced.setter
    def synced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "synced", value)

    @_builtins.property
    @pulumi.getter(name="waitCatalogs")
    def wait_catalogs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wait until all catalogs are downloaded and active. Default: `false` (bool)
        """
        return pulumi.get(self, "wait_catalogs")

    @wait_catalogs.setter
    def wait_catalogs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_catalogs", value)


@pulumi.input_type
class _ClusterSyncState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSyncNodeArgs']]]] = None,
                 state_confirm: Optional[pulumi.Input[_builtins.int]] = None,
                 synced: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_catalogs: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ClusterSync resources.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID that is syncing (string)
        :param pulumi.Input[_builtins.str] default_project_id: (Computed) Default project ID for the cluster sync (string)
        :param pulumi.Input[_builtins.str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster sync (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_pool_ids: The node pool IDs used by the cluster id (list)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterSyncNodeArgs']]] nodes: (Computed) The cluster nodes (list).
        :param pulumi.Input[_builtins.int] state_confirm: Wait until active status is confirmed a number of times (wait interval of 5s). Default: `1` means no confirmation (int)
               
               **Note:** `state_confirm` would be useful, if you have troubles for creating/updating custom clusters that eventually are reaching `active` state before they are fully installed. For example: setting `state_confirm = 2` will assure that the cluster has been in `active` state for at least 5 seconds, `state_confirm = 3` assure at least 10 seconds, etc
        :param pulumi.Input[_builtins.str] system_project_id: (Computed) System project ID for the cluster sync (string)
        :param pulumi.Input[_builtins.bool] wait_catalogs: Wait until all catalogs are downloaded and active. Default: `false` (bool)
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if default_project_id is not None:
            pulumi.set(__self__, "default_project_id", default_project_id)
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if node_pool_ids is not None:
            pulumi.set(__self__, "node_pool_ids", node_pool_ids)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if state_confirm is not None:
            pulumi.set(__self__, "state_confirm", state_confirm)
        if synced is not None:
            pulumi.set(__self__, "synced", synced)
        if system_project_id is not None:
            pulumi.set(__self__, "system_project_id", system_project_id)
        if wait_catalogs is not None:
            pulumi.set(__self__, "wait_catalogs", wait_catalogs)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster ID that is syncing (string)
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultProjectId")
    def default_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) Default project ID for the cluster sync (string)
        """
        return pulumi.get(self, "default_project_id")

    @default_project_id.setter
    def default_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_project_id", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster sync (string)
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolIds")
    def node_pool_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The node pool IDs used by the cluster id (list)
        """
        return pulumi.get(self, "node_pool_ids")

    @node_pool_ids.setter
    def node_pool_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_pool_ids", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSyncNodeArgs']]]]:
        """
        (Computed) The cluster nodes (list).
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSyncNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="stateConfirm")
    def state_confirm(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Wait until active status is confirmed a number of times (wait interval of 5s). Default: `1` means no confirmation (int)

        **Note:** `state_confirm` would be useful, if you have troubles for creating/updating custom clusters that eventually are reaching `active` state before they are fully installed. For example: setting `state_confirm = 2` will assure that the cluster has been in `active` state for at least 5 seconds, `state_confirm = 3` assure at least 10 seconds, etc
        """
        return pulumi.get(self, "state_confirm")

    @state_confirm.setter
    def state_confirm(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "state_confirm", value)

    @_builtins.property
    @pulumi.getter
    def synced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "synced")

    @synced.setter
    def synced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "synced", value)

    @_builtins.property
    @pulumi.getter(name="systemProjectId")
    def system_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) System project ID for the cluster sync (string)
        """
        return pulumi.get(self, "system_project_id")

    @system_project_id.setter
    def system_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_project_id", value)

    @_builtins.property
    @pulumi.getter(name="waitCatalogs")
    def wait_catalogs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wait until all catalogs are downloaded and active. Default: `false` (bool)
        """
        return pulumi.get(self, "wait_catalogs")

    @wait_catalogs.setter
    def wait_catalogs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_catalogs", value)


@pulumi.type_token("rancher2:index/clusterSync:ClusterSync")
class ClusterSync(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state_confirm: Optional[pulumi.Input[_builtins.int]] = None,
                 synced: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_catalogs: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 rke Cluster 
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        # Create a new rancher2 Node Template
        foo = rancher2.NodeTemplate("foo",
            name="foo",
            description="foo test",
            amazonec2_config={
                "access_key": "<AWS_ACCESS_KEY>",
                "secret_key": "<AWS_SECRET_KEY>",
                "ami": "<AMI_ID>",
                "region": "<REGION>",
                "security_groups": ["<AWS_SECURITY_GROUP>"],
                "subnet_id": "<SUBNET_ID>",
                "vpc_id": "<VPC_ID>",
                "zone": "<ZONE>",
            })
        # Create a new rancher2 Node Pool
        foo_node_pool = rancher2.NodePool("foo",
            cluster_id=foo_custom.id,
            name="foo",
            hostname_prefix="foo-cluster-0",
            node_template_id=foo.id,
            quantity=3,
            control_plane=True,
            etcd=True,
            worker=True)
        # Create a new rancher2 Cluster Sync
        foo_custom_cluster_sync = rancher2.ClusterSync("foo-custom",
            cluster_id=foo_custom.id,
            node_pool_ids=[foo_node_pool.id])
        # Create a new rancher2 Project
        foo_project = rancher2.Project("foo",
            name="foo",
            cluster_id=foo_custom_cluster_sync.id,
            description="Terraform namespace acceptance test",
            resource_quota={
                "project_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "2000Mi",
                    "requests_storage": "2Gi",
                },
                "namespace_default_limit": {
                    "limits_cpu": "500m",
                    "limits_memory": "500Mi",
                    "requests_storage": "1Gi",
                },
            },
            container_resource_limit={
                "limits_cpu": "20m",
                "limits_memory": "20Mi",
                "requests_cpu": "1m",
                "requests_memory": "1Mi",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID that is syncing (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_pool_ids: The node pool IDs used by the cluster id (list)
        :param pulumi.Input[_builtins.int] state_confirm: Wait until active status is confirmed a number of times (wait interval of 5s). Default: `1` means no confirmation (int)
               
               **Note:** `state_confirm` would be useful, if you have troubles for creating/updating custom clusters that eventually are reaching `active` state before they are fully installed. For example: setting `state_confirm = 2` will assure that the cluster has been in `active` state for at least 5 seconds, `state_confirm = 3` assure at least 10 seconds, etc
        :param pulumi.Input[_builtins.bool] wait_catalogs: Wait until all catalogs are downloaded and active. Default: `false` (bool)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterSyncArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 rke Cluster 
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        # Create a new rancher2 Node Template
        foo = rancher2.NodeTemplate("foo",
            name="foo",
            description="foo test",
            amazonec2_config={
                "access_key": "<AWS_ACCESS_KEY>",
                "secret_key": "<AWS_SECRET_KEY>",
                "ami": "<AMI_ID>",
                "region": "<REGION>",
                "security_groups": ["<AWS_SECURITY_GROUP>"],
                "subnet_id": "<SUBNET_ID>",
                "vpc_id": "<VPC_ID>",
                "zone": "<ZONE>",
            })
        # Create a new rancher2 Node Pool
        foo_node_pool = rancher2.NodePool("foo",
            cluster_id=foo_custom.id,
            name="foo",
            hostname_prefix="foo-cluster-0",
            node_template_id=foo.id,
            quantity=3,
            control_plane=True,
            etcd=True,
            worker=True)
        # Create a new rancher2 Cluster Sync
        foo_custom_cluster_sync = rancher2.ClusterSync("foo-custom",
            cluster_id=foo_custom.id,
            node_pool_ids=[foo_node_pool.id])
        # Create a new rancher2 Project
        foo_project = rancher2.Project("foo",
            name="foo",
            cluster_id=foo_custom_cluster_sync.id,
            description="Terraform namespace acceptance test",
            resource_quota={
                "project_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "2000Mi",
                    "requests_storage": "2Gi",
                },
                "namespace_default_limit": {
                    "limits_cpu": "500m",
                    "limits_memory": "500Mi",
                    "requests_storage": "1Gi",
                },
            },
            container_resource_limit={
                "limits_cpu": "20m",
                "limits_memory": "20Mi",
                "requests_cpu": "1m",
                "requests_memory": "1Mi",
            })
        ```

        :param str resource_name: The name of the resource.
        :param ClusterSyncArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterSyncArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state_confirm: Optional[pulumi.Input[_builtins.int]] = None,
                 synced: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_catalogs: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterSyncArgs.__new__(ClusterSyncArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["node_pool_ids"] = node_pool_ids
            __props__.__dict__["state_confirm"] = state_confirm
            __props__.__dict__["synced"] = synced
            __props__.__dict__["wait_catalogs"] = wait_catalogs
            __props__.__dict__["default_project_id"] = None
            __props__.__dict__["kube_config"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["system_project_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeConfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ClusterSync, __self__).__init__(
            'rancher2:index/clusterSync:ClusterSync',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            kube_config: Optional[pulumi.Input[_builtins.str]] = None,
            node_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterSyncNodeArgs', 'ClusterSyncNodeArgsDict']]]]] = None,
            state_confirm: Optional[pulumi.Input[_builtins.int]] = None,
            synced: Optional[pulumi.Input[_builtins.bool]] = None,
            system_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            wait_catalogs: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ClusterSync':
        """
        Get an existing ClusterSync resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster ID that is syncing (string)
        :param pulumi.Input[_builtins.str] default_project_id: (Computed) Default project ID for the cluster sync (string)
        :param pulumi.Input[_builtins.str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster sync (string)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_pool_ids: The node pool IDs used by the cluster id (list)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterSyncNodeArgs', 'ClusterSyncNodeArgsDict']]]] nodes: (Computed) The cluster nodes (list).
        :param pulumi.Input[_builtins.int] state_confirm: Wait until active status is confirmed a number of times (wait interval of 5s). Default: `1` means no confirmation (int)
               
               **Note:** `state_confirm` would be useful, if you have troubles for creating/updating custom clusters that eventually are reaching `active` state before they are fully installed. For example: setting `state_confirm = 2` will assure that the cluster has been in `active` state for at least 5 seconds, `state_confirm = 3` assure at least 10 seconds, etc
        :param pulumi.Input[_builtins.str] system_project_id: (Computed) System project ID for the cluster sync (string)
        :param pulumi.Input[_builtins.bool] wait_catalogs: Wait until all catalogs are downloaded and active. Default: `false` (bool)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterSyncState.__new__(_ClusterSyncState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["default_project_id"] = default_project_id
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["node_pool_ids"] = node_pool_ids
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["state_confirm"] = state_confirm
        __props__.__dict__["synced"] = synced
        __props__.__dict__["system_project_id"] = system_project_id
        __props__.__dict__["wait_catalogs"] = wait_catalogs
        return ClusterSync(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster ID that is syncing (string)
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="defaultProjectId")
    def default_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) Default project ID for the cluster sync (string)
        """
        return pulumi.get(self, "default_project_id")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster sync (string)
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter(name="nodePoolIds")
    def node_pool_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The node pool IDs used by the cluster id (list)
        """
        return pulumi.get(self, "node_pool_ids")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.ClusterSyncNode']]:
        """
        (Computed) The cluster nodes (list).
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="stateConfirm")
    def state_confirm(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Wait until active status is confirmed a number of times (wait interval of 5s). Default: `1` means no confirmation (int)

        **Note:** `state_confirm` would be useful, if you have troubles for creating/updating custom clusters that eventually are reaching `active` state before they are fully installed. For example: setting `state_confirm = 2` will assure that the cluster has been in `active` state for at least 5 seconds, `state_confirm = 3` assure at least 10 seconds, etc
        """
        return pulumi.get(self, "state_confirm")

    @_builtins.property
    @pulumi.getter
    def synced(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "synced")

    @_builtins.property
    @pulumi.getter(name="systemProjectId")
    def system_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) System project ID for the cluster sync (string)
        """
        return pulumi.get(self, "system_project_id")

    @_builtins.property
    @pulumi.getter(name="waitCatalogs")
    def wait_catalogs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Wait until all catalogs are downloaded and active. Default: `false` (bool)
        """
        return pulumi.get(self, "wait_catalogs")

