# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterV2Args', 'ClusterV2']

@pulumi.input_type
class ClusterV2Args:
    def __init__(__self__, *,
                 kubernetes_version: pulumi.Input[_builtins.str],
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]]] = None,
                 fleet_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rke_config: Optional[pulumi.Input['ClusterV2RkeConfigArgs']] = None):
        """
        The set of arguments for constructing a ClusterV2 resource.
        :param pulumi.Input[_builtins.str] kubernetes_version: The RKE2 or K3s version for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]] agent_env_vars: Agent env vars is a list of additional environment variables to be appended to the `cattle-cluster-agent` and `fleet-agent` deployment, and the plan for the [system upgrade controller](https://github.com/rancher/system-upgrade-controller) to upgrade nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster.
        :param pulumi.Input[_builtins.str] cloud_credential_secret_name: Cloud credential secret name is the secret to be used when a cloud credential secret name is not specified at the machine pool level.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]] cluster_agent_deployment_customizations: Cluster agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `cattle-cluster-agent` deployment. This argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input[_builtins.str] default_cluster_role_for_project_members: Default cluster role for project members.
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above.
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable k8s network policy on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]] fleet_agent_deployment_customizations: Fleet agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `fleet-agent` deployment. The argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input[_builtins.str] fleet_namespace: Fleet namespace is the namespace where the cluster is to create in the local cluster. It is recommended to leave it as the default value.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster.
        :param pulumi.Input['ClusterV2LocalAuthEndpointArgs'] local_auth_endpoint: Local auth endpoint configures the Authorized Cluster Endpoint (ACE) which can be used to directly access the Kubernetes API server, without requiring communication through Rancher. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/kubernetes-clusters-in-rancher-setup/register-existing-clusters#authorized-cluster-endpoint-support-for-rke2-and-k3s-clusters).
        :param pulumi.Input[_builtins.str] name: The name of the cluster.
        :param pulumi.Input['ClusterV2RkeConfigArgs'] rke_config: The RKE configuration for the cluster.
        """
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if agent_env_vars is not None:
            pulumi.set(__self__, "agent_env_vars", agent_env_vars)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cloud_credential_secret_name is not None:
            pulumi.set(__self__, "cloud_credential_secret_name", cloud_credential_secret_name)
        if cluster_agent_deployment_customizations is not None:
            pulumi.set(__self__, "cluster_agent_deployment_customizations", cluster_agent_deployment_customizations)
        if default_cluster_role_for_project_members is not None:
            pulumi.set(__self__, "default_cluster_role_for_project_members", default_cluster_role_for_project_members)
        if default_pod_security_admission_configuration_template_name is not None:
            pulumi.set(__self__, "default_pod_security_admission_configuration_template_name", default_pod_security_admission_configuration_template_name)
        if enable_network_policy is not None:
            pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if fleet_agent_deployment_customizations is not None:
            pulumi.set(__self__, "fleet_agent_deployment_customizations", fleet_agent_deployment_customizations)
        if fleet_namespace is not None:
            pulumi.set(__self__, "fleet_namespace", fleet_namespace)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_auth_endpoint is not None:
            pulumi.set(__self__, "local_auth_endpoint", local_auth_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rke_config is not None:
            pulumi.set(__self__, "rke_config", rke_config)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Input[_builtins.str]:
        """
        The RKE2 or K3s version for the cluster.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kubernetes_version", value)

    @_builtins.property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]:
        """
        Agent env vars is a list of additional environment variables to be appended to the `cattle-cluster-agent` and `fleet-agent` deployment, and the plan for the [system upgrade controller](https://github.com/rancher/system-upgrade-controller) to upgrade nodes.
        """
        return pulumi.get(self, "agent_env_vars")

    @agent_env_vars.setter
    def agent_env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]):
        pulumi.set(self, "agent_env_vars", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the Cluster.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="cloudCredentialSecretName")
    def cloud_credential_secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud credential secret name is the secret to be used when a cloud credential secret name is not specified at the machine pool level.
        """
        return pulumi.get(self, "cloud_credential_secret_name")

    @cloud_credential_secret_name.setter
    def cloud_credential_secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_credential_secret_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterAgentDeploymentCustomizations")
    def cluster_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]]]:
        """
        Cluster agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `cattle-cluster-agent` deployment. This argument is available in Rancher v2.7.5 and above.
        """
        return pulumi.get(self, "cluster_agent_deployment_customizations")

    @cluster_agent_deployment_customizations.setter
    def cluster_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "cluster_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="defaultClusterRoleForProjectMembers")
    def default_cluster_role_for_project_members(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default cluster role for project members.
        """
        return pulumi.get(self, "default_cluster_role_for_project_members")

    @default_cluster_role_for_project_members.setter
    def default_cluster_role_for_project_members(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_cluster_role_for_project_members", value)

    @_builtins.property
    @pulumi.getter(name="defaultPodSecurityAdmissionConfigurationTemplateName")
    def default_pod_security_admission_configuration_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above.
        """
        return pulumi.get(self, "default_pod_security_admission_configuration_template_name")

    @default_pod_security_admission_configuration_template_name.setter
    def default_pod_security_admission_configuration_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pod_security_admission_configuration_template_name", value)

    @_builtins.property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable k8s network policy on the cluster.
        """
        return pulumi.get(self, "enable_network_policy")

    @enable_network_policy.setter
    def enable_network_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_network_policy", value)

    @_builtins.property
    @pulumi.getter(name="fleetAgentDeploymentCustomizations")
    def fleet_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]]]:
        """
        Fleet agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `fleet-agent` deployment. The argument is available in Rancher v2.7.5 and above.
        """
        return pulumi.get(self, "fleet_agent_deployment_customizations")

    @fleet_agent_deployment_customizations.setter
    def fleet_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "fleet_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="fleetNamespace")
    def fleet_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet namespace is the namespace where the cluster is to create in the local cluster. It is recommended to leave it as the default value.
        """
        return pulumi.get(self, "fleet_namespace")

    @fleet_namespace.setter
    def fleet_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_namespace", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the Cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEndpoint")
    def local_auth_endpoint(self) -> Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]:
        """
        Local auth endpoint configures the Authorized Cluster Endpoint (ACE) which can be used to directly access the Kubernetes API server, without requiring communication through Rancher. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/kubernetes-clusters-in-rancher-setup/register-existing-clusters#authorized-cluster-endpoint-support-for-rke2-and-k3s-clusters).
        """
        return pulumi.get(self, "local_auth_endpoint")

    @local_auth_endpoint.setter
    def local_auth_endpoint(self, value: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]):
        pulumi.set(self, "local_auth_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> Optional[pulumi.Input['ClusterV2RkeConfigArgs']]:
        """
        The RKE configuration for the cluster.
        """
        return pulumi.get(self, "rke_config")

    @rke_config.setter
    def rke_config(self, value: Optional[pulumi.Input['ClusterV2RkeConfigArgs']]):
        pulumi.set(self, "rke_config", value)


@pulumi.input_type
class _ClusterV2State:
    def __init__(__self__, *,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]]] = None,
                 cluster_registration_token: Optional[pulumi.Input['ClusterV2ClusterRegistrationTokenArgs']] = None,
                 cluster_v1_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]]] = None,
                 fleet_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_version: Optional[pulumi.Input[_builtins.str]] = None,
                 rke_config: Optional[pulumi.Input['ClusterV2RkeConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ClusterV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]] agent_env_vars: Agent env vars is a list of additional environment variables to be appended to the `cattle-cluster-agent` and `fleet-agent` deployment, and the plan for the [system upgrade controller](https://github.com/rancher/system-upgrade-controller) to upgrade nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster.
        :param pulumi.Input[_builtins.str] cloud_credential_secret_name: Cloud credential secret name is the secret to be used when a cloud credential secret name is not specified at the machine pool level.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]] cluster_agent_deployment_customizations: Cluster agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `cattle-cluster-agent` deployment. This argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input['ClusterV2ClusterRegistrationTokenArgs'] cluster_registration_token: (Computed, sensitive, list, max length: 1) Cluster Registration Token generated for the cluster.
        :param pulumi.Input[_builtins.str] cluster_v1_id: (Computed, string) Cluster v1 id for cluster v2. (e.g. to be used with `rancher2_sync`).
        :param pulumi.Input[_builtins.str] default_cluster_role_for_project_members: Default cluster role for project members.
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above.
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable k8s network policy on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]] fleet_agent_deployment_customizations: Fleet agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `fleet-agent` deployment. The argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input[_builtins.str] fleet_namespace: Fleet namespace is the namespace where the cluster is to create in the local cluster. It is recommended to leave it as the default value.
        :param pulumi.Input[_builtins.str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected`.
        :param pulumi.Input[_builtins.str] kubernetes_version: The RKE2 or K3s version for the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster.
        :param pulumi.Input['ClusterV2LocalAuthEndpointArgs'] local_auth_endpoint: Local auth endpoint configures the Authorized Cluster Endpoint (ACE) which can be used to directly access the Kubernetes API server, without requiring communication through Rancher. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/kubernetes-clusters-in-rancher-setup/register-existing-clusters#authorized-cluster-endpoint-support-for-rke2-and-k3s-clusters).
        :param pulumi.Input[_builtins.str] name: The name of the cluster.
        :param pulumi.Input[_builtins.str] resource_version: (Computed, string) Cluster's k8s resource version.
        :param pulumi.Input['ClusterV2RkeConfigArgs'] rke_config: The RKE configuration for the cluster.
        """
        if agent_env_vars is not None:
            pulumi.set(__self__, "agent_env_vars", agent_env_vars)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cloud_credential_secret_name is not None:
            pulumi.set(__self__, "cloud_credential_secret_name", cloud_credential_secret_name)
        if cluster_agent_deployment_customizations is not None:
            pulumi.set(__self__, "cluster_agent_deployment_customizations", cluster_agent_deployment_customizations)
        if cluster_registration_token is not None:
            pulumi.set(__self__, "cluster_registration_token", cluster_registration_token)
        if cluster_v1_id is not None:
            pulumi.set(__self__, "cluster_v1_id", cluster_v1_id)
        if default_cluster_role_for_project_members is not None:
            pulumi.set(__self__, "default_cluster_role_for_project_members", default_cluster_role_for_project_members)
        if default_pod_security_admission_configuration_template_name is not None:
            pulumi.set(__self__, "default_pod_security_admission_configuration_template_name", default_pod_security_admission_configuration_template_name)
        if enable_network_policy is not None:
            pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if fleet_agent_deployment_customizations is not None:
            pulumi.set(__self__, "fleet_agent_deployment_customizations", fleet_agent_deployment_customizations)
        if fleet_namespace is not None:
            pulumi.set(__self__, "fleet_namespace", fleet_namespace)
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_auth_endpoint is not None:
            pulumi.set(__self__, "local_auth_endpoint", local_auth_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if rke_config is not None:
            pulumi.set(__self__, "rke_config", rke_config)

    @_builtins.property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]:
        """
        Agent env vars is a list of additional environment variables to be appended to the `cattle-cluster-agent` and `fleet-agent` deployment, and the plan for the [system upgrade controller](https://github.com/rancher/system-upgrade-controller) to upgrade nodes.
        """
        return pulumi.get(self, "agent_env_vars")

    @agent_env_vars.setter
    def agent_env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2AgentEnvVarArgs']]]]):
        pulumi.set(self, "agent_env_vars", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the Cluster.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="cloudCredentialSecretName")
    def cloud_credential_secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud credential secret name is the secret to be used when a cloud credential secret name is not specified at the machine pool level.
        """
        return pulumi.get(self, "cloud_credential_secret_name")

    @cloud_credential_secret_name.setter
    def cloud_credential_secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_credential_secret_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterAgentDeploymentCustomizations")
    def cluster_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]]]:
        """
        Cluster agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `cattle-cluster-agent` deployment. This argument is available in Rancher v2.7.5 and above.
        """
        return pulumi.get(self, "cluster_agent_deployment_customizations")

    @cluster_agent_deployment_customizations.setter
    def cluster_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2ClusterAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "cluster_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="clusterRegistrationToken")
    def cluster_registration_token(self) -> Optional[pulumi.Input['ClusterV2ClusterRegistrationTokenArgs']]:
        """
        (Computed, sensitive, list, max length: 1) Cluster Registration Token generated for the cluster.
        """
        return pulumi.get(self, "cluster_registration_token")

    @cluster_registration_token.setter
    def cluster_registration_token(self, value: Optional[pulumi.Input['ClusterV2ClusterRegistrationTokenArgs']]):
        pulumi.set(self, "cluster_registration_token", value)

    @_builtins.property
    @pulumi.getter(name="clusterV1Id")
    def cluster_v1_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed, string) Cluster v1 id for cluster v2. (e.g. to be used with `rancher2_sync`).
        """
        return pulumi.get(self, "cluster_v1_id")

    @cluster_v1_id.setter
    def cluster_v1_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_v1_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultClusterRoleForProjectMembers")
    def default_cluster_role_for_project_members(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default cluster role for project members.
        """
        return pulumi.get(self, "default_cluster_role_for_project_members")

    @default_cluster_role_for_project_members.setter
    def default_cluster_role_for_project_members(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_cluster_role_for_project_members", value)

    @_builtins.property
    @pulumi.getter(name="defaultPodSecurityAdmissionConfigurationTemplateName")
    def default_pod_security_admission_configuration_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above.
        """
        return pulumi.get(self, "default_pod_security_admission_configuration_template_name")

    @default_pod_security_admission_configuration_template_name.setter
    def default_pod_security_admission_configuration_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pod_security_admission_configuration_template_name", value)

    @_builtins.property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable k8s network policy on the cluster.
        """
        return pulumi.get(self, "enable_network_policy")

    @enable_network_policy.setter
    def enable_network_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_network_policy", value)

    @_builtins.property
    @pulumi.getter(name="fleetAgentDeploymentCustomizations")
    def fleet_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]]]:
        """
        Fleet agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `fleet-agent` deployment. The argument is available in Rancher v2.7.5 and above.
        """
        return pulumi.get(self, "fleet_agent_deployment_customizations")

    @fleet_agent_deployment_customizations.setter
    def fleet_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterV2FleetAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "fleet_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="fleetNamespace")
    def fleet_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet namespace is the namespace where the cluster is to create in the local cluster. It is recommended to leave it as the default value.
        """
        return pulumi.get(self, "fleet_namespace")

    @fleet_namespace.setter
    def fleet_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_namespace", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected`.
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RKE2 or K3s version for the cluster.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the Cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEndpoint")
    def local_auth_endpoint(self) -> Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]:
        """
        Local auth endpoint configures the Authorized Cluster Endpoint (ACE) which can be used to directly access the Kubernetes API server, without requiring communication through Rancher. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/kubernetes-clusters-in-rancher-setup/register-existing-clusters#authorized-cluster-endpoint-support-for-rke2-and-k3s-clusters).
        """
        return pulumi.get(self, "local_auth_endpoint")

    @local_auth_endpoint.setter
    def local_auth_endpoint(self, value: Optional[pulumi.Input['ClusterV2LocalAuthEndpointArgs']]):
        pulumi.set(self, "local_auth_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed, string) Cluster's k8s resource version.
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_version", value)

    @_builtins.property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> Optional[pulumi.Input['ClusterV2RkeConfigArgs']]:
        """
        The RKE configuration for the cluster.
        """
        return pulumi.get(self, "rke_config")

    @rke_config.setter
    def rke_config(self, value: Optional[pulumi.Input['ClusterV2RkeConfigArgs']]):
        pulumi.set(self, "rke_config", value)


@pulumi.type_token("rancher2:index/clusterV2:ClusterV2")
class ClusterV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2AgentEnvVarArgs', 'ClusterV2AgentEnvVarArgsDict']]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ClusterAgentDeploymentCustomizationArgs', 'ClusterV2ClusterAgentDeploymentCustomizationArgsDict']]]]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2FleetAgentDeploymentCustomizationArgs', 'ClusterV2FleetAgentDeploymentCustomizationArgsDict']]]]] = None,
                 fleet_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input[Union['ClusterV2LocalAuthEndpointArgs', 'ClusterV2LocalAuthEndpointArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rke_config: Optional[pulumi.Input[Union['ClusterV2RkeConfigArgs', 'ClusterV2RkeConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Import

        Clusters v2 can be imported using the Rancher Cluster v2 ID, that is in the form &lt;FLEET_NAMESPACE&gt;/&lt;CLUSTER_NAME&gt;

        ```sh
        $ pulumi import rancher2:index/clusterV2:ClusterV2 foo <FLEET_NAMESPACE>/<CLUSTER_NAME>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2AgentEnvVarArgs', 'ClusterV2AgentEnvVarArgsDict']]]] agent_env_vars: Agent env vars is a list of additional environment variables to be appended to the `cattle-cluster-agent` and `fleet-agent` deployment, and the plan for the [system upgrade controller](https://github.com/rancher/system-upgrade-controller) to upgrade nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster.
        :param pulumi.Input[_builtins.str] cloud_credential_secret_name: Cloud credential secret name is the secret to be used when a cloud credential secret name is not specified at the machine pool level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ClusterAgentDeploymentCustomizationArgs', 'ClusterV2ClusterAgentDeploymentCustomizationArgsDict']]]] cluster_agent_deployment_customizations: Cluster agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `cattle-cluster-agent` deployment. This argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input[_builtins.str] default_cluster_role_for_project_members: Default cluster role for project members.
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above.
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable k8s network policy on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2FleetAgentDeploymentCustomizationArgs', 'ClusterV2FleetAgentDeploymentCustomizationArgsDict']]]] fleet_agent_deployment_customizations: Fleet agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `fleet-agent` deployment. The argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input[_builtins.str] fleet_namespace: Fleet namespace is the namespace where the cluster is to create in the local cluster. It is recommended to leave it as the default value.
        :param pulumi.Input[_builtins.str] kubernetes_version: The RKE2 or K3s version for the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster.
        :param pulumi.Input[Union['ClusterV2LocalAuthEndpointArgs', 'ClusterV2LocalAuthEndpointArgsDict']] local_auth_endpoint: Local auth endpoint configures the Authorized Cluster Endpoint (ACE) which can be used to directly access the Kubernetes API server, without requiring communication through Rancher. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/kubernetes-clusters-in-rancher-setup/register-existing-clusters#authorized-cluster-endpoint-support-for-rke2-and-k3s-clusters).
        :param pulumi.Input[_builtins.str] name: The name of the cluster.
        :param pulumi.Input[Union['ClusterV2RkeConfigArgs', 'ClusterV2RkeConfigArgsDict']] rke_config: The RKE configuration for the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Clusters v2 can be imported using the Rancher Cluster v2 ID, that is in the form &lt;FLEET_NAMESPACE&gt;/&lt;CLUSTER_NAME&gt;

        ```sh
        $ pulumi import rancher2:index/clusterV2:ClusterV2 foo <FLEET_NAMESPACE>/<CLUSTER_NAME>
        ```

        :param str resource_name: The name of the resource.
        :param ClusterV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2AgentEnvVarArgs', 'ClusterV2AgentEnvVarArgsDict']]]]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cloud_credential_secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ClusterAgentDeploymentCustomizationArgs', 'ClusterV2ClusterAgentDeploymentCustomizationArgsDict']]]]] = None,
                 default_cluster_role_for_project_members: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2FleetAgentDeploymentCustomizationArgs', 'ClusterV2FleetAgentDeploymentCustomizationArgsDict']]]]] = None,
                 fleet_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_auth_endpoint: Optional[pulumi.Input[Union['ClusterV2LocalAuthEndpointArgs', 'ClusterV2LocalAuthEndpointArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rke_config: Optional[pulumi.Input[Union['ClusterV2RkeConfigArgs', 'ClusterV2RkeConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterV2Args.__new__(ClusterV2Args)

            __props__.__dict__["agent_env_vars"] = agent_env_vars
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["cloud_credential_secret_name"] = cloud_credential_secret_name
            __props__.__dict__["cluster_agent_deployment_customizations"] = cluster_agent_deployment_customizations
            __props__.__dict__["default_cluster_role_for_project_members"] = default_cluster_role_for_project_members
            __props__.__dict__["default_pod_security_admission_configuration_template_name"] = default_pod_security_admission_configuration_template_name
            __props__.__dict__["enable_network_policy"] = enable_network_policy
            __props__.__dict__["fleet_agent_deployment_customizations"] = fleet_agent_deployment_customizations
            __props__.__dict__["fleet_namespace"] = fleet_namespace
            if kubernetes_version is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_version'")
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["local_auth_endpoint"] = local_auth_endpoint
            __props__.__dict__["name"] = name
            __props__.__dict__["rke_config"] = rke_config
            __props__.__dict__["cluster_registration_token"] = None
            __props__.__dict__["cluster_v1_id"] = None
            __props__.__dict__["kube_config"] = None
            __props__.__dict__["resource_version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterRegistrationToken", "kubeConfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ClusterV2, __self__).__init__(
            'rancher2:index/clusterV2:ClusterV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2AgentEnvVarArgs', 'ClusterV2AgentEnvVarArgsDict']]]]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            cloud_credential_secret_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ClusterAgentDeploymentCustomizationArgs', 'ClusterV2ClusterAgentDeploymentCustomizationArgsDict']]]]] = None,
            cluster_registration_token: Optional[pulumi.Input[Union['ClusterV2ClusterRegistrationTokenArgs', 'ClusterV2ClusterRegistrationTokenArgsDict']]] = None,
            cluster_v1_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_cluster_role_for_project_members: Optional[pulumi.Input[_builtins.str]] = None,
            default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2FleetAgentDeploymentCustomizationArgs', 'ClusterV2FleetAgentDeploymentCustomizationArgsDict']]]]] = None,
            fleet_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            kube_config: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            local_auth_endpoint: Optional[pulumi.Input[Union['ClusterV2LocalAuthEndpointArgs', 'ClusterV2LocalAuthEndpointArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_version: Optional[pulumi.Input[_builtins.str]] = None,
            rke_config: Optional[pulumi.Input[Union['ClusterV2RkeConfigArgs', 'ClusterV2RkeConfigArgsDict']]] = None) -> 'ClusterV2':
        """
        Get an existing ClusterV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2AgentEnvVarArgs', 'ClusterV2AgentEnvVarArgsDict']]]] agent_env_vars: Agent env vars is a list of additional environment variables to be appended to the `cattle-cluster-agent` and `fleet-agent` deployment, and the plan for the [system upgrade controller](https://github.com/rancher/system-upgrade-controller) to upgrade nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster.
        :param pulumi.Input[_builtins.str] cloud_credential_secret_name: Cloud credential secret name is the secret to be used when a cloud credential secret name is not specified at the machine pool level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2ClusterAgentDeploymentCustomizationArgs', 'ClusterV2ClusterAgentDeploymentCustomizationArgsDict']]]] cluster_agent_deployment_customizations: Cluster agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `cattle-cluster-agent` deployment. This argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input[Union['ClusterV2ClusterRegistrationTokenArgs', 'ClusterV2ClusterRegistrationTokenArgsDict']] cluster_registration_token: (Computed, sensitive, list, max length: 1) Cluster Registration Token generated for the cluster.
        :param pulumi.Input[_builtins.str] cluster_v1_id: (Computed, string) Cluster v1 id for cluster v2. (e.g. to be used with `rancher2_sync`).
        :param pulumi.Input[_builtins.str] default_cluster_role_for_project_members: Default cluster role for project members.
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above.
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable k8s network policy on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterV2FleetAgentDeploymentCustomizationArgs', 'ClusterV2FleetAgentDeploymentCustomizationArgsDict']]]] fleet_agent_deployment_customizations: Fleet agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `fleet-agent` deployment. The argument is available in Rancher v2.7.5 and above.
        :param pulumi.Input[_builtins.str] fleet_namespace: Fleet namespace is the namespace where the cluster is to create in the local cluster. It is recommended to leave it as the default value.
        :param pulumi.Input[_builtins.str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected`.
        :param pulumi.Input[_builtins.str] kubernetes_version: The RKE2 or K3s version for the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster.
        :param pulumi.Input[Union['ClusterV2LocalAuthEndpointArgs', 'ClusterV2LocalAuthEndpointArgsDict']] local_auth_endpoint: Local auth endpoint configures the Authorized Cluster Endpoint (ACE) which can be used to directly access the Kubernetes API server, without requiring communication through Rancher. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/kubernetes-clusters-in-rancher-setup/register-existing-clusters#authorized-cluster-endpoint-support-for-rke2-and-k3s-clusters).
        :param pulumi.Input[_builtins.str] name: The name of the cluster.
        :param pulumi.Input[_builtins.str] resource_version: (Computed, string) Cluster's k8s resource version.
        :param pulumi.Input[Union['ClusterV2RkeConfigArgs', 'ClusterV2RkeConfigArgsDict']] rke_config: The RKE configuration for the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterV2State.__new__(_ClusterV2State)

        __props__.__dict__["agent_env_vars"] = agent_env_vars
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["cloud_credential_secret_name"] = cloud_credential_secret_name
        __props__.__dict__["cluster_agent_deployment_customizations"] = cluster_agent_deployment_customizations
        __props__.__dict__["cluster_registration_token"] = cluster_registration_token
        __props__.__dict__["cluster_v1_id"] = cluster_v1_id
        __props__.__dict__["default_cluster_role_for_project_members"] = default_cluster_role_for_project_members
        __props__.__dict__["default_pod_security_admission_configuration_template_name"] = default_pod_security_admission_configuration_template_name
        __props__.__dict__["enable_network_policy"] = enable_network_policy
        __props__.__dict__["fleet_agent_deployment_customizations"] = fleet_agent_deployment_customizations
        __props__.__dict__["fleet_namespace"] = fleet_namespace
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["labels"] = labels
        __props__.__dict__["local_auth_endpoint"] = local_auth_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_version"] = resource_version
        __props__.__dict__["rke_config"] = rke_config
        return ClusterV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterV2AgentEnvVar']]]:
        """
        Agent env vars is a list of additional environment variables to be appended to the `cattle-cluster-agent` and `fleet-agent` deployment, and the plan for the [system upgrade controller](https://github.com/rancher/system-upgrade-controller) to upgrade nodes.
        """
        return pulumi.get(self, "agent_env_vars")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations for the Cluster.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="cloudCredentialSecretName")
    def cloud_credential_secret_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cloud credential secret name is the secret to be used when a cloud credential secret name is not specified at the machine pool level.
        """
        return pulumi.get(self, "cloud_credential_secret_name")

    @_builtins.property
    @pulumi.getter(name="clusterAgentDeploymentCustomizations")
    def cluster_agent_deployment_customizations(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterV2ClusterAgentDeploymentCustomization']]]:
        """
        Cluster agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `cattle-cluster-agent` deployment. This argument is available in Rancher v2.7.5 and above.
        """
        return pulumi.get(self, "cluster_agent_deployment_customizations")

    @_builtins.property
    @pulumi.getter(name="clusterRegistrationToken")
    def cluster_registration_token(self) -> pulumi.Output['outputs.ClusterV2ClusterRegistrationToken']:
        """
        (Computed, sensitive, list, max length: 1) Cluster Registration Token generated for the cluster.
        """
        return pulumi.get(self, "cluster_registration_token")

    @_builtins.property
    @pulumi.getter(name="clusterV1Id")
    def cluster_v1_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed, string) Cluster v1 id for cluster v2. (e.g. to be used with `rancher2_sync`).
        """
        return pulumi.get(self, "cluster_v1_id")

    @_builtins.property
    @pulumi.getter(name="defaultClusterRoleForProjectMembers")
    def default_cluster_role_for_project_members(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default cluster role for project members.
        """
        return pulumi.get(self, "default_cluster_role_for_project_members")

    @_builtins.property
    @pulumi.getter(name="defaultPodSecurityAdmissionConfigurationTemplateName")
    def default_pod_security_admission_configuration_template_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above.
        """
        return pulumi.get(self, "default_pod_security_admission_configuration_template_name")

    @_builtins.property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable k8s network policy on the cluster.
        """
        return pulumi.get(self, "enable_network_policy")

    @_builtins.property
    @pulumi.getter(name="fleetAgentDeploymentCustomizations")
    def fleet_agent_deployment_customizations(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterV2FleetAgentDeploymentCustomization']]]:
        """
        Fleet agent deployment customization specifies the additional tolerations, new affinity rules, and new resource requirements on the `fleet-agent` deployment. The argument is available in Rancher v2.7.5 and above.
        """
        return pulumi.get(self, "fleet_agent_deployment_customizations")

    @_builtins.property
    @pulumi.getter(name="fleetNamespace")
    def fleet_namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Fleet namespace is the namespace where the cluster is to create in the local cluster. It is recommended to leave it as the default value.
        """
        return pulumi.get(self, "fleet_namespace")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster. Note: When the cluster has `local_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected`.
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[_builtins.str]:
        """
        The RKE2 or K3s version for the cluster.
        """
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels for the Cluster.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="localAuthEndpoint")
    def local_auth_endpoint(self) -> pulumi.Output[Optional['outputs.ClusterV2LocalAuthEndpoint']]:
        """
        Local auth endpoint configures the Authorized Cluster Endpoint (ACE) which can be used to directly access the Kubernetes API server, without requiring communication through Rancher. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/kubernetes-clusters-in-rancher-setup/register-existing-clusters#authorized-cluster-endpoint-support-for-rke2-and-k3s-clusters).
        """
        return pulumi.get(self, "local_auth_endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed, string) Cluster's k8s resource version.
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> pulumi.Output['outputs.ClusterV2RkeConfig']:
        """
        The RKE configuration for the cluster.
        """
        return pulumi.get(self, "rke_config")

