# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, annotations=None, certs=None, description=None, id=None, labels=None, name=None, namespace_id=None, project_id=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if certs and not isinstance(certs, str):
            raise TypeError("Expected argument 'certs' to be a str")
        pulumi.set(__self__, "certs", certs)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        (Computed) Annotations for certificate object (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def certs(self) -> _builtins.str:
        """
        (Computed) Base64 encoded certs (string)
        """
        return pulumi.get(self, "certs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Computed) A certificate description (string)
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        (Computed) Labels for certificate object (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            annotations=self.annotations,
            certs=self.certs,
            description=self.description,
            id=self.id,
            labels=self.labels,
            name=self.name,
            namespace_id=self.namespace_id,
            project_id=self.project_id)


def get_certificate(name: Optional[_builtins.str] = None,
                    namespace_id: Optional[_builtins.str] = None,
                    project_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Use this data source to retrieve information about a Rancher v2 certificate.

    Depending of the availability, there are 2 types of Rancher v2 certificates:
    - Project certificate: Available to all namespaces in the `project_id`
    - Namespaced certificate: Available to just `namespace_id` in the `project_id`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    # Retrieve a rancher2 Project Certificate
    foo = rancher2.get_certificate(name="<name>",
        project_id="<project_id>")
    ```

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    # Retrieve a rancher2 Namespaced Certificate
    foo = rancher2.get_certificate(name="<name>",
        project_id="<project_id>",
        namespace_id="<namespace_id>")
    ```


    :param _builtins.str name: The name of the certificate (string)
    :param _builtins.str namespace_id: The namespace id where to assign the namespaced certificate (string)
    :param _builtins.str project_id: The project id where to assign the certificate (string)
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('rancher2:index/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        annotations=pulumi.get(__ret__, 'annotations'),
        certs=pulumi.get(__ret__, 'certs'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_certificate_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           namespace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           project_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Use this data source to retrieve information about a Rancher v2 certificate.

    Depending of the availability, there are 2 types of Rancher v2 certificates:
    - Project certificate: Available to all namespaces in the `project_id`
    - Namespaced certificate: Available to just `namespace_id` in the `project_id`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    # Retrieve a rancher2 Project Certificate
    foo = rancher2.get_certificate(name="<name>",
        project_id="<project_id>")
    ```

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    # Retrieve a rancher2 Namespaced Certificate
    foo = rancher2.get_certificate(name="<name>",
        project_id="<project_id>",
        namespace_id="<namespace_id>")
    ```


    :param _builtins.str name: The name of the certificate (string)
    :param _builtins.str namespace_id: The namespace id where to assign the namespaced certificate (string)
    :param _builtins.str project_id: The project id where to assign the certificate (string)
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('rancher2:index/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        annotations=pulumi.get(__response__, 'annotations'),
        certs=pulumi.get(__response__, 'certs'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        project_id=pulumi.get(__response__, 'project_id')))
