# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mtmaisdk.clients.rest.models.agent_finish import AgentFinish
from mtmaisdk.clients.rest.models.agent_node_output import AgentNodeOutput
from mtmaisdk.clients.rest.models.agent_node_state import AgentNodeState
from mtmaisdk.clients.rest.models.agent_step import AgentStep
from mtmaisdk.clients.rest.models.api_resource_meta import APIResourceMeta
from typing import Optional, Set
from typing_extensions import Self

class AgentNode(BaseModel):
    """
    AgentNode
    """ # noqa: E501
    metadata: APIResourceMeta
    title: StrictStr = Field(description="agent 节点名称, 或者作为工具名称")
    description: StrictStr = Field(description="agent 节点描述, 或者作为工具描述")
    type: Optional[StrictStr] = Field(default=None, description="节点类型，决定了由哪个agent来进行调度")
    config: Optional[Dict[str, Any]] = Field(default=None, description="agent 的配置", alias="Config")
    state: Optional[AgentNodeState] = None
    steps: List[AgentStep] = Field(description="agent 节点执行步骤, 一般表示之前执行的步骤")
    finish: Optional[AgentFinish] = None
    parent_id: Optional[StrictStr] = Field(default=None, description="上级节点", alias="parentId")
    agent_node_output: Optional[AgentNodeOutput] = Field(default=None, alias="agentNodeOutput")
    tools: Optional[StrictStr] = None
    memory_id: Optional[StrictStr] = Field(default=None, description="记忆ID，表示这个agent的记忆", alias="memoryId")
    input: Optional[StrictStr] = Field(default=None, description="输入")
    output: Optional[StrictStr] = Field(default=None, description="输出")
    __properties: ClassVar[List[str]] = ["metadata", "title", "description", "type", "Config", "state", "steps", "finish", "parentId", "agentNodeOutput", "tools", "memoryId", "input", "output"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentNode from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item_steps in self.steps:
                if _item_steps:
                    _items.append(_item_steps.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of finish
        if self.finish:
            _dict['finish'] = self.finish.to_dict()
        # override the default output from pydantic by calling `to_dict()` of agent_node_output
        if self.agent_node_output:
            _dict['agentNodeOutput'] = self.agent_node_output.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentNode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metadata": APIResourceMeta.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "title": obj.get("title"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "Config": obj.get("Config"),
            "state": AgentNodeState.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "steps": [AgentStep.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None,
            "finish": AgentFinish.from_dict(obj["finish"]) if obj.get("finish") is not None else None,
            "parentId": obj.get("parentId"),
            "agentNodeOutput": AgentNodeOutput.from_dict(obj["agentNodeOutput"]) if obj.get("agentNodeOutput") is not None else None,
            "tools": obj.get("tools"),
            "memoryId": obj.get("memoryId"),
            "input": obj.get("input"),
            "output": obj.get("output")
        })
        return _obj


