# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from mtmaisdk.clients.rest.models.agent_node_run_request_action import AgentNodeRunRequestAction
from mtmaisdk.clients.rest.models.chat_message import ChatMessage
from typing import Optional, Set
from typing_extensions import Self

class AgentNodeRunRequest(BaseModel):
    """
    创建agent节点请求
    """ # noqa: E501
    is_stream: Optional[StrictBool] = Field(default=None, description="是否使用stream 传输事件", alias="isStream")
    node_id: Optional[StrictStr] = Field(default=None, description="agent 节点ID", alias="nodeId")
    profile: Optional[StrictStr] = Field(default=None, description="profile")
    step_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="步骤限制(没用上)", alias="stepLimit")
    input: Optional[Dict[str, Any]] = Field(default=None, description="输入")
    messages: Optional[List[ChatMessage]] = None
    action: Optional[AgentNodeRunRequestAction] = None
    __properties: ClassVar[List[str]] = ["isStream", "nodeId", "profile", "stepLimit", "input", "messages", "action"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentNodeRunRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item_messages in self.messages:
                if _item_messages:
                    _items.append(_item_messages.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of action
        if self.action:
            _dict['action'] = self.action.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentNodeRunRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isStream": obj.get("isStream"),
            "nodeId": obj.get("nodeId"),
            "profile": obj.get("profile"),
            "stepLimit": obj.get("stepLimit"),
            "input": obj.get("input"),
            "messages": [ChatMessage.from_dict(_item) for _item in obj["messages"]] if obj.get("messages") is not None else None,
            "action": AgentNodeRunRequestAction.from_dict(obj["action"]) if obj.get("action") is not None else None
        })
        return _obj


