# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from mtmaisdk.clients.rest.models.book import Book
from mtmaisdk.clients.rest.models.book_outline import BookOutline
from mtmaisdk.clients.rest.models.chapter import Chapter
from mtmaisdk.clients.rest.models.chapter_outline import ChapterOutline
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ALLTASKSTATE_ONE_OF_SCHEMAS = ["Book", "BookOutline", "Chapter", "ChapterOutline"]

class AllTaskState(BaseModel):
    """
    all task state types
    """
    # data type: Book
    oneof_schema_1_validator: Optional[Book] = None
    # data type: BookOutline
    oneof_schema_2_validator: Optional[BookOutline] = None
    # data type: Chapter
    oneof_schema_3_validator: Optional[Chapter] = None
    # data type: ChapterOutline
    oneof_schema_4_validator: Optional[ChapterOutline] = None
    actual_instance: Optional[Union[Book, BookOutline, Chapter, ChapterOutline]] = None
    one_of_schemas: Set[str] = { "Book", "BookOutline", "Chapter", "ChapterOutline" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AllTaskState.model_construct()
        error_messages = []
        match = 0
        # validate data type: Book
        if not isinstance(v, Book):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Book`")
        else:
            match += 1
        # validate data type: BookOutline
        if not isinstance(v, BookOutline):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BookOutline`")
        else:
            match += 1
        # validate data type: Chapter
        if not isinstance(v, Chapter):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Chapter`")
        else:
            match += 1
        # validate data type: ChapterOutline
        if not isinstance(v, ChapterOutline):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChapterOutline`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AllTaskState with oneOf schemas: Book, BookOutline, Chapter, ChapterOutline. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AllTaskState with oneOf schemas: Book, BookOutline, Chapter, ChapterOutline. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into Book
        try:
            instance.actual_instance = Book.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BookOutline
        try:
            instance.actual_instance = BookOutline.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Chapter
        try:
            instance.actual_instance = Chapter.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ChapterOutline
        try:
            instance.actual_instance = ChapterOutline.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AllTaskState with oneOf schemas: Book, BookOutline, Chapter, ChapterOutline. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AllTaskState with oneOf schemas: Book, BookOutline, Chapter, ChapterOutline. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Book, BookOutline, Chapter, ChapterOutline]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


