# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from mtmaisdk.clients.rest.models.llm_config import LlmConfig
from typing import Optional, Set
from typing_extensions import Self

class BlogTaskState(BaseModel):
    """
    博客自动化操作的状态
    """ # noqa: E501
    llm: Optional[LlmConfig] = None
    prompt: Optional[StrictStr] = Field(default=None, description="关键提示语")
    blog_description: StrictStr = Field(description="博客站点功能定位描述", alias="blogDescription")
    blog_keywords: List[StrictStr] = Field(description="博客的SEO关键字", alias="blogKeywords")
    cur_topic_to_gen: Optional[StrictStr] = Field(default=None, description="当前生成文章使用的主题", alias="curTopicToGen")
    cur_article_state: Optional[GenArticleState] = Field(default=None, description="当前正在生成的文章", alias="curArticleState")
    step_description: Optional[StrictStr] = Field(default=None, description="当前步骤描述", alias="stepDescription")
    running_state: Optional[StrictStr] = Field(default=None, description="运行状态", alias="runningState")
    day_publishd_count: Union[StrictFloat, StrictInt] = Field(description="已经完成的日更天子数量", alias="dayPublishdCount")
    day_publish_count_hint: Union[StrictFloat, StrictInt] = Field(description="建议日更数", alias="dayPublishCountHint")
    __properties: ClassVar[List[str]] = ["llm", "prompt", "blogDescription", "blogKeywords", "curTopicToGen", "curArticleState", "stepDescription", "runningState", "dayPublishdCount", "dayPublishCountHint"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BlogTaskState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of llm
        if self.llm:
            _dict['llm'] = self.llm.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cur_article_state
        if self.cur_article_state:
            _dict['curArticleState'] = self.cur_article_state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BlogTaskState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "llm": LlmConfig.from_dict(obj["llm"]) if obj.get("llm") is not None else None,
            "prompt": obj.get("prompt"),
            "blogDescription": obj.get("blogDescription"),
            "blogKeywords": obj.get("blogKeywords"),
            "curTopicToGen": obj.get("curTopicToGen"),
            "curArticleState": GenArticleState.from_dict(obj["curArticleState"]) if obj.get("curArticleState") is not None else None,
            "stepDescription": obj.get("stepDescription"),
            "runningState": obj.get("runningState"),
            "dayPublishdCount": obj.get("dayPublishdCount") if obj.get("dayPublishdCount") is not None else 0,
            "dayPublishCountHint": obj.get("dayPublishCountHint") if obj.get("dayPublishCountHint") is not None else 10
        })
        return _obj

from mtmaisdk.clients.rest.models.gen_article_state import GenArticleState
# TODO: Rewrite to not use raise_errors
BlogTaskState.model_rebuild(raise_errors=False)

