# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mtmaisdk.clients.rest.models.chapter import Chapter
from typing import Optional, Set
from typing_extensions import Self

class Book(BaseModel):
    """
    书本
    """ # noqa: E501
    topic: Optional[StrictStr] = Field(default=None, description="书本主题")
    title: Optional[StrictStr] = Field(default=None, description="书本标题")
    book: Optional[List[Chapter]] = None
    book_outline: Optional[Dict[str, Any]] = Field(default=None, alias="bookOutline")
    chapters: Optional[List[Chapter]] = None
    goal: Optional[StrictStr] = Field(default=None, description="目标")
    __properties: ClassVar[List[str]] = ["topic", "title", "book", "bookOutline", "chapters", "goal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Book from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in book (list)
        _items = []
        if self.book:
            for _item_book in self.book:
                if _item_book:
                    _items.append(_item_book.to_dict())
            _dict['book'] = _items
        # override the default output from pydantic by calling `to_dict()` of book_outline
        if self.book_outline:
            _dict['bookOutline'] = self.book_outline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in chapters (list)
        _items = []
        if self.chapters:
            for _item_chapters in self.chapters:
                if _item_chapters:
                    _items.append(_item_chapters.to_dict())
            _dict['chapters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Book from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "topic": obj.get("topic"),
            "title": obj.get("title"),
            "book": [Chapter.from_dict(_item) for _item in obj["book"]] if obj.get("book") is not None else None,
            "bookOutline": BookOutline.from_dict(obj["bookOutline"]) if obj.get("bookOutline") is not None else None,
            "chapters": [Chapter.from_dict(_item) for _item in obj["chapters"]] if obj.get("chapters") is not None else None,
            "goal": obj.get("goal")
        })
        return _obj


