# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from mtmaisdk.clients.rest.models.crew_ai_agent import CrewAiAgent
from mtmaisdk.clients.rest.models.crew_ai_task import CrewAiTask
from mtmaisdk.clients.rest.models.llm_config import LlmConfig
from typing import Optional, Set
from typing_extensions import Self

class CallAgent(BaseModel):
    """
    调用 Agent 参数
    """ # noqa: E501
    llm: Optional[LlmConfig] = Field(default=None, description="大语言模型 api 配置")
    input: Dict[str, Any] = Field(description="输入参数")
    agents: List[CrewAiAgent] = Field(description="agents 列表")
    tasks: List[CrewAiTask] = Field(description="任务列表")
    debug: Optional[StrictBool] = Field(default=False, description="是否调试模式")
    __properties: ClassVar[List[str]] = ["llm", "input", "agents", "tasks", "debug"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallAgent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of llm
        if self.llm:
            _dict['llm'] = self.llm.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in agents (list)
        _items = []
        if self.agents:
            for _item_agents in self.agents:
                if _item_agents:
                    _items.append(_item_agents.to_dict())
            _dict['agents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tasks (list)
        _items = []
        if self.tasks:
            for _item_tasks in self.tasks:
                if _item_tasks:
                    _items.append(_item_tasks.to_dict())
            _dict['tasks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallAgent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "llm": LlmConfig.from_dict(obj["llm"]) if obj.get("llm") is not None else None,
            "input": obj.get("input"),
            "agents": [CrewAiAgent.from_dict(_item) for _item in obj["agents"]] if obj.get("agents") is not None else None,
            "tasks": [CrewAiTask.from_dict(_item) for _item in obj["tasks"]] if obj.get("tasks") is not None else None,
            "debug": obj.get("debug") if obj.get("debug") is not None else False
        })
        return _obj


