# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CrewAiAgent(BaseModel):
    """
    crawai agent 定义
    """ # noqa: E501
    name: StrictStr = Field(description="name")
    role: StrictStr = Field(description="role")
    backstory: StrictStr = Field(description="role")
    goal: StrictStr = Field(description="goal")
    max_retry_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="maxRetryLimit", alias="maxRetryLimit")
    max_rpm: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="maxRpm", alias="maxRpm")
    __properties: ClassVar[List[str]] = ["name", "role", "backstory", "goal", "maxRetryLimit", "maxRpm"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CrewAiAgent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CrewAiAgent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "role": obj.get("role"),
            "backstory": obj.get("backstory"),
            "goal": obj.get("goal"),
            "maxRetryLimit": obj.get("maxRetryLimit"),
            "maxRpm": obj.get("maxRpm")
        })
        return _obj


