# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mtmaisdk.clients.rest.models.gen_article_state_oulines_inner import GenArticleStateOulinesInner
from typing import Optional, Set
from typing_extensions import Self

class GenArticleState(BaseModel):
    """
    文章生成的过程状态
    """ # noqa: E501
    blog_task_state: Optional[BlogTaskState] = Field(default=None, description="关联的上级博客生成任务", alias="blogTaskState")
    topic: StrictStr = Field(description="当前关联的主题")
    prompt: Optional[StrictStr] = Field(default=None, description="关键提示语")
    title: Optional[StrictStr] = Field(default=None, description="文章主标题")
    sub_title: Optional[StrictStr] = Field(default=None, description="文章副标题", alias="subTitle")
    oulines: Optional[List[GenArticleStateOulinesInner]] = Field(default=None, description="文章大纲列表")
    __properties: ClassVar[List[str]] = ["blogTaskState", "topic", "prompt", "title", "subTitle", "oulines"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GenArticleState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of blog_task_state
        if self.blog_task_state:
            _dict['blogTaskState'] = self.blog_task_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in oulines (list)
        _items = []
        if self.oulines:
            for _item_oulines in self.oulines:
                if _item_oulines:
                    _items.append(_item_oulines.to_dict())
            _dict['oulines'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GenArticleState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "blogTaskState": BlogTaskState.from_dict(obj["blogTaskState"]) if obj.get("blogTaskState") is not None else None,
            "topic": obj.get("topic"),
            "prompt": obj.get("prompt"),
            "title": obj.get("title"),
            "subTitle": obj.get("subTitle"),
            "oulines": [GenArticleStateOulinesInner.from_dict(_item) for _item in obj["oulines"]] if obj.get("oulines") is not None else None
        })
        return _obj

from mtmaisdk.clients.rest.models.blog_task_state import BlogTaskState
# TODO: Rewrite to not use raise_errors
GenArticleState.model_rebuild(raise_errors=False)

