# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateTenantRequest(BaseModel):
    """
    UpdateTenantRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of the tenant.")
    analytics_opt_out: Optional[StrictBool] = Field(default=None, description="Whether the tenant has opted out of analytics.", alias="analyticsOptOut")
    alert_member_emails: Optional[StrictBool] = Field(default=None, description="Whether to alert tenant members.", alias="alertMemberEmails")
    enable_workflow_run_failure_alerts: Optional[StrictBool] = Field(default=None, description="Whether to send alerts when workflow runs fail.", alias="enableWorkflowRunFailureAlerts")
    enable_expiring_token_alerts: Optional[StrictBool] = Field(default=None, description="Whether to enable alerts when tokens are approaching expiration.", alias="enableExpiringTokenAlerts")
    enable_tenant_resource_limit_alerts: Optional[StrictBool] = Field(default=None, description="Whether to enable alerts when tenant resources are approaching limits.", alias="enableTenantResourceLimitAlerts")
    max_alerting_frequency: Optional[StrictStr] = Field(default=None, description="The max frequency at which to alert.", alias="maxAlertingFrequency")
    __properties: ClassVar[List[str]] = ["name", "analyticsOptOut", "alertMemberEmails", "enableWorkflowRunFailureAlerts", "enableExpiringTokenAlerts", "enableTenantResourceLimitAlerts", "maxAlertingFrequency"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateTenantRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateTenantRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "analyticsOptOut": obj.get("analyticsOptOut"),
            "alertMemberEmails": obj.get("alertMemberEmails"),
            "enableWorkflowRunFailureAlerts": obj.get("enableWorkflowRunFailureAlerts"),
            "enableExpiringTokenAlerts": obj.get("enableExpiringTokenAlerts"),
            "enableTenantResourceLimitAlerts": obj.get("enableTenantResourceLimitAlerts"),
            "maxAlertingFrequency": obj.get("maxAlertingFrequency")
        })
        return _obj


