"""
Dummy Python package for testing CI workflows.

This package provides simple utility functions for demonstration purposes.
"""

try:
    from importlib.metadata import PackageNotFoundError, version
except ImportError:
    from importlib_metadata import PackageNotFoundError, version

try:
    __version__ = version("vahidlari_dummypkg")
except PackageNotFoundError:
    # Package is not installed, use setuptools_scm fallback
    try:
        from setuptools_scm import get_version

        __version__ = get_version()
    except Exception:
        __version__ = "0.0.0"
from .core import calculate_sum, greet, say_goodbye
from .utils import format_message, get_package_info

__all__ = [
    "__version__",
    "greet",
    "calculate_sum",
    "say_goodbye",
    "format_message",
    "get_package_info",
]
