"""
Core functionality for the dummy package.
"""


def greet(name: str = "World") -> str:
    """
    Generate a greeting message.

    Args:
        name: Name to greet (default: "World")

    Returns:
        Greeting message string

    Example:
        >>> greet("Alice")
        'Hello, Alice!'
    """
    message = f"Hello, {name}!"
    print(message)
    return message


def calculate_sum(a: float, b: float) -> float:
    """
    Calculate the sum of two numbers.

    Args:
        a: First number
        b: Second number

    Returns:
        Sum of a and b

    Example:
        >>> calculate_sum(2, 3)
        5.0
    """
    result = a + b
    print(f"Calculating {a} + {b} = {result}")
    return result


def say_goodbye(name: str = "World") -> str:
    """
    Say goodbye to someone.

    Args:
        name: Name to say goodbye to (default: "World")

    Returns:
        Goodbye message string
    """
    message = f"Goodbye, {name}!"
    print(message)
    return message
