"""
Utility functions for the dummy package.
"""

try:
    from importlib.metadata import PackageNotFoundError, version
except ImportError:
    from importlib_metadata import PackageNotFoundError, version

try:
    __version__ = version("vahidlari_dummypkg")
except PackageNotFoundError:
    # Package is not installed, use setuptools_scm fallback
    try:
        from setuptools_scm import get_version

        __version__ = get_version()
    except Exception:
        __version__ = "0.0.0"


def format_message(message: str, prefix: str = "INFO") -> str:
    """
    Format a message with a prefix.

    Args:
        message: Message to format
        prefix: Prefix to add (default: "INFO")

    Returns:
        Formatted message string

    Example:
        >>> format_message("Test message")
        '[INFO] Test message'
    """
    formatted = f"[{prefix}] {message}"
    print(formatted)
    return formatted


def get_package_info() -> dict:
    """
    Get information about the package.

    Returns:
        Dictionary containing package information

    Example:
        >>> info = get_package_info()
        >>> info['name']
        'vahidlari_dummypkg'
    """
    info = {
        "name": "vahidlari_dummypkg",
        "version": __version__,
        "description": "A dummy Python package for testing CI workflows",
        "author": "Test Author",
    }
    print(f"Package info: {info}")
    return info
