"""Generated by Django 5.1.1 on 2024-09-12 00:13."""

from django.db import migrations, models


class Migration(migrations.Migration):
    """Migrate db."""

    dependencies = [
        ("codex", "0029_comicfts"),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name="groupauth",
            unique_together=set(),
        ),
        migrations.AlterField(
            model_name="adminflag",
            name="key",
            field=models.CharField(
                choices=[
                    ("FV", "Folder View"),
                    ("RG", "Registration"),
                    ("NU", "Non Users"),
                    ("AU", "Auto Update"),
                    ("IM", "Import Metadata"),
                    ("ST", "Send Telemetry"),
                ],
                db_index=True,
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="day",
            field=models.PositiveSmallIntegerField(db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name="comic",
            name="file_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("CBZ", "Cbz"),
                    ("CBR", "Cbr"),
                    ("CBT", "Cbt"),
                    ("PDF", "Pdf"),
                ],
                db_collation="nocase",
                db_index=True,
                default="",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="issue_suffix",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=16
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="month",
            field=models.PositiveSmallIntegerField(db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name="comic",
            name="notes",
            field=models.TextField(db_collation="nocase", default=""),
        ),
        migrations.AlterField(
            model_name="comic",
            name="reading_direction",
            field=models.CharField(
                choices=[
                    ("ltr", "Ltr"),
                    ("rtl", "Rtl"),
                    ("ttb", "Ttb"),
                    ("btt", "Btt"),
                ],
                db_collation="nocase",
                db_index=True,
                default="ltr",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="review",
            field=models.TextField(db_collation="nocase", default=""),
        ),
        migrations.AlterField(
            model_name="comic",
            name="sort_name",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="summary",
            field=models.TextField(db_collation="nocase", default=""),
        ),
        migrations.AlterField(
            model_name="customcover",
            name="sort_name",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="folder",
            name="sort_name",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="imprint",
            name="sort_name",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="librarianstatus",
            name="status_type",
            field=models.CharField(
                choices=[
                    ("CCC", "Create Covers"),
                    ("CCD", "Purge Covers"),
                    ("CFO", "Find Orphan"),
                    ("IDM", "Dirs Moved"),
                    ("IFM", "Files Moved"),
                    ("ITR", "Aggregate Tags"),
                    ("ITQ", "Query Missing Fks"),
                    ("ITC", "Create Fks"),
                    ("IDU", "Dirs Modified"),
                    ("IFU", "Files Modified"),
                    ("IFC", "Files Created"),
                    ("IMQ", "Query M2M Fields"),
                    ("IMC", "Link M2M Fields"),
                    ("IDD", "Dirs Deleted"),
                    ("IFD", "Files Deleted"),
                    ("IFI", "Failed Imports"),
                    ("ICQ", "Query Missing Covers"),
                    ("ICM", "Covers Moved"),
                    ("ICU", "Covers Modified"),
                    ("ICC", "Covers Created"),
                    ("ICD", "Covers Deleted"),
                    ("ICL", "Covers Link"),
                    ("IGU", "Group Update"),
                    ("IAF", "Adopt Folders"),
                    ("JTD", "Cleanup Fk"),
                    ("JLV", "Codex Latest Version"),
                    ("JCU", "Codex Update"),
                    ("JCR", "Codex Restart"),
                    ("JCS", "Codex Stop"),
                    ("JDO", "Db Optimize"),
                    ("JDB", "Db Backup"),
                    ("JSD", "Cleanup Sessions"),
                    ("JCD", "Cleanup Covers"),
                    ("JCB", "Cleanup Bookmarks"),
                    ("JIF", "Integrity Fk"),
                    ("JIC", "Integrity Check"),
                    ("JFC", "Fts Integrity Check"),
                    ("JFR", "Fts Rebuild"),
                    ("SIX", "Search Index Clear"),
                    ("SIU", "Search Index Update"),
                    ("SIC", "Search Index Create"),
                    ("SID", "Search Index Remove"),
                    ("SIO", "Search Index Optimize"),
                    ("WPO", "Poll"),
                ],
                db_index=True,
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="publisher",
            name="sort_name",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="series",
            name="sort_name",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="storyarc",
            name="sort_name",
            field=models.CharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
    ]
