"""Generated by Django 5.2.4 on 2025-07-21 15:05."""

import django.db.models.deletion
from django.db import migrations, models

import codex.models.fields
import codex.models.library


class Migration(migrations.Migration):
    """Migrate db."""

    dependencies = [
        ("codex", "0033_alter_librarianstatus_status_type"),
    ]

    operations = [
        migrations.AlterField(
            model_name="agerating",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="character",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="comic",
            name="community_rating",
            field=codex.models.fields.CoercingDecimalField(
                db_index=True, decimal_places=2, default=None, max_digits=5, null=True
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="critical_rating",
            field=codex.models.fields.CoercingDecimalField(
                db_index=True, decimal_places=2, default=None, max_digits=5, null=True
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="day",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                db_index=True, null=True
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="decade",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                db_index=True, null=True
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="file_type",
            field=codex.models.fields.CleaningCharField(
                blank=True,
                choices=[
                    ("CBZ", "Cbz"),
                    ("CBR", "Cbr"),
                    ("CBT", "Cbt"),
                    ("PDF", "Pdf"),
                ],
                db_collation="nocase",
                db_index=True,
                default="",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="issue_number",
            field=codex.models.fields.CoercingDecimalField(
                db_index=True, decimal_places=2, max_digits=10, null=True
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="issue_suffix",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=16
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="month",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                db_index=True, null=True
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="name",
            field=codex.models.fields.CleaningCharField(
                db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="notes",
            field=codex.models.fields.CleaningTextField(
                db_collation="nocase", default=""
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="page_count",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                db_index=True, default=0
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="path",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=4095),
        ),
        migrations.AlterField(
            model_name="comic",
            name="reading_direction",
            field=codex.models.fields.CleaningCharField(
                choices=[
                    ("ltr", "Ltr"),
                    ("rtl", "Rtl"),
                    ("ttb", "Ttb"),
                    ("btt", "Btt"),
                ],
                db_collation="nocase",
                db_index=True,
                default="ltr",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="review",
            field=codex.models.fields.CleaningTextField(
                db_collation="nocase", default=""
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="sort_name",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="summary",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", default=""
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="year",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                db_index=True, null=True
            ),
        ),
        migrations.AlterField(
            model_name="contributorperson",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="contributorrole",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="country",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="customcover",
            name="path",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=4095),
        ),
        migrations.AlterField(
            model_name="failedimport",
            name="path",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=4095),
        ),
        migrations.AlterField(
            model_name="folder",
            name="name",
            field=codex.models.fields.CleaningCharField(
                db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="folder",
            name="path",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=4095),
        ),
        migrations.AlterField(
            model_name="folder",
            name="sort_name",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="genre",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="identifier",
            name="nss",
            field=codex.models.fields.CleaningCharField(max_length=128),
        ),
        migrations.AlterField(
            model_name="identifiertype",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="imprint",
            name="name",
            field=codex.models.fields.CleaningCharField(
                db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="imprint",
            name="sort_name",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="language",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="library",
            name="path",
            field=codex.models.fields.CleaningCharField(
                db_index=True,
                max_length=4095,
                unique=True,
                validators=[codex.models.library.validate_dir_exists],
            ),
        ),
        migrations.AlterField(
            model_name="location",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="originalformat",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="publisher",
            name="name",
            field=codex.models.fields.CleaningCharField(
                db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="publisher",
            name="sort_name",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="scaninfo",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="series",
            name="name",
            field=codex.models.fields.CleaningCharField(
                db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="series",
            name="sort_name",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="series",
            name="volume_count",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(null=True),
        ),
        migrations.AlterField(
            model_name="seriesgroup",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="story",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="storyarc",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="storyarc",
            name="sort_name",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="storyarcnumber",
            name="number",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="tagger",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="team",
            name="name",
            field=codex.models.fields.CleaningCharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="volume",
            name="issue_count",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(null=True),
        ),
        migrations.AlterField(
            model_name="volume",
            name="name",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                db_index=True, default=None, null=True
            ),
        ),
        migrations.RenameModel(
            old_name="Contributor",
            new_name="Credit",
        ),
        migrations.RenameModel(
            old_name="ContributorPerson",
            new_name="CreditPerson",
        ),
        migrations.RenameModel(
            old_name="ContributorRole",
            new_name="CreditRole",
        ),
        migrations.RenameField(
            model_name="comic",
            old_name="contributors",
            new_name="credits",
        ),
        migrations.SeparateDatabaseAndState(
            database_operations=[
                migrations.RunSQL(
                    sql="DROP TABLE IF EXISTS codex_comicfts;",
                ),
                migrations.RunSQL(
                    sql="CREATE VIRTUAL TABLE codex_comicfts USING fts5(comic_id UNINDEXED, created_at UNINDEXED, updated_at UNINDEXED, publisher, imprint, series, issue, name, collection_title, age_rating, country, language, notes, original_format, review, scan_info, summary, tagger, characters, credits, genres, locations, roles, series_groups, stories, story_arcs, tags, teams, reading_direction, file_type, universes, identifiers, sources)",
                    reverse_sql="DROP TABLE IF EXISTS codex_comicfts",
                ),
            ],
            state_operations=[
                migrations.DeleteModel(
                    name="ComicFTS",
                ),
                migrations.CreateModel(
                    name="ComicFTS",
                    fields=[
                        ("created_at", models.DateTimeField(auto_now_add=True)),
                        ("updated_at", models.DateTimeField(auto_now=True)),
                        (
                            "comic",
                            models.OneToOneField(
                                on_delete=django.db.models.deletion.CASCADE,
                                primary_key=True,
                                serialize=False,
                                to="codex.comic",
                            ),
                        ),
                        ("body", models.TextField()),
                    ],
                    options={
                        "get_latest_by": "updated_at",
                        "managed": False,
                    },
                ),
            ],
        ),
        migrations.AddField(
            model_name="comic",
            name="metadata_mtime",
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name="comic",
            name="main_character",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="main_character_in_comics",
                to="codex.character",
            ),
        ),
        migrations.AddField(
            model_name="comic",
            name="main_team",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="main_team_in_comics",
                to="codex.character",
            ),
        ),
        migrations.CreateModel(
            name="Universe",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    codex.models.fields.CleaningCharField(
                        db_index=True, max_length=128
                    ),
                ),
                ("designation", codex.models.fields.CleaningCharField(max_length=128)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="codex.identifier",
                    ),
                ),
            ],
            options={
                "get_latest_by": "updated_at",
                "abstract": False,
                "unique_together": {("name",)},
            },
        ),
        migrations.AddField(
            model_name="comic",
            name="universes",
            field=models.ManyToManyField(to="codex.universe"),
        ),
        migrations.RemoveField(
            model_name="comic",
            name="community_rating",
        ),
        migrations.AlterUniqueTogether(
            name="character",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="creditperson",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="location",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="story",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="storyarc",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="tag",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="team",
            unique_together={("name",)},
        ),
        migrations.AddField(
            model_name="character",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="creditperson",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="imprint",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="publisher",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="series",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="story",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="storyarc",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="tag",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="team",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.RenameModel(
            old_name="IdentifierType",
            new_name="IdentifierSource",
        ),
        migrations.RenameField(
            model_name="identifier",
            old_name="nss",
            new_name="key",
        ),
        migrations.RenameField(
            model_name="identifier",
            old_name="identifier_type",
            new_name="source",
        ),
        migrations.AlterUniqueTogether(
            name="genre",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="identifier",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="genre",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="creditrole",
            name="identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.identifier",
            ),
        ),
        migrations.AddField(
            model_name="identifier",
            name="id_type",
            field=models.CharField(
                choices=[
                    ("storyarc", "Arc"),
                    ("character", "Character"),
                    ("genre", "Genre"),
                    ("imprint", "Imprint"),
                    ("comic", "Issue"),
                    ("location", "Location"),
                    ("publisher", "Publisher"),
                    ("series", "Series"),
                    ("story", "Story"),
                    ("tag", "Tag"),
                    ("team", "Team"),
                    ("universe", "Universe"),
                    ("creditrole", "Role"),
                    ("creditperson", "Creator"),
                ],
                db_index=True,
                default="comic",
                max_length=16,
            ),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name="identifier",
            unique_together={("source", "id_type", "key")},
        ),
        migrations.AlterUniqueTogether(
            name="volume",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="volume",
            name="number_to",
            field=codex.models.fields.CoercingPositiveSmallIntegerField(
                db_index=True, default=None, null=True
            ),
        ),
        migrations.AlterUniqueTogether(
            name="imprint",
            unique_together={("publisher", "name")},
        ),
        migrations.AlterUniqueTogether(
            name="series",
            unique_together={("imprint", "name")},
        ),
        migrations.AlterUniqueTogether(
            name="volume",
            unique_together={("series", "name", "number_to")},
        ),
        migrations.AlterField(
            model_name="adminflag",
            name="key",
            field=models.CharField(
                choices=[
                    ("AU", "Auto Update"),
                    ("BT", "Banner Text"),
                    ("FV", "Folder View"),
                    ("IM", "Import Metadata"),
                    ("LI", "Lazy Import Metadata"),
                    ("NU", "Non Users"),
                    ("RG", "Registration"),
                    ("ST", "Send Telemetry"),
                ],
                db_index=True,
                max_length=2,
            ),
        ),
        migrations.AddField(
            model_name="comic",
            name="collection_title",
            field=codex.models.fields.CleaningCharField(
                db_collation="nocase", db_index=True, default="", max_length=128
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="file_type",
            field=codex.models.fields.CleaningCharField(
                blank=True,
                choices=[
                    ("CBR", "Cbr"),
                    ("CBZ", "Cbz"),
                    ("CBT", "Cbt"),
                    ("CB7", "Cb7"),
                    ("PDF", "Pdf"),
                ],
                db_collation="nocase",
                db_index=True,
                default="",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="librarianstatus",
            name="status_type",
            field=models.CharField(
                choices=[
                    ("CCC", "Create Covers"),
                    ("CFO", "Find Orphan Covers"),
                    ("CRC", "Remove Covers"),
                    ("IAT", "Aggregate Tags From Comics"),
                    ("ICC", "Create Comics"),
                    ("ICT", "Create Tags"),
                    ("ICV", "Create Custom Covers"),
                    ("IFC", "Mark Failed Failed Imports"),
                    ("IFD", "Clean Up Failed Imports"),
                    ("IFQ", "Query Failed Imports"),
                    ("IFU", "Update Failed Imports"),
                    ("IGU", "Update Timestamps For Browser Groups"),
                    ("ILT", "Link Tags"),
                    ("ILV", "Link Custom Covers"),
                    ("IQC", "Query Comics"),
                    ("IQL", "Query Tag Links"),
                    ("IQT", "Query Missing Tags"),
                    ("IQV", "Query Missing Custom Covers"),
                    ("IRC", "Remove Comics"),
                    ("IRF", "Remove Folders"),
                    ("IRT", "Read Tags From Comics"),
                    ("IRV", "Remove Custom Covers"),
                    ("ISC", "Create Search Index Entries"),
                    ("ISU", "Update Search Index Entries"),
                    ("IUC", "Update Comics"),
                    ("IUT", "Update Tags"),
                    ("IUV", "Update Custom Covers"),
                    ("JAF", "Adopt Orphan Folders"),
                    ("JCT", "Cleanup Orphan Tags"),
                    ("JCU", "Update Codex Server Software"),
                    ("JDB", "Backup Database"),
                    ("JDO", "Optimize Database"),
                    ("JID", "Check Integrity Of Entire Database"),
                    ("JIF", "Check Integrtity Of Database Foreign Keys"),
                    ("JIS", "Check Integrity Of Full Text Virtual Table"),
                    ("JLV", "Check Codex Latest Version"),
                    ("JRB", "Cleanup Orphan Bookmarks"),
                    ("JRS", "Cleanup Old Sessions"),
                    ("JRV", "Cleanup Orphan Covers"),
                    ("JSR", "Rebuild Full Text Search Virtual Table"),
                    ("RCR", "Restart Codex Server"),
                    ("RCS", "Stop Codex Server"),
                    ("SIO", "Optimize Search Virtual Table"),
                    ("SIR", "Clean Orphan Search Entries"),
                    ("SIX", "Clear Full Text Search Table"),
                    ("SSC", "Sync New Search Entries"),
                    ("SSU", "Sync Old Search Entries"),
                    ("WPO", "Poll Library"),
                ],
                db_index=True,
                max_length=3,
            ),
        ),
    ]
