"""Generated by Django 5.2.4 on 2025-07-21 15:05."""

from itertools import chain

import django.db.models.deletion
from comicbox.enums.maps.identifiers import ID_SOURCE_NAME_MAP, get_id_source_by_alias
from django.db import migrations, models


def _map_identifiers_to_canonical_names(apps):
    id_source_model = apps.get_model("codex", "identifiersource")
    identifier_source_map = {}

    for source in id_source_model.objects.all():
        if id_source_enum := get_id_source_by_alias(source.name, default=None):
            canon_name = ID_SOURCE_NAME_MAP.get(id_source_enum, source.name)
            if canon_name != source.name:
                if canon_name not in identifier_source_map:
                    identifier_source_map[canon_name] = set()
                identifier_source_map[canon_name] |= set(
                    source.identifier_set.values_list("pk", flat=True)
                )
    return identifier_source_map


def _prepare_canonical_id_sources(apps, identifier_source_map):
    id_source_model = apps.get_model("codex", "identifiersource")
    source_names = identifier_source_map.keys()
    existing_id_sources = id_source_model.objects.filter(name__in=source_names).only(
        "name"
    )
    existing_id_source_names = id_source_model.objects.filter(
        name__in=source_names
    ).values_list("name", flat=True)
    create_id_source_names = sorted(
        frozenset(set(identifier_source_map.keys()) - set(existing_id_source_names))
    )
    return tuple(
        id_source_model(name=name) for name in create_id_source_names
    ), existing_id_sources


def _create_link_map(identifier_source_map, sources):
    link_map = {}
    for id_source in chain(*sources):
        for id_pk in identifier_source_map[id_source.name]:
            link_map[id_pk] = id_source
    return link_map


def _prepare_updatatable_identifiers(apps, identifier_source_map, sources):
    link_map = _create_link_map(identifier_source_map, sources)
    identifier_model = apps.get_model("codex", "identifier")
    updateable_identifiers = identifier_model.objects.filter(pk__in=link_map.keys())
    obj_list = []
    for identifier in updateable_identifiers:
        identifier.source = link_map[identifier.pk]
        obj_list.append(identifier)
    return tuple(obj_list)


def _create_canonical_sources(apps):
    print("Examining identifier sources for conversion to canonical sources...")
    identifier_source_map = _map_identifiers_to_canonical_names(apps)
    print("Preparing missing canonical identifiers sources for creation...")
    obj_list, existing_id_sources = _prepare_canonical_id_sources(
        apps, identifier_source_map
    )
    id_source_model = apps.get_model("codex", "identifiersource")
    created_id_sources = id_source_model.objects.bulk_create(obj_list)
    count = len(obj_list)
    print(f"Created {count} canonical identifier sources")
    return identifier_source_map, (existing_id_sources, created_id_sources)


def _update_identifiers_with_canonical_sources(apps, identifier_source_map, sources):
    print("Preparing identifiers for update with canonical sources...")
    obj_list = _prepare_updatatable_identifiers(apps, identifier_source_map, sources)
    identifier_model = apps.get_model("codex", "identifier")
    identifier_model.objects.bulk_update(obj_list, fields=("source",))
    count = len(obj_list)
    print(f"Updated {count} identifiers with canonical sources.")


def _convert_identifier_sources(apps, _schema_editor):
    identifier_source_map, sources = _create_canonical_sources(apps)
    _update_identifiers_with_canonical_sources(apps, identifier_source_map, sources)


class Migration(migrations.Migration):
    """Migrate db."""

    dependencies = [
        ("codex", "0034_comicbox2"),
    ]

    operations = [
        migrations.RunPython(_convert_identifier_sources),
        migrations.SeparateDatabaseAndState(
            database_operations=[
                migrations.RunSQL(
                    sql="DROP TABLE IF EXISTS codex_comicfts;",
                ),
                migrations.RunSQL(
                    sql="CREATE VIRTUAL TABLE codex_comicfts USING fts5(comic_id UNINDEXED, created_at UNINDEXED, updated_at UNINDEXED, publisher, imprint, series, name, collection_title, age_rating, country, language, original_format, review, scan_info, summary, tagger, characters, credits, genres, locations, roles, series_groups, stories, story_arcs, tags, teams, universes, sources)",
                    reverse_sql="DROP TABLE IF EXISTS codex_comicfts",
                ),
            ],
            state_operations=[
                migrations.DeleteModel(
                    name="ComicFTS",
                ),
                migrations.CreateModel(
                    name="ComicFTS",
                    fields=[
                        ("created_at", models.DateTimeField(auto_now_add=True)),
                        ("updated_at", models.DateTimeField(auto_now=True)),
                        (
                            "comic",
                            models.OneToOneField(
                                on_delete=django.db.models.deletion.CASCADE,
                                primary_key=True,
                                serialize=False,
                                to="codex.comic",
                            ),
                        ),
                        ("body", models.TextField()),
                    ],
                    options={
                        "get_latest_by": "updated_at",
                        "managed": False,
                    },
                ),
            ],
        ),
    ]
